/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.zip.InflaterInputStream;
import sun.nio.cs.ISO_8859_1;

class CharacterName {
    private static SoftReference<CharacterName> refCharName;
    private final byte[] strPool;
    private final int[] lookup;
    private final int[] bkIndices;
    private final int[] cpEntries;
    private final int[] hsIndices;

    private CharacterName() {
        try (DataInputStream dis = new DataInputStream(new InflaterInputStream(AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream("uniName.dat");
            }
        })));){
            int total = dis.readInt();
            int bkNum = dis.readInt();
            int cpNum = dis.readInt();
            int cpEnd = dis.readInt();
            byte[] ba = new byte[cpEnd];
            this.lookup = new int[bkNum * 256];
            this.bkIndices = new int[4352];
            this.strPool = new byte[total - cpEnd];
            this.cpEntries = new int[cpNum * 3];
            this.hsIndices = new int[cpNum / 2 | 1];
            Arrays.fill(this.bkIndices, -1);
            Arrays.fill(this.hsIndices, -1);
            dis.readFully(ba);
            dis.readFully(this.strPool);
            int nameOff = 0;
            int cpOff = 0;
            int cp = 0;
            int bk = -1;
            int prevBk = -1;
            int idx = 0;
            int next = -1;
            int hash = 0;
            int hsh = 0;
            do {
                int len;
                if ((len = ba[cpOff++] & 0xFF) == 0) {
                    len = ba[cpOff++] & 0xFF;
                    cp = (ba[cpOff++] & 0xFF) << 16 | (ba[cpOff++] & 0xFF) << 8 | ba[cpOff++] & 0xFF;
                } else {
                    ++cp;
                }
                int hi = cp >> 8;
                if (prevBk != hi) {
                    this.bkIndices[hi] = ++bk;
                    prevBk = hi;
                }
                this.lookup[(bk << 8) + (cp & 0xFF)] = nameOff << 8 | len;
                hash = CharacterName.hashN(this.strPool, nameOff, len);
                hsh = (hash & Integer.MAX_VALUE) % this.hsIndices.length;
                next = this.hsIndices[hsh];
                this.hsIndices[hsh] = idx;
                idx = this.addCp(idx, hash, next, cp);
                nameOff += len;
            } while (cpOff < cpEnd);
        }
        catch (Exception x) {
            throw new InternalError(x.getMessage(), x);
        }
    }

    private static final int hashN(byte[] a, int off, int len) {
        int h = 1;
        while (len-- > 0) {
            h = 31 * h + a[off++];
        }
        return h;
    }

    private int addCp(int idx, int hash, int next, int cp) {
        this.cpEntries[idx++] = hash;
        this.cpEntries[idx++] = next;
        this.cpEntries[idx++] = cp;
        return idx;
    }

    private int getCpHash(int idx) {
        return this.cpEntries[idx];
    }

    private int getCpNext(int idx) {
        return this.cpEntries[idx + 1];
    }

    private int getCp(int idx) {
        return this.cpEntries[idx + 2];
    }

    public static CharacterName getInstance() {
        SoftReference<CharacterName> ref = refCharName;
        CharacterName cname = null;
        if (ref == null || (cname = ref.get()) == null) {
            cname = new CharacterName();
            refCharName = new SoftReference<CharacterName>(cname);
        }
        return cname;
    }

    public String getName(int cp) {
        int off = 0;
        int bk = this.bkIndices[cp >> 8];
        if (bk == -1 || (off = this.lookup[(bk << 8) + (cp & 0xFF)]) == 0) {
            return null;
        }
        String result = new String(this.strPool, 0, off >>> 8, off & 0xFF);
        return result;
    }

    public int getCodePoint(String name) {
        byte[] bname = name.getBytes(ISO_8859_1.INSTANCE);
        int hsh = CharacterName.hashN(bname, 0, bname.length);
        int idx = this.hsIndices[(hsh & Integer.MAX_VALUE) % this.hsIndices.length];
        while (idx != -1) {
            if (this.getCpHash(idx) == hsh) {
                int cp = this.getCp(idx);
                int off = -1;
                int bk = this.bkIndices[cp >> 8];
                if (bk != -1 && (off = this.lookup[(bk << 8) + (cp & 0xFF)]) != 0) {
                    int len = off & 0xFF;
                    off >>>= 8;
                    if (bname.length == len) {
                        int i;
                        for (i = 0; i < len && bname[i] == this.strPool[off++]; ++i) {
                        }
                        if (i == len) {
                            return cp;
                        }
                    }
                }
            }
            idx = this.getCpNext(idx);
        }
        return -1;
    }
}

