/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.loader.NativeLibraries;
import jdk.internal.loader.NativeLibrary;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.perf.PerfCounter;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.util.StaticProperty;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private final ClassLoader parent;
    private final String name;
    private final Module unnamedModule;
    private final String nameAndId;
    private final ConcurrentHashMap<String, Object> parallelLockMap;
    private final ConcurrentHashMap<String, Certificate[]> package2certs;
    private static final Certificate[] nocerts;
    private final ArrayList<Class<?>> classes = new ArrayList();
    private final ProtectionDomain defaultDomain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, this, null);
    private final ConcurrentHashMap<String, NamedPackage> packages = new ConcurrentHashMap();
    private static volatile ClassLoader scl;
    private final NativeLibraries libraries = NativeLibraries.jniNativeLibraries(this);
    final Object assertionLock;
    private boolean defaultAssertionStatus = false;
    private Map<String, Boolean> packageAssertionStatus = null;
    Map<String, Boolean> classAssertionStatus = null;
    private volatile ConcurrentHashMap<?, ?> classLoaderValueMap;

    private static native void registerNatives();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClass(Class<?> c) {
        ArrayList<Class<?>> arrayList = this.classes;
        synchronized (arrayList) {
            this.classes.add(c);
        }
    }

    private NamedPackage getNamedPackage(String pn, Module m) {
        NamedPackage value;
        NamedPackage p = this.packages.get(pn);
        if (p == null && (value = this.packages.putIfAbsent(pn, p = new NamedPackage(pn, m))) != null) {
            p = value;
            assert (value.module() == m);
        }
        return p;
    }

    private static Void checkCreateClassLoader() {
        return ClassLoader.checkCreateClassLoader(null);
    }

    private static Void checkCreateClassLoader(String name) {
        if (name != null && name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-empty or null");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkCreateClassLoader();
        }
        return null;
    }

    private ClassLoader(Void unused, String name, ClassLoader parent) {
        this.name = name;
        this.parent = parent;
        this.unnamedModule = new Module(this);
        if (ParallelLoaders.isRegistered(this.getClass())) {
            this.parallelLockMap = new ConcurrentHashMap();
            this.assertionLock = new Object();
        } else {
            this.parallelLockMap = null;
            this.assertionLock = this;
        }
        this.package2certs = new ConcurrentHashMap();
        this.nameAndId = ClassLoader.nameAndId(this);
    }

    private static String nameAndId(ClassLoader ld) {
        String nid;
        String string = nid = ld.getName() != null ? "'" + ld.getName() + "'" : ld.getClass().getName();
        if (!(ld instanceof BuiltinClassLoader)) {
            String id = Integer.toHexString(System.identityHashCode(ld));
            nid = nid + " @" + id;
        }
        return nid;
    }

    protected ClassLoader(String name, ClassLoader parent) {
        this(ClassLoader.checkCreateClassLoader(name), name, parent);
    }

    protected ClassLoader(ClassLoader parent) {
        this(ClassLoader.checkCreateClassLoader(), null, parent);
    }

    protected ClassLoader() {
        this(ClassLoader.checkCreateClassLoader(), null, ClassLoader.getSystemClassLoader());
    }

    public String getName() {
        return this.name;
    }

    final String name() {
        return this.name;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object2 = this.getClassLoadingLock(name);
        synchronized (object2) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                long t0 = System.nanoTime();
                try {
                    c = this.parent != null ? this.parent.loadClass(name, false) : ClassLoader.findBootstrapClassOrNull(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    long t1 = System.nanoTime();
                    c = this.findClass(name);
                    PerfCounter.getParentDelegationTime().addTime(t1 - t0);
                    PerfCounter.getFindClassTime().addElapsedTimeFrom(t1);
                    PerfCounter.getFindClasses().increment();
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Class<?> loadClass(Module module, String name) {
        Object object2 = this.getClassLoadingLock(name);
        synchronized (object2) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(module.getName(), name);
            }
            if (c != null && c.getModule() == module) {
                return c;
            }
            return null;
        }
    }

    protected Object getClassLoadingLock(String className) {
        Object newLock;
        Object lock = this;
        if (this.parallelLockMap != null && (lock = this.parallelLockMap.putIfAbsent(className, newLock = new Object())) == null) {
            lock = newLock;
        }
        return lock;
    }

    private void checkPackageAccess(Class<?> cls, ProtectionDomain pd) {
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (ReflectUtil.isNonPublicProxyClass(cls)) {
                for (Class<?> intf : cls.getInterfaces()) {
                    this.checkPackageAccess(intf, pd);
                }
                return;
            }
            final String packageName = cls.getPackageName();
            if (!packageName.isEmpty()) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        sm.checkPackageAccess(packageName);
                        return null;
                    }
                }, new AccessControlContext(new ProtectionDomain[]{pd}));
            }
        }
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    protected Class<?> findClass(String moduleName, String name) {
        if (moduleName == null) {
            try {
                return this.findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated(since="1.1")
    protected final Class<?> defineClass(byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(null, b, off, len, null);
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len) throws ClassFormatError {
        return this.defineClass(name, b, off, len, null);
    }

    private ProtectionDomain preDefineClass(String name, ProtectionDomain pd) {
        if (!ClassLoader.checkName(name)) {
            throw new NoClassDefFoundError("IllegalName: " + name);
        }
        if (name != null && name.startsWith("java.") && this != ClassLoader.getBuiltinPlatformClassLoader()) {
            throw new SecurityException("Prohibited package name: " + name.substring(0, name.lastIndexOf(46)));
        }
        if (pd == null) {
            pd = this.defaultDomain;
        }
        if (name != null) {
            this.checkCerts(name, pd.getCodeSource());
        }
        return pd;
    }

    private String defineClassSourceLocation(ProtectionDomain pd) {
        CodeSource cs = pd.getCodeSource();
        String source = null;
        if (cs != null && cs.getLocation() != null) {
            source = cs.getLocation().toString();
        }
        return source;
    }

    private void postDefineClass(Class<?> c, ProtectionDomain pd) {
        Object[] certs;
        this.getNamedPackage(c.getPackageName(), c.getModule());
        if (pd.getCodeSource() != null && (certs = pd.getCodeSource().getCertificates()) != null) {
            this.setSigners(c, certs);
        }
    }

    protected final Class<?> defineClass(String name, byte[] b, int off, int len, ProtectionDomain protectionDomain) throws ClassFormatError {
        protectionDomain = this.preDefineClass(name, protectionDomain);
        String source = this.defineClassSourceLocation(protectionDomain);
        Class<?> c = ClassLoader.defineClass1(this, name, b, off, len, protectionDomain, source);
        this.postDefineClass(c, protectionDomain);
        return c;
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        int len = b.remaining();
        if (!b.isDirect()) {
            if (b.hasArray()) {
                return this.defineClass(name, b.array(), b.position() + b.arrayOffset(), len, protectionDomain);
            }
            byte[] tb = new byte[len];
            b.get(tb);
            return this.defineClass(name, tb, 0, len, protectionDomain);
        }
        protectionDomain = this.preDefineClass(name, protectionDomain);
        String source = this.defineClassSourceLocation(protectionDomain);
        Class<?> c = ClassLoader.defineClass2(this, name, b, b.position(), len, protectionDomain, source);
        this.postDefineClass(c, protectionDomain);
        return c;
    }

    static native Class<?> defineClass1(ClassLoader var0, String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    static native Class<?> defineClass2(ClassLoader var0, String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    static native Class<?> defineClass0(ClassLoader var0, Class<?> var1, String var2, byte[] var3, int var4, int var5, ProtectionDomain var6, boolean var7, int var8, Object var9);

    private static boolean checkName(String name) {
        if (name == null || name.isEmpty()) {
            return true;
        }
        return name.indexOf(47) == -1 && name.charAt(0) != '[';
    }

    private void checkCerts(String name, CodeSource cs) {
        Certificate[] pcerts;
        int i = name.lastIndexOf(46);
        String pname = i == -1 ? "" : name.substring(0, i);
        Certificate[] certs = null;
        if (cs != null) {
            certs = cs.getCertificates();
        }
        if ((pcerts = this.package2certs.putIfAbsent(pname, certs = certs == null ? nocerts : certs)) != null && !this.compareCerts(pcerts, certs)) {
            throw new SecurityException("class \"" + name + "\"'s signer information does not match signer information of other classes in the same package");
        }
    }

    private boolean compareCerts(Certificate[] pcerts, Certificate[] certs) {
        boolean match;
        if (certs.length == 0) {
            return pcerts.length == 0;
        }
        if (certs.length != pcerts.length) {
            return false;
        }
        for (Certificate cert : certs) {
            match = false;
            for (Certificate pcert : pcerts) {
                if (!cert.equals(pcert)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        for (Certificate pcert : pcerts) {
            match = false;
            for (Certificate cert : certs) {
                if (!pcert.equals(cert)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
    }

    protected final Class<?> findSystemClass(String name) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(name);
    }

    static Class<?> findBootstrapClassOrNull(String name) {
        if (!ClassLoader.checkName(name)) {
            return null;
        }
        return ClassLoader.findBootstrapClass(name);
    }

    private static native Class<?> findBootstrapClass(String var0);

    protected final Class<?> findLoadedClass(String name) {
        if (!ClassLoader.checkName(name)) {
            return null;
        }
        return this.findLoadedClass0(name);
    }

    private final native Class<?> findLoadedClass0(String var1);

    protected final void setSigners(Class<?> c, Object[] signers) {
        c.setSigners(signers);
    }

    protected URL findResource(String moduleName, String name) throws IOException {
        if (moduleName == null) {
            return this.findResource(name);
        }
        return null;
    }

    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.parent != null ? this.parent.getResource(name) : BootLoader.findResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        Enumeration[] tmp = new Enumeration[]{this.parent != null ? this.parent.getResources(name) : BootLoader.findResources(name), this.findResources(name)};
        return new CompoundEnumeration<URL>(tmp);
    }

    public Stream<URL> resources(String name) {
        Objects.requireNonNull(name);
        int characteristics = 1280;
        Supplier<Spliterator> si = () -> {
            try {
                return Spliterators.spliteratorUnknownSize(this.getResources(name).asIterator(), characteristics);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return StreamSupport.stream(si, characteristics, false);
    }

    protected URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name) throws IOException {
        return Collections.emptyEnumeration();
    }

    @CallerSensitive
    protected static boolean registerAsParallelCapable() {
        Class<ClassLoader> callerClass = Reflection.getCallerClass().asSubclass(ClassLoader.class);
        return ParallelLoaders.register(callerClass);
    }

    public final boolean isRegisteredAsParallelCapable() {
        return ParallelLoaders.isRegistered(this.getClass());
    }

    public static URL getSystemResource(String name) {
        return ClassLoader.getSystemClassLoader().getResource(name);
    }

    public static Enumeration<URL> getSystemResources(String name) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        Objects.requireNonNull(name);
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String name) {
        URL url = ClassLoader.getSystemResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @CallerSensitive
    public final ClassLoader getParent() {
        if (this.parent == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(this.parent, Reflection.getCallerClass());
        }
        return this.parent;
    }

    public final Module getUnnamedModule() {
        return this.unnamedModule;
    }

    @CallerSensitive
    public static ClassLoader getPlatformClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader loader = ClassLoader.getBuiltinPlatformClassLoader();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(loader, Reflection.getCallerClass());
        }
        return loader;
    }

    @CallerSensitive
    public static ClassLoader getSystemClassLoader() {
        switch (VM.initLevel()) {
            case 0: 
            case 1: 
            case 2: {
                return ClassLoader.getBuiltinAppClassLoader();
            }
            case 3: {
                String msg = "getSystemClassLoader cannot be called during the system class loader instantiation";
                throw new IllegalStateException(msg);
            }
        }
        assert (VM.isBooted() && scl != null);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(scl, Reflection.getCallerClass());
        }
        return scl;
    }

    static ClassLoader getBuiltinPlatformClassLoader() {
        return ClassLoaders.platformClassLoader();
    }

    static ClassLoader getBuiltinAppClassLoader() {
        return ClassLoaders.appClassLoader();
    }

    static synchronized ClassLoader initSystemClassLoader() {
        if (VM.initLevel() != 3) {
            throw new InternalError("system class loader cannot be set at initLevel " + VM.initLevel());
        }
        if (scl != null) {
            throw new IllegalStateException("recursive invocation");
        }
        ClassLoader builtinLoader = ClassLoader.getBuiltinAppClassLoader();
        String cn = System.getProperty("java.system.class.loader");
        if (cn != null) {
            try {
                Constructor<?> ctor = Class.forName(cn, false, builtinLoader).getDeclaredConstructor(ClassLoader.class);
                scl = (ClassLoader)ctor.newInstance(builtinLoader);
            }
            catch (Exception e) {
                Throwable cause = e;
                if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new Error(cause.getMessage(), cause);
            }
        } else {
            scl = builtinLoader;
        }
        return scl;
    }

    boolean isAncestor(ClassLoader cl) {
        ClassLoader acl = this;
        do {
            if (cl != (acl = acl.parent)) continue;
            return true;
        } while (acl != null);
        return false;
    }

    private static boolean needsClassLoaderPermissionCheck(ClassLoader from, ClassLoader to) {
        if (from == to) {
            return false;
        }
        if (from == null) {
            return false;
        }
        return !to.isAncestor(from);
    }

    static ClassLoader getClassLoader(Class<?> caller) {
        if (caller == null) {
            return null;
        }
        return caller.getClassLoader0();
    }

    static void checkClassLoaderPermission(ClassLoader cl, Class<?> caller) {
        ClassLoader ccl;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && ClassLoader.needsClassLoaderPermissionCheck(ccl = ClassLoader.getClassLoader(caller), cl)) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    Package definePackage(Class<?> c) {
        if (c.isPrimitive() || c.isArray()) {
            return null;
        }
        return this.definePackage(c.getPackageName(), c.getModule());
    }

    Package definePackage(String name, Module m) {
        if (name.isEmpty() && m.isNamed()) {
            throw new InternalError("unnamed package in  " + m);
        }
        NamedPackage pkg = this.packages.get(name);
        if (pkg instanceof Package) {
            return (Package)pkg;
        }
        return (Package)this.packages.compute(name, (n, p) -> this.toPackage((String)n, (NamedPackage)p, m));
    }

    private Package toPackage(String name, NamedPackage p, Module m) {
        if (p == null) {
            return NamedPackage.toPackage(name, m);
        }
        if (p instanceof Package) {
            return (Package)p;
        }
        return NamedPackage.toPackage(p.packageName(), p.module());
    }

    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        Objects.requireNonNull(name);
        Package p = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase, this);
        if (this.packages.putIfAbsent(name, p) != null) {
            throw new IllegalArgumentException(name);
        }
        return p;
    }

    public final Package getDefinedPackage(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        NamedPackage p = this.packages.get(name);
        if (p == null) {
            return null;
        }
        return this.definePackage(name, p.module());
    }

    public final Package[] getDefinedPackages() {
        return (Package[])this.packages().toArray(Package[]::new);
    }

    @Deprecated(since="9")
    protected Package getPackage(String name) {
        Package pkg = this.getDefinedPackage(name);
        if (pkg == null) {
            pkg = this.parent != null ? this.parent.getPackage(name) : BootLoader.getDefinedPackage(name);
        }
        return pkg;
    }

    protected Package[] getPackages() {
        Stream<Package> pkgs = this.packages();
        ClassLoader ld = this.parent;
        while (ld != null) {
            pkgs = Stream.concat(ld.packages(), pkgs);
            ld = ld.parent;
        }
        return (Package[])Stream.concat(BootLoader.packages(), pkgs).toArray(Package[]::new);
    }

    Stream<Package> packages() {
        return this.packages.values().stream().map(p -> this.definePackage(p.packageName(), p.module()));
    }

    protected String findLibrary(String libname) {
        return null;
    }

    static NativeLibrary loadLibrary(Class<?> fromClass, File file) {
        ClassLoader loader = fromClass == null ? null : fromClass.getClassLoader();
        NativeLibraries libs = loader != null ? loader.libraries : BootLoader.getNativeLibraries();
        NativeLibrary nl = libs.loadLibrary(fromClass, file);
        if (nl != null) {
            return nl;
        }
        throw new UnsatisfiedLinkError("Can't load library: " + file);
    }

    static NativeLibrary loadLibrary(Class<?> fromClass, String name) {
        ClassLoader loader;
        ClassLoader classLoader = loader = fromClass == null ? null : fromClass.getClassLoader();
        if (loader == null) {
            NativeLibrary nl = BootLoader.getNativeLibraries().loadLibrary(fromClass, name);
            if (nl != null) {
                return nl;
            }
            throw new UnsatisfiedLinkError("no " + name + " in system library path: " + StaticProperty.sunBootLibraryPath());
        }
        NativeLibraries libs = loader.libraries;
        String libfilename = loader.findLibrary(name);
        if (libfilename != null) {
            File libfile = new File(libfilename);
            if (!libfile.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + libfilename);
            }
            NativeLibrary nl = libs.loadLibrary(fromClass, libfile);
            if (nl != null) {
                return nl;
            }
            throw new UnsatisfiedLinkError("Can't load " + libfilename);
        }
        NativeLibrary nl = libs.loadLibrary(fromClass, name);
        if (nl != null) {
            return nl;
        }
        throw new UnsatisfiedLinkError("no " + name + " in java.library.path: " + StaticProperty.javaLibraryPath());
    }

    static long findNative(ClassLoader loader, String entryName) {
        if (loader == null) {
            return BootLoader.getNativeLibraries().find(entryName);
        }
        return loader.libraries.find(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssertionStatus(boolean enabled) {
        Object object2 = this.assertionLock;
        synchronized (object2) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.defaultAssertionStatus = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        Object object2 = this.assertionLock;
        synchronized (object2) {
            if (this.packageAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.packageAssertionStatus.put(packageName, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassAssertionStatus(String className, boolean enabled) {
        Object object2 = this.assertionLock;
        synchronized (object2) {
            if (this.classAssertionStatus == null) {
                this.initializeJavaAssertionMaps();
            }
            this.classAssertionStatus.put(className, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAssertionStatus() {
        Object object2 = this.assertionLock;
        synchronized (object2) {
            this.classAssertionStatus = new HashMap<String, Boolean>();
            this.packageAssertionStatus = new HashMap<String, Boolean>();
            this.defaultAssertionStatus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean desiredAssertionStatus(String className) {
        Object object2 = this.assertionLock;
        synchronized (object2) {
            Boolean result = this.classAssertionStatus.get(className);
            if (result != null) {
                return result;
            }
            int dotIndex = className.lastIndexOf(46);
            if (dotIndex < 0 && (result = this.packageAssertionStatus.get(null)) != null) {
                return result;
            }
            while (dotIndex > 0) {
                result = this.packageAssertionStatus.get(className = className.substring(0, dotIndex));
                if (result != null) {
                    return result;
                }
                dotIndex = className.lastIndexOf(46, dotIndex - 1);
            }
            return this.defaultAssertionStatus;
        }
    }

    private void initializeJavaAssertionMaps() {
        int i;
        this.classAssertionStatus = new HashMap<String, Boolean>();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        AssertionStatusDirectives directives = ClassLoader.retrieveDirectives();
        for (i = 0; i < directives.classes.length; ++i) {
            this.classAssertionStatus.put(directives.classes[i], directives.classEnabled[i]);
        }
        for (i = 0; i < directives.packages.length; ++i) {
            this.packageAssertionStatus.put(directives.packages[i], directives.packageEnabled[i]);
        }
        this.defaultAssertionStatus = directives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap() {
        boolean set;
        ConcurrentHashMap<Object, Object> map = this.classLoaderValueMap;
        if (map == null && !(set = this.trySetObjectField("classLoaderValueMap", map = new ConcurrentHashMap()))) {
            map = this.classLoaderValueMap;
        }
        return map;
    }

    private boolean trySetObjectField(String name, Object obj) {
        Unsafe unsafe = Unsafe.getUnsafe();
        Class<ClassLoader> k = ClassLoader.class;
        long offset = unsafe.objectFieldOffset(k, name);
        return unsafe.compareAndSetReference(this, offset, null, obj);
    }

    private void resetArchivedStates() {
        this.parallelLockMap.clear();
        this.packages.clear();
        this.package2certs.clear();
        this.classes.clear();
        this.classLoaderValueMap = null;
    }

    static {
        ClassLoader.registerNatives();
        nocerts = new Certificate[0];
    }

    private static class ParallelLoaders {
        private static final Set<Class<? extends ClassLoader>> loaderTypes;

        private ParallelLoaders() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean register(Class<? extends ClassLoader> c) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                if (loaderTypes.contains(c.getSuperclass())) {
                    loaderTypes.add(c);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static boolean isRegistered(Class<? extends ClassLoader> c) {
            Set<Class<? extends ClassLoader>> set = loaderTypes;
            synchronized (set) {
                return loaderTypes.contains(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            Set<Class<? extends ClassLoader>> set = loaderTypes = Collections.newSetFromMap(new WeakHashMap());
            synchronized (set) {
                loaderTypes.add(ClassLoader.class);
            }
        }
    }
}

