/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import sun.text.Normalizer;

final class ConditionalSpecialCasing {
    static final int FINAL_CASED = 1;
    static final int AFTER_SOFT_DOTTED = 2;
    static final int MORE_ABOVE = 3;
    static final int AFTER_I = 4;
    static final int NOT_BEFORE_DOT = 5;
    static final int COMBINING_CLASS_ABOVE = 230;
    static Entry[] entry = new Entry[]{new Entry(931, new char[]{'\u03c2'}, new char[]{'\u03a3'}, null, 1), new Entry(304, new char[]{'i', '\u0307'}, new char[]{'\u0130'}, null, 0), new Entry(775, new char[]{'\u0307'}, new char[0], "lt", 2), new Entry(73, new char[]{'i', '\u0307'}, new char[]{'I'}, "lt", 3), new Entry(74, new char[]{'j', '\u0307'}, new char[]{'J'}, "lt", 3), new Entry(302, new char[]{'\u012f', '\u0307'}, new char[]{'\u012e'}, "lt", 3), new Entry(204, new char[]{'i', '\u0307', '\u0300'}, new char[]{'\u00cc'}, "lt", 0), new Entry(205, new char[]{'i', '\u0307', '\u0301'}, new char[]{'\u00cd'}, "lt", 0), new Entry(296, new char[]{'i', '\u0307', '\u0303'}, new char[]{'\u0128'}, "lt", 0), new Entry(304, new char[]{'i'}, new char[]{'\u0130'}, "tr", 0), new Entry(304, new char[]{'i'}, new char[]{'\u0130'}, "az", 0), new Entry(775, new char[0], new char[]{'\u0307'}, "tr", 4), new Entry(775, new char[0], new char[]{'\u0307'}, "az", 4), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "tr", 5), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "az", 5), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "tr", 0), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "az", 0)};
    static Hashtable<Integer, HashSet<Entry>> entryTable = new Hashtable();

    ConditionalSpecialCasing() {
    }

    static int toLowerCaseEx(String src, int index, Locale locale) {
        char[] result = ConditionalSpecialCasing.lookUpTable(src, index, locale, true);
        if (result != null) {
            if (result.length == 1) {
                return result[0];
            }
            return -1;
        }
        return Character.toLowerCase(src.codePointAt(index));
    }

    static int toUpperCaseEx(String src, int index, Locale locale) {
        char[] result = ConditionalSpecialCasing.lookUpTable(src, index, locale, false);
        if (result != null) {
            if (result.length == 1) {
                return result[0];
            }
            return -1;
        }
        return Character.toUpperCaseEx(src.codePointAt(index));
    }

    static char[] toLowerCaseCharArray(String src, int index, Locale locale) {
        return ConditionalSpecialCasing.lookUpTable(src, index, locale, true);
    }

    static char[] toUpperCaseCharArray(String src, int index, Locale locale) {
        char[] result = ConditionalSpecialCasing.lookUpTable(src, index, locale, false);
        if (result != null) {
            return result;
        }
        return Character.toUpperCaseCharArray(src.codePointAt(index));
    }

    private static char[] lookUpTable(String src, int index, Locale locale, boolean bLowerCasing) {
        HashSet<Entry> set = entryTable.get(src.codePointAt(index));
        char[] ret = null;
        if (set != null) {
            Iterator<Entry> iter = set.iterator();
            String currentLang = locale.getLanguage();
            while (iter.hasNext()) {
                Entry entry = iter.next();
                String conditionLang = entry.getLanguage();
                if (conditionLang != null && !conditionLang.equals(currentLang) || !ConditionalSpecialCasing.isConditionMet(src, index, locale, entry.getCondition())) continue;
                char[] cArray = ret = bLowerCasing ? entry.getLowerCase() : entry.getUpperCase();
                if (conditionLang == null) continue;
                break;
            }
        }
        return ret;
    }

    private static boolean isConditionMet(String src, int index, Locale locale, int condition) {
        return switch (condition) {
            case 1 -> ConditionalSpecialCasing.isFinalCased(src, index, locale);
            case 2 -> ConditionalSpecialCasing.isAfterSoftDotted(src, index);
            case 3 -> ConditionalSpecialCasing.isMoreAbove(src, index);
            case 4 -> ConditionalSpecialCasing.isAfterI(src, index);
            case 5 -> {
                if (!ConditionalSpecialCasing.isBeforeDot(src, index)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static boolean isFinalCased(String src, int index, Locale locale) {
        int ch;
        BreakIterator wordBoundary = BreakIterator.getWordInstance(locale);
        wordBoundary.setText(src);
        for (int i = index; i >= 0 && !wordBoundary.isBoundary(i); i -= Character.charCount(ch)) {
            ch = src.codePointBefore(i);
            if (!ConditionalSpecialCasing.isCased(ch)) continue;
            int len = src.length();
            for (i = index + Character.charCount(src.codePointAt(index)); i < len && !wordBoundary.isBoundary(i); i += Character.charCount(ch)) {
                ch = src.codePointAt(i);
                if (!ConditionalSpecialCasing.isCased(ch)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAfterI(String src, int index) {
        int ch;
        for (int i = index; i > 0; i -= Character.charCount(ch)) {
            ch = src.codePointBefore(i);
            if (ch == 73) {
                return true;
            }
            int cc = Normalizer.getCombiningClass(ch);
            if (cc != 0 && cc != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isAfterSoftDotted(String src, int index) {
        int ch;
        for (int i = index; i > 0; i -= Character.charCount(ch)) {
            ch = src.codePointBefore(i);
            if (ConditionalSpecialCasing.isSoftDotted(ch)) {
                return true;
            }
            int cc = Normalizer.getCombiningClass(ch);
            if (cc != 0 && cc != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isMoreAbove(String src, int index) {
        int ch;
        int len = src.length();
        for (int i = index + Character.charCount(src.codePointAt(index)); i < len; i += Character.charCount(ch)) {
            ch = src.codePointAt(i);
            int cc = Normalizer.getCombiningClass(ch);
            if (cc == 230) {
                return true;
            }
            if (cc != 0) continue;
            return false;
        }
        return false;
    }

    private static boolean isBeforeDot(String src, int index) {
        int ch;
        int len = src.length();
        for (int i = index + Character.charCount(src.codePointAt(index)); i < len; i += Character.charCount(ch)) {
            ch = src.codePointAt(i);
            if (ch == 775) {
                return true;
            }
            int cc = Normalizer.getCombiningClass(ch);
            if (cc != 0 && cc != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isCased(int ch) {
        int type = Character.getType(ch);
        if (type == 2 || type == 1 || type == 3) {
            return true;
        }
        if (ch >= 688 && ch <= 696) {
            return true;
        }
        if (ch >= 704 && ch <= 705) {
            return true;
        }
        if (ch >= 736 && ch <= 740) {
            return true;
        }
        if (ch == 837) {
            return true;
        }
        if (ch == 890) {
            return true;
        }
        if (ch >= 7468 && ch <= 7521) {
            return true;
        }
        if (ch >= 8544 && ch <= 8575) {
            return true;
        }
        return ch >= 9398 && ch <= 9449;
    }

    private static boolean isSoftDotted(int ch) {
        switch (ch) {
            case 105: 
            case 106: 
            case 303: 
            case 616: 
            case 1110: 
            case 1112: 
            case 7522: 
            case 7725: 
            case 7883: 
            case 8305: {
                return true;
            }
        }
        return false;
    }

    static {
        for (Entry cur : entry) {
            Integer cp = cur.getCodePoint();
            HashSet<Entry> set = entryTable.get(cp);
            if (set == null) {
                set = new HashSet();
                entryTable.put(cp, set);
            }
            set.add(cur);
        }
    }

    static class Entry {
        int ch;
        char[] lower;
        char[] upper;
        String lang;
        int condition;

        Entry(int ch, char[] lower, char[] upper, String lang, int condition) {
            this.ch = ch;
            this.lower = lower;
            this.upper = upper;
            this.lang = lang;
            this.condition = condition;
        }

        int getCodePoint() {
            return this.ch;
        }

        char[] getLowerCase() {
            return this.lower;
        }

        char[] getUpperCase() {
            return this.upper;
        }

        String getLanguage() {
            return this.lang;
        }

        int getCondition() {
            return this.condition;
        }
    }
}

