/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Optional;

public abstract class Enum<E extends Enum<E>>
implements Constable,
Comparable<E>,
Serializable {
    private final String name;
    private final int ordinal;

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    protected Enum(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public final int compareTo(E o) {
        E other = o;
        Enum self = this;
        if (self.getClass() != other.getClass() && self.getDeclaringClass() != ((Enum)other).getDeclaringClass()) {
            throw new ClassCastException();
        }
        return self.ordinal - ((Enum)other).ordinal;
    }

    public final Class<E> getDeclaringClass() {
        Class<?> clazz = this.getClass();
        Class<?> zuper = clazz.getSuperclass();
        return zuper == Enum.class ? clazz : zuper;
    }

    public final Optional<EnumDesc<E>> describeConstable() {
        return this.getDeclaringClass().describeConstable().map(c -> EnumDesc.of(c, this.name));
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumClass, String name) {
        Enum result = (Enum)enumClass.enumConstantDirectory().get(name);
        if (result != null) {
            return (T)result;
        }
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        throw new IllegalArgumentException("No enum constant " + enumClass.getCanonicalName() + "." + name);
    }

    protected final void finalize() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("can't deserialize enum");
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("can't deserialize enum");
    }

    public static final class EnumDesc<E extends Enum<E>>
    extends DynamicConstantDesc<E> {
        private EnumDesc(ClassDesc constantClass, String constantName) {
            super(ConstantDescs.BSM_ENUM_CONSTANT, Objects.requireNonNull(constantName), Objects.requireNonNull(constantClass), new ConstantDesc[0]);
        }

        public static <E extends Enum<E>> EnumDesc<E> of(ClassDesc enumClass, String constantName) {
            return new EnumDesc<E>(enumClass, constantName);
        }

        @Override
        public E resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            return (E)Enum.valueOf((Class)this.constantType().resolveConstantDesc(lookup), this.constantName());
        }

        @Override
        public String toString() {
            return String.format("EnumDesc[%s.%s]", this.constantType().displayName(), this.constantName());
        }
    }
}

