/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.misc.VM;
import jdk.internal.vm.annotation.IntrinsicCandidate;

@ValueBased
public final class Integer
extends Number
implements Comparable<Integer>,
Constable,
ConstantDesc {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class<Integer> TYPE = Class.getPrimitiveClass("int");
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    static final int[] sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private final int value;
    public static final int SIZE = 32;
    public static final int BYTES = 4;
    private static final long serialVersionUID = 1360826667806852920L;

    public static String toString(int i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Integer.toString(i);
        }
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[33];
            boolean negative = i < 0;
            int charPos = 32;
            if (!negative) {
                i = -i;
            }
            while (i <= -radix) {
                buf[charPos--] = (byte)digits[-(i % radix)];
                i /= radix;
            }
            buf[charPos] = (byte)digits[-i];
            if (negative) {
                buf[--charPos] = 45;
            }
            return StringLatin1.newString(buf, charPos, 33 - charPos);
        }
        return Integer.toStringUTF16(i, radix);
    }

    private static String toStringUTF16(int i, int radix) {
        byte[] buf = new byte[66];
        boolean negative = i < 0;
        int charPos = 32;
        if (!negative) {
            i = -i;
        }
        while (i <= -radix) {
            StringUTF16.putChar(buf, charPos--, digits[-(i % radix)]);
            i /= radix;
        }
        StringUTF16.putChar(buf, charPos, digits[-i]);
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return StringUTF16.newString(buf, charPos, 33 - charPos);
    }

    public static String toUnsignedString(int i, int radix) {
        return Long.toUnsignedString(Integer.toUnsignedLong(i), radix);
    }

    public static String toHexString(int i) {
        return Integer.toUnsignedString0(i, 4);
    }

    public static String toOctalString(int i) {
        return Integer.toUnsignedString0(i, 3);
    }

    public static String toBinaryString(int i) {
        return Integer.toUnsignedString0(i, 1);
    }

    private static String toUnsignedString0(int val, int shift) {
        int mag = 32 - Integer.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[chars];
            Integer.formatUnsignedInt(val, shift, buf, chars);
            return new String(buf, 0);
        }
        byte[] buf = new byte[chars * 2];
        Integer.formatUnsignedIntUTF16(val, shift, buf, chars);
        return new String(buf, 1);
    }

    private static void formatUnsignedInt(int val, int shift, byte[] buf, int len) {
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = (byte)digits[val & mask];
            val >>>= shift;
        } while (charPos > 0);
    }

    private static void formatUnsignedIntUTF16(int val, int shift, byte[] buf, int len) {
        int charPos = len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            StringUTF16.putChar(buf, --charPos, digits[val & mask]);
            val >>>= shift;
        } while (charPos > 0);
    }

    @IntrinsicCandidate
    public static String toString(int i) {
        int size = Integer.stringSize(i);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[size];
            Integer.getChars(i, size, buf);
            return new String(buf, 0);
        }
        byte[] buf = new byte[size * 2];
        StringUTF16.getChars(i, size, buf);
        return new String(buf, 1);
    }

    public static String toUnsignedString(int i) {
        return Long.toString(Integer.toUnsignedLong(i));
    }

    static int getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            q = i / 100;
            r = q * 100 - i;
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        q = i / 10;
        r = q * 10 - i;
        buf[--charPos] = (byte)(48 + r);
        if (q < 0) {
            buf[--charPos] = (byte)(48 - q);
        }
        if (negative) {
            buf[--charPos] = 45;
        }
        return charPos;
    }

    static int stringSize(int x) {
        int d = 1;
        if (x >= 0) {
            d = 0;
            x = -x;
        }
        int p = -10;
        for (int i = 1; i < 10; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10 * p;
        }
        return 10 + d;
    }

    public static int parseInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = 0;
        int len = s.length();
        int limit = -2147483647;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forInputString(s, radix);
                }
                if (len == 1) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                ++i;
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                if ((result *= radix) < limit + digit) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                result -= digit;
            }
            return negative ? result : -result;
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static int parseInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        int limit = -2147483647;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if (++i == endIndex) {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= radix) < limit + digit) {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= digit;
            }
            return negative ? result : -result;
        }
        throw NumberFormatException.forInputString("", radix);
    }

    public static int parseInt(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    public static int parseUnsignedInt(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, radix);
            }
            long ell = Long.parseLong(s, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static int parseUnsignedInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = beginIndex;
        int len = endIndex - beginIndex;
        if (len > 0) {
            char firstChar = s.charAt(start);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 5 || radix == 10 && len <= 9) {
                return Integer.parseInt(s, start, start + len, radix);
            }
            long ell = Long.parseLong(s, start, start + len, radix);
            if ((ell & 0xFFFFFFFF00000000L) == 0L) {
                return (int)ell;
            }
            throw new NumberFormatException(String.format("String value %s exceeds range of unsigned int.", s));
        }
        throw new NumberFormatException("");
    }

    public static int parseUnsignedInt(String s) throws NumberFormatException {
        return Integer.parseUnsignedInt(s, 10);
    }

    public static Integer valueOf(String s, int radix) throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }

    public static Integer valueOf(String s) throws NumberFormatException {
        return Integer.parseInt(s, 10);
    }

    @IntrinsicCandidate
    public static Integer valueOf(int i) {
        if (i >= -128 && i <= IntegerCache.high) {
            return IntegerCache.cache[i + 128];
        }
        return new Integer(i);
    }

    @Deprecated(since="9", forRemoval=true)
    public Integer(int value) {
        this.value = value;
    }

    @Deprecated(since="9", forRemoval=true)
    public Integer(String s) throws NumberFormatException {
        this.value = Integer.parseInt(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    @IntrinsicCandidate
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public static int hashCode(int value) {
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.value == (Integer)obj;
        }
        return false;
    }

    public static Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? Integer.valueOf(val) : result;
    }

    public static Integer getInteger(String nm, Integer val) {
        String v = null;
        try {
            v = System.getProperty(nm);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (v != null) {
            try {
                return Integer.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    public static Integer decode(String nm) throws NumberFormatException {
        Integer result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.isEmpty()) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Integer.valueOf(nm.substring(index), radix);
            result = negative ? Integer.valueOf(-result.intValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Integer.valueOf(constant, radix);
        }
        return result;
    }

    @Override
    public int compareTo(Integer anotherInteger) {
        return Integer.compare(this.value, anotherInteger.value);
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(int x, int y) {
        return Integer.compare(x + Integer.MIN_VALUE, y + Integer.MIN_VALUE);
    }

    public static long toUnsignedLong(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static int divideUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) / Integer.toUnsignedLong(divisor));
    }

    public static int remainderUnsigned(int dividend, int divisor) {
        return (int)(Integer.toUnsignedLong(dividend) % Integer.toUnsignedLong(divisor));
    }

    public static int highestOneBit(int i) {
        return i & Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(i);
    }

    public static int lowestOneBit(int i) {
        return i & -i;
    }

    @IntrinsicCandidate
    public static int numberOfLeadingZeros(int i) {
        if (i <= 0) {
            return i == 0 ? 32 : 0;
        }
        int n = 31;
        if (i >= 65536) {
            n -= 16;
            i >>>= 16;
        }
        if (i >= 256) {
            n -= 8;
            i >>>= 8;
        }
        if (i >= 16) {
            n -= 4;
            i >>>= 4;
        }
        if (i >= 4) {
            n -= 2;
            i >>>= 2;
        }
        return n - (i >>> 1);
    }

    @IntrinsicCandidate
    public static int numberOfTrailingZeros(int i) {
        if ((i = ~i & i - 1) <= 0) {
            return i & 0x20;
        }
        int n = 1;
        if (i > 65536) {
            n += 16;
            i >>>= 16;
        }
        if (i > 256) {
            n += 8;
            i >>>= 8;
        }
        if (i > 16) {
            n += 4;
            i >>>= 4;
        }
        if (i > 4) {
            n += 2;
            i >>>= 2;
        }
        return n + (i >>> 1);
    }

    @IntrinsicCandidate
    public static int bitCount(int i) {
        i -= i >>> 1 & 0x55555555;
        i = (i & 0x33333333) + (i >>> 2 & 0x33333333);
        i = i + (i >>> 4) & 0xF0F0F0F;
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x3F;
    }

    public static int rotateLeft(int i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static int rotateRight(int i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static int reverse(int i) {
        i = (i & 0x55555555) << 1 | i >>> 1 & 0x55555555;
        i = (i & 0x33333333) << 2 | i >>> 2 & 0x33333333;
        i = (i & 0xF0F0F0F) << 4 | i >>> 4 & 0xF0F0F0F;
        return Integer.reverseBytes(i);
    }

    public static int signum(int i) {
        return i >> 31 | -i >>> 31;
    }

    @IntrinsicCandidate
    public static int reverseBytes(int i) {
        return i << 24 | (i & 0xFF00) << 8 | i >>> 8 & 0xFF00 | i >>> 24;
    }

    public static int sum(int a, int b) {
        return a + b;
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public Optional<Integer> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public Integer resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }

    private static class IntegerCache {
        static final int low = -128;
        static final int high;
        static final Integer[] cache;
        static Integer[] archivedCache;

        private IntegerCache() {
        }

        static {
            int h = 127;
            String integerCacheHighPropValue = VM.getSavedProperty("java.lang.Integer.IntegerCache.high");
            if (integerCacheHighPropValue != null) {
                try {
                    h = Math.max(Integer.parseInt(integerCacheHighPropValue), 127);
                    h = Math.min(h, 0x7FFFFF7E);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            high = h;
            CDS.initializeFromArchive(IntegerCache.class);
            int size = high - -128 + 1;
            if (archivedCache == null || size > archivedCache.length) {
                Integer[] c = new Integer[size];
                int j = -128;
                for (int i = 0; i < c.length; ++i) {
                    c[i] = new Integer(j++);
                }
                archivedCache = c;
            }
            cache = archivedCache;
            assert (high >= 127);
        }
    }
}

