/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.EnumSet;
import java.util.Set;

interface LiveStackFrame
extends StackWalker.StackFrame {
    public Object[] getMonitors();

    public Object[] getLocals();

    public Object[] getStack();

    public static StackWalker getStackWalker() {
        return LiveStackFrame.getStackWalker(EnumSet.noneOf(StackWalker.Option.class));
    }

    public static StackWalker getStackWalker(Set<StackWalker.Option> options) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("liveStackFrames"));
        }
        return StackWalker.newInstance(options, StackWalker.ExtendedOption.LOCALS_AND_OPERANDS);
    }

    public static abstract class PrimitiveSlot {
        PrimitiveSlot() {
        }

        public abstract int size();

        public int intValue() {
            throw new UnsupportedOperationException("this " + this.size() + "-byte primitive");
        }

        public long longValue() {
            throw new UnsupportedOperationException("this " + this.size() + "-byte primitive");
        }
    }
}

