/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import jdk.internal.ValueBased;
import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.IntrinsicCandidate;

@ValueBased
public final class Long
extends Number
implements Comparable<Long>,
Constable,
ConstantDesc {
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class<Long> TYPE = Class.getPrimitiveClass("long");
    private final long value;
    public static final int SIZE = 64;
    public static final int BYTES = 8;
    private static final long serialVersionUID = 4290774380558885855L;

    public static String toString(long i, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (radix == 10) {
            return Long.toString(i);
        }
        if (String.COMPACT_STRINGS) {
            boolean negative;
            byte[] buf = new byte[65];
            int charPos = 64;
            boolean bl = negative = i < 0L;
            if (!negative) {
                i = -i;
            }
            while (i <= (long)(-radix)) {
                buf[charPos--] = (byte)Integer.digits[(int)(-(i % (long)radix))];
                i /= (long)radix;
            }
            buf[charPos] = (byte)Integer.digits[(int)(-i)];
            if (negative) {
                buf[--charPos] = 45;
            }
            return StringLatin1.newString(buf, charPos, 65 - charPos);
        }
        return Long.toStringUTF16(i, radix);
    }

    private static String toStringUTF16(long i, int radix) {
        boolean negative;
        byte[] buf = new byte[130];
        int charPos = 64;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= (long)(-radix)) {
            StringUTF16.putChar(buf, charPos--, Integer.digits[(int)(-(i % (long)radix))]);
            i /= (long)radix;
        }
        StringUTF16.putChar(buf, charPos, Integer.digits[(int)(-i)]);
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return StringUTF16.newString(buf, charPos, 65 - charPos);
    }

    public static String toUnsignedString(long i, int radix) {
        if (i >= 0L) {
            return Long.toString(i, radix);
        }
        return switch (radix) {
            case 2 -> Long.toBinaryString(i);
            case 4 -> Long.toUnsignedString0(i, 2);
            case 8 -> Long.toOctalString(i);
            case 10 -> {
                long quot = (i >>> 1) / 5L;
                long rem = i - quot * 10L;
                yield Long.toString(quot) + rem;
            }
            case 16 -> Long.toHexString(i);
            case 32 -> Long.toUnsignedString0(i, 5);
            default -> Long.toUnsignedBigInteger(i).toString(radix);
        };
    }

    private static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static String toHexString(long i) {
        return Long.toUnsignedString0(i, 4);
    }

    public static String toOctalString(long i) {
        return Long.toUnsignedString0(i, 3);
    }

    public static String toBinaryString(long i) {
        return Long.toUnsignedString0(i, 1);
    }

    static String toUnsignedString0(long val, int shift) {
        int mag = 64 - Long.numberOfLeadingZeros(val);
        int chars = Math.max((mag + (shift - 1)) / shift, 1);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[chars];
            Long.formatUnsignedLong0(val, shift, buf, 0, chars);
            return new String(buf, 0);
        }
        byte[] buf = new byte[chars * 2];
        Long.formatUnsignedLong0UTF16(val, shift, buf, 0, chars);
        return new String(buf, 1);
    }

    private static void formatUnsignedLong0(long val, int shift, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            buf[--charPos] = (byte)Integer.digits[(int)val & mask];
            val >>>= shift;
        } while (charPos > offset);
    }

    private static void formatUnsignedLong0UTF16(long val, int shift, byte[] buf, int offset, int len) {
        int charPos = offset + len;
        int radix = 1 << shift;
        int mask = radix - 1;
        do {
            StringUTF16.putChar(buf, --charPos, Integer.digits[(int)val & mask]);
            val >>>= shift;
        } while (charPos > offset);
    }

    static String fastUUID(long lsb, long msb) {
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[36];
            Long.formatUnsignedLong0(lsb, 4, buf, 24, 12);
            Long.formatUnsignedLong0(lsb >>> 48, 4, buf, 19, 4);
            Long.formatUnsignedLong0(msb, 4, buf, 14, 4);
            Long.formatUnsignedLong0(msb >>> 16, 4, buf, 9, 4);
            Long.formatUnsignedLong0(msb >>> 32, 4, buf, 0, 8);
            buf[23] = 45;
            buf[18] = 45;
            buf[13] = 45;
            buf[8] = 45;
            return new String(buf, 0);
        }
        byte[] buf = new byte[72];
        Long.formatUnsignedLong0UTF16(lsb, 4, buf, 24, 12);
        Long.formatUnsignedLong0UTF16(lsb >>> 48, 4, buf, 19, 4);
        Long.formatUnsignedLong0UTF16(msb, 4, buf, 14, 4);
        Long.formatUnsignedLong0UTF16(msb >>> 16, 4, buf, 9, 4);
        Long.formatUnsignedLong0UTF16(msb >>> 32, 4, buf, 0, 8);
        StringUTF16.putChar(buf, 23, 45);
        StringUTF16.putChar(buf, 18, 45);
        StringUTF16.putChar(buf, 13, 45);
        StringUTF16.putChar(buf, 8, 45);
        return new String(buf, 1);
    }

    public static String toString(long i) {
        int size = Long.stringSize(i);
        if (String.COMPACT_STRINGS) {
            byte[] buf = new byte[size];
            Long.getChars(i, size, buf);
            return new String(buf, 0);
        }
        byte[] buf = new byte[size * 2];
        StringUTF16.getChars(i, size, buf);
        return new String(buf, 1);
    }

    public static String toUnsignedString(long i) {
        return Long.toUnsignedString(i, 10);
    }

    static int getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            buf[--charPos] = Integer.DigitOnes[r];
            buf[--charPos] = Integer.DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            q2 = i2 / 100;
            r = q2 * 100 - i2;
            i2 = q2;
            buf[--charPos] = Integer.DigitOnes[r];
            buf[--charPos] = Integer.DigitTens[r];
        }
        q2 = i2 / 10;
        r = q2 * 10 - i2;
        buf[--charPos] = (byte)(48 + r);
        if (q2 < 0) {
            buf[--charPos] = (byte)(48 - q2);
        }
        if (negative) {
            buf[--charPos] = 45;
        }
        return charPos;
    }

    static int stringSize(long x) {
        int d = 1;
        if (x >= 0L) {
            d = 0;
            x = -x;
        }
        long p = -10L;
        for (int i = 1; i < 19; ++i) {
            if (x > p) {
                return i + d;
            }
            p = 10L * p;
        }
        return 19 + d;
    }

    public static long parseLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = 0;
        int len = s.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forInputString(s, radix);
                }
                if (len == 1) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            long result = 0L;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s.charAt(i++), radix)) < 0 || result < multmin) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw NumberFormatException.forInputString(s, radix);
                }
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static long parseLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        long limit = -9223372036854775807L;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
            }
            if (i >= endIndex) {
                throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
            }
            long multmin = limit / (long)radix;
            long result = 0L;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw NumberFormatException.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        throw new NumberFormatException("");
    }

    public static long parseLong(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    public static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("Cannot parse null string");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = Long.parseLong(s, 0, len - 1, radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s);
            }
            long result = first * (long)radix + (long)second;
            int guard = radix * (int)(first >>> 57);
            if (guard >= 128 || result >= 0L && guard >= 92) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return result;
        }
        throw NumberFormatException.forInputString(s, radix);
    }

    public static long parseUnsignedLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        int start = beginIndex;
        int len = endIndex - beginIndex;
        if (len > 0) {
            char firstChar = s.charAt(start);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s.subSequence(start, start + len)));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, start, start + len, radix);
            }
            long first = Long.parseLong(s, start, start + len - 1, radix);
            int second = Character.digit(s.charAt(start + len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s.subSequence(start, start + len));
            }
            long result = first * (long)radix + (long)second;
            int guard = radix * (int)(first >>> 57);
            if (guard >= 128 || result >= 0L && guard >= 92) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s.subSequence(start, start + len)));
            }
            return result;
        }
        throw NumberFormatException.forInputString("", radix);
    }

    public static long parseUnsignedLong(String s) throws NumberFormatException {
        return Long.parseUnsignedLong(s, 10);
    }

    public static Long valueOf(String s, int radix) throws NumberFormatException {
        return Long.parseLong(s, radix);
    }

    public static Long valueOf(String s) throws NumberFormatException {
        return Long.parseLong(s, 10);
    }

    @IntrinsicCandidate
    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Long decode(String nm) throws NumberFormatException {
        Long result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.isEmpty()) {
            throw new NumberFormatException("Zero length string");
        }
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index) || nm.startsWith("+", index)) {
            throw new NumberFormatException("Sign character in wrong position");
        }
        try {
            result = Long.valueOf(nm.substring(index), radix);
            result = negative ? Long.valueOf(-result.longValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            result = Long.valueOf(constant, radix);
        }
        return result;
    }

    @Deprecated(since="9", forRemoval=true)
    public Long(long value) {
        this.value = value;
    }

    @Deprecated(since="9", forRemoval=true)
    public Long(String s) throws NumberFormatException {
        this.value = Long.parseLong(s, 10);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    @IntrinsicCandidate
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Long) {
            return this.value == (Long)obj;
        }
        return false;
    }

    public static Long getLong(String nm) {
        return Long.getLong(nm, null);
    }

    public static Long getLong(String nm, long val) {
        Long result = Long.getLong(nm, null);
        return result == null ? Long.valueOf(val) : result;
    }

    public static Long getLong(String nm, Long val) {
        String v = null;
        try {
            v = System.getProperty(nm);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (v != null) {
            try {
                return Long.decode(v);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public int compareTo(Long anotherLong) {
        return Long.compare(this.value, anotherLong.value);
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int compareUnsigned(long x, long y) {
        return Long.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    public static long divideUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return q + ((r | r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
        }
        return (dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >>> 63;
    }

    public static long remainderUnsigned(long dividend, long divisor) {
        if (divisor >= 0L) {
            long q = (dividend >>> 1) / divisor << 1;
            long r = dividend - q * divisor;
            return r - ((r - divisor ^ 0xFFFFFFFFFFFFFFFFL) >> 63 & divisor);
        }
        return dividend - ((dividend & (dividend - divisor ^ 0xFFFFFFFFFFFFFFFFL)) >> 63 & divisor);
    }

    public static long highestOneBit(long i) {
        return i & Long.MIN_VALUE >>> Long.numberOfLeadingZeros(i);
    }

    public static long lowestOneBit(long i) {
        return i & -i;
    }

    @IntrinsicCandidate
    public static int numberOfLeadingZeros(long i) {
        int x = (int)(i >>> 32);
        return x == 0 ? 32 + Integer.numberOfLeadingZeros((int)i) : Integer.numberOfLeadingZeros(x);
    }

    @IntrinsicCandidate
    public static int numberOfTrailingZeros(long i) {
        int x = (int)i;
        return x == 0 ? 32 + Integer.numberOfTrailingZeros((int)(i >>> 32)) : Integer.numberOfTrailingZeros(x);
    }

    @IntrinsicCandidate
    public static int bitCount(long i) {
        i -= i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) + (i >>> 2 & 0x3333333333333333L);
        i = i + (i >>> 4) & 0xF0F0F0F0F0F0F0FL;
        i += i >>> 8;
        i += i >>> 16;
        i += i >>> 32;
        return (int)i & 0x7F;
    }

    public static long rotateLeft(long i, int distance) {
        return i << distance | i >>> -distance;
    }

    public static long rotateRight(long i, int distance) {
        return i >>> distance | i << -distance;
    }

    public static long reverse(long i) {
        i = (i & 0x5555555555555555L) << 1 | i >>> 1 & 0x5555555555555555L;
        i = (i & 0x3333333333333333L) << 2 | i >>> 2 & 0x3333333333333333L;
        i = (i & 0xF0F0F0F0F0F0F0FL) << 4 | i >>> 4 & 0xF0F0F0F0F0F0F0FL;
        return Long.reverseBytes(i);
    }

    public static int signum(long i) {
        return (int)(i >> 63 | -i >>> 63);
    }

    @IntrinsicCandidate
    public static long reverseBytes(long i) {
        i = (i & 0xFF00FF00FF00FFL) << 8 | i >>> 8 & 0xFF00FF00FF00FFL;
        return i << 48 | (i & 0xFFFF0000L) << 16 | i >>> 16 & 0xFFFF0000L | i >>> 48;
    }

    public static long sum(long a, long b) {
        return a + b;
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public Optional<Long> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public Long resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }

    private static class LongCache {
        static final Long[] cache;
        static Long[] archivedCache;

        private LongCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(LongCache.class);
            if (archivedCache == null || archivedCache.length != size) {
                Long[] c = new Long[size];
                long value = -128L;
                for (int i = 0; i < size; ++i) {
                    c[i] = new Long(value++);
                }
                archivedCache = c;
            }
            cache = archivedCache;
        }
    }
}

