/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.math.BigDecimal;
import java.util.Random;
import jdk.internal.vm.annotation.IntrinsicCandidate;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static final double DEGREES_TO_RADIANS = 0.017453292519943295;
    private static final double RADIANS_TO_DEGREES = 57.29577951308232;
    private static final long negativeZeroFloatBits = Float.floatToRawIntBits(-0.0f);
    private static final long negativeZeroDoubleBits = Double.doubleToRawLongBits(-0.0);
    static double twoToTheDoubleScaleUp = Math.powerOfTwoD(512);
    static double twoToTheDoubleScaleDown = Math.powerOfTwoD(-512);

    private Math() {
    }

    @IntrinsicCandidate
    public static double sin(double a) {
        return StrictMath.sin(a);
    }

    @IntrinsicCandidate
    public static double cos(double a) {
        return StrictMath.cos(a);
    }

    @IntrinsicCandidate
    public static double tan(double a) {
        return StrictMath.tan(a);
    }

    public static double asin(double a) {
        return StrictMath.asin(a);
    }

    public static double acos(double a) {
        return StrictMath.acos(a);
    }

    public static double atan(double a) {
        return StrictMath.atan(a);
    }

    public static double toRadians(double angdeg) {
        return angdeg * (Math.PI / 180);
    }

    public static double toDegrees(double angrad) {
        return angrad * 57.29577951308232;
    }

    @IntrinsicCandidate
    public static double exp(double a) {
        return StrictMath.exp(a);
    }

    @IntrinsicCandidate
    public static double log(double a) {
        return StrictMath.log(a);
    }

    @IntrinsicCandidate
    public static double log10(double a) {
        return StrictMath.log10(a);
    }

    @IntrinsicCandidate
    public static double sqrt(double a) {
        return StrictMath.sqrt(a);
    }

    public static double cbrt(double a) {
        return StrictMath.cbrt(a);
    }

    public static double IEEEremainder(double f1, double f2) {
        return StrictMath.IEEEremainder(f1, f2);
    }

    @IntrinsicCandidate
    public static double ceil(double a) {
        return StrictMath.ceil(a);
    }

    @IntrinsicCandidate
    public static double floor(double a) {
        return StrictMath.floor(a);
    }

    @IntrinsicCandidate
    public static double rint(double a) {
        return StrictMath.rint(a);
    }

    @IntrinsicCandidate
    public static double atan2(double y, double x) {
        return StrictMath.atan2(y, x);
    }

    @IntrinsicCandidate
    public static double pow(double a, double b) {
        return StrictMath.pow(a, b);
    }

    public static int round(float a) {
        int intBits = Float.floatToRawIntBits(a);
        int biasedExp = (intBits & 0x7F800000) >> 23;
        int shift = 149 - biasedExp;
        if ((shift & 0xFFFFFFE0) == 0) {
            int r = intBits & 0x7FFFFF | 0x800000;
            if (intBits < 0) {
                r = -r;
            }
            return (r >> shift) + 1 >> 1;
        }
        return (int)a;
    }

    public static long round(double a) {
        long longBits = Double.doubleToRawLongBits(a);
        long biasedExp = (longBits & 0x7FF0000000000000L) >> 52;
        long shift = 1074L - biasedExp;
        if ((shift & 0xFFFFFFFFFFFFFFC0L) == 0L) {
            long r = longBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            if (longBits < 0L) {
                r = -r;
            }
            return (r >> (int)shift) + 1L >> 1;
        }
        return (long)a;
    }

    public static double random() {
        return RandomNumberGeneratorHolder.randomNumberGenerator.nextDouble();
    }

    @IntrinsicCandidate
    public static int addExact(int x, int y) {
        int r = x + y;
        if (((x ^ r) & (y ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    @IntrinsicCandidate
    public static long addExact(long x, long y) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @IntrinsicCandidate
    public static int subtractExact(int x, int y) {
        int r = x - y;
        if (((x ^ y) & (x ^ r)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return r;
    }

    @IntrinsicCandidate
    public static long subtractExact(long x, long y) {
        long r = x - y;
        if (((x ^ y) & (x ^ r)) < 0L) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @IntrinsicCandidate
    public static int multiplyExact(int x, int y) {
        long r = (long)x * (long)y;
        if ((long)((int)r) != r) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)r;
    }

    public static long multiplyExact(long x, int y) {
        return Math.multiplyExact(x, (long)y);
    }

    @IntrinsicCandidate
    public static long multiplyExact(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            throw new ArithmeticException("long overflow");
        }
        return r;
    }

    @IntrinsicCandidate
    public static int incrementExact(int a) {
        if (a == Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a + 1;
    }

    @IntrinsicCandidate
    public static long incrementExact(long a) {
        if (a == Long.MAX_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a + 1L;
    }

    @IntrinsicCandidate
    public static int decrementExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return a - 1;
    }

    @IntrinsicCandidate
    public static long decrementExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return a - 1L;
    }

    @IntrinsicCandidate
    public static int negateExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return -a;
    }

    @IntrinsicCandidate
    public static long negateExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("long overflow");
        }
        return -a;
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static long multiplyFull(int x, int y) {
        return (long)x * (long)y;
    }

    @IntrinsicCandidate
    public static long multiplyHigh(long x, long y) {
        if (x < 0L || y < 0L) {
            long x1 = x >> 32;
            long x2 = x & 0xFFFFFFFFL;
            long y1 = y >> 32;
            long y2 = y & 0xFFFFFFFFL;
            long z2 = x2 * y2;
            long t = x1 * y2 + (z2 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z0 = t >> 32;
            return x1 * y1 + z0 + ((z1 += x2 * y1) >> 32);
        }
        long x1 = x >>> 32;
        long y1 = y >>> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y2 = y & 0xFFFFFFFFL;
        long A = x1 * y1;
        long B = x2 * y2;
        long C = (x1 + x2) * (y1 + y2);
        long K = C - A - B;
        return ((B >>> 32) + K >>> 32) + A;
    }

    public static int floorDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) < 0 && r * y != x) {
            --r;
        }
        return r;
    }

    public static long floorDiv(long x, int y) {
        return Math.floorDiv(x, (long)y);
    }

    public static long floorDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) < 0L && r * y != x) {
            --r;
        }
        return r;
    }

    public static int floorMod(int x, int y) {
        int mod = x % y;
        if ((mod ^ y) < 0 && mod != 0) {
            mod += y;
        }
        return mod;
    }

    public static int floorMod(long x, int y) {
        return (int)Math.floorMod(x, (long)y);
    }

    public static long floorMod(long x, long y) {
        long mod = x % y;
        if ((x ^ y) < 0L && mod != 0L) {
            mod += y;
        }
        return mod;
    }

    @IntrinsicCandidate
    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static int absExact(int a) {
        if (a == Integer.MIN_VALUE) {
            throw new ArithmeticException("Overflow to represent absolute value of Integer.MIN_VALUE");
        }
        return Math.abs(a);
    }

    @IntrinsicCandidate
    public static long abs(long a) {
        return a < 0L ? -a : a;
    }

    public static long absExact(long a) {
        if (a == Long.MIN_VALUE) {
            throw new ArithmeticException("Overflow to represent absolute value of Long.MIN_VALUE");
        }
        return Math.abs(a);
    }

    @IntrinsicCandidate
    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    @IntrinsicCandidate
    public static double abs(double a) {
        return a <= 0.0 ? 0.0 - a : a;
    }

    @IntrinsicCandidate
    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    @IntrinsicCandidate
    public static float max(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(a) == negativeZeroFloatBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    @IntrinsicCandidate
    public static double max(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(a) == negativeZeroDoubleBits) {
            return b;
        }
        return a >= b ? a : b;
    }

    @IntrinsicCandidate
    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    @IntrinsicCandidate
    public static float min(float a, float b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0f && b == 0.0f && (long)Float.floatToRawIntBits(b) == negativeZeroFloatBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    @IntrinsicCandidate
    public static double min(double a, double b) {
        if (a != a) {
            return a;
        }
        if (a == 0.0 && b == 0.0 && Double.doubleToRawLongBits(b) == negativeZeroDoubleBits) {
            return b;
        }
        return a <= b ? a : b;
    }

    @IntrinsicCandidate
    public static double fma(double a, double b, double c) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isNaN(c)) {
            return Double.NaN;
        }
        boolean infiniteA = Double.isInfinite(a);
        boolean infiniteB = Double.isInfinite(b);
        boolean infiniteC = Double.isInfinite(c);
        if (infiniteA || infiniteB || infiniteC) {
            if (infiniteA && b == 0.0 || infiniteB && a == 0.0) {
                return Double.NaN;
            }
            double product = a * b;
            if (Double.isInfinite(product) && !infiniteA && !infiniteB) {
                assert (Double.isInfinite(c));
                return c;
            }
            double result = product + c;
            assert (!Double.isFinite(result));
            return result;
        }
        BigDecimal product = new BigDecimal(a).multiply(new BigDecimal(b));
        if (c == 0.0) {
            if (a == 0.0 || b == 0.0) {
                return a * b + c;
            }
            return product.doubleValue();
        }
        return product.add(new BigDecimal(c)).doubleValue();
    }

    @IntrinsicCandidate
    public static float fma(float a, float b, float c) {
        if (Float.isFinite(a) && Float.isFinite(b) && Float.isFinite(c)) {
            if ((double)a == 0.0 || (double)b == 0.0) {
                return a * b + c;
            }
            return new BigDecimal((double)a * (double)b).add(new BigDecimal(c)).floatValue();
        }
        return (float)Math.fma((double)a, (double)b, (double)c);
    }

    public static double ulp(double d) {
        int exp = Math.getExponent(d);
        return switch (exp) {
            case 1024 -> Math.abs(d);
            case -1023 -> Double.MIN_VALUE;
            default -> {
                if (!($assertionsDisabled || exp <= 1023 && exp >= -1022)) {
                    throw new AssertionError();
                }
                yield (exp -= 52) >= -1022 ? Math.powerOfTwoD(exp) : Double.longBitsToDouble(1L << exp - -1074);
            }
        };
    }

    public static float ulp(float f) {
        int exp = Math.getExponent(f);
        return switch (exp) {
            case 128 -> Math.abs(f);
            case -127 -> Float.MIN_VALUE;
            default -> {
                if (!($assertionsDisabled || exp <= 127 && exp >= -126)) {
                    throw new AssertionError();
                }
                yield (exp -= 23) >= -126 ? Math.powerOfTwoF(exp) : Float.intBitsToFloat(1 << exp - -149);
            }
        };
    }

    @IntrinsicCandidate
    public static double signum(double d) {
        return d == 0.0 || Double.isNaN(d) ? d : Math.copySign(1.0, d);
    }

    @IntrinsicCandidate
    public static float signum(float f) {
        return f == 0.0f || Float.isNaN(f) ? f : Math.copySign(1.0f, f);
    }

    public static double sinh(double x) {
        return StrictMath.sinh(x);
    }

    public static double cosh(double x) {
        return StrictMath.cosh(x);
    }

    public static double tanh(double x) {
        return StrictMath.tanh(x);
    }

    public static double hypot(double x, double y) {
        return StrictMath.hypot(x, y);
    }

    public static double expm1(double x) {
        return StrictMath.expm1(x);
    }

    public static double log1p(double x) {
        return StrictMath.log1p(x);
    }

    @IntrinsicCandidate
    public static double copySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(sign) & Long.MIN_VALUE | Double.doubleToRawLongBits(magnitude) & Long.MAX_VALUE);
    }

    @IntrinsicCandidate
    public static float copySign(float magnitude, float sign) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(sign) & Integer.MIN_VALUE | Float.floatToRawIntBits(magnitude) & Integer.MAX_VALUE);
    }

    public static int getExponent(float f) {
        return ((Float.floatToRawIntBits(f) & 0x7F800000) >> 23) - 127;
    }

    public static int getExponent(double d) {
        return (int)(((Double.doubleToRawLongBits(d) & 0x7FF0000000000000L) >> 52) - 1023L);
    }

    public static double nextAfter(double start, double direction) {
        if (start > direction) {
            if (start != 0.0) {
                long transducer;
                return Double.longBitsToDouble(transducer + ((transducer = Double.doubleToRawLongBits(start)) > 0L ? -1L : 1L));
            }
            return -4.9E-324;
        }
        if (start < direction) {
            long transducer;
            return Double.longBitsToDouble(transducer + ((transducer = Double.doubleToRawLongBits(start + 0.0)) >= 0L ? 1L : -1L));
        }
        if (start == direction) {
            return direction;
        }
        return start + direction;
    }

    public static float nextAfter(float start, double direction) {
        if ((double)start > direction) {
            if (start != 0.0f) {
                int transducer;
                return Float.intBitsToFloat(transducer + ((transducer = Float.floatToRawIntBits(start)) > 0 ? -1 : 1));
            }
            return -1.4E-45f;
        }
        if ((double)start < direction) {
            int transducer;
            return Float.intBitsToFloat(transducer + ((transducer = Float.floatToRawIntBits(start + 0.0f)) >= 0 ? 1 : -1));
        }
        if ((double)start == direction) {
            return (float)direction;
        }
        return start + (float)direction;
    }

    public static double nextUp(double d) {
        if (d < Double.POSITIVE_INFINITY) {
            long transducer;
            return Double.longBitsToDouble(transducer + ((transducer = Double.doubleToRawLongBits(d + 0.0)) >= 0L ? 1L : -1L));
        }
        return d;
    }

    public static float nextUp(float f) {
        if (f < Float.POSITIVE_INFINITY) {
            int transducer;
            return Float.intBitsToFloat(transducer + ((transducer = Float.floatToRawIntBits(f + 0.0f)) >= 0 ? 1 : -1));
        }
        return f;
    }

    public static double nextDown(double d) {
        if (Double.isNaN(d) || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        if (d == 0.0) {
            return -4.9E-324;
        }
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) + (d > 0.0 ? -1L : 1L));
    }

    public static float nextDown(float f) {
        if (Float.isNaN(f) || f == Float.NEGATIVE_INFINITY) {
            return f;
        }
        if (f == 0.0f) {
            return -1.4E-45f;
        }
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) + (f > 0.0f ? -1 : 1));
    }

    public static double scalb(double d, int scaleFactor) {
        int MAX_SCALE = 2099;
        int exp_adjust = 0;
        int scale_increment = 0;
        double exp_delta = Double.NaN;
        if (scaleFactor < 0) {
            scaleFactor = Math.max(scaleFactor, -2099);
            scale_increment = -512;
            exp_delta = twoToTheDoubleScaleDown;
        } else {
            scaleFactor = Math.min(scaleFactor, 2099);
            scale_increment = 512;
            exp_delta = twoToTheDoubleScaleUp;
        }
        int t = scaleFactor >> 8 >>> 23;
        exp_adjust = (scaleFactor + t & 0x1FF) - t;
        d *= Math.powerOfTwoD(exp_adjust);
        scaleFactor -= exp_adjust;
        while (scaleFactor != 0) {
            d *= exp_delta;
            scaleFactor -= scale_increment;
        }
        return d;
    }

    public static float scalb(float f, int scaleFactor) {
        int MAX_SCALE = 278;
        scaleFactor = Math.max(Math.min(scaleFactor, 278), -278);
        return (float)((double)f * Math.powerOfTwoD(scaleFactor));
    }

    static double powerOfTwoD(int n) {
        assert (n >= -1022 && n <= 1023);
        return Double.longBitsToDouble((long)n + 1023L << 52 & 0x7FF0000000000000L);
    }

    static float powerOfTwoF(int n) {
        assert (n >= -126 && n <= 127);
        return Float.intBitsToFloat(n + 127 << 23 & 0x7F800000);
    }

    private static final class RandomNumberGeneratorHolder {
        static final Random randomNumberGenerator = new Random();

        private RandomNumberGeneratorHolder() {
        }
    }
}

