/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.loader.ClassLoaders;
import jdk.internal.misc.CDS;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleLoaderMap;
import jdk.internal.module.Resources;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.ModuleVisitor;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import sun.security.util.SecurityConstants;

public final class Module
implements AnnotatedElement {
    private final ModuleLayer layer;
    private final String name;
    private final ClassLoader loader;
    private final ModuleDescriptor descriptor;
    private volatile boolean enableNativeAccess;
    private static final Module ALL_UNNAMED_MODULE;
    private static final Set<Module> ALL_UNNAMED_MODULE_SET;
    private static final Module EVERYONE_MODULE;
    private static final Set<Module> EVERYONE_SET;
    private volatile Set<Module> reads;
    private volatile Map<String, Set<Module>> openPackages;
    private volatile Map<String, Set<Module>> exportedPackages;
    private volatile Class<?> moduleInfoClass;

    Module(ModuleLayer layer, ClassLoader loader, ModuleDescriptor descriptor, URI uri) {
        this.layer = layer;
        this.name = descriptor.name();
        this.loader = loader;
        this.descriptor = descriptor;
        boolean isOpen = descriptor.isOpen() || descriptor.isAutomatic();
        ModuleDescriptor.Version version = descriptor.version().orElse(null);
        String vs = Objects.toString(version, null);
        String loc = Objects.toString(uri, null);
        Object[] packages = descriptor.packages().toArray();
        Module.defineModule0(this, isOpen, vs, loc, packages);
        if (loader == null || loader == ClassLoaders.platformClassLoader()) {
            this.implAddEnableNativeAccess();
        }
    }

    Module(ClassLoader loader) {
        this.layer = null;
        this.name = null;
        this.loader = loader;
        this.descriptor = null;
    }

    Module(ClassLoader loader, ModuleDescriptor descriptor) {
        this.layer = null;
        this.name = descriptor.name();
        this.loader = loader;
        this.descriptor = descriptor;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.loader;
    }

    public ModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ModuleLayer getLayer() {
        if (this.isNamed()) {
            ModuleLayer layer = this.layer;
            if (layer != null) {
                return layer;
            }
            if (this.loader == null && this.name.equals("java.base")) {
                return ModuleLayer.boot();
            }
        }
        return null;
    }

    Module implAddEnableNativeAccess() {
        this.enableNativeAccess = true;
        return this;
    }

    static void implAddEnableNativeAccessAllUnnamed() {
        Module.ALL_UNNAMED_MODULE.enableNativeAccess = true;
    }

    boolean implIsEnableNativeAccess() {
        return this.isNamed() ? this.enableNativeAccess : Module.ALL_UNNAMED_MODULE.enableNativeAccess;
    }

    public boolean canRead(Module other) {
        Set<Module> reads;
        Objects.requireNonNull(other);
        if (!this.isNamed()) {
            return true;
        }
        if (other == this) {
            return true;
        }
        if (other.isNamed() && (reads = this.reads) != null && reads.contains(other)) {
            return true;
        }
        if (ReflectionData.reads.containsKeyPair(this, other)) {
            return true;
        }
        return !other.isNamed() && ReflectionData.reads.containsKeyPair(this, ALL_UNNAMED_MODULE);
    }

    @CallerSensitive
    public Module addReads(Module other) {
        Objects.requireNonNull(other);
        if (this.isNamed()) {
            Module caller = this.getCallerModule(Reflection.getCallerClass());
            if (caller != this) {
                throw new IllegalCallerException(caller + " != " + this);
            }
            this.implAddReads(other, true);
        }
        return this;
    }

    void implAddReads(Module other) {
        this.implAddReads(other, true);
    }

    void implAddReadsAllUnnamed() {
        this.implAddReads(ALL_UNNAMED_MODULE, true);
    }

    void implAddReadsNoSync(Module other) {
        this.implAddReads(other, false);
    }

    private void implAddReads(Module other, boolean syncVM) {
        Objects.requireNonNull(other);
        if (!this.canRead(other)) {
            if (syncVM) {
                if (other == ALL_UNNAMED_MODULE) {
                    Module.addReads0(this, null);
                } else {
                    Module.addReads0(this, other);
                }
            }
            ReflectionData.reads.putIfAbsent(this, other, Boolean.TRUE);
        }
    }

    public boolean isExported(String pn, Module other) {
        Objects.requireNonNull(pn);
        Objects.requireNonNull(other);
        return this.implIsExportedOrOpen(pn, other, false);
    }

    public boolean isOpen(String pn, Module other) {
        Objects.requireNonNull(pn);
        Objects.requireNonNull(other);
        return this.implIsExportedOrOpen(pn, other, true);
    }

    public boolean isExported(String pn) {
        Objects.requireNonNull(pn);
        return this.implIsExportedOrOpen(pn, EVERYONE_MODULE, false);
    }

    public boolean isOpen(String pn) {
        Objects.requireNonNull(pn);
        return this.implIsExportedOrOpen(pn, EVERYONE_MODULE, true);
    }

    private boolean implIsExportedOrOpen(String pn, Module other, boolean open) {
        if (!this.isNamed()) {
            return true;
        }
        if (other == this && this.descriptor.packages().contains(pn)) {
            return true;
        }
        if (this.descriptor.isOpen() || this.descriptor.isAutomatic()) {
            return this.descriptor.packages().contains(pn);
        }
        if (this.isStaticallyExportedOrOpen(pn, other, open)) {
            return true;
        }
        return this.isReflectivelyExportedOrOpen(pn, other, open);
    }

    private boolean isStaticallyExportedOrOpen(String pn, Module other, boolean open) {
        Map<String, Set<Module>> exportedPackages;
        Map<String, Set<Module>> openPackages = this.openPackages;
        if (openPackages != null && this.allows(openPackages.get(pn), other)) {
            return true;
        }
        return !open && (exportedPackages = this.exportedPackages) != null && this.allows(exportedPackages.get(pn), other);
    }

    private boolean allows(Set<Module> targets, Module module) {
        if (targets != null) {
            if (targets.contains(EVERYONE_MODULE)) {
                return true;
            }
            if (module != EVERYONE_MODULE) {
                if (targets.contains(module)) {
                    return true;
                }
                if (!module.isNamed() && targets.contains(ALL_UNNAMED_MODULE)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isReflectivelyExportedOrOpen(String pn, Module other, boolean open) {
        boolean isOpen;
        Boolean b;
        Map<String, Boolean> exports = ReflectionData.exports.get(this, EVERYONE_MODULE);
        if (exports != null && (b = exports.get(pn)) != null) {
            isOpen = b;
            if (!open || isOpen) {
                return true;
            }
        }
        if (other != EVERYONE_MODULE) {
            exports = ReflectionData.exports.get(this, other);
            if (exports != null && (b = exports.get(pn)) != null) {
                isOpen = b;
                if (!open || isOpen) {
                    return true;
                }
            }
            if (!other.isNamed() && (exports = ReflectionData.exports.get(this, ALL_UNNAMED_MODULE)) != null && (b = exports.get(pn)) != null) {
                isOpen = b;
                if (!open || isOpen) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean isReflectivelyExported(String pn, Module other) {
        return this.isReflectivelyExportedOrOpen(pn, other, false);
    }

    boolean isReflectivelyOpened(String pn, Module other) {
        return this.isReflectivelyExportedOrOpen(pn, other, true);
    }

    @CallerSensitive
    public Module addExports(String pn, Module other) {
        if (pn == null) {
            throw new IllegalArgumentException("package is null");
        }
        Objects.requireNonNull(other);
        if (this.isNamed()) {
            Module caller = this.getCallerModule(Reflection.getCallerClass());
            if (caller != this) {
                throw new IllegalCallerException(caller + " != " + this);
            }
            this.implAddExportsOrOpens(pn, other, false, true);
        }
        return this;
    }

    @CallerSensitive
    public Module addOpens(String pn, Module other) {
        if (pn == null) {
            throw new IllegalArgumentException("package is null");
        }
        Objects.requireNonNull(other);
        if (this.isNamed()) {
            Module caller = this.getCallerModule(Reflection.getCallerClass());
            if (!(caller == this || caller != null && this.isOpen(pn, caller))) {
                throw new IllegalCallerException(pn + " is not open to " + caller);
            }
            this.implAddExportsOrOpens(pn, other, true, true);
        }
        return this;
    }

    void implAddExports(String pn) {
        this.implAddExportsOrOpens(pn, EVERYONE_MODULE, false, true);
    }

    void implAddExports(String pn, Module other) {
        this.implAddExportsOrOpens(pn, other, false, true);
    }

    void implAddExportsToAllUnnamed(String pn) {
        this.implAddExportsOrOpens(pn, ALL_UNNAMED_MODULE, false, true);
    }

    void implAddExportsNoSync(String pn) {
        this.implAddExportsOrOpens(pn.replace('/', '.'), EVERYONE_MODULE, false, false);
    }

    void implAddExportsNoSync(String pn, Module other) {
        this.implAddExportsOrOpens(pn.replace('/', '.'), other, false, false);
    }

    void implAddOpens(String pn) {
        this.implAddExportsOrOpens(pn, EVERYONE_MODULE, true, true);
    }

    void implAddOpens(String pn, Module other) {
        this.implAddExportsOrOpens(pn, other, true, true);
    }

    void implAddOpensToAllUnnamed(String pn) {
        this.implAddExportsOrOpens(pn, ALL_UNNAMED_MODULE, true, true);
    }

    private void implAddExportsOrOpens(String pn, Module other, boolean open, boolean syncVM) {
        Objects.requireNonNull(other);
        Objects.requireNonNull(pn);
        if (!this.isNamed() || this.descriptor.isOpen() || this.descriptor.isAutomatic()) {
            return;
        }
        if (this.implIsExportedOrOpen(pn, other, open)) {
            return;
        }
        if (!this.descriptor.packages().contains(pn)) {
            throw new IllegalArgumentException("package " + pn + " not in contents");
        }
        if (syncVM) {
            if (other == EVERYONE_MODULE) {
                Module.addExportsToAll0(this, pn);
            } else if (other == ALL_UNNAMED_MODULE) {
                Module.addExportsToAllUnnamed0(this, pn);
            } else {
                Module.addExports0(this, pn, other);
            }
        }
        Map map = ReflectionData.exports.computeIfAbsent(this, other, (m1, m2) -> new ConcurrentHashMap());
        if (open) {
            map.put(pn, Boolean.TRUE);
        } else {
            map.putIfAbsent(pn, Boolean.FALSE);
        }
    }

    void implAddOpensToAllUnnamed(Set<String> concealedPkgs, Set<String> exportedPkgs) {
        if (VM.isModuleSystemInited()) {
            throw new IllegalStateException("Module system already initialized");
        }
        Map<String, Set<Module>> openPackages = this.openPackages;
        openPackages = openPackages == null ? new HashMap<String, Set<Module>>(4 * (concealedPkgs.size() + exportedPkgs.size()) / 3 + 1) : new HashMap<String, Set<Module>>(openPackages);
        this.implAddOpensToAllUnnamed(concealedPkgs, openPackages);
        this.implAddOpensToAllUnnamed(exportedPkgs, openPackages);
        this.openPackages = openPackages;
    }

    private void implAddOpensToAllUnnamed(Set<String> pkgs, Map<String, Set<Module>> openPackages) {
        for (String pn : pkgs) {
            Set<Module> prev = openPackages.putIfAbsent(pn, ALL_UNNAMED_MODULE_SET);
            if (prev != null) {
                prev.add(ALL_UNNAMED_MODULE);
            }
            Module.addExportsToAllUnnamed0(this, pn);
        }
    }

    @CallerSensitive
    public Module addUses(Class<?> service) {
        Objects.requireNonNull(service);
        if (this.isNamed() && !this.descriptor.isAutomatic()) {
            Module caller = this.getCallerModule(Reflection.getCallerClass());
            if (caller != this) {
                throw new IllegalCallerException(caller + " != " + this);
            }
            this.implAddUses(service);
        }
        return this;
    }

    void implAddUses(Class<?> service) {
        if (!this.canUse(service)) {
            ReflectionData.uses.putIfAbsent(this, service, Boolean.TRUE);
        }
    }

    public boolean canUse(Class<?> service) {
        Objects.requireNonNull(service);
        if (!this.isNamed()) {
            return true;
        }
        if (this.descriptor.isAutomatic()) {
            return true;
        }
        if (this.descriptor.uses().contains(service.getName())) {
            return true;
        }
        return ReflectionData.uses.containsKeyPair(this, service);
    }

    public Set<String> getPackages() {
        if (this.isNamed()) {
            return this.descriptor.packages();
        }
        Stream<Package> packages = this.loader == null ? BootLoader.packages() : this.loader.packages();
        return packages.filter(p -> p.module() == this).map(Package::getName).collect(Collectors.toSet());
    }

    static Map<String, Module> defineModules(Configuration cf, Function<String, ClassLoader> clf, ModuleLayer layer) {
        int index;
        boolean isBootLayer = ModuleLayer.boot() == null;
        int numModules = cf.modules().size();
        int cap = (int)((float)numModules / 0.75f + 1.0f);
        HashMap<String, Module> nameToModule = new HashMap<String, Module>(cap);
        ResolvedModule[] resolvedModules = new ResolvedModule[numModules];
        Module[] modules = new Module[numModules];
        ClassLoader[] classLoaders = new ClassLoader[numModules];
        resolvedModules = cf.modules().toArray(resolvedModules);
        HashSet<ClassLoader> toBindLoaders = new HashSet<ClassLoader>(4);
        boolean hasPlatformModules = false;
        ClassLoader pcl = ClassLoaders.platformClassLoader();
        boolean isModuleLoaderMapper = ModuleLoaderMap.isBuiltinMapper(clf);
        for (index = 0; index < numModules; ++index) {
            String name = resolvedModules[index].name();
            ClassLoader loader = clf.apply(name);
            if (loader == null || loader == pcl) {
                if (!isModuleLoaderMapper) {
                    throw new IllegalArgumentException("loader can't be 'null' or the platform class loader");
                }
                hasPlatformModules = true;
            } else {
                toBindLoaders.add(loader);
            }
            classLoaders[index] = loader;
        }
        for (index = 0; index < numModules; ++index) {
            Module m;
            ModuleReference mref = resolvedModules[index].reference();
            ModuleDescriptor descriptor = mref.descriptor();
            String name = descriptor.name();
            ClassLoader loader = classLoaders[index];
            if (loader == null && name.equals("java.base")) {
                m = Object.class.getModule();
            } else {
                URI uri = mref.location().orElse(null);
                m = new Module(layer, loader, descriptor, uri);
            }
            nameToModule.put(name, m);
            modules[index] = m;
        }
        for (index = 0; index < numModules; ++index) {
            ResolvedModule resolvedModule = resolvedModules[index];
            ModuleReference mref = resolvedModule.reference();
            ModuleDescriptor descriptor = mref.descriptor();
            Module m = modules[index];
            HashSet<Module> reads = new HashSet<Module>();
            Map<String, Module> nameToSource = Map.of();
            for (ResolvedModule other : resolvedModule.reads()) {
                Module m2 = null;
                if (other.configuration() == cf) {
                    m2 = (Module)nameToModule.get(other.name());
                    assert (m2 != null);
                } else {
                    ModuleLayer parent;
                    Iterator<ModuleLayer> iterator = layer.parents().iterator();
                    while (iterator.hasNext() && (m2 = Module.findModule(parent = iterator.next(), other)) == null) {
                    }
                    assert (m2 != null);
                    if (nameToSource.isEmpty()) {
                        nameToSource = new HashMap<String, Module>();
                    }
                    nameToSource.put(other.name(), m2);
                }
                reads.add(m2);
                Module.addReads0(m, m2);
            }
            m.reads = reads;
            if (descriptor.isAutomatic()) {
                m.implAddReads(ALL_UNNAMED_MODULE, true);
            }
            if (descriptor.isOpen() || descriptor.isAutomatic()) continue;
            if (isBootLayer && descriptor.opens().isEmpty()) {
                Module.initExports(m, nameToModule);
                continue;
            }
            Module.initExportsAndOpens(m, nameToSource, nameToModule, layer.parents());
        }
        if (hasPlatformModules) {
            ServicesCatalog bootCatalog = BootLoader.getServicesCatalog();
            ServicesCatalog pclCatalog = ServicesCatalog.getServicesCatalog(pcl);
            for (int index2 = 0; index2 < numModules; ++index2) {
                ResolvedModule resolvedModule = resolvedModules[index2];
                ModuleReference mref = resolvedModule.reference();
                ModuleDescriptor descriptor = mref.descriptor();
                if (descriptor.provides().isEmpty()) continue;
                Module m = modules[index2];
                ClassLoader loader = classLoaders[index2];
                if (loader == null) {
                    bootCatalog.register(m);
                    continue;
                }
                if (loader != pcl) continue;
                pclCatalog.register(m);
            }
        }
        for (ClassLoader loader : toBindLoaders) {
            layer.bindToLoader(loader);
        }
        return nameToModule;
    }

    private static Module findModule(ModuleLayer parent, ResolvedModule resolvedModule) {
        Configuration cf = resolvedModule.configuration();
        String dn = resolvedModule.name();
        return parent.layers().filter(l -> l.configuration() == cf).findAny().map(layer -> {
            Optional<Module> om = layer.findModule(dn);
            assert (om.isPresent()) : dn + " not found in layer";
            Module m = om.get();
            assert (m.getLayer() == layer) : m + " not in expected layer";
            return m;
        }).orElse(null);
    }

    private static void initExports(Module m, Map<String, Module> nameToModule) {
        HashMap<String, Set<Module>> exportedPackages = new HashMap<String, Set<Module>>();
        for (ModuleDescriptor.Exports exports : m.getDescriptor().exports()) {
            String source = exports.source();
            if (exports.isQualified()) {
                HashSet<Module> targets = new HashSet<Module>();
                for (String target : exports.targets()) {
                    Module m2 = nameToModule.get(target);
                    if (m2 == null) continue;
                    Module.addExports0(m, source, m2);
                    targets.add(m2);
                }
                if (targets.isEmpty()) continue;
                exportedPackages.put(source, targets);
                continue;
            }
            Module.addExportsToAll0(m, source);
            exportedPackages.put(source, EVERYONE_SET);
        }
        if (!exportedPackages.isEmpty()) {
            m.exportedPackages = exportedPackages;
        }
    }

    private static void initExportsAndOpens(Module m, Map<String, Module> nameToSource, Map<String, Module> nameToModule, List<ModuleLayer> parents) {
        String source;
        ModuleDescriptor descriptor = m.getDescriptor();
        HashMap<String, Set<Module>> openPackages = new HashMap<String, Set<Module>>();
        HashMap<String, Set<Module>> exportedPackages = new HashMap<String, Set<Module>>();
        for (ModuleDescriptor.Opens opens : descriptor.opens()) {
            source = opens.source();
            if (opens.isQualified()) {
                HashSet<Module> targets = new HashSet<Module>();
                for (String target : opens.targets()) {
                    Module m2 = Module.findModule(target, nameToSource, nameToModule, parents);
                    if (m2 == null) continue;
                    Module.addExports0(m, source, m2);
                    targets.add(m2);
                }
                if (targets.isEmpty()) continue;
                openPackages.put(source, targets);
                continue;
            }
            Module.addExportsToAll0(m, source);
            openPackages.put(source, EVERYONE_SET);
        }
        for (ModuleDescriptor.Exports exports : descriptor.exports()) {
            source = exports.source();
            Set openToTargets = (Set)openPackages.get(source);
            if (openToTargets != null && openToTargets.contains(EVERYONE_MODULE)) continue;
            if (exports.isQualified()) {
                HashSet<Module> targets = new HashSet<Module>();
                for (String target : exports.targets()) {
                    Module m2 = Module.findModule(target, nameToSource, nameToModule, parents);
                    if (m2 == null || openToTargets != null && openToTargets.contains(m2)) continue;
                    Module.addExports0(m, source, m2);
                    targets.add(m2);
                }
                if (targets.isEmpty()) continue;
                exportedPackages.put(source, targets);
                continue;
            }
            Module.addExportsToAll0(m, source);
            exportedPackages.put(source, EVERYONE_SET);
        }
        if (!openPackages.isEmpty()) {
            m.openPackages = openPackages;
        }
        if (!exportedPackages.isEmpty()) {
            m.exportedPackages = exportedPackages;
        }
    }

    private static Module findModule(String target, Map<String, Module> nameToSource, Map<String, Module> nameToModule, List<ModuleLayer> parents) {
        Module m;
        block1: {
            ModuleLayer parent;
            m = nameToSource.get(target);
            if (m != null || (m = nameToModule.get(target)) != null) break block1;
            Iterator<ModuleLayer> iterator = parents.iterator();
            while (iterator.hasNext() && (m = (Module)(parent = iterator.next()).findModule(target).orElse(null)) == null) {
            }
        }
        return m;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.moduleInfoClass().getDeclaredAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.moduleInfoClass().getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.moduleInfoClass().getDeclaredAnnotations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> moduleInfoClass() {
        Class<?> clazz = this.moduleInfoClass;
        if (clazz != null) {
            return clazz;
        }
        Module module = this;
        synchronized (module) {
            clazz = this.moduleInfoClass;
            if (clazz == null) {
                if (this.isNamed()) {
                    PrivilegedAction<Class> pa = this::loadModuleInfoClass;
                    clazz = AccessController.doPrivileged(pa);
                }
                if (clazz == null) {
                    class DummyModuleInfo {
                        DummyModuleInfo() {
                        }
                    }
                    clazz = DummyModuleInfo.class;
                }
                this.moduleInfoClass = clazz;
            }
            return clazz;
        }
    }

    private Class<?> loadModuleInfoClass() {
        Class<?> clazz = null;
        try (InputStream in = this.getResourceAsStream("module-info.class");){
            if (in != null) {
                clazz = this.loadModuleInfoClass(in);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private Class<?> loadModuleInfoClass(InputStream in) throws IOException {
        String MODULE_INFO = "module-info";
        final ClassWriter cw = new ClassWriter(3);
        ClassVisitor cv = new ClassVisitor(458752, cw){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                cw.visit(version, 5632, "module-info", null, "java/lang/Object", null);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public void visitAttribute(Attribute attr) {
            }

            @Override
            public ModuleVisitor visitModule(String name, int flags, String version) {
                return null;
            }
        };
        ClassReader cr = new ClassReader(in);
        cr.accept(cv, 0);
        final byte[] bytes = cw.toByteArray();
        ClassLoader cl = new ClassLoader(this.loader){

            @Override
            protected Class<?> findClass(String cn) throws ClassNotFoundException {
                if (cn.equals("module-info")) {
                    return super.defineClass(cn, bytes, 0, bytes.length);
                }
                throw new ClassNotFoundException(cn);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Class<?> loadClass(String cn, boolean resolve) throws ClassNotFoundException {
                Object object2 = this.getClassLoadingLock(cn);
                synchronized (object2) {
                    Class<?> c = this.findLoadedClass(cn);
                    if (c == null) {
                        c = cn.equals("module-info") ? this.findClass(cn) : super.loadClass(cn, resolve);
                    }
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
        };
        try {
            return cl.loadClass("module-info");
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    @CallerSensitive
    public InputStream getResourceAsStream(String name) throws IOException {
        Module caller;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.isNamed() && Resources.canEncapsulate(name) && (caller = this.getCallerModule(Reflection.getCallerClass())) != this && caller != Object.class.getModule()) {
            String pn = Resources.toPackageName(name);
            if (this.getPackages().contains(pn)) {
                if (caller == null && !this.isOpen(pn)) {
                    return null;
                }
                if (!this.isOpen(pn, caller)) {
                    return null;
                }
            }
        }
        String mn = this.name;
        if (this.loader == null) {
            return BootLoader.findResourceAsStream(mn, name);
        }
        if (this.loader instanceof BuiltinClassLoader) {
            return ((BuiltinClassLoader)this.loader).findResourceAsStream(mn, name);
        }
        URL url = this.loader.findResource(mn, name);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toString() {
        if (this.isNamed()) {
            return "module " + this.name;
        }
        String id = Integer.toHexString(System.identityHashCode(this));
        return "unnamed module @" + id;
    }

    private Module getCallerModule(Class<?> caller) {
        return caller != null ? caller.getModule() : null;
    }

    private static native void defineModule0(Module var0, boolean var1, String var2, String var3, Object[] var4);

    private static native void addReads0(Module var0, Module var1);

    private static native void addExports0(Module var0, String var1, Module var2);

    private static native void addExportsToAll0(Module var0, String var1);

    private static native void addExportsToAllUnnamed0(Module var0, String var1);

    static {
        ArchivedData archivedData = ArchivedData.get();
        if (archivedData != null) {
            ALL_UNNAMED_MODULE = archivedData.allUnnamedModule;
            ALL_UNNAMED_MODULE_SET = archivedData.allUnnamedModules;
            EVERYONE_MODULE = archivedData.everyoneModule;
            EVERYONE_SET = archivedData.everyoneSet;
        } else {
            ALL_UNNAMED_MODULE = new Module(null);
            ALL_UNNAMED_MODULE_SET = Set.of(ALL_UNNAMED_MODULE);
            EVERYONE_MODULE = new Module(null);
            EVERYONE_SET = Set.of(EVERYONE_MODULE);
            ArchivedData.archive();
        }
    }

    private static class ReflectionData {
        static final WeakPairMap<Module, Module, Boolean> reads = new WeakPairMap();
        static final WeakPairMap<Module, Module, Map<String, Boolean>> exports = new WeakPairMap();
        static final WeakPairMap<Module, Class<?>, Boolean> uses = new WeakPairMap();

        private ReflectionData() {
        }
    }

    private static class ArchivedData {
        private static ArchivedData archivedData;
        private final Module allUnnamedModule = ALL_UNNAMED_MODULE;
        private final Set<Module> allUnnamedModules = ALL_UNNAMED_MODULE_SET;
        private final Module everyoneModule = EVERYONE_MODULE;
        private final Set<Module> everyoneSet = EVERYONE_SET;

        private ArchivedData() {
        }

        static void archive() {
            archivedData = new ArchivedData();
        }

        static ArchivedData get() {
            return archivedData;
        }

        static {
            CDS.initializeFromArchive(ArchivedData.class);
        }
    }
}

