/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import jdk.internal.loader.BootLoader;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;

public class Package
extends NamedPackage
implements AnnotatedElement {
    private final VersionInfo versionInfo;
    private Class<?> packageInfo;

    public String getName() {
        return this.packageName();
    }

    public String getSpecificationTitle() {
        return this.versionInfo.specTitle;
    }

    public String getSpecificationVersion() {
        return this.versionInfo.specVersion;
    }

    public String getSpecificationVendor() {
        return this.versionInfo.specVendor;
    }

    public String getImplementationTitle() {
        return this.versionInfo.implTitle;
    }

    public String getImplementationVersion() {
        return this.versionInfo.implVersion;
    }

    public String getImplementationVendor() {
        return this.versionInfo.implVendor;
    }

    public boolean isSealed() {
        return this.module().isNamed() || this.versionInfo.sealBase != null;
    }

    public boolean isSealed(URL url) {
        Objects.requireNonNull(url);
        URL sealBase = null;
        if (this.versionInfo != VersionInfo.NULL_VERSION_INFO) {
            sealBase = this.versionInfo.sealBase;
        } else {
            try {
                URI uri = this.location();
                sealBase = uri != null ? uri.toURL() : null;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url.equals(sealBase);
    }

    public boolean isCompatibleWith(String desired) throws NumberFormatException {
        if (this.versionInfo.specVersion == null || this.versionInfo.specVersion.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        String[] sa = this.versionInfo.specVersion.split("\\.", -1);
        int[] si = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            si[i] = Integer.parseInt(sa[i]);
            if (si[i] >= 0) continue;
            throw NumberFormatException.forInputString("" + si[i], 10);
        }
        String[] da = desired.split("\\.", -1);
        int[] di = new int[da.length];
        for (int i = 0; i < da.length; ++i) {
            di[i] = Integer.parseInt(da[i]);
            if (di[i] >= 0) continue;
            throw NumberFormatException.forInputString("" + di[i], 10);
        }
        int len = Math.max(di.length, si.length);
        for (int i = 0; i < len; ++i) {
            int s;
            int d = i < di.length ? di[i] : 0;
            int n = s = i < si.length ? si[i] : 0;
            if (s < d) {
                return false;
            }
            if (s <= d) continue;
            return true;
        }
        return true;
    }

    @CallerSensitive
    @Deprecated(since="9")
    public static Package getPackage(String name) {
        ClassLoader l = ClassLoader.getClassLoader(Reflection.getCallerClass());
        return l != null ? l.getPackage(name) : BootLoader.getDefinedPackage(name);
    }

    @CallerSensitive
    public static Package[] getPackages() {
        ClassLoader cl = ClassLoader.getClassLoader(Reflection.getCallerClass());
        return cl != null ? cl.getPackages() : (Package[])BootLoader.packages().toArray(Package[]::new);
    }

    public int hashCode() {
        return this.packageName().hashCode();
    }

    public String toString() {
        String spec = this.versionInfo.specTitle;
        String ver = this.versionInfo.specVersion;
        spec = spec != null && !spec.isEmpty() ? ", " + spec : "";
        ver = ver != null && !ver.isEmpty() ? ", version " + ver : "";
        return "package " + this.packageName() + spec + ver;
    }

    private Class<?> getPackageInfo() {
        if (this.packageInfo == null) {
            String cn = this.packageName() + ".package-info";
            Module module = this.module();
            PrivilegedAction<ClassLoader> pa = module::getClassLoader;
            ClassLoader loader = AccessController.doPrivileged(pa);
            Class<?> c = loader != null ? loader.loadClass(module, cn) : BootLoader.loadClass(module, cn);
            class PackageInfoProxy {
                PackageInfoProxy() {
                }
            }
            this.packageInfo = c != null ? c : PackageInfoProxy.class;
        }
        return this.packageInfo;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getPackageInfo().getAnnotation(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return AnnotatedElement.super.isAnnotationPresent(annotationClass);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        return this.getPackageInfo().getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getPackageInfo().getAnnotations();
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        return this.getPackageInfo().getDeclaredAnnotation(annotationClass);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        return this.getPackageInfo().getDeclaredAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getPackageInfo().getDeclaredAnnotations();
    }

    Package(String name, String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase, ClassLoader loader) {
        super(Objects.requireNonNull(name), loader != null ? loader.getUnnamedModule() : BootLoader.getUnnamedModule());
        this.versionInfo = VersionInfo.getInstance(spectitle, specversion, specvendor, impltitle, implversion, implvendor, sealbase);
    }

    Package(String name, Module module) {
        super(name, module);
        this.versionInfo = VersionInfo.NULL_VERSION_INFO;
    }

    static class VersionInfo {
        static final VersionInfo NULL_VERSION_INFO = new VersionInfo(null, null, null, null, null, null, null);
        private final String specTitle;
        private final String specVersion;
        private final String specVendor;
        private final String implTitle;
        private final String implVersion;
        private final String implVendor;
        private final URL sealBase;

        static VersionInfo getInstance(String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase) {
            if (spectitle == null && specversion == null && specvendor == null && impltitle == null && implversion == null && implvendor == null && sealbase == null) {
                return NULL_VERSION_INFO;
            }
            return new VersionInfo(spectitle, specversion, specvendor, impltitle, implversion, implvendor, sealbase);
        }

        private VersionInfo(String spectitle, String specversion, String specvendor, String impltitle, String implversion, String implvendor, URL sealbase) {
            this.implTitle = impltitle;
            this.implVersion = implversion;
            this.implVendor = implvendor;
            this.specTitle = spectitle;
            this.specVersion = specversion;
            this.specVendor = specvendor;
            this.sealBase = sealbase;
        }
    }
}

