/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import sun.security.action.GetPropertyAction;

final class PosixProcessImpl
extends ProcessImpl {
    private final int pid;
    private final ProcessHandleImpl processHandle;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final Platform platform = Platform.get();
    private static final LaunchMechanism launchMechanism = platform.launchMechanism();
    private static final byte[] helperpath = "\u0000".getBytes(StandardCharsets.UTF_8);

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] cmdArray, Map<String, String> environment, String dir, ProcessBuilder.Redirect[] redirects, boolean redirectErrorStream) throws IOException {
        assert (cmdArray != null && cmdArray.length > 0);
        byte[][] args = new byte[cmdArray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdArray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        int[] envc = new int[1];
        byte[] envBlock = ProcessEnvironment.toEnvironmentBlock(environment, envc);
        FileInputStream f0 = null;
        FileOutputStream f1 = null;
        FileOutputStream f2 = null;
        try {
            int[] std_fds;
            boolean forceNullOutputStream = false;
            if (redirects == null) {
                std_fds = new int[]{-1, -1, -1};
            } else {
                std_fds = new int[3];
                if (redirects[0] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[0] = -1;
                } else if (redirects[0] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[0] = 0;
                } else if (redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    std_fds[0] = fdAccess.get(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd());
                } else {
                    f0 = new FileInputStream(redirects[0].file());
                    std_fds[0] = fdAccess.get(f0.getFD());
                }
                if (redirects[1] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[1] = -1;
                } else if (redirects[1] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[1] = 1;
                } else if (redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    std_fds[1] = fdAccess.get(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd());
                    forceNullOutputStream = true;
                } else {
                    f1 = new FileOutputStream(redirects[1].file(), redirects[1].append());
                    std_fds[1] = fdAccess.get(f1.getFD());
                }
                if (redirects[2] == ProcessBuilder.Redirect.PIPE) {
                    std_fds[2] = -1;
                } else if (redirects[2] == ProcessBuilder.Redirect.INHERIT) {
                    std_fds[2] = 2;
                } else if (redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    std_fds[2] = fdAccess.get(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd());
                } else {
                    f2 = new FileOutputStream(redirects[2].file(), redirects[2].append());
                    std_fds[2] = fdAccess.get(f2.getFD());
                }
            }
            PosixProcessImpl p = new PosixProcessImpl(PosixProcessImpl.toCString(cmdArray[0]), argBlock, args.length, envBlock, envc[0], PosixProcessImpl.toCString(dir), std_fds, forceNullOutputStream, redirectErrorStream);
            if (redirects != null) {
                if (std_fds[0] >= 0 && redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.set(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd(), std_fds[0]);
                }
                if (std_fds[1] >= 0 && redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.set(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd(), std_fds[1]);
                }
                if (std_fds[2] >= 0 && redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.set(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd(), std_fds[2]);
                }
            }
            PosixProcessImpl posixProcessImpl = p;
            return posixProcessImpl;
        }
        finally {
            try {
                if (f0 != null) {
                    f0.close();
                }
            }
            finally {
                try {
                    if (f1 != null) {
                        f1.close();
                    }
                }
                finally {
                    if (f2 != null) {
                        f2.close();
                    }
                }
            }
        }
    }

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    private PosixProcessImpl(byte[] prog, byte[] argBlock, int argc, byte[] envBlock, int envc, byte[] dir, int[] fds, boolean forceNullOutputStream, boolean redirectErrorStream) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.ordinal() + 1, helperpath, prog, argBlock, argc, envBlock, envc, dir, fds, redirectErrorStream);
        this.processHandle = ProcessHandleImpl.getInternal(this.pid);
        this.initStreams(fds, forceNullOutputStream);
    }

    static FileDescriptor newFileDescriptor(int fd) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, fd);
        return fileDescriptor;
    }

    void initStreams(int[] fds, boolean forceNullOutputStream) throws IOException {
        switch (platform) {
            case LINUX: 
            case BSD: {
                this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(fds[0]);
                this.stdout = fds[1] == -1 || forceNullOutputStream ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[1]);
                this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[2]);
                ProcessHandleImpl.completion(this.pid, true).handle((exitcode, throwable) -> {
                    PosixProcessImpl posixProcessImpl = this;
                    synchronized (posixProcessImpl) {
                        this.exitcode = exitcode == null ? -1 : exitcode;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                    return null;
                });
                break;
            }
            case AIX: {
                this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(fds[0]);
                this.stdout = fds[1] == -1 || forceNullOutputStream ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(fds[1]);
                this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(fds[2]);
                ProcessHandleImpl.completion(this.pid, true).handle((exitcode, throwable) -> {
                    PosixProcessImpl posixProcessImpl = this;
                    synchronized (posixProcessImpl) {
                        this.exitcode = exitcode == null ? -1 : exitcode;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                    return null;
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        if (this.hasExited) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + remainingNanos;
        do {
            TimeUnit.NANOSECONDS.timedWait(this, remainingNanos);
            if (!this.hasExited) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return this.hasExited;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(boolean force) {
        switch (platform) {
            case LINUX: 
            case BSD: 
            case AIX: {
                PosixProcessImpl posixProcessImpl = this;
                synchronized (posixProcessImpl) {
                    if (!this.hasExited) {
                        this.processHandle.destroyProcess(force);
                    }
                }
                try {
                    this.stdin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stdout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stderr.close();
                }
                catch (IOException iOException) {}
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public CompletableFuture<Process> onExit() {
        return ProcessHandleImpl.completion(this.pid, false).handleAsync((unusedExitStatus, unusedThrowable) -> {
            boolean interrupted = false;
            while (true) {
                try {
                    this.waitFor();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return this;
        });
    }

    @Override
    public ProcessHandle toHandle() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        return this.processHandle;
    }

    @Override
    public boolean supportsNormalTermination() {
        return ProcessImpl.SUPPORTS_NORMAL_TERMINATION;
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }

    @Override
    public Process destroyForcibly() {
        this.destroy(true);
        return this;
    }

    @Override
    public long pid() {
        return this.pid;
    }

    @Override
    public synchronized boolean isAlive() {
        return !this.hasExited;
    }

    public String toString() {
        return "Process[pid=" + this.pid + ", exitValue=" + (this.hasExited ? Integer.valueOf(this.exitcode) : "\"not exited\"") + "]";
    }

    private static native void init();

    static {
        PosixProcessImpl.init();
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }

    private static enum Platform {
        LINUX(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.VFORK, LaunchMechanism.FORK),
        BSD(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        AIX(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK);

        final LaunchMechanism defaultLaunchMechanism;
        final Set<LaunchMechanism> validLaunchMechanisms;

        private Platform(LaunchMechanism ... launchMechanisms) {
            this.defaultLaunchMechanism = launchMechanisms[0];
            this.validLaunchMechanisms = EnumSet.copyOf(Arrays.asList(launchMechanisms));
        }

        LaunchMechanism launchMechanism() {
            return AccessController.doPrivileged(() -> {
                LaunchMechanism lm;
                String s = System.getProperty("jdk.lang.Process.launchMechanism");
                if (s == null) {
                    lm = this.defaultLaunchMechanism;
                    s = lm.name().toLowerCase(Locale.ENGLISH);
                } else {
                    try {
                        lm = LaunchMechanism.valueOf(s.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        lm = null;
                    }
                }
                if (lm == null || !this.validLaunchMechanisms.contains((Object)lm)) {
                    throw new Error(s + " is not a supported process launch mechanism on this platform.");
                }
                return lm;
            });
        }

        static Platform get() {
            String osName = GetPropertyAction.privilegedGetProperty("os.name");
            if (osName.equals("Linux")) {
                return LINUX;
            }
            if (osName.contains("OS X")) {
                return BSD;
            }
            if (osName.equals("AIX")) {
                return AIX;
            }
            throw new Error(osName + " is not a supported OS platform.");
        }
    }

    private static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int fd) {
            super(new FileOutputStream(PosixProcessImpl.newFileDescriptor(fd)));
        }

        synchronized void processExited() {
            OutputStream out = this.out;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    private static class ProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();

        ProcessPipeInputStream(int fd) {
            super(new Process.PipeInputStream(PosixProcessImpl.newFileDescriptor(fd)));
        }

        private static byte[] drainInputStream(InputStream in) throws IOException {
            int j;
            int n = 0;
            byte[] a = null;
            while ((j = in.available()) > 0) {
                a = a == null ? new byte[j] : Arrays.copyOf(a, n + j);
                n += in.read(a, n, j);
            }
            return a == null || n == a.length ? a : Arrays.copyOf(a, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void processExited() {
            Object object2 = this.closeLock;
            synchronized (object2) {
                try {
                    InputStream in = this.in;
                    if (in != null) {
                        byte[] stragglers = ProcessPipeInputStream.drainInputStream(in);
                        in.close();
                        this.in = stragglers == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(stragglers);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object2 = this.closeLock;
            synchronized (object2) {
                super.close();
            }
        }
    }

    private static class DeferredCloseProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();
        private int useCount = 0;
        private boolean closePending = false;

        DeferredCloseProcessPipeInputStream(int fd) {
            super(new Process.PipeInputStream(PosixProcessImpl.newFileDescriptor(fd)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream drainInputStream(InputStream in) throws IOException {
            int j;
            int n = 0;
            byte[] a = null;
            Object object2 = this.closeLock;
            synchronized (object2) {
                if (this.buf == null) {
                    return null;
                }
                j = in.available();
            }
            while (j > 0) {
                a = a == null ? new byte[j] : Arrays.copyOf(a, n + j);
                object2 = this.closeLock;
                synchronized (object2) {
                    if (this.buf == null) {
                        return null;
                    }
                    n += in.read(a, n, j);
                    j = in.available();
                }
            }
            return a == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(n == a.length ? a : Arrays.copyOf(a, n));
        }

        synchronized void processExited() {
            try {
                InputStream in = this.in;
                if (in != null) {
                    InputStream stragglers = this.drainInputStream(in);
                    in.close();
                    this.in = stragglers;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object2 = this.closeLock;
            synchronized (object2) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object2 = this.closeLock;
            synchronized (object2) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.closePending = false;
                    super.close();
                }
            }
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.raise();
            try {
                int n = super.read(b);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.raise();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            this.raise();
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object2 = this.closeLock;
            synchronized (object2) {
                if (this.useCount == 0) {
                    super.close();
                } else {
                    this.closePending = true;
                }
            }
        }
    }

    private static class DeferredCloseInputStream
    extends Process.PipeInputStream {
        private Object lock = new Object();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        DeferredCloseInputStream(FileDescriptor fd) {
            super(fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object2 = this.lock;
            synchronized (object2) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream stc) throws IOException {
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.useCount == 0) {
                    stc.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = stc;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object2 = this.lock;
            synchronized (object2) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.raise();
            try {
                int n = super.read(b);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.raise();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            this.raise();
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }
    }
}

