/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import jdk.internal.util.StaticProperty;

public abstract class Process {
    private BufferedWriter outputWriter;
    private Charset outputCharset;
    private BufferedReader inputReader;
    private Charset inputCharset;
    private BufferedReader errorReader;
    private Charset errorCharset;

    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public abstract InputStream getErrorStream();

    public final BufferedReader inputReader() {
        return this.inputReader(CharsetHolder.nativeCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedReader inputReader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        Process process = this;
        synchronized (process) {
            if (this.inputReader == null) {
                this.inputCharset = charset;
                this.inputReader = new BufferedReader(new InputStreamReader(this.getInputStream(), charset));
            } else if (!this.inputCharset.equals(charset)) {
                throw new IllegalStateException("BufferedReader was created with charset: " + this.inputCharset);
            }
            return this.inputReader;
        }
    }

    public final BufferedReader errorReader() {
        return this.errorReader(CharsetHolder.nativeCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedReader errorReader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        Process process = this;
        synchronized (process) {
            if (this.errorReader == null) {
                this.errorCharset = charset;
                this.errorReader = new BufferedReader(new InputStreamReader(this.getErrorStream(), charset));
            } else if (!this.errorCharset.equals(charset)) {
                throw new IllegalStateException("BufferedReader was created with charset: " + this.errorCharset);
            }
            return this.errorReader;
        }
    }

    public final BufferedWriter outputWriter() {
        return this.outputWriter(CharsetHolder.nativeCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BufferedWriter outputWriter(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        Process process = this;
        synchronized (process) {
            if (this.outputWriter == null) {
                this.outputCharset = charset;
                this.outputWriter = new BufferedWriter(new OutputStreamWriter(this.getOutputStream(), charset));
            } else if (!this.outputCharset.equals(charset)) {
                throw new IllegalStateException("BufferedWriter was created with charset: " + this.outputCharset);
            }
            return this.outputWriter;
        }
    }

    public abstract int waitFor() throws InterruptedException;

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        if (this.hasExited()) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + remainingNanos;
        do {
            Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(remainingNanos) + 1L, 100L));
            if (!this.hasExited()) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return false;
    }

    public abstract int exitValue();

    public abstract void destroy();

    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    public boolean supportsNormalTermination() {
        throw new UnsupportedOperationException(this.getClass() + ".supportsNormalTermination() not supported");
    }

    public boolean isAlive() {
        return !this.hasExited();
    }

    private boolean hasExited() {
        try {
            this.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    public long pid() {
        return this.toHandle().pid();
    }

    public CompletableFuture<Process> onExit() {
        return CompletableFuture.supplyAsync(this::waitForInternal);
    }

    private Process waitForInternal() {
        boolean interrupted = false;
        while (true) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        Process.this.waitFor();
                        return true;
                    }

                    @Override
                    public boolean isReleasable() {
                        return !Process.this.isAlive();
                    }
                });
            }
            catch (InterruptedException x) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public ProcessHandle toHandle() {
        throw new UnsupportedOperationException(this.getClass() + ".toHandle() not supported");
    }

    public ProcessHandle.Info info() {
        return this.toHandle().info();
    }

    public Stream<ProcessHandle> children() {
        return this.toHandle().children();
    }

    public Stream<ProcessHandle> descendants() {
        return this.toHandle().descendants();
    }

    private static class CharsetHolder {
        private static final Charset nativeCharset;

        private CharsetHolder() {
        }

        static Charset nativeCharset() {
            return nativeCharset;
        }

        static {
            Charset cs;
            try {
                cs = Charset.forName(StaticProperty.nativeEncoding());
            }
            catch (UnsupportedCharsetException uce) {
                cs = Charset.defaultCharset();
            }
            nativeCharset = cs;
        }
    }

    static class PipeInputStream
    extends FileInputStream {
        PipeInputStream(FileDescriptor fd) {
            super(fd);
        }

        @Override
        public long skip(long n) throws IOException {
            int nr;
            long remaining;
            if (n <= 0L) {
                return 0L;
            }
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            for (remaining = n; remaining > 0L && (nr = this.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0; remaining -= (long)nr) {
            }
            return n - remaining;
        }
    }
}

