/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.posix.Unistd;

final class ProcessEnvironment {
    static final EnvironmentMap theEnvironment;
    static final Map<String, String> theUnmodifiableEnvironment;
    static final int MIN_NAME_LENGTH;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ProcessEnvironment() {
    }

    private static Key makeKey(String str) {
        if (str == null) {
            return null;
        }
        if (Build.Target.isWindows()) {
            return new WindowsKey(str);
        }
        return new PosixKey(str);
    }

    static String getenv(String name) {
        return theEnvironment.get(name);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return theEnvironment.clone();
    }

    static Map<String, String> emptyEnvironment(int capacity) {
        return new EnvironmentMap(capacity);
    }

    static String toEnvironmentBlock(Map<String, String> map) {
        if (!Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        return ProcessEnvironment.makeWindowsEnvironmentBlock(map);
    }

    static byte[] toEnvironmentBlock(Map<String, String> map, int[] envc) {
        if (Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        return ProcessEnvironment.makeUnixEnvironmentBlock(map, envc);
    }

    static boolean isValidEnvString(String string) {
        return string.indexOf(61) == -1 && string.indexOf(0) == -1;
    }

    static String validateEnvString(String string) {
        if (!ProcessEnvironment.isValidEnvString(string)) {
            throw new IllegalArgumentException("Invalid environment string");
        }
        return string;
    }

    static native String[] getHostEnvironment();

    static byte[] makeUnixEnvironmentBlock(Map<String, String> map, int[] envCnt) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        int cnt = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ProcessEnvironment.isValidEnvString(key) || !ProcessEnvironment.isValidEnvString(value)) continue;
                ++cnt;
                w.write(key);
                w.write(0);
                w.write(value);
                w.write(0);
                w.flush();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        envCnt[0] = cnt;
        return baos.toByteArray();
    }

    static void getPosixEnv(Map<String, String> env) {
        CNative.char_ptr_ptr env_ptr = Unistd.environ;
        StringBuilder b = new StringBuilder();
        while (true) {
            CNative.char_ptr entry_ptr = (CNative.char_ptr)env_ptr.loadUnshared();
            env_ptr = (CNative.char_ptr_ptr)env_ptr.plus(1);
            String key = ProcessEnvironment.makeString(b, entry_ptr);
            if (key == null) {
                return;
            }
            entry_ptr = (CNative.char_ptr)env_ptr.loadUnshared();
            env_ptr = (CNative.char_ptr_ptr)env_ptr.plus(1);
            String value = ProcessEnvironment.makeString(b, entry_ptr);
            if (value == null) {
                return;
            }
            env.put(key, value);
        }
    }

    private static String makeString(StringBuilder sb, CNative.char_ptr ptr2) {
        if (ptr2.isNull()) {
            return null;
        }
        sb.setLength(0);
        while (true) {
            int a = ((CNative.c_char)ptr2.loadUnshared()).byteValue() & 0xFF;
            ptr2 = (CNative.char_ptr)ptr2.plus(1);
            if (a == 0) {
                return sb.toString();
            }
            if (a < 128) {
                sb.appendCodePoint(a);
                continue;
            }
            if (a < 192 || a >= 248) {
                sb.append('\ufffd');
                continue;
            }
            int b = ((CNative.c_char)ptr2.loadUnshared()).byteValue() & 0xFF;
            ptr2 = (CNative.char_ptr)ptr2.plus(1);
            if (b == 0) {
                sb.append('\ufffd');
                return sb.toString();
            }
            if (b < 128 || b >= 192) {
                sb.append('\ufffd').append('\ufffd');
                continue;
            }
            if (a < 224) {
                sb.appendCodePoint((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            int c = ((CNative.c_char)ptr2.loadUnshared()).byteValue() & 0xFF;
            ptr2 = (CNative.char_ptr)ptr2.plus(1);
            if (c == 0) {
                sb.append('\ufffd').append('\ufffd');
                return sb.toString();
            }
            if (c < 128 || c >= 192) {
                sb.append('\ufffd').append('\ufffd').append('\ufffd');
                continue;
            }
            if (a < 240) {
                sb.appendCodePoint((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            int d = ((CNative.c_char)ptr2.loadUnshared()).byteValue() & 0xFF;
            ptr2 = (CNative.char_ptr)ptr2.plus(1);
            if (d == 0) {
                sb.append('\ufffd').append('\ufffd').append('\ufffd');
                return sb.toString();
            }
            if (d < 128 || d >= 192) {
                sb.append('\ufffd').append('\ufffd').append('\ufffd').append('\ufffd');
                continue;
            }
            sb.appendCodePoint((a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F);
        }
    }

    static native String environmentBlock();

    static int compareWindowsStyle(String a, String b) {
        int lenA = a.length();
        int lenB = b.length();
        int minLen = Math.min(lenA, lenB);
        for (int i = 0; i < minLen; ++i) {
            int cmp;
            char bc;
            char ac = a.charAt(i);
            if (ac == (bc = b.charAt(i)) || (cmp = Character.compare(Character.toUpperCase(ac), Character.toUpperCase(bc))) == 0) continue;
            return cmp;
        }
        return Integer.compare(lenA, lenB);
    }

    private static String makeWindowsEnvironmentBlock(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        list.sort(ProcessEnvironment::compareWindowsStyle);
        StringBuilder sb = new StringBuilder(map.size() * 30);
        int cmp = -1;
        String systemRoot = "SystemRoot";
        for (String key : list) {
            String value = map.get(key);
            if (cmp < 0 && (cmp = ProcessEnvironment.compareWindowsStyle(key, "SystemRoot")) > 0) {
                ProcessEnvironment.addToEnvIfSet(sb, "SystemRoot");
            }
            ProcessEnvironment.addToEnv(sb, key, value);
        }
        if (cmp < 0) {
            ProcessEnvironment.addToEnvIfSet(sb, "SystemRoot");
        }
        if (sb.length() == 0) {
            sb.append('\u0000');
        }
        sb.append('\u0000');
        return sb.toString();
    }

    private static void addToEnvIfSet(StringBuilder sb, String key) {
        String val = ProcessEnvironment.getenv(key);
        if (val != null) {
            ProcessEnvironment.addToEnv(sb, key, val);
        }
    }

    private static void addToEnv(StringBuilder sb, String key, String val) {
        sb.append(key).append('=').append(val).appendCodePoint(0);
    }

    static void parseWindowsEnvBlock(String block, Map<String, String> map) {
        int eql;
        int end;
        if (!Build.Target.isWindows()) {
            throw new UnsupportedOperationException();
        }
        String envblock = ProcessEnvironment.environmentBlock();
        int beg = 0;
        while ((end = envblock.indexOf(0, beg)) != -1 && (eql = envblock.indexOf(61, beg + 1)) != -1) {
            if (eql < end) {
                map.put(envblock.substring(beg, eql), envblock.substring(eql + 1, end));
            }
            beg = end + 1;
        }
    }

    static {
        boolean bl = $assertionsDisabled = !ProcessEnvironment.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Build.isHost()) {
            throw new AssertionError();
        }
        String[] hostEnvironment = ProcessEnvironment.getHostEnvironment();
        EnvironmentMap env = new EnvironmentMap();
        for (int i = 0; i < hostEnvironment.length; i += 2) {
            String key = hostEnvironment[i];
            String value = hostEnvironment[i + 1];
            if (!ProcessEnvironment.isValidEnvString(key) || !ProcessEnvironment.isValidEnvString(value)) continue;
            env.put(key, value);
        }
        theEnvironment = env;
        theUnmodifiableEnvironment = Collections.unmodifiableMap(env);
        MIN_NAME_LENGTH = Build.Target.isWindows() ? 1 : 0;
    }

    static final class WindowsKey
    extends Key {
        WindowsKey(String string) {
            super(string);
        }

        @Override
        public int compareTo(Key other) {
            WindowsKey key = (WindowsKey)other;
            String a = this.toString();
            String b = key.toString();
            int lenA = a.length();
            int lenB = b.length();
            int minLen = Math.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                int cmp;
                char bc;
                char ac = a.charAt(i);
                if (ac == (bc = b.charAt(i)) || (cmp = Character.compare(Character.toUpperCase(ac), Character.toUpperCase(bc))) == 0) continue;
                return cmp;
            }
            return Integer.compare(lenA, lenB);
        }

        @Override
        boolean equals(Key other) {
            WindowsKey key = (WindowsKey)other;
            String a = this.toString();
            String b = key.toString();
            int len = a.length();
            if (len != b.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char bc;
                char ac = a.charAt(i);
                if (ac == (bc = b.charAt(i)) || Character.toUpperCase(ac) == Character.toUpperCase(bc)) continue;
                return false;
            }
            return true;
        }

        @Override
        int computeHashCode() {
            int hc = 0;
            String str = this.toString();
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                hc = 31 * hc + Character.toUpperCase(str.charAt(i));
            }
            return hc;
        }
    }

    static final class PosixKey
    extends Key {
        PosixKey(String string) {
            super(string);
        }

        @Override
        public int compareTo(Key o) {
            return this.toString().compareTo(o.toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean equals(Key other) {
            if (!(other instanceof PosixKey)) return false;
            PosixKey pk = (PosixKey)other;
            if (!this.toString().equals(pk.toString())) return false;
            return true;
        }

        @Override
        int computeHashCode() {
            return this.toString().hashCode();
        }
    }

    static final class EnvironmentMap
    extends AbstractMap<String, String> {
        private final Map<Key, String> env;
        private EntrySet entrySet;
        private KeySet keySet;

        EnvironmentMap(Map<Key, String> env) {
            this.env = env;
        }

        EnvironmentMap(int capacity) {
            this(new HashMap<Key, String>(capacity));
        }

        EnvironmentMap() {
            this(new HashMap<Key, String>());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            EntrySet entrySet = this.entrySet;
            if (entrySet == null) {
                this.entrySet = entrySet = new EntrySet();
            }
            return entrySet;
        }

        @Override
        public Set<String> keySet() {
            KeySet keySet = this.keySet;
            if (keySet == null) {
                this.keySet = keySet = new KeySet();
            }
            return keySet;
        }

        @Override
        public Collection<String> values() {
            return this.env.values();
        }

        @Override
        public boolean containsKey(Object key) {
            String keyStr;
            Objects.requireNonNull(key, "key");
            return key instanceof String && this.env.containsKey(ProcessEnvironment.makeKey(keyStr = (String)key));
        }

        @Override
        public boolean containsValue(Object value) {
            Objects.requireNonNull(value, "value");
            return this.env.containsValue(value);
        }

        @Override
        public String get(Object key) {
            String string;
            Objects.requireNonNull(key, "key");
            if (key instanceof String) {
                String keyStr = (String)key;
                string = this.env.get(ProcessEnvironment.makeKey(keyStr));
            } else {
                string = null;
            }
            return string;
        }

        @Override
        public String getOrDefault(Object key, String defaultValue) {
            String string;
            Objects.requireNonNull(key, "key");
            if (key instanceof String) {
                String keyStr = (String)key;
                string = Objects.requireNonNullElse(this.env.get(ProcessEnvironment.makeKey(keyStr)), defaultValue);
            } else {
                string = defaultValue;
            }
            return string;
        }

        @Override
        public String put(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return this.env.put(ProcessEnvironment.makeKey(ProcessEnvironment.validateEnvString(key)), ProcessEnvironment.validateEnvString(value));
        }

        @Override
        public String putIfAbsent(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return this.env.putIfAbsent(ProcessEnvironment.makeKey(ProcessEnvironment.validateEnvString(key)), ProcessEnvironment.validateEnvString(value));
        }

        @Override
        public String remove(Object key) {
            String string;
            Objects.requireNonNull(key, "key");
            if (key instanceof String) {
                String keyStr = (String)key;
                string = this.env.remove(ProcessEnvironment.makeKey(keyStr));
            } else {
                string = null;
            }
            return string;
        }

        @Override
        public boolean remove(Object key, Object value) {
            String keyStr;
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return key instanceof String && this.env.remove(ProcessEnvironment.makeKey(keyStr = (String)key), value);
        }

        @Override
        public String replace(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            return this.env.replace(ProcessEnvironment.makeKey(key), ProcessEnvironment.validateEnvString(value));
        }

        @Override
        public boolean replace(String key, String oldValue, String newValue) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(oldValue, "oldValue");
            Objects.requireNonNull(newValue, "newValue");
            return this.env.replace(ProcessEnvironment.makeKey(key), oldValue, ProcessEnvironment.validateEnvString(newValue));
        }

        @Override
        public void clear() {
            this.env.clear();
        }

        @Override
        public EnvironmentMap clone() {
            return new EnvironmentMap(new HashMap<Key, String>(this.env));
        }

        @Override
        public int size() {
            return this.env.size();
        }

        final class EntrySet
        extends AbstractSet<Map.Entry<String, String>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator<Map.Entry<Key, String>> iterator = EnvironmentMap.this.env.entrySet().iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        Map.Entry next = (Map.Entry)iterator.next();
                        return Map.entry(((Key)next.getKey()).toString(), (String)next.getValue());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) return false;
                Map.Entry me = (Map.Entry)o;
                Object k = me.getKey();
                if (!(k instanceof String)) return false;
                String key = (String)k;
                Object v = me.getValue();
                if (!(v instanceof String)) return false;
                String value = (String)v;
                if (!EnvironmentMap.this.env.entrySet().contains(Map.entry(ProcessEnvironment.makeKey(key), value))) return false;
                return true;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) return false;
                Map.Entry me = (Map.Entry)o;
                Object k = me.getKey();
                if (!(k instanceof String)) return false;
                String key = (String)k;
                Object v = me.getValue();
                if (!(v instanceof String)) return false;
                String value = (String)v;
                if (!EnvironmentMap.this.env.remove(ProcessEnvironment.makeKey(key), value)) return false;
                return true;
            }

            @Override
            public int size() {
                return EnvironmentMap.this.env.size();
            }
        }

        final class KeySet
        extends AbstractSet<String> {
            KeySet() {
            }

            @Override
            public Iterator<String> iterator() {
                final Iterator<Key> iterator = EnvironmentMap.this.env.keySet().iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return ((Key)iterator.next()).toString();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return EnvironmentMap.this.env.size();
            }

            @Override
            public boolean contains(Object o) {
                String str;
                return o instanceof String && EnvironmentMap.this.env.containsKey(ProcessEnvironment.makeKey(str = (String)o));
            }

            @Override
            public boolean remove(Object o) {
                String str;
                return o instanceof String && EnvironmentMap.this.env.remove(ProcessEnvironment.makeKey(str = (String)o)) != null;
            }
        }
    }

    static abstract class Key
    implements Comparable<Key> {
        private final String string;
        private int hashCode;

        Key(String string) {
            ProcessEnvironment.validateEnvString(string);
            this.string = string;
        }

        public final boolean equals(Object other) {
            Key key;
            return other instanceof Key && this.equals(key = (Key)other);
        }

        @Override
        public abstract int compareTo(Key var1);

        abstract boolean equals(Key var1);

        public final int hashCode() {
            int hashCode = this.hashCode;
            if (hashCode == 0) {
                hashCode = this.computeHashCode();
                if (hashCode == 0) {
                    hashCode |= Integer.MIN_VALUE;
                }
                this.hashCode = hashCode;
            }
            return hashCode;
        }

        abstract int computeHashCode();

        public final String toString() {
            return this.string;
        }
    }
}

