/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessController;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jdk.internal.ValueBased;

@ValueBased
final class ProcessHandleImpl
implements ProcessHandle {
    private static long REAPER_DEFAULT_STACKSIZE = 131072L;
    private static final int NOT_A_CHILD = -2;
    private static final ProcessHandleImpl current;
    private static final ConcurrentMap<Long, ExitCompletion> completions;
    private static final Executor processReaperExecutor;
    private final long pid;
    private final long startTime;
    private final long STARTTIME_ANY = 0L;
    private final long STARTTIME_PROCESS_UNKNOWN = -1L;

    private static native void initNative();

    static CompletableFuture<Integer> completion(final long pid, final boolean shouldReap) {
        ExitCompletion completion = (ExitCompletion)completions.get(pid);
        while (completion == null || shouldReap && !completion.isReaping) {
            final ExitCompletion newCompletion = new ExitCompletion(shouldReap);
            if (completion == null) {
                completion = completions.putIfAbsent(pid, newCompletion);
            } else {
                ExitCompletion exitCompletion = completion = completions.replace(pid, completion, newCompletion) ? null : (ExitCompletion)completions.get(pid);
            }
            if (completion != null) continue;
            completion = newCompletion;
            processReaperExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    int exitValue = ProcessHandleImpl.waitForProcessExit0(pid, shouldReap);
                    if (exitValue == -2) {
                        long startTime;
                        long sleep = 300L;
                        int incr = 30;
                        long origStart = startTime = ProcessHandleImpl.isAlive0(pid);
                        while (startTime >= 0L) {
                            try {
                                Thread.sleep(Math.min(sleep, 5000L));
                                sleep += (long)incr;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if ((startTime = ProcessHandleImpl.isAlive0(pid)) <= 0L || origStart <= 0L || startTime == origStart) continue;
                        }
                        exitValue = 0;
                    }
                    newCompletion.complete(exitValue);
                    completions.remove(pid, newCompletion);
                }
            });
        }
        return completion;
    }

    @Override
    public CompletableFuture<ProcessHandle> onExit() {
        if (this.equals(current)) {
            throw new IllegalStateException("onExit for current process not allowed");
        }
        return ProcessHandleImpl.completion(this.pid(), false).handleAsync((exitStatus, unusedThrowable) -> this);
    }

    private static native int waitForProcessExit0(long var0, boolean var2);

    private ProcessHandleImpl(long pid, long startTime) {
        this.pid = pid;
        this.startTime = startTime;
    }

    static Optional<ProcessHandle> get(long pid) {
        long start;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        return (start = ProcessHandleImpl.isAlive0(pid)) >= 0L ? Optional.of(new ProcessHandleImpl(pid, start)) : Optional.empty();
    }

    static ProcessHandleImpl getInternal(long pid) {
        return new ProcessHandleImpl(pid, ProcessHandleImpl.isAlive0(pid));
    }

    @Override
    public long pid() {
        return this.pid;
    }

    public static ProcessHandleImpl current() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        return current;
    }

    private static native long getCurrentPid0();

    @Override
    public Optional<ProcessHandle> parent() {
        long ppid;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        if ((ppid = ProcessHandleImpl.parent0(this.pid, this.startTime)) <= 0L) {
            return Optional.empty();
        }
        return ProcessHandleImpl.get(ppid);
    }

    private static native long parent0(long var0, long var2);

    private static native int getProcessPids0(long var0, long[] var2, long[] var3, long[] var4);

    boolean destroyProcess(boolean force) {
        if (this.equals(current)) {
            throw new IllegalStateException("destroy of current process not allowed");
        }
        return ProcessHandleImpl.destroy0(this.pid, this.startTime, force);
    }

    private static native boolean destroy0(long var0, long var2, boolean var4);

    @Override
    public boolean destroy() {
        return this.destroyProcess(false);
    }

    @Override
    public boolean destroyForcibly() {
        return this.destroyProcess(true);
    }

    @Override
    public boolean supportsNormalTermination() {
        return ProcessImpl.SUPPORTS_NORMAL_TERMINATION;
    }

    @Override
    public boolean isAlive() {
        long start = ProcessHandleImpl.isAlive0(this.pid);
        return start >= 0L && (start == this.startTime || start == 0L || this.startTime == 0L);
    }

    private static native long isAlive0(long var0);

    @Override
    public Stream<ProcessHandle> children() {
        return ProcessHandleImpl.children(this.pid).filter(ph -> this.startTime <= ((ProcessHandleImpl)ph).startTime);
    }

    static Stream<ProcessHandle> children(long pid) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        int size = 100;
        long[] childpids = null;
        long[] starttimes = null;
        while (childpids == null || size > childpids.length) {
            childpids = new long[size];
            starttimes = new long[size];
            size = ProcessHandleImpl.getProcessPids0(pid, childpids, null, starttimes);
        }
        long[] cpids = childpids;
        long[] stimes = starttimes;
        return IntStream.range(0, size).mapToObj(i -> new ProcessHandleImpl(cpids[i], stimes[i]));
    }

    @Override
    public Stream<ProcessHandle> descendants() {
        int i2;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        int size = 100;
        long[] pids = null;
        long[] ppids = null;
        long[] starttimes = null;
        while (pids == null || size > pids.length) {
            pids = new long[size];
            ppids = new long[size];
            starttimes = new long[size];
            size = ProcessHandleImpl.getProcessPids0(0L, pids, ppids, starttimes);
        }
        int next = 0;
        int count = -1;
        long ppid = this.pid;
        long ppStart = 0L;
        for (i2 = 0; i2 < size; ++i2) {
            if (pids[i2] != ppid) continue;
            ppStart = starttimes[i2];
            break;
        }
        do {
            for (i2 = next; i2 < size; ++i2) {
                if (ppids[i2] != ppid || ppStart > starttimes[i2]) continue;
                ProcessHandleImpl.swap(pids, i2, next);
                ProcessHandleImpl.swap(ppids, i2, next);
                ProcessHandleImpl.swap(starttimes, i2, next);
                ++next;
            }
            ppid = pids[++count];
            ppStart = starttimes[count];
        } while (count < next);
        long[] cpids = pids;
        long[] stimes = starttimes;
        return IntStream.range(0, count).mapToObj(i -> new ProcessHandleImpl(cpids[i], stimes[i]));
    }

    private static void swap(long[] array, int x, int y) {
        long v = array[x];
        array[x] = array[y];
        array[y] = v;
    }

    @Override
    public ProcessHandle.Info info() {
        return Info.info(this.pid, this.startTime);
    }

    @Override
    public int compareTo(ProcessHandle other) {
        return Long.compare(this.pid, ((ProcessHandleImpl)other).pid);
    }

    public String toString() {
        return Long.toString(this.pid);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.pid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProcessHandleImpl)) return false;
        ProcessHandleImpl other = (ProcessHandleImpl)obj;
        if (this.pid != other.pid) return false;
        if (this.startTime == other.startTime) return true;
        if (this.startTime == 0L) return true;
        if (other.startTime != 0L) return false;
        return true;
    }

    static {
        completions = new ConcurrentHashMap<Long, ExitCompletion>();
        ProcessHandleImpl.initNative();
        long pid = ProcessHandleImpl.getCurrentPid0();
        current = new ProcessHandleImpl(pid, ProcessHandleImpl.isAlive0(pid));
        processReaperExecutor = AccessController.doPrivileged(() -> {
            ThreadLocalRandom.current();
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            while (tg.getParent() != null) {
                tg = tg.getParent();
            }
            ThreadGroup systemThreadGroup = tg;
            int debugDelta = "release".equals(System.getProperty("jdk.debug")) ? 0 : 16384;
            long stackSize = Boolean.getBoolean("jdk.lang.processReaperUseDefaultStackSize") ? 0L : REAPER_DEFAULT_STACKSIZE + (long)debugDelta;
            ThreadFactory threadFactory = grimReaper -> {
                Thread t = new Thread(systemThreadGroup, grimReaper, "process reaper", stackSize, false);
                t.setDaemon(true);
                t.setPriority(10);
                return t;
            };
            return Executors.newCachedThreadPool(threadFactory);
        });
    }

    private static class ExitCompletion
    extends CompletableFuture<Integer> {
        final boolean isReaping;

        ExitCompletion(boolean isReaping) {
            this.isReaping = isReaping;
        }
    }

    static class Info
    implements ProcessHandle.Info {
        String command = null;
        String commandLine = null;
        String[] arguments = null;
        long startTime = -1L;
        long totalTime = -1L;
        String user = null;

        private static native void initIDs();

        private native void info0(long var1);

        Info() {
        }

        public static ProcessHandle.Info info(long pid, long startTime) {
            Info info = new Info();
            info.info0(pid);
            if (startTime != info.startTime) {
                info.command = null;
                info.arguments = null;
                info.startTime = -1L;
                info.totalTime = -1L;
                info.user = null;
            }
            return info;
        }

        @Override
        public Optional<String> command() {
            return Optional.ofNullable(this.command);
        }

        @Override
        public Optional<String> commandLine() {
            if (this.command != null && this.arguments != null) {
                return Optional.of(this.command + " " + String.join((CharSequence)" ", this.arguments));
            }
            return Optional.ofNullable(this.commandLine);
        }

        @Override
        public Optional<String[]> arguments() {
            return Optional.ofNullable(this.arguments);
        }

        @Override
        public Optional<Instant> startInstant() {
            return this.startTime > 0L ? Optional.of(Instant.ofEpochMilli(this.startTime)) : Optional.empty();
        }

        @Override
        public Optional<Duration> totalCpuDuration() {
            return this.totalTime != -1L ? Optional.of(Duration.ofNanos(this.totalTime)) : Optional.empty();
        }

        @Override
        public Optional<String> user() {
            return Optional.ofNullable(this.user);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(60);
            sb.append('[');
            if (this.user != null) {
                sb.append("user: ");
                sb.append(this.user());
            }
            if (this.command != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("cmd: ");
                sb.append(this.command);
            }
            if (this.arguments != null && this.arguments.length > 0) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("args: ");
                sb.append(Arrays.toString(this.arguments));
            }
            if (this.commandLine != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("cmdLine: ");
                sb.append(this.commandLine);
            }
            if (this.startTime > 0L) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("startTime: ");
                sb.append(this.startInstant());
            }
            if (this.totalTime != -1L) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append("totalTime: ");
                sb.append(this.totalCpuDuration().toString());
            }
            sb.append(']');
            return sb.toString();
        }

        static {
            Info.initIDs();
        }
    }
}

