/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.invoke.MethodType;
import jdk.internal.access.JavaLangInvokeAccess;
import jdk.internal.access.SharedSecrets;

class StackFrameInfo
implements StackWalker.StackFrame {
    private static final JavaLangInvokeAccess JLIA = SharedSecrets.getJavaLangInvokeAccess();
    private final boolean retainClassRef;
    private final Object memberName;
    private int bci;
    private volatile StackTraceElement ste;

    StackFrameInfo(StackWalker walker) {
        this.retainClassRef = walker.retainClassRef;
        this.memberName = JLIA.newMemberName();
    }

    Class<?> declaringClass() {
        return JLIA.getDeclaringClass(this.memberName);
    }

    @Override
    public String getClassName() {
        return this.declaringClass().getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        this.ensureRetainClassRefEnabled();
        return this.declaringClass();
    }

    @Override
    public String getMethodName() {
        return JLIA.getName(this.memberName);
    }

    @Override
    public MethodType getMethodType() {
        this.ensureRetainClassRefEnabled();
        return JLIA.getMethodType(this.memberName);
    }

    @Override
    public String getDescriptor() {
        return JLIA.getMethodDescriptor(this.memberName);
    }

    @Override
    public int getByteCodeIndex() {
        if (this.isNativeMethod()) {
            return -1;
        }
        return this.bci;
    }

    @Override
    public String getFileName() {
        return this.toStackTraceElement().getFileName();
    }

    @Override
    public int getLineNumber() {
        if (this.isNativeMethod()) {
            return -2;
        }
        return this.toStackTraceElement().getLineNumber();
    }

    @Override
    public boolean isNativeMethod() {
        return JLIA.isNative(this.memberName);
    }

    public String toString() {
        return this.toStackTraceElement().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StackTraceElement toStackTraceElement() {
        StackTraceElement s = this.ste;
        if (s == null) {
            StackFrameInfo stackFrameInfo = this;
            synchronized (stackFrameInfo) {
                s = this.ste;
                if (s == null) {
                    this.ste = s = StackTraceElement.of(this);
                }
            }
        }
        return s;
    }

    private void ensureRetainClassRefEnabled() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("No access to RETAIN_CLASS_REFERENCE");
        }
    }
}

