/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import jdk.internal.loader.BuiltinClassLoader;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleHashes;
import jdk.internal.module.ModuleReferenceImpl;

public final class StackTraceElement
implements Serializable {
    private transient Class<?> declaringClassObject;
    private String classLoaderName;
    private String moduleName;
    private String moduleVersion;
    private String declaringClass;
    private String methodName;
    private String fileName;
    private int lineNumber;
    private byte format = 0;
    private static final byte BUILTIN_CLASS_LOADER = 1;
    private static final byte JDK_NON_UPGRADEABLE_MODULE = 2;
    private static final long serialVersionUID = 6992337162326171013L;

    public StackTraceElement(String declaringClass, String methodName, String fileName, int lineNumber) {
        this(null, null, null, declaringClass, methodName, fileName, lineNumber);
    }

    public StackTraceElement(String classLoaderName, String moduleName, String moduleVersion, String declaringClass, String methodName, String fileName, int lineNumber) {
        this.classLoaderName = classLoaderName;
        this.moduleName = moduleName;
        this.moduleVersion = moduleVersion;
        this.declaringClass = Objects.requireNonNull(declaringClass, "Declaring class is null");
        this.methodName = Objects.requireNonNull(methodName, "Method name is null");
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    private StackTraceElement() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public String getClassLoaderName() {
        return this.classLoaderName;
    }

    public String getClassName() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        String s = "";
        if (!this.dropClassLoaderName() && this.classLoaderName != null && !this.classLoaderName.isEmpty()) {
            s = s + this.classLoaderName + "/";
        }
        if (this.moduleName != null && !this.moduleName.isEmpty()) {
            s = s + this.moduleName;
            if (!this.dropModuleVersion() && this.moduleVersion != null && !this.moduleVersion.isEmpty()) {
                s = s + "@" + this.moduleVersion;
            }
        }
        s = s.isEmpty() ? this.declaringClass : s + "/" + this.declaringClass;
        return s + "." + this.methodName + "(" + (this.isNativeMethod() ? "Native Method)" : (this.fileName != null && this.lineNumber >= 0 ? this.fileName + ":" + this.lineNumber + ")" : (this.fileName != null ? "" + this.fileName + ")" : "Unknown Source)")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackTraceElement)) return false;
        StackTraceElement e = (StackTraceElement)obj;
        if (e.lineNumber != this.lineNumber) return false;
        if (!e.declaringClass.equals(this.declaringClass)) return false;
        if (!Objects.equals(this.classLoaderName, e.classLoaderName)) return false;
        if (!Objects.equals(this.moduleName, e.moduleName)) return false;
        if (!Objects.equals(this.moduleVersion, e.moduleVersion)) return false;
        if (!Objects.equals(this.methodName, e.methodName)) return false;
        if (!Objects.equals(this.fileName, e.fileName)) return false;
        return true;
    }

    public int hashCode() {
        int result = 31 * this.declaringClass.hashCode() + this.methodName.hashCode();
        result = 31 * result + Objects.hashCode(this.classLoaderName);
        result = 31 * result + Objects.hashCode(this.moduleName);
        result = 31 * result + Objects.hashCode(this.moduleVersion);
        result = 31 * result + Objects.hashCode(this.fileName);
        result = 31 * result + this.lineNumber;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void computeFormat() {
        try {
            Class<?> cls = this.declaringClassObject;
            ClassLoader loader = cls.getClassLoader0();
            Module m = cls.getModule();
            byte bits = 0;
            if (loader instanceof BuiltinClassLoader) {
                bits = (byte)(bits | 1);
            }
            if (StackTraceElement.isHashedInJavaBase(m)) {
                bits = (byte)(bits | 2);
            }
            this.format = bits;
        }
        finally {
            this.declaringClassObject = null;
        }
    }

    private boolean dropClassLoaderName() {
        return (this.format & 1) == 1;
    }

    private boolean dropModuleVersion() {
        return (this.format & 2) == 2;
    }

    private static boolean isHashedInJavaBase(Module m) {
        if (!VM.isModuleSystemInited()) {
            return true;
        }
        return ModuleLayer.boot() == m.getLayer() && HashedModules.contains(m);
    }

    static StackTraceElement[] of(Throwable x, int depth) {
        StackTraceElement[] stackTrace = new StackTraceElement[depth];
        for (int i = 0; i < depth; ++i) {
            stackTrace[i] = new StackTraceElement();
        }
        StackTraceElement.initStackTraceElements(stackTrace, x);
        for (StackTraceElement ste : stackTrace) {
            ste.computeFormat();
        }
        return stackTrace;
    }

    static StackTraceElement of(StackFrameInfo sfi) {
        StackTraceElement ste = new StackTraceElement();
        StackTraceElement.initStackTraceElement(ste, sfi);
        ste.computeFormat();
        return ste;
    }

    private static native void initStackTraceElements(StackTraceElement[] var0, Throwable var1);

    private static native void initStackTraceElement(StackTraceElement var0, StackFrameInfo var1);

    private static class HashedModules {
        static Set<String> HASHED_MODULES = HashedModules.hashedModules();

        private HashedModules() {
        }

        static Set<String> hashedModules() {
            Optional<ResolvedModule> resolvedModule = ModuleLayer.boot().configuration().findModule("java.base");
            assert (resolvedModule.isPresent());
            ModuleReference mref = resolvedModule.get().reference();
            assert (mref instanceof ModuleReferenceImpl);
            ModuleHashes hashes = ((ModuleReferenceImpl)mref).recordedHashes();
            if (hashes != null) {
                HashSet<String> names = new HashSet<String>(hashes.names());
                names.add("java.base");
                return names;
            }
            return Set.of();
        }

        static boolean contains(Module m) {
            return HASHED_MODULES.contains(m.getName());
        }
    }
}

