/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.invoke.MethodType;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import jdk.internal.reflect.CallerSensitive;

public final class StackWalker {
    static final EnumSet<Option> DEFAULT_EMPTY_OPTION = EnumSet.noneOf(Option.class);
    private static final StackWalker DEFAULT_WALKER = new StackWalker(DEFAULT_EMPTY_OPTION);
    private final Set<Option> options;
    private final ExtendedOption extendedOption;
    private final int estimateDepth;
    final boolean retainClassRef;

    public static StackWalker getInstance() {
        return DEFAULT_WALKER;
    }

    public static StackWalker getInstance(Option option) {
        return StackWalker.getInstance(EnumSet.of(Objects.requireNonNull(option)));
    }

    public static StackWalker getInstance(Set<Option> options) {
        if (options.isEmpty()) {
            return DEFAULT_WALKER;
        }
        EnumSet<Option> optionSet = StackWalker.toEnumSet(options);
        StackWalker.checkPermission(optionSet);
        return new StackWalker(optionSet);
    }

    public static StackWalker getInstance(Set<Option> options, int estimateDepth) {
        if (estimateDepth <= 0) {
            throw new IllegalArgumentException("estimateDepth must be > 0");
        }
        EnumSet<Option> optionSet = StackWalker.toEnumSet(options);
        StackWalker.checkPermission(optionSet);
        return new StackWalker(optionSet, estimateDepth);
    }

    private StackWalker(EnumSet<Option> options) {
        this(options, 0, null);
    }

    private StackWalker(EnumSet<Option> options, int estimateDepth) {
        this(options, estimateDepth, null);
    }

    private StackWalker(EnumSet<Option> options, int estimateDepth, ExtendedOption extendedOption) {
        this.options = options;
        this.estimateDepth = estimateDepth;
        this.extendedOption = extendedOption;
        this.retainClassRef = this.hasOption(Option.RETAIN_CLASS_REFERENCE);
    }

    private static void checkPermission(Set<Option> options) {
        Objects.requireNonNull(options);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && options.contains((Object)Option.RETAIN_CLASS_REFERENCE)) {
            sm.checkPermission(new RuntimePermission("getStackWalkerWithClassReference"));
        }
    }

    private static EnumSet<Option> toEnumSet(Set<Option> options) {
        Objects.requireNonNull(options);
        if (options.isEmpty()) {
            return DEFAULT_EMPTY_OPTION;
        }
        return EnumSet.copyOf(options);
    }

    @CallerSensitive
    public <T> T walk(Function<? super Stream<StackFrame>, ? extends T> function) {
        Objects.requireNonNull(function);
        return (T)StackStreamFactory.makeStackTraverser(this, function).walk();
    }

    @CallerSensitive
    public void forEach(Consumer<? super StackFrame> action) {
        Objects.requireNonNull(action);
        StackStreamFactory.makeStackTraverser(this, s -> {
            s.forEach(action);
            return null;
        }).walk();
    }

    @CallerSensitive
    public Class<?> getCallerClass() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }
        return StackStreamFactory.makeCallerFinder(this).findCaller();
    }

    static StackWalker newInstance(Set<Option> options, ExtendedOption extendedOption) {
        EnumSet<Option> optionSet = StackWalker.toEnumSet(options);
        StackWalker.checkPermission(optionSet);
        return new StackWalker(optionSet, 0, extendedOption);
    }

    int estimateDepth() {
        return this.estimateDepth;
    }

    boolean hasOption(Option option) {
        return this.options.contains((Object)option);
    }

    boolean hasLocalsOperandsOption() {
        return this.extendedOption == ExtendedOption.LOCALS_AND_OPERANDS;
    }

    public static enum Option {
        RETAIN_CLASS_REFERENCE,
        SHOW_REFLECT_FRAMES,
        SHOW_HIDDEN_FRAMES;

    }

    static enum ExtendedOption {
        LOCALS_AND_OPERANDS;

    }

    public static interface StackFrame {
        public String getClassName();

        public String getMethodName();

        public Class<?> getDeclaringClass();

        default public MethodType getMethodType() {
            throw new UnsupportedOperationException();
        }

        default public String getDescriptor() {
            throw new UnsupportedOperationException();
        }

        public int getByteCodeIndex();

        public String getFileName();

        public int getLineNumber();

        public boolean isNativeMethod();

        public StackTraceElement toStackTraceElement();
    }
}

