/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.UTF_8;

public final class String
implements Serializable,
Comparable<String>,
CharSequence,
Constable,
ConstantDesc {
    @Stable
    private final byte[] value;
    private final byte coder;
    private int hash;
    private boolean hashIsZero;
    private static final long serialVersionUID = -6849794470754667710L;
    static final boolean COMPACT_STRINGS = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final char REPL = '\ufffd';
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    static final byte LATIN1 = 0;
    static final byte UTF16 = 1;

    public String() {
        this.value = "".value;
        this.coder = "".coder;
    }

    @IntrinsicCandidate
    public String(String original) {
        this.value = original.value;
        this.coder = original.coder;
        this.hash = original.hash;
    }

    public String(char[] value) {
        this(value, 0, value.length, null);
    }

    public String(char[] value, int offset, int count) {
        this(value, offset, count, String.rangeCheck(value, offset, count));
    }

    private static Void rangeCheck(char[] value, int offset, int count) {
        String.checkBoundsOffCount(offset, count, value.length);
        return null;
    }

    public String(int[] codePoints, int offset, int count) {
        byte[] val;
        String.checkBoundsOffCount(offset, count, codePoints.length);
        if (count == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (val = StringLatin1.toBytes(codePoints, offset, count)) != null) {
            this.coder = 0;
            this.value = val;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(codePoints, offset, count);
    }

    @Deprecated(since="1.1")
    public String(byte[] ascii, int hibyte, int offset, int count) {
        String.checkBoundsOffCount(offset, count, ascii.length);
        if (count == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (byte)hibyte == 0) {
            this.value = Arrays.copyOfRange(ascii, offset, offset + count);
            this.coder = 0;
        } else {
            hibyte <<= 8;
            byte[] val = StringUTF16.newBytesFor(count);
            for (int i = 0; i < count; ++i) {
                StringUTF16.putChar(val, i, hibyte | ascii[offset++] & 0xFF);
            }
            this.value = val;
            this.coder = 1;
        }
    }

    @Deprecated(since="1.1")
    public String(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        this(bytes, offset, length, String.lookupCharset(charsetName));
    }

    public String(byte[] bytes, int offset, int length, Charset charset) {
        Objects.requireNonNull(charset);
        String.checkBoundsOffCount(offset, length, bytes.length);
        if (length == 0) {
            this.value = "".value;
            this.coder = "".coder;
        } else if (charset == UTF_8.INSTANCE) {
            if (COMPACT_STRINGS && !StringCoding.hasNegatives(bytes, offset, length)) {
                this.value = Arrays.copyOfRange(bytes, offset, offset + length);
                this.coder = 0;
            } else {
                int sl = offset + length;
                int dp = 0;
                byte[] dst = null;
                if (COMPACT_STRINGS) {
                    dst = new byte[length];
                    while (offset < sl) {
                        byte b2;
                        byte b1 = bytes[offset];
                        if (b1 >= 0) {
                            dst[dp++] = b1;
                            ++offset;
                            continue;
                        }
                        if (b1 != -62 && b1 != -61 || offset + 1 >= sl || String.isNotContinuation(b2 = bytes[offset + 1])) break;
                        dst[dp++] = (byte)String.decode2(b1, b2);
                        offset += 2;
                    }
                    if (offset == sl) {
                        if (dp != dst.length) {
                            dst = Arrays.copyOf(dst, dp);
                        }
                        this.value = dst;
                        this.coder = 0;
                        return;
                    }
                }
                if (dp == 0 || dst == null) {
                    dst = new byte[length << 1];
                } else {
                    byte[] buf = new byte[length << 1];
                    StringLatin1.inflate(dst, 0, buf, 0, dp);
                    dst = buf;
                }
                dp = String.decodeUTF8_UTF16(bytes, offset, sl, dst, dp, true);
                if (dp != length) {
                    dst = Arrays.copyOf(dst, dp << 1);
                }
                this.value = dst;
                this.coder = 1;
            }
        } else if (charset == ISO_8859_1.INSTANCE) {
            if (COMPACT_STRINGS) {
                this.value = Arrays.copyOfRange(bytes, offset, offset + length);
                this.coder = 0;
            } else {
                this.value = StringLatin1.inflate(bytes, offset, length);
                this.coder = 1;
            }
        } else if (charset == US_ASCII.INSTANCE) {
            if (COMPACT_STRINGS && !StringCoding.hasNegatives(bytes, offset, length)) {
                this.value = Arrays.copyOfRange(bytes, offset, offset + length);
                this.coder = 0;
            } else {
                byte[] dst = new byte[length << 1];
                int dp = 0;
                while (dp < length) {
                    byte b = bytes[offset++];
                    StringUTF16.putChar(dst, dp++, b >= 0 ? (int)b : 65533);
                }
                this.value = dst;
                this.coder = 1;
            }
        } else {
            byte[] bs;
            CharsetDecoder cd = charset.newDecoder();
            if (cd instanceof ArrayDecoder) {
                byte[] bs2;
                ArrayDecoder ad = (ArrayDecoder)((Object)cd);
                if (ad.isASCIICompatible() && !StringCoding.hasNegatives(bytes, offset, length)) {
                    if (COMPACT_STRINGS) {
                        this.value = Arrays.copyOfRange(bytes, offset, offset + length);
                        this.coder = 0;
                        return;
                    }
                    this.value = StringLatin1.inflate(bytes, offset, length);
                    this.coder = 1;
                    return;
                }
                if (COMPACT_STRINGS && ad.isLatin1Decodable()) {
                    byte[] dst = new byte[length];
                    ad.decodeToLatin1(bytes, offset, length, dst);
                    this.value = dst;
                    this.coder = 0;
                    return;
                }
                int en = String.scale(length, cd.maxCharsPerByte());
                cd.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                char[] ca = new char[en];
                int clen = ad.decode(bytes, offset, length, ca);
                if (COMPACT_STRINGS && (bs2 = StringUTF16.compress(ca, 0, clen)) != null) {
                    this.value = bs2;
                    this.coder = 0;
                    return;
                }
                this.coder = 1;
                this.value = StringUTF16.toBytes(ca, 0, clen);
                return;
            }
            int en = String.scale(length, cd.maxCharsPerByte());
            cd.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            char[] ca = new char[en];
            if (charset.getClass().getClassLoader0() != null && System.getSecurityManager() != null) {
                bytes = Arrays.copyOfRange(bytes, offset, offset + length);
                offset = 0;
            }
            int caLen = String.decodeWithDecoder(cd, ca, bytes, offset, length);
            if (COMPACT_STRINGS && (bs = StringUTF16.compress(ca, 0, caLen)) != null) {
                this.value = bs;
                this.coder = 0;
                return;
            }
            this.coder = 1;
            this.value = StringUTF16.toBytes(ca, 0, caLen);
        }
    }

    static String newStringUTF8NoRepl(byte[] bytes, int offset, int length) {
        String.checkBoundsOffCount(offset, length, bytes.length);
        if (length == 0) {
            return "";
        }
        if (COMPACT_STRINGS && !StringCoding.hasNegatives(bytes, offset, length)) {
            return new String(Arrays.copyOfRange(bytes, offset, offset + length), 0);
        }
        int sl = offset + length;
        int dp = 0;
        byte[] dst = null;
        if (COMPACT_STRINGS) {
            dst = new byte[length];
            while (offset < sl) {
                byte b2;
                byte b1 = bytes[offset];
                if (b1 >= 0) {
                    dst[dp++] = b1;
                    ++offset;
                    continue;
                }
                if (b1 != -62 && b1 != -61 || offset + 1 >= sl || String.isNotContinuation(b2 = bytes[offset + 1])) break;
                dst[dp++] = (byte)String.decode2(b1, b2);
                offset += 2;
            }
            if (offset == sl) {
                if (dp != dst.length) {
                    dst = Arrays.copyOf(dst, dp);
                }
                return new String(dst, 0);
            }
        }
        if (dp == 0 || dst == null) {
            dst = new byte[length << 1];
        } else {
            byte[] buf = new byte[length << 1];
            StringLatin1.inflate(dst, 0, buf, 0, dp);
            dst = buf;
        }
        dp = String.decodeUTF8_UTF16(bytes, offset, sl, dst, dp, false);
        if (dp != length) {
            dst = Arrays.copyOf(dst, dp << 1);
        }
        return new String(dst, 1);
    }

    static String newStringNoRepl(byte[] src, Charset cs) throws CharacterCodingException {
        try {
            return String.newStringNoRepl1(src, cs);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MalformedInputException) {
                MalformedInputException mie = (MalformedInputException)cause;
                throw mie;
            }
            throw (CharacterCodingException)cause;
        }
    }

    private static String newStringNoRepl1(byte[] src, Charset cs) {
        byte[] bs;
        ArrayDecoder ad;
        CharsetDecoder cd;
        int len = src.length;
        if (len == 0) {
            return "";
        }
        if (cs == UTF_8.INSTANCE) {
            return String.newStringUTF8NoRepl(src, 0, src.length);
        }
        if (cs == ISO_8859_1.INSTANCE) {
            if (COMPACT_STRINGS) {
                return new String(src, 0);
            }
            return new String(StringLatin1.inflate(src, 0, src.length), 1);
        }
        if (cs == US_ASCII.INSTANCE) {
            if (!StringCoding.hasNegatives(src, 0, src.length)) {
                if (COMPACT_STRINGS) {
                    return new String(src, 0);
                }
                return new String(StringLatin1.inflate(src, 0, src.length), 1);
            }
            String.throwMalformed(src);
        }
        if ((cd = cs.newDecoder()) instanceof ArrayDecoder && (ad = (ArrayDecoder)((Object)cd)).isASCIICompatible() && !StringCoding.hasNegatives(src, 0, src.length)) {
            return new String(src, 0, src.length, ISO_8859_1.INSTANCE);
        }
        int en = String.scale(len, cd.maxCharsPerByte());
        char[] ca = new char[en];
        if (cs.getClass().getClassLoader0() != null && System.getSecurityManager() != null) {
            src = Arrays.copyOf(src, len);
        }
        int caLen = String.decodeWithDecoder(cd, ca, src, 0, src.length);
        if (COMPACT_STRINGS && (bs = StringUTF16.compress(ca, 0, caLen)) != null) {
            return new String(bs, 0);
        }
        return new String(StringUTF16.toBytes(ca, 0, caLen), 1);
    }

    private static byte[] safeTrim(byte[] ba, int len, boolean isTrusted) {
        if (len == ba.length && (isTrusted || System.getSecurityManager() == null)) {
            return ba;
        }
        return Arrays.copyOf(ba, len);
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private static Charset lookupCharset(String csn) throws UnsupportedEncodingException {
        Objects.requireNonNull(csn);
        try {
            return Charset.forName(csn);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException x) {
            throw new UnsupportedEncodingException(csn);
        }
    }

    private static byte[] encode(Charset cs, byte coder, byte[] val) {
        if (cs == UTF_8.INSTANCE) {
            return String.encodeUTF8(coder, val, true);
        }
        if (cs == ISO_8859_1.INSTANCE) {
            return String.encode8859_1(coder, val);
        }
        if (cs == US_ASCII.INSTANCE) {
            return String.encodeASCII(coder, val);
        }
        return String.encodeWithEncoder(cs, coder, val, true);
    }

    private static byte[] encodeWithEncoder(Charset cs, byte coder, byte[] val, boolean doReplace) {
        CharsetEncoder ce = cs.newEncoder();
        int len = val.length >> coder;
        int en = String.scale(len, ce.maxBytesPerChar());
        if (ce instanceof ArrayEncoder) {
            int blen;
            ArrayEncoder ae = (ArrayEncoder)((Object)ce);
            if (coder == 0 && ae.isASCIICompatible() && !StringCoding.hasNegatives(val, 0, val.length)) {
                return Arrays.copyOf(val, val.length);
            }
            byte[] ba = new byte[en];
            if (len == 0) {
                return ba;
            }
            if (doReplace) {
                ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            }
            int n = blen = coder == 0 ? ae.encodeFromLatin1(val, 0, len, ba) : ae.encodeFromUTF16(val, 0, len, ba);
            if (blen != -1) {
                return String.safeTrim(ba, blen, true);
            }
        }
        byte[] ba = new byte[en];
        if (len == 0) {
            return ba;
        }
        if (doReplace) {
            ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        char[] ca = coder == 0 ? StringLatin1.toChars(val) : StringUTF16.toChars(val);
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca, 0, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            if (!doReplace) {
                throw new IllegalArgumentException(x);
            }
            throw new Error(x);
        }
        return String.safeTrim(ba, bb.position(), cs.getClass().getClassLoader0() == null);
    }

    static byte[] getBytesUTF8NoRepl(String s) {
        return String.encodeUTF8(s.coder(), s.value(), false);
    }

    private static boolean isASCII(byte[] src) {
        return !StringCoding.hasNegatives(src, 0, src.length);
    }

    static byte[] getBytesNoRepl(String s, Charset cs) throws CharacterCodingException {
        try {
            return String.getBytesNoRepl1(s, cs);
        }
        catch (IllegalArgumentException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnmappableCharacterException) {
                throw (UnmappableCharacterException)cause;
            }
            throw (CharacterCodingException)cause;
        }
    }

    private static byte[] getBytesNoRepl1(String s, Charset cs) {
        byte[] val = s.value();
        byte coder = s.coder();
        if (cs == UTF_8.INSTANCE) {
            if (coder == 0 && String.isASCII(val)) {
                return val;
            }
            return String.encodeUTF8(coder, val, false);
        }
        if (cs == ISO_8859_1.INSTANCE) {
            if (coder == 0) {
                return val;
            }
            return String.encode8859_1(coder, val, false);
        }
        if (cs == US_ASCII.INSTANCE && coder == 0) {
            if (String.isASCII(val)) {
                return val;
            }
            String.throwUnmappable(val);
        }
        return String.encodeWithEncoder(cs, coder, val, false);
    }

    private static byte[] encodeASCII(byte coder, byte[] val) {
        if (coder == 0) {
            byte[] dst = Arrays.copyOf(val, val.length);
            for (int i = 0; i < dst.length; ++i) {
                if (dst[i] >= 0) continue;
                dst[i] = 63;
            }
            return dst;
        }
        int len = val.length >> 1;
        byte[] dst = new byte[len];
        int dp = 0;
        for (int i = 0; i < len; ++i) {
            char c = StringUTF16.getChar(val, i);
            if (c < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (Character.isHighSurrogate(c) && i + 1 < len && Character.isLowSurrogate(StringUTF16.getChar(val, i + 1))) {
                ++i;
            }
            dst[dp++] = 63;
        }
        if (len == dp) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    private static byte[] encode8859_1(byte coder, byte[] val) {
        return String.encode8859_1(coder, val, true);
    }

    private static byte[] encode8859_1(byte coder, byte[] val, boolean doReplace) {
        if (coder == 0) {
            return Arrays.copyOf(val, val.length);
        }
        int len = val.length >> 1;
        byte[] dst = new byte[len];
        int dp = 0;
        int sp = 0;
        int sl = len;
        while (sp < sl) {
            char c;
            int ret = StringCoding.implEncodeISOArray(val, sp, dst, dp, len);
            sp += ret;
            dp += ret;
            if (ret == len) continue;
            if (!doReplace) {
                String.throwUnmappable(sp);
            }
            if (Character.isHighSurrogate(c = StringUTF16.getChar(val, sp++)) && sp < sl && Character.isLowSurrogate(StringUTF16.getChar(val, sp))) {
                ++sp;
            }
            dst[dp++] = 63;
            len = sl - sp;
        }
        if (dp == dst.length) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    static int decodeASCII(byte[] sa, int sp, char[] da, int dp, int len) {
        if (!StringCoding.hasNegatives(sa, sp, len)) {
            StringLatin1.inflate(sa, sp, da, dp, len);
            return len;
        }
        int start = sp;
        int end = sp + len;
        while (sp < end && sa[sp] >= 0) {
            da[dp++] = (char)sa[sp++];
        }
        return sp - start;
    }

    private static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed3_2(int b1, int b2) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    private static boolean isMalformed4_2(int b1, int b2) {
        return b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || (b2 & 0xC0) != 128;
    }

    private static boolean isMalformed4_3(int b3) {
        return (b3 & 0xC0) != 128;
    }

    private static char decode2(int b1, int b2) {
        return (char)(b1 << 6 ^ b2 ^ 0xF80);
    }

    private static char decode3(int b1, int b2, int b3) {
        return (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
    }

    private static int decode4(int b1, int b2, int b3, int b4) {
        return b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
    }

    private static int decodeUTF8_UTF16(byte[] src, int sp, int sl, byte[] dst, int dp, boolean doReplace) {
        while (sp < sl) {
            byte b3;
            byte b2;
            int b1;
            if ((b1 = src[sp++]) >= 0) {
                StringUTF16.putChar(dst, dp++, (char)b1);
                continue;
            }
            if (b1 >> 5 == -2 && (b1 & 0x1E) != 0) {
                if (sp < sl) {
                    if (String.isNotContinuation(b2 = src[sp++])) {
                        if (!doReplace) {
                            String.throwMalformed(sp - 1, 1);
                        }
                        StringUTF16.putChar(dst, dp++, 65533);
                        --sp;
                        continue;
                    }
                    StringUTF16.putChar(dst, dp++, String.decode2(b1, b2));
                    continue;
                }
                if (!doReplace) {
                    String.throwMalformed(sp, 1);
                }
                StringUTF16.putChar(dst, dp++, 65533);
                break;
            }
            if (b1 >> 4 == -2) {
                if (sp + 1 < sl) {
                    if (String.isMalformed3(b1, b2 = src[sp++], b3 = src[sp++])) {
                        if (!doReplace) {
                            String.throwMalformed(sp - 3, 3);
                        }
                        StringUTF16.putChar(dst, dp++, 65533);
                        sp -= 3;
                        sp += String.malformed3(src, sp);
                        continue;
                    }
                    char c = String.decode3(b1, b2, b3);
                    if (Character.isSurrogate(c)) {
                        if (!doReplace) {
                            String.throwMalformed(sp - 3, 3);
                        }
                        StringUTF16.putChar(dst, dp++, 65533);
                        continue;
                    }
                    StringUTF16.putChar(dst, dp++, c);
                    continue;
                }
                if (sp < sl && String.isMalformed3_2(b1, src[sp])) {
                    if (!doReplace) {
                        String.throwMalformed(sp - 1, 2);
                    }
                    StringUTF16.putChar(dst, dp++, 65533);
                    continue;
                }
                if (!doReplace) {
                    String.throwMalformed(sp, 1);
                }
                StringUTF16.putChar(dst, dp++, 65533);
                break;
            }
            if (b1 >> 3 == -2) {
                if (sp + 2 < sl) {
                    b2 = src[sp++];
                    b3 = src[sp++];
                    byte b4 = src[sp++];
                    int uc = String.decode4(b1, b2, b3, b4);
                    if (String.isMalformed4(b2, b3, b4) || !Character.isSupplementaryCodePoint(uc)) {
                        if (!doReplace) {
                            String.throwMalformed(sp - 4, 4);
                        }
                        StringUTF16.putChar(dst, dp++, 65533);
                        sp -= 4;
                        sp += String.malformed4(src, sp);
                        continue;
                    }
                    StringUTF16.putChar(dst, dp++, Character.highSurrogate(uc));
                    StringUTF16.putChar(dst, dp++, Character.lowSurrogate(uc));
                    continue;
                }
                if ((b1 &= 0xFF) > 244 || sp < sl && String.isMalformed4_2(b1, src[sp] & 0xFF)) {
                    if (!doReplace) {
                        String.throwMalformed(sp - 1, 1);
                    }
                    StringUTF16.putChar(dst, dp++, 65533);
                    continue;
                }
                if (!doReplace) {
                    String.throwMalformed(sp - 1, 1);
                }
                StringUTF16.putChar(dst, dp++, 65533);
                if (++sp >= sl || !String.isMalformed4_3(src[sp])) break;
                continue;
            }
            if (!doReplace) {
                String.throwMalformed(sp - 1, 1);
            }
            StringUTF16.putChar(dst, dp++, 65533);
        }
        return dp;
    }

    private static int decodeWithDecoder(CharsetDecoder cd, char[] dst, byte[] src, int offset, int length) {
        ByteBuffer bb = ByteBuffer.wrap(src, offset, length);
        CharBuffer cb = CharBuffer.wrap(dst, 0, dst.length);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return cb.position();
    }

    private static int malformed3(byte[] src, int sp) {
        byte b1 = src[sp++];
        byte b2 = src[sp];
        return b1 == -32 && (b2 & 0xE0) == 128 || String.isNotContinuation(b2) ? 1 : 2;
    }

    private static int malformed4(byte[] src, int sp) {
        int b1 = src[sp++] & 0xFF;
        int b2 = src[sp++] & 0xFF;
        if (b1 > 244 || b1 == 240 && (b2 < 144 || b2 > 191) || b1 == 244 && (b2 & 0xF0) != 128 || String.isNotContinuation(b2)) {
            return 1;
        }
        if (String.isNotContinuation(src[sp])) {
            return 2;
        }
        return 3;
    }

    private static void throwMalformed(int off, int nb) {
        String msg = "malformed input off : " + off + ", length : " + nb;
        throw new IllegalArgumentException(msg, new MalformedInputException(nb));
    }

    private static void throwMalformed(byte[] val) {
        int dp;
        for (dp = 0; dp < val.length && val[dp] >= 0; ++dp) {
        }
        String.throwMalformed(dp, 1);
    }

    private static void throwUnmappable(int off) {
        String msg = "malformed input off : " + off + ", length : 1";
        throw new IllegalArgumentException(msg, new UnmappableCharacterException(1));
    }

    private static void throwUnmappable(byte[] val) {
        int dp;
        for (dp = 0; dp < val.length && val[dp] >= 0; ++dp) {
        }
        String.throwUnmappable(dp);
    }

    private static byte[] encodeUTF8(byte coder, byte[] val, boolean doReplace) {
        if (coder == 1) {
            return String.encodeUTF8_UTF16(val, doReplace);
        }
        if (!StringCoding.hasNegatives(val, 0, val.length)) {
            return Arrays.copyOf(val, val.length);
        }
        int dp = 0;
        byte[] dst = new byte[val.length << 1];
        for (byte c : val) {
            if (c < 0) {
                dst[dp++] = (byte)(0xC0 | (c & 0xFF) >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            dst[dp++] = c;
        }
        if (dp == dst.length) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    private static byte[] encodeUTF8_UTF16(byte[] val, boolean doReplace) {
        char c;
        int sp;
        int dp = 0;
        int sl = val.length >> 1;
        byte[] dst = new byte[sl * 3];
        for (sp = 0; sp < sl && (c = StringUTF16.getChar(val, sp)) < '\u0080'; ++sp) {
            dst[dp++] = (byte)c;
        }
        while (sp < sl) {
            if ((c = StringUTF16.getChar(val, sp++)) < '\u0080') {
                dst[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[dp++] = (byte)(0xC0 | c >> 6);
                dst[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (Character.isSurrogate(c)) {
                char c2;
                int uc = -1;
                if (Character.isHighSurrogate(c) && sp < sl && Character.isLowSurrogate(c2 = StringUTF16.getChar(val, sp))) {
                    uc = Character.toCodePoint(c, c2);
                }
                if (uc < 0) {
                    if (doReplace) {
                        dst[dp++] = 63;
                        continue;
                    }
                    String.throwUnmappable(sp - 1);
                    continue;
                }
                dst[dp++] = (byte)(0xF0 | uc >> 18);
                dst[dp++] = (byte)(0x80 | uc >> 12 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc >> 6 & 0x3F);
                dst[dp++] = (byte)(0x80 | uc & 0x3F);
                ++sp;
                continue;
            }
            dst[dp++] = (byte)(0xE0 | c >> 12);
            dst[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            dst[dp++] = (byte)(0x80 | c & 0x3F);
        }
        if (dp == dst.length) {
            return dst;
        }
        return Arrays.copyOf(dst, dp);
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public String(byte[] bytes, Charset charset) {
        this(bytes, 0, bytes.length, charset);
    }

    public String(byte[] bytes, int offset, int length) {
        this(bytes, offset, length, Charset.defaultCharset());
    }

    public String(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public String(StringBuffer buffer) {
        this(buffer.toString());
    }

    public String(StringBuilder builder) {
        this(builder, null);
    }

    @Override
    public int length() {
        return this.value.length >> this.coder();
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public char charAt(int index) {
        if (this.isLatin1()) {
            return StringLatin1.charAt(this.value, index);
        }
        return StringUTF16.charAt(this.value, index);
    }

    public int codePointAt(int index) {
        if (this.isLatin1()) {
            String.checkIndex(index, this.value.length);
            return this.value[index] & 0xFF;
        }
        int length = this.value.length >> 1;
        String.checkIndex(index, length);
        return StringUTF16.codePointAt(this.value, index, length);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.isLatin1()) {
            return this.value[i] & 0xFF;
        }
        return StringUTF16.codePointBefore(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isLatin1()) {
            return endIndex - beginIndex;
        }
        return StringUTF16.codePointCount(this.value, beginIndex, endIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePoints(this, index, codePointOffset);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        String.checkBoundsBeginEnd(srcBegin, srcEnd, this.length());
        String.checkBoundsOffCount(dstBegin, srcEnd - srcBegin, dst.length);
        if (this.isLatin1()) {
            StringLatin1.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        } else {
            StringUTF16.getChars(this.value, srcBegin, srcEnd, dst, dstBegin);
        }
    }

    @Deprecated(since="1.1")
    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        String.checkBoundsBeginEnd(srcBegin, srcEnd, this.length());
        Objects.requireNonNull(dst);
        String.checkBoundsOffCount(dstBegin, srcEnd - srcBegin, dst.length);
        if (this.isLatin1()) {
            StringLatin1.getBytes(this.value, srcBegin, srcEnd, dst, dstBegin);
        } else {
            StringUTF16.getBytes(this.value, srcBegin, srcEnd, dst, dstBegin);
        }
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return String.encode(String.lookupCharset(charsetName), this.coder(), this.value);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return String.encode(charset, this.coder(), this.value);
    }

    public byte[] getBytes() {
        return String.encode(Charset.defaultCharset(), this.coder(), this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof String)) return false;
        String aString = (String)anObject;
        if (COMPACT_STRINGS) {
            if (this.coder != aString.coder) return false;
        }
        if (!StringLatin1.equals(this.value, aString.value)) return false;
        return true;
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.contentEquals((CharSequence)sb);
    }

    private boolean nonSyncContentEquals(AbstractStringBuilder sb) {
        int len = this.length();
        if (len != sb.length()) {
            return false;
        }
        byte[] v1 = this.value;
        byte[] v2 = sb.getValue();
        byte coder = this.coder();
        if (coder == sb.getCoder()) {
            int n = v1.length;
            for (int i = 0; i < n; ++i) {
                if (v1[i] == v2[i]) continue;
                return false;
            }
        } else {
            if (coder != 0) {
                return false;
            }
            return StringUTF16.contentEquals(v1, v2, len);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(CharSequence cs) {
        if (cs instanceof AbstractStringBuilder) {
            if (cs instanceof StringBuffer) {
                CharSequence charSequence = cs;
                synchronized (charSequence) {
                    return this.nonSyncContentEquals((AbstractStringBuilder)cs);
                }
            }
            return this.nonSyncContentEquals((AbstractStringBuilder)cs);
        }
        if (cs instanceof String) {
            return this.equals(cs);
        }
        int n = cs.length();
        if (n != this.length()) {
            return false;
        }
        byte[] val = this.value;
        if (this.isLatin1()) {
            for (int i = 0; i < n; ++i) {
                if ((val[i] & 0xFF) == cs.charAt(i)) continue;
                return false;
            }
        } else if (!StringUTF16.contentEquals(val, cs, n)) {
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.length() == this.length() && this.regionMatches(true, 0, anotherString, 0, this.length());
    }

    @Override
    public int compareTo(String anotherString) {
        byte[] v1 = this.value;
        byte[] v2 = anotherString.value;
        byte coder = this.coder();
        if (coder == anotherString.coder()) {
            return coder == 0 ? StringLatin1.compareTo(v1, v2) : StringUTF16.compareTo(v1, v2);
        }
        return coder == 0 ? StringLatin1.compareToUTF16(v1, v2) : StringUTF16.compareToLatin1(v1, v2);
    }

    public int compareToIgnoreCase(String str) {
        return CASE_INSENSITIVE_ORDER.compare(this, str);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        byte[] tv = this.value;
        byte[] ov = other.value;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        byte coder = this.coder();
        if (coder == other.coder()) {
            if (!this.isLatin1() && len > 0) {
                toffset <<= 1;
                ooffset <<= 1;
                len <<= 1;
            }
            while (len-- > 0) {
                if (tv[toffset++] == ov[ooffset++]) continue;
                return false;
            }
        } else if (coder == 0) {
            while (len-- > 0) {
                if (StringLatin1.getChar(tv, toffset++) == StringUTF16.getChar(ov, ooffset++)) continue;
                return false;
            }
        } else {
            while (len-- > 0) {
                if (StringUTF16.getChar(tv, toffset++) == StringLatin1.getChar(ov, ooffset++)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        if (!ignoreCase) {
            return this.regionMatches(toffset, other, ooffset, len);
        }
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.length() - (long)len || (long)ooffset > (long)other.length() - (long)len) {
            return false;
        }
        byte[] tv = this.value;
        byte[] ov = other.value;
        byte coder = this.coder();
        if (coder == other.coder()) {
            return coder == 0 ? StringLatin1.regionMatchesCI(tv, toffset, ov, ooffset, len) : StringUTF16.regionMatchesCI(tv, toffset, ov, ooffset, len);
        }
        return coder == 0 ? StringLatin1.regionMatchesCI_UTF16(tv, toffset, ov, ooffset, len) : StringUTF16.regionMatchesCI_Latin1(tv, toffset, ov, ooffset, len);
    }

    public boolean startsWith(String prefix, int toffset) {
        if (toffset < 0 || toffset > this.length() - prefix.length()) {
            return false;
        }
        byte[] ta = this.value;
        byte[] pa = prefix.value;
        int po = 0;
        int pc = pa.length;
        byte coder = this.coder();
        if (coder == prefix.coder()) {
            int to;
            int n = to = coder == 0 ? toffset : toffset << 1;
            while (po < pc) {
                if (ta[to++] == pa[po++]) continue;
                return false;
            }
        } else {
            if (coder == 0) {
                return false;
            }
            while (po < pc) {
                if (StringUTF16.getChar(ta, toffset++) == (pa[po++] & 0xFF)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.length() - suffix.length());
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && !this.hashIsZero) {
            int n = h = this.isLatin1() ? StringLatin1.hashCode(this.value) : StringUTF16.hashCode(this.value);
            if (h == 0) {
                this.hashIsZero = true;
            } else {
                this.hash = h;
            }
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.isLatin1() ? StringLatin1.indexOf(this.value, ch, fromIndex) : StringUTF16.indexOf(this.value, ch, fromIndex);
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.length() - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        return this.isLatin1() ? StringLatin1.lastIndexOf(this.value, ch, fromIndex) : StringUTF16.lastIndexOf(this.value, ch, fromIndex);
    }

    public int indexOf(String str) {
        byte coder = this.coder();
        if (coder == str.coder()) {
            return this.isLatin1() ? StringLatin1.indexOf(this.value, str.value) : StringUTF16.indexOf(this.value, str.value);
        }
        if (coder == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(this.value, str.value);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, this.coder(), this.length(), str, fromIndex);
    }

    static int indexOf(byte[] src, byte srcCoder, int srcCount, String tgtStr, int fromIndex) {
        byte[] tgt = tgtStr.value;
        byte tgtCoder = tgtStr.coder();
        int tgtCount = tgtStr.length();
        if (fromIndex >= srcCount) {
            return tgtCount == 0 ? srcCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (tgtCount == 0) {
            return fromIndex;
        }
        if (tgtCount > srcCount) {
            return -1;
        }
        if (srcCoder == tgtCoder) {
            return srcCoder == 0 ? StringLatin1.indexOf(src, srcCount, tgt, tgtCount, fromIndex) : StringUTF16.indexOf(src, srcCount, tgt, tgtCount, fromIndex);
        }
        if (srcCoder == 0) {
            return -1;
        }
        return StringUTF16.indexOfLatin1(src, srcCount, tgt, tgtCount, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.length());
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, this.coder(), this.length(), str, fromIndex);
    }

    static int lastIndexOf(byte[] src, byte srcCoder, int srcCount, String tgtStr, int fromIndex) {
        byte[] tgt = tgtStr.value;
        byte tgtCoder = tgtStr.coder();
        int tgtCount = tgtStr.length();
        int rightIndex = srcCount - tgtCount;
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (fromIndex < 0) {
            return -1;
        }
        if (tgtCount == 0) {
            return fromIndex;
        }
        if (srcCoder == tgtCoder) {
            return srcCoder == 0 ? StringLatin1.lastIndexOf(src, srcCount, tgt, tgtCount, fromIndex) : StringUTF16.lastIndexOf(src, srcCount, tgt, tgtCount, fromIndex);
        }
        if (srcCoder == 0) {
            return -1;
        }
        return StringUTF16.lastIndexOfLatin1(src, srcCount, tgt, tgtCount, fromIndex);
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.length());
    }

    public String substring(int beginIndex, int endIndex) {
        int length = this.length();
        String.checkBoundsBeginEnd(beginIndex, endIndex, length);
        if (beginIndex == 0 && endIndex == length) {
            return this;
        }
        int subLen = endIndex - beginIndex;
        return this.isLatin1() ? StringLatin1.newString(this.value, beginIndex, subLen) : StringUTF16.newString(this.value, beginIndex, subLen);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String concat(String str) {
        if (str.isEmpty()) {
            return this;
        }
        return StringConcatHelper.simpleConcat(this, str);
    }

    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            String ret;
            String string = ret = this.isLatin1() ? StringLatin1.replace(this.value, oldChar, newChar) : StringUTF16.replace(this.value, oldChar, newChar);
            if (ret != null) {
                return ret;
            }
        }
        return this;
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) >= 0;
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public String replace(CharSequence target, CharSequence replacement) {
        int resultLen;
        String trgtStr = target.toString();
        String replStr = replacement.toString();
        int thisLen = this.length();
        int trgtLen = trgtStr.length();
        int replLen = replStr.length();
        if (trgtLen > 0) {
            String ret;
            if (trgtLen == 1 && replLen == 1) {
                return this.replace(trgtStr.charAt(0), replStr.charAt(0));
            }
            boolean thisIsLatin1 = this.isLatin1();
            boolean trgtIsLatin1 = trgtStr.isLatin1();
            boolean replIsLatin1 = replStr.isLatin1();
            String string = ret = thisIsLatin1 && trgtIsLatin1 && replIsLatin1 ? StringLatin1.replace(this.value, thisLen, trgtStr.value, trgtLen, replStr.value, replLen) : StringUTF16.replace(this.value, thisLen, thisIsLatin1, trgtStr.value, trgtLen, trgtIsLatin1, replStr.value, replLen, replIsLatin1);
            if (ret != null) {
                return ret;
            }
            return this;
        }
        try {
            resultLen = Math.addExact(thisLen, Math.multiplyExact(Math.addExact(thisLen, 1), replLen));
        }
        catch (ArithmeticException ignored) {
            throw new OutOfMemoryError("Required length exceeds implementation limit");
        }
        StringBuilder sb = new StringBuilder(resultLen);
        sb.append(replStr);
        for (int i = 0; i < thisLen; ++i) {
            sb.append(this.charAt(i)).append(replStr);
        }
        return sb.toString();
    }

    public String[] split(String regex, int limit) {
        char ch = '\u0000';
        if ((regex.length() == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            boolean limited = limit > 0;
            ArrayList<String> list = new ArrayList<String>();
            while ((next = this.indexOf(ch, off)) != -1) {
                if (!limited || list.size() < limit - 1) {
                    list.add(this.substring(off, next));
                    off = next + 1;
                    continue;
                }
                int last = this.length();
                list.add(this.substring(off, last));
                off = last;
                break;
            }
            if (off == 0) {
                return new String[]{this};
            }
            if (!limited || list.size() < limit) {
                list.add(this.substring(off, this.length()));
            }
            if (limit == 0) {
                for (resultSize = list.size(); resultSize > 0 && ((String)list.get(resultSize - 1)).isEmpty(); --resultSize) {
                }
            }
            String[] result = new String[resultSize];
            return list.subList(0, resultSize).toArray(result);
        }
        return Pattern.compile(regex).split(this, limit);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        String delim = delimiter.toString();
        String[] elems = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            elems[i] = String.valueOf(elements[i]);
        }
        return String.join("", "", delim, elems, elems.length);
    }

    @ForceInline
    static String join(String prefix, String suffix, String delimiter, String[] elements, int size) {
        int icoder = prefix.coder() | suffix.coder();
        long len = (long)prefix.length() + (long)suffix.length();
        if (size > 1) {
            len += (long)(size - 1) * (long)delimiter.length();
            icoder |= delimiter.coder();
        }
        for (int i = 0; i < size; ++i) {
            String el = elements[i];
            len += (long)el.length();
            icoder |= el.coder();
        }
        byte coder = (byte)icoder;
        if (len < 0L || (len <<= coder) != (long)((int)len)) {
            throw new OutOfMemoryError("Requested string length exceeds VM limit");
        }
        byte[] value = StringConcatHelper.newArray(len);
        int off = 0;
        prefix.getBytes(value, off, coder);
        off += prefix.length();
        if (size > 0) {
            String el = elements[0];
            el.getBytes(value, off, coder);
            off += el.length();
            for (int i = 1; i < size; ++i) {
                delimiter.getBytes(value, off, coder);
                el = elements[i];
                el.getBytes(value, off += delimiter.length(), coder);
                off += el.length();
            }
        }
        suffix.getBytes(value, off, coder);
        return new String(value, coder);
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        String delim = delimiter.toString();
        String[] elems = new String[8];
        int size = 0;
        for (CharSequence charSequence : elements) {
            if (size >= elems.length) {
                elems = Arrays.copyOf(elems, elems.length << 1);
            }
            elems[size++] = String.valueOf(charSequence);
        }
        return String.join("", "", delim, elems, size);
    }

    public String toLowerCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toLowerCase(this, this.value, locale) : StringUTF16.toLowerCase(this, this.value, locale);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        return this.isLatin1() ? StringLatin1.toUpperCase(this, this.value, locale) : StringUTF16.toUpperCase(this, this.value, locale);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        String ret = this.isLatin1() ? StringLatin1.trim(this.value) : StringUTF16.trim(this.value);
        return ret == null ? this : ret;
    }

    public String strip() {
        String ret = this.isLatin1() ? StringLatin1.strip(this.value) : StringUTF16.strip(this.value);
        return ret == null ? this : ret;
    }

    public String stripLeading() {
        String ret = this.isLatin1() ? StringLatin1.stripLeading(this.value) : StringUTF16.stripLeading(this.value);
        return ret == null ? this : ret;
    }

    public String stripTrailing() {
        String ret = this.isLatin1() ? StringLatin1.stripTrailing(this.value) : StringUTF16.stripTrailing(this.value);
        return ret == null ? this : ret;
    }

    public boolean isBlank() {
        return this.indexOfNonWhitespace() == this.length();
    }

    public Stream<String> lines() {
        return this.isLatin1() ? StringLatin1.lines(this.value) : StringUTF16.lines(this.value);
    }

    public String indent(int n) {
        if (this.isEmpty()) {
            return "";
        }
        Stream<String> stream = this.lines();
        if (n > 0) {
            String spaces = " ".repeat(n);
            stream = stream.map(s -> spaces + s);
        } else if (n == Integer.MIN_VALUE) {
            stream = stream.map(s -> s.stripLeading());
        } else if (n < 0) {
            stream = stream.map(s -> s.substring(Math.min(-n, s.indexOfNonWhitespace())));
        }
        return stream.collect(Collectors.joining("\n", "", "\n"));
    }

    private int indexOfNonWhitespace() {
        return this.isLatin1() ? StringLatin1.indexOfNonWhitespace(this.value) : StringUTF16.indexOfNonWhitespace(this.value);
    }

    private int lastIndexOfNonWhitespace() {
        return this.isLatin1() ? StringLatin1.lastIndexOfNonWhitespace(this.value) : StringUTF16.lastIndexOfNonWhitespace(this.value);
    }

    public String stripIndent() {
        int length = this.length();
        if (length == 0) {
            return "";
        }
        char lastChar = this.charAt(length - 1);
        boolean optOut = lastChar == '\n' || lastChar == '\r';
        List<String> lines = this.lines().toList();
        int outdent = optOut ? 0 : String.outdent(lines);
        return lines.stream().map(line -> {
            int firstNonWhitespace = line.indexOfNonWhitespace();
            int lastNonWhitespace = line.lastIndexOfNonWhitespace();
            int incidentalWhitespace = Math.min(outdent, firstNonWhitespace);
            return firstNonWhitespace > lastNonWhitespace ? "" : line.substring(incidentalWhitespace, lastNonWhitespace);
        }).collect(Collectors.joining("\n", "", optOut ? "\n" : ""));
    }

    private static int outdent(List<String> lines) {
        int outdent = Integer.MAX_VALUE;
        for (String line : lines) {
            int leadingWhitespace = line.indexOfNonWhitespace();
            if (leadingWhitespace == line.length()) continue;
            outdent = Integer.min(outdent, leadingWhitespace);
        }
        String lastLine = lines.get(lines.size() - 1);
        if (lastLine.isBlank()) {
            outdent = Integer.min(outdent, lastLine.length());
        }
        return outdent;
    }

    public String translateEscapes() {
        if (this.isEmpty()) {
            return "";
        }
        char[] chars = this.toCharArray();
        int length = chars.length;
        int from = 0;
        int to = 0;
        block12: while (from < length) {
            char ch;
            if ((ch = chars[from++]) == '\\') {
                ch = from < length ? chars[from++] : (char)'\u0000';
                switch (ch) {
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 's': {
                        ch = ' ';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int limit = Integer.min(from + (ch <= '3' ? 2 : 1), length);
                        int code = ch - 48;
                        while (from < limit && (ch = chars[from]) >= '0' && '7' >= ch) {
                            ++from;
                            code = code << 3 | ch - 48;
                        }
                        ch = (char)code;
                        break;
                    }
                    case '\n': {
                        continue block12;
                    }
                    case '\r': {
                        if (from >= length || chars[from] != '\n') continue block12;
                        ++from;
                        continue block12;
                    }
                    default: {
                        String msg = String.format("Invalid escape sequence: \\%c \\\\u%04X", Character.valueOf(ch), (int)ch);
                        throw new IllegalArgumentException(msg);
                    }
                }
            }
            chars[to++] = ch;
        }
        return new String(chars, 0, to);
    }

    public <R> R transform(Function<? super String, ? extends R> f) {
        return f.apply(this);
    }

    @Override
    public String toString() {
        return this;
    }

    @Override
    public IntStream chars() {
        return StreamSupport.intStream(this.isLatin1() ? new StringLatin1.CharsSpliterator(this.value, 1024) : new StringUTF16.CharsSpliterator(this.value, 1024), false);
    }

    @Override
    public IntStream codePoints() {
        return StreamSupport.intStream(this.isLatin1() ? new StringLatin1.CharsSpliterator(this.value, 1024) : new StringUTF16.CodePointsSpliterator(this.value, 1024), false);
    }

    public char[] toCharArray() {
        return this.isLatin1() ? StringLatin1.toChars(this.value) : StringUTF16.toChars(this.value);
    }

    public static String format(String format, Object ... args) {
        return new Formatter().format(format, args).toString();
    }

    public static String format(Locale l, String format, Object ... args) {
        return new Formatter(l).format(format, args).toString();
    }

    public String formatted(Object ... args) {
        return new Formatter().format(this, args).toString();
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        if (COMPACT_STRINGS && StringLatin1.canEncode(c)) {
            return new String(StringLatin1.toBytes(c), 0);
        }
        return new String(StringUTF16.toBytes(c), 1);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    public String repeat(int count) {
        int copied;
        if (count < 0) {
            throw new IllegalArgumentException("count is negative: " + count);
        }
        if (count == 1) {
            return this;
        }
        int len = this.value.length;
        if (len == 0 || count == 0) {
            return "";
        }
        if (Integer.MAX_VALUE / count < len) {
            throw new OutOfMemoryError("Required length exceeds implementation limit");
        }
        if (len == 1) {
            byte[] single = new byte[count];
            Arrays.fill(single, this.value[0]);
            return new String(single, this.coder);
        }
        int limit = len * count;
        byte[] multiple = new byte[limit];
        System.arraycopy(this.value, 0, multiple, 0, len);
        for (copied = len; copied < limit - copied; copied <<= 1) {
            System.arraycopy(multiple, 0, multiple, copied, copied);
        }
        System.arraycopy(multiple, 0, multiple, copied, limit - copied);
        return new String(multiple, this.coder);
    }

    void getBytes(byte[] dst, int dstBegin, byte coder) {
        if (this.coder() == coder) {
            System.arraycopy(this.value, 0, dst, dstBegin << coder, this.value.length);
        } else {
            StringLatin1.inflate(this.value, 0, dst, dstBegin, this.value.length);
        }
    }

    void getBytes(byte[] dst, int srcPos, int dstBegin, byte coder, int length) {
        if (this.coder() == coder) {
            System.arraycopy(this.value, srcPos << coder, dst, dstBegin << coder, length << coder);
        } else {
            StringLatin1.inflate(this.value, srcPos, dst, dstBegin, length);
        }
    }

    String(char[] value, int off, int len, Void sig) {
        byte[] val;
        if (len == 0) {
            this.value = "".value;
            this.coder = "".coder;
            return;
        }
        if (COMPACT_STRINGS && (val = StringUTF16.compress(value, off, len)) != null) {
            this.value = val;
            this.coder = 0;
            return;
        }
        this.coder = 1;
        this.value = StringUTF16.toBytes(value, off, len);
    }

    String(AbstractStringBuilder asb, Void sig) {
        byte[] val = asb.getValue();
        int length = asb.length();
        if (asb.isLatin1()) {
            this.coder = 0;
            this.value = Arrays.copyOfRange(val, 0, length);
        } else {
            byte[] buf;
            if (COMPACT_STRINGS && (buf = StringUTF16.compress(val, 0, length)) != null) {
                this.coder = 0;
                this.value = buf;
                return;
            }
            this.coder = 1;
            this.value = Arrays.copyOfRange(val, 0, length << 1);
        }
    }

    String(byte[] value, byte coder) {
        this.value = value;
        this.coder = coder;
    }

    byte coder() {
        return COMPACT_STRINGS ? this.coder : (byte)1;
    }

    byte[] value() {
        return this.value;
    }

    boolean isLatin1() {
        return COMPACT_STRINGS && this.coder == 0;
    }

    static void checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new StringIndexOutOfBoundsException("index " + index + ", length " + length);
        }
    }

    static void checkOffset(int offset, int length) {
        if (offset < 0 || offset > length) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", length " + length);
        }
    }

    static void checkBoundsOffCount(int offset, int count, int length) {
        if (offset < 0 || count < 0 || offset > length - count) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", count " + count + ", length " + length);
        }
    }

    static void checkBoundsBeginEnd(int begin, int end, int length) {
        if (begin < 0 || begin > end || end > length) {
            throw new StringIndexOutOfBoundsException("begin " + begin + ", end " + end + ", length " + length);
        }
    }

    static String valueOfCodePoint(int codePoint) {
        if (COMPACT_STRINGS && StringLatin1.canEncode(codePoint)) {
            return new String(StringLatin1.toBytes((char)codePoint), 0);
        }
        if (Character.isBmpCodePoint(codePoint)) {
            return new String(StringUTF16.toBytes((char)codePoint), 1);
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return new String(StringUTF16.toBytesSupplementary(codePoint), 1);
        }
        throw new IllegalArgumentException(String.format("Not a valid Unicode code point: 0x%X", codePoint));
    }

    public Optional<String> describeConstable() {
        return Optional.of(this);
    }

    @Override
    public String resolveConstantDesc(MethodHandles.Lookup lookup) {
        return this;
    }

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            byte[] v1 = s1.value;
            byte[] v2 = s2.value;
            byte coder = s1.coder();
            if (coder == s2.coder()) {
                return coder == 0 ? StringLatin1.compareToCI(v1, v2) : StringUTF16.compareToCI(v1, v2);
            }
            return coder == 0 ? StringLatin1.compareToCI_UTF16(v1, v2) : StringUTF16.compareToCI_Latin1(v1, v2);
        }

        private Object readResolve() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }
}

