/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.internal.misc.Unsafe;
import jdk.internal.vm.annotation.ForceInline;

final class StringConcatHelper {
    private static final long LATIN1 = 0L;
    private static final long UTF16 = 0x100000000L;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();

    private StringConcatHelper() {
    }

    private static long checkOverflow(long lengthCoder) {
        if ((int)lengthCoder >= 0) {
            return lengthCoder;
        }
        throw new OutOfMemoryError("Overflow: String length out of range");
    }

    static long mix(long lengthCoder, boolean value) {
        return StringConcatHelper.checkOverflow(lengthCoder + (long)(value ? 4 : 5));
    }

    static long mix(long lengthCoder, byte value) {
        return StringConcatHelper.mix(lengthCoder, (int)value);
    }

    static long mix(long lengthCoder, char value) {
        return StringConcatHelper.checkOverflow(lengthCoder + 1L) | (StringLatin1.canEncode(value) ? 0L : 0x100000000L);
    }

    static long mix(long lengthCoder, short value) {
        return StringConcatHelper.mix(lengthCoder, (int)value);
    }

    static long mix(long lengthCoder, int value) {
        return StringConcatHelper.checkOverflow(lengthCoder + (long)Integer.stringSize(value));
    }

    static long mix(long lengthCoder, long value) {
        return StringConcatHelper.checkOverflow(lengthCoder + (long)Long.stringSize(value));
    }

    static long mix(long lengthCoder, String value) {
        lengthCoder += (long)value.length();
        if (value.coder() == 1) {
            lengthCoder |= 0x100000000L;
        }
        return StringConcatHelper.checkOverflow(lengthCoder);
    }

    private static long prepend(long indexCoder, byte[] buf, boolean value) {
        int index = (int)indexCoder;
        if (indexCoder < 0x100000000L) {
            if (value) {
                buf[--index] = 101;
                buf[--index] = 117;
                buf[--index] = 114;
                buf[--index] = 116;
            } else {
                buf[--index] = 101;
                buf[--index] = 115;
                buf[--index] = 108;
                buf[--index] = 97;
                buf[--index] = 102;
            }
            return index;
        }
        if (value) {
            StringUTF16.putChar(buf, --index, 101);
            StringUTF16.putChar(buf, --index, 117);
            StringUTF16.putChar(buf, --index, 114);
            StringUTF16.putChar(buf, --index, 116);
        } else {
            StringUTF16.putChar(buf, --index, 101);
            StringUTF16.putChar(buf, --index, 115);
            StringUTF16.putChar(buf, --index, 108);
            StringUTF16.putChar(buf, --index, 97);
            StringUTF16.putChar(buf, --index, 102);
        }
        return (long)index | 0x100000000L;
    }

    static long prepend(long indexCoder, byte[] buf, boolean value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    static long prepend(long indexCoder, byte[] buf, byte value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    private static long prepend(long indexCoder, byte[] buf, char value) {
        if (indexCoder < 0x100000000L) {
            buf[(int)(--indexCoder)] = (byte)(value & 0xFF);
        } else {
            StringUTF16.putChar(buf, (int)(--indexCoder), value);
        }
        return indexCoder;
    }

    static long prepend(long indexCoder, byte[] buf, char value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    static long prepend(long indexCoder, byte[] buf, short value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    private static long prepend(long indexCoder, byte[] buf, int value) {
        if (indexCoder < 0x100000000L) {
            return Integer.getChars(value, (int)indexCoder, buf);
        }
        return (long)StringUTF16.getChars(value, (int)indexCoder, buf) | 0x100000000L;
    }

    static long prepend(long indexCoder, byte[] buf, int value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    private static long prepend(long indexCoder, byte[] buf, long value) {
        if (indexCoder < 0x100000000L) {
            return Long.getChars(value, (int)indexCoder, buf);
        }
        return (long)StringUTF16.getChars(value, (int)indexCoder, buf) | 0x100000000L;
    }

    static long prepend(long indexCoder, byte[] buf, long value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    private static long prepend(long indexCoder, byte[] buf, String value) {
        if ((indexCoder -= (long)value.length()) < 0x100000000L) {
            value.getBytes(buf, (int)indexCoder, (byte)0);
        } else {
            value.getBytes(buf, (int)indexCoder, (byte)1);
        }
        return indexCoder;
    }

    static long prepend(long indexCoder, byte[] buf, String value, String prefix) {
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, value);
        if (prefix != null) {
            indexCoder = StringConcatHelper.prepend(indexCoder, buf, prefix);
        }
        return indexCoder;
    }

    static String newString(byte[] buf, long indexCoder) {
        if (indexCoder == 0L) {
            return new String(buf, 0);
        }
        if (indexCoder == 0x100000000L) {
            return new String(buf, 1);
        }
        throw new InternalError("Storage is not completely initialized, " + (int)indexCoder + " bytes left");
    }

    @ForceInline
    static String simpleConcat(Object first, Object second) {
        String s1 = StringConcatHelper.stringOf(first);
        String s2 = StringConcatHelper.stringOf(second);
        if (s1.isEmpty()) {
            return new String(s2);
        }
        if (s2.isEmpty()) {
            return new String(s1);
        }
        long indexCoder = StringConcatHelper.mix(StringConcatHelper.initialCoder(), s1);
        indexCoder = StringConcatHelper.mix(indexCoder, s2);
        byte[] buf = StringConcatHelper.newArray(indexCoder);
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, s2);
        indexCoder = StringConcatHelper.prepend(indexCoder, buf, s1);
        return StringConcatHelper.newString(buf, indexCoder);
    }

    @ForceInline
    static String newStringOf(Object arg) {
        return new String(StringConcatHelper.stringOf(arg));
    }

    /*
     * WARNING - void declaration
     */
    static String stringOf(Object value) {
        void var1_1;
        String s;
        return value == null || (s = value.toString()) == null ? "null" : var1_1;
    }

    @ForceInline
    static byte[] newArrayWithSuffix(String suffix, long indexCoder) {
        byte[] buf = StringConcatHelper.newArray(indexCoder + (long)suffix.length());
        if (indexCoder < 0x100000000L) {
            suffix.getBytes(buf, (int)indexCoder, (byte)0);
        } else {
            suffix.getBytes(buf, (int)indexCoder, (byte)1);
        }
        return buf;
    }

    @ForceInline
    static byte[] newArray(long indexCoder) {
        byte coder = (byte)(indexCoder >> 32);
        int index = (int)indexCoder;
        return (byte[])UNSAFE.allocateUninitializedArray(Byte.TYPE, index << coder);
    }

    static long initialCoder() {
        return String.COMPACT_STRINGS ? 0L : 0x100000000L;
    }

    static MethodHandle lookupStatic(String name, MethodType methodType) {
        try {
            return MethodHandles.lookup().findStatic(StringConcatHelper.class, name, methodType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

