/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.util.ArraysSupport;
import jdk.internal.vm.annotation.IntrinsicCandidate;

final class StringLatin1 {
    StringLatin1() {
    }

    public static char charAt(byte[] value, int index) {
        if (index < 0 || index >= value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return (char)(value[index] & 0xFF);
    }

    public static boolean canEncode(int cp) {
        return cp >>> 8 == 0;
    }

    public static int length(byte[] value) {
        return value.length;
    }

    public static int codePointAt(byte[] value, int index, int end) {
        return value[index] & 0xFF;
    }

    public static int codePointBefore(byte[] value, int index) {
        return value[index - 1] & 0xFF;
    }

    public static int codePointCount(byte[] value, int beginIndex, int endIndex) {
        return endIndex - beginIndex;
    }

    public static char[] toChars(byte[] value) {
        char[] dst = new char[value.length];
        StringLatin1.inflate(value, 0, dst, 0, value.length);
        return dst;
    }

    public static byte[] inflate(byte[] value, int off, int len) {
        byte[] ret = StringUTF16.newBytesFor(len);
        StringLatin1.inflate(value, off, ret, 0, len);
        return ret;
    }

    public static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        StringLatin1.inflate(value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public static void getBytes(byte[] value, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        System.arraycopy(value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @IntrinsicCandidate
    public static boolean equals(byte[] value, byte[] other) {
        if (value.length == other.length) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == other[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @IntrinsicCandidate
    public static int compareTo(byte[] value, byte[] other) {
        int len1 = value.length;
        int len2 = other.length;
        return StringLatin1.compareTo(value, other, len1, len2);
    }

    public static int compareTo(byte[] value, byte[] other, int len1, int len2) {
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            if (value[k] == other[k]) continue;
            return StringLatin1.getChar(value, k) - StringLatin1.getChar(other, k);
        }
        return len1 - len2;
    }

    @IntrinsicCandidate
    public static int compareToUTF16(byte[] value, byte[] other) {
        int len1 = StringLatin1.length(value);
        int len2 = StringUTF16.length(other);
        return StringLatin1.compareToUTF16Values(value, other, len1, len2);
    }

    public static int compareToUTF16(byte[] value, byte[] other, int len1, int len2) {
        String.checkOffset(len1, StringLatin1.length(value));
        String.checkOffset(len2, StringUTF16.length(other));
        return StringLatin1.compareToUTF16Values(value, other, len1, len2);
    }

    private static int compareToUTF16Values(byte[] value, byte[] other, int len1, int len2) {
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringLatin1.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compareToCI(byte[] value, byte[] other) {
        int len1 = value.length;
        int len2 = other.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1;
            if (value[k] == other[k] || (c1 = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(value, k))) == (c2 = (char)CharacterDataLatin1.instance.toUpperCase(StringLatin1.getChar(other, k))) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int compareToCI_UTF16(byte[] value, byte[] other) {
        int len1 = StringLatin1.length(value);
        int len2 = StringUTF16.length(other);
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringLatin1.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k)) || (c1 = (char)CharacterDataLatin1.instance.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int hashCode(byte[] value) {
        int h = 0;
        for (byte v : value) {
            h = 31 * h + (v & 0xFF);
        }
        return h;
    }

    public static int indexOf(byte[] value, int ch, int fromIndex) {
        if (!StringLatin1.canEncode(ch)) {
            return -1;
        }
        int max = value.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        return StringLatin1.indexOfChar(value, ch, fromIndex, max);
    }

    @IntrinsicCandidate
    private static int indexOfChar(byte[] value, int ch, int fromIndex, int max) {
        byte c = (byte)ch;
        for (int i = fromIndex; i < max; ++i) {
            if (value[i] != c) continue;
            return i;
        }
        return -1;
    }

    @IntrinsicCandidate
    public static int indexOf(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length == 0) {
            return -1;
        }
        return StringLatin1.indexOf(value, value.length, str, str.length, 0);
    }

    @IntrinsicCandidate
    public static int indexOf(byte[] value, int valueCount, byte[] str, int strCount, int fromIndex) {
        byte first = str[0];
        int max = valueCount - strCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (value[i] != first) {
                while (++i <= max && value[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + strCount - 1;
            int k = 1;
            while (j < end && value[j] == str[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        int start;
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        char strLastChar = (char)(tgt[strLastIndex] & 0xFF);
        block0: while (true) {
            if (i >= min && (src[i] & 0xFF) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if ((src[j--] & 0xFF) == (tgt[k--] & 0xFF)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(byte[] value, int ch, int fromIndex) {
        if (!StringLatin1.canEncode(ch)) {
            return -1;
        }
        for (int off = Math.min(fromIndex, value.length - 1); off >= 0; --off) {
            if (value[off] != (byte)ch) continue;
            return off;
        }
        return -1;
    }

    public static String replace(byte[] value, char oldChar, char newChar) {
        if (StringLatin1.canEncode(oldChar)) {
            int len = value.length;
            int i = -1;
            while (++i < len && value[i] != (byte)oldChar) {
            }
            if (i < len) {
                if (StringLatin1.canEncode(newChar)) {
                    byte[] buf = StringConcatHelper.newArray(len);
                    for (int j = 0; j < i; ++j) {
                        buf[j] = value[j];
                    }
                    while (i < len) {
                        byte c = value[i];
                        buf[i] = c == (byte)oldChar ? (byte)newChar : c;
                        ++i;
                    }
                    return new String(buf, 0);
                }
                byte[] buf = StringUTF16.newBytesFor(len);
                StringLatin1.inflate(value, 0, buf, 0, i);
                while (i < len) {
                    char c = (char)(value[i] & 0xFF);
                    StringUTF16.putChar(buf, i, c == oldChar ? newChar : c);
                    ++i;
                }
                return new String(buf, 1);
            }
        }
        return null;
    }

    public static String replace(byte[] value, int valLen, byte[] targ, int targLen, byte[] repl, int replLen) {
        int resultLen;
        int j;
        int i;
        assert (targLen > 0);
        int p = 0;
        if (valLen == 0 || (i = StringLatin1.indexOf(value, valLen, targ, targLen, 0)) < 0) {
            return null;
        }
        int[] pos = new int[16];
        pos[0] = i;
        i += targLen;
        while ((j = StringLatin1.indexOf(value, valLen, targ, targLen, i)) > 0) {
            if (++p == pos.length) {
                pos = Arrays.copyOf(pos, ArraysSupport.newLength(p, 1, p >> 1));
            }
            pos[p] = j;
            i = j + targLen;
        }
        try {
            resultLen = Math.addExact(valLen, Math.multiplyExact(++p, replLen - targLen));
        }
        catch (ArithmeticException ignored) {
            throw new OutOfMemoryError("Required length exceeds implementation limit");
        }
        if (resultLen == 0) {
            return "";
        }
        byte[] result = StringConcatHelper.newArray(resultLen);
        int posFrom = 0;
        int posTo = 0;
        for (int q = 0; q < p; ++q) {
            int nextPos = pos[q];
            while (posFrom < nextPos) {
                result[posTo++] = value[posFrom++];
            }
            posFrom += targLen;
            for (int k = 0; k < replLen; ++k) {
                result[posTo++] = repl[k];
            }
        }
        while (posFrom < valLen) {
            result[posTo++] = value[posFrom++];
        }
        return new String(result, 0);
    }

    public static boolean regionMatchesCI(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        int last = toffset + len;
        while (toffset < last) {
            int u2;
            int u1;
            char c2;
            char c1;
            if ((c1 = (char)(value[toffset++] & 0xFF)) == (c2 = (char)(other[ooffset++] & 0xFF)) || (u1 = CharacterDataLatin1.instance.toUpperCase(c1)) == (u2 = CharacterDataLatin1.instance.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatchesCI_UTF16(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        int last = toffset + len;
        while (toffset < last) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = (char)(value[toffset++] & 0xFF)) == (c2 = StringUTF16.getChar(other, ooffset++)) || (u1 = (char)CharacterDataLatin1.instance.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCase(String str, byte[] value, Locale locale) {
        int cp;
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        int len = value.length;
        for (first = 0; first < len && (cp = value[first] & 0xFF) == CharacterDataLatin1.instance.toLowerCase(cp); ++first) {
        }
        if (first == len) {
            return str;
        }
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringLatin1.toLowerCaseEx(str, value, first, locale, true);
        }
        byte[] result = new byte[len];
        System.arraycopy(value, 0, result, 0, first);
        for (int i = first; i < len; ++i) {
            int cp2 = value[i] & 0xFF;
            if (!StringLatin1.canEncode(cp2 = CharacterDataLatin1.instance.toLowerCase(cp2))) {
                return StringLatin1.toLowerCaseEx(str, value, first, locale, false);
            }
            result[i] = (byte)cp2;
        }
        return new String(result, 0);
    }

    private static String toLowerCaseEx(String str, byte[] value, int first, Locale locale, boolean localeDependent) {
        int i;
        byte[] result = StringUTF16.newBytesFor(value.length);
        int resultOffset = 0;
        for (i = 0; i < first; ++i) {
            StringUTF16.putChar(result, resultOffset++, value[i] & 0xFF);
        }
        for (i = first; i < value.length; ++i) {
            int srcChar = value[i] & 0xFF;
            int lowerChar = localeDependent ? ConditionalSpecialCasing.toLowerCaseEx(str, i, locale) : CharacterDataLatin1.instance.toLowerCase(srcChar);
            if (Character.isBmpCodePoint(lowerChar)) {
                StringUTF16.putChar(result, resultOffset++, lowerChar);
                continue;
            }
            char[] lowerCharArray = lowerChar == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(str, i, locale) : Character.toChars(lowerChar);
            int mapLen = lowerCharArray.length;
            if (mapLen > 1) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - 1);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, lowerCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String toUpperCase(String str, byte[] value, Locale locale) {
        int cp;
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        int len = value.length;
        for (first = 0; first < len && (cp = value[first] & 0xFF) == CharacterDataLatin1.instance.toUpperCaseEx(cp); ++first) {
        }
        if (first == len) {
            return str;
        }
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringLatin1.toUpperCaseEx(str, value, first, locale, true);
        }
        byte[] result = new byte[len];
        System.arraycopy(value, 0, result, 0, first);
        for (int i = first; i < len; ++i) {
            int cp2 = value[i] & 0xFF;
            if (!StringLatin1.canEncode(cp2 = CharacterDataLatin1.instance.toUpperCaseEx(cp2))) {
                return StringLatin1.toUpperCaseEx(str, value, first, locale, false);
            }
            result[i] = (byte)cp2;
        }
        return new String(result, 0);
    }

    private static String toUpperCaseEx(String str, byte[] value, int first, Locale locale, boolean localeDependent) {
        int i;
        byte[] result = StringUTF16.newBytesFor(value.length);
        int resultOffset = 0;
        for (i = 0; i < first; ++i) {
            StringUTF16.putChar(result, resultOffset++, value[i] & 0xFF);
        }
        for (i = first; i < value.length; ++i) {
            int srcChar = value[i] & 0xFF;
            int upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(str, i, locale) : CharacterDataLatin1.instance.toUpperCaseEx(srcChar);
            if (Character.isBmpCodePoint(upperChar)) {
                StringUTF16.putChar(result, resultOffset++, upperChar);
                continue;
            }
            char[] upperCharArray = upperChar == -1 ? (localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(str, i, locale) : CharacterDataLatin1.instance.toUpperCaseCharArray(srcChar)) : Character.toChars(upperChar);
            int mapLen = upperCharArray.length;
            if (mapLen > 1) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - 1);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, upperCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String trim(byte[] value) {
        int st;
        int len = value.length;
        for (st = 0; st < len && (value[st] & 0xFF) <= 32; ++st) {
        }
        while (st < len && (value[len - 1] & 0xFF) <= 32) {
            --len;
        }
        return st > 0 || len < value.length ? StringLatin1.newString(value, st, len - st) : null;
    }

    public static int indexOfNonWhitespace(byte[] value) {
        char ch;
        int left;
        int length = value.length;
        for (left = 0; left < length && ((ch = StringLatin1.getChar(value, left)) == ' ' || ch == '\t' || CharacterDataLatin1.instance.isWhitespace(ch)); ++left) {
        }
        return left;
    }

    public static int lastIndexOfNonWhitespace(byte[] value) {
        int length;
        char ch;
        int right;
        for (right = length = value.length; 0 < right && ((ch = StringLatin1.getChar(value, right - 1)) == ' ' || ch == '\t' || CharacterDataLatin1.instance.isWhitespace(ch)); --right) {
        }
        return right;
    }

    public static String strip(byte[] value) {
        int left = StringLatin1.indexOfNonWhitespace(value);
        if (left == value.length) {
            return "";
        }
        int right = StringLatin1.lastIndexOfNonWhitespace(value);
        boolean ifChanged = left > 0 || right < value.length;
        return ifChanged ? StringLatin1.newString(value, left, right - left) : null;
    }

    public static String stripLeading(byte[] value) {
        int left = StringLatin1.indexOfNonWhitespace(value);
        return left != 0 ? StringLatin1.newString(value, left, value.length - left) : null;
    }

    public static String stripTrailing(byte[] value) {
        int right = StringLatin1.lastIndexOfNonWhitespace(value);
        return right != value.length ? StringLatin1.newString(value, 0, right) : null;
    }

    static Stream<String> lines(byte[] value) {
        return StreamSupport.stream(LinesSpliterator.spliterator(value), false);
    }

    public static void putChar(byte[] val, int index, int c) {
        val[index] = (byte)c;
    }

    public static char getChar(byte[] val, int index) {
        return (char)(val[index] & 0xFF);
    }

    public static byte[] toBytes(int[] val, int off, int len) {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            int cp;
            if (!StringLatin1.canEncode(cp = val[off++])) {
                return null;
            }
            ret[i] = (byte)cp;
        }
        return ret;
    }

    public static byte[] toBytes(char c) {
        return new byte[]{(byte)c};
    }

    public static String newString(byte[] val, int index, int len) {
        if (len == 0) {
            return "";
        }
        return new String(Arrays.copyOfRange(val, index, index + len), 0);
    }

    public static void fillNull(byte[] val, int index, int end) {
        Arrays.fill(val, index, end, (byte)0);
    }

    @IntrinsicCandidate
    public static void inflate(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            dst[dstOff++] = (char)(src[srcOff++] & 0xFF);
        }
    }

    @IntrinsicCandidate
    public static void inflate(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        StringUTF16.inflate(src, srcOff, dst, dstOff, len);
    }

    private static final class LinesSpliterator
    implements Spliterator<String> {
        private byte[] value;
        private int index;
        private final int fence;

        private LinesSpliterator(byte[] value, int start, int length) {
            this.value = value;
            this.index = start;
            this.fence = start + length;
        }

        private int indexOfLineSeparator(int start) {
            for (int current = start; current < this.fence; ++current) {
                char ch = StringLatin1.getChar(this.value, current);
                if (ch != '\n' && ch != '\r') continue;
                return current;
            }
            return this.fence;
        }

        private int skipLineSeparator(int start) {
            if (start < this.fence) {
                int next;
                if (StringLatin1.getChar(this.value, start) == '\r' && (next = start + 1) < this.fence && StringLatin1.getChar(this.value, next) == '\n') {
                    return next + 1;
                }
                return start + 1;
            }
            return this.fence;
        }

        private String next() {
            int start = this.index;
            int end = this.indexOfLineSeparator(start);
            this.index = this.skipLineSeparator(end);
            return StringLatin1.newString(this.value, start, end - start);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException("tryAdvance action missing");
            }
            if (this.index != this.fence) {
                action.accept(this.next());
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException("forEachRemaining action missing");
            }
            while (this.index != this.fence) {
                action.accept(this.next());
            }
        }

        @Override
        public Spliterator<String> trySplit() {
            int half = this.fence + this.index >>> 1;
            int mid = this.skipLineSeparator(this.indexOfLineSeparator(half));
            if (mid < this.fence) {
                int start = this.index;
                this.index = mid;
                return new LinesSpliterator(this.value, start, mid - start);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index + 1;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        static LinesSpliterator spliterator(byte[] value) {
            return new LinesSpliterator(value, 0, value.length);
        }
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length, acs);
        }

        CharsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                charsSpliterator = null;
            } else {
                this.index = mid;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, lo, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i] & 0xFF);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++] & 0xFF);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

