/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Arrays;
import java.util.Locale;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.util.ArraysSupport;
import jdk.internal.vm.annotation.IntrinsicCandidate;

final class StringUTF16 {
    static final int HI_BYTE_SHIFT;
    static final int LO_BYTE_SHIFT;
    static final int MAX_LENGTH = 0x3FFFFFFF;
    static final /* synthetic */ boolean $assertionsDisabled;

    StringUTF16() {
    }

    public static byte[] newBytesFor(int len) {
        if (len < 0) {
            throw new NegativeArraySizeException();
        }
        if (len > 0x3FFFFFFF) {
            throw new OutOfMemoryError("UTF16 String size is " + len + ", should be less than " + 0x3FFFFFFF);
        }
        return new byte[len << 1];
    }

    @IntrinsicCandidate
    static void putChar(byte[] val, int index, int c) {
        if (!($assertionsDisabled || index >= 0 && index < StringUTF16.length(val))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        index <<= 1;
        val[index++] = (byte)(c >> HI_BYTE_SHIFT);
        val[index] = (byte)(c >> LO_BYTE_SHIFT);
    }

    @IntrinsicCandidate
    static char getChar(byte[] val, int index) {
        if (!($assertionsDisabled || index >= 0 && index < StringUTF16.length(val))) {
            throw new AssertionError((Object)"Trusted caller missed bounds check");
        }
        index <<= 1;
        return (char)((val[index++] & 0xFF) << HI_BYTE_SHIFT | (val[index] & 0xFF) << LO_BYTE_SHIFT);
    }

    public static int length(byte[] value) {
        return value.length >> 1;
    }

    private static int codePointAt(byte[] value, int index, int end, boolean checked) {
        char c1;
        if (!$assertionsDisabled && index >= end) {
            throw new AssertionError();
        }
        if (checked) {
            StringUTF16.checkIndex(index, value);
        }
        if (Character.isHighSurrogate(c1 = StringUTF16.getChar(value, index)) && ++index < end) {
            char c2;
            if (checked) {
                StringUTF16.checkIndex(index, value);
            }
            if (Character.isLowSurrogate(c2 = StringUTF16.getChar(value, index))) {
                return Character.toCodePoint(c1, c2);
            }
        }
        return c1;
    }

    public static int codePointAt(byte[] value, int index, int end) {
        return StringUTF16.codePointAt(value, index, end, false);
    }

    private static int codePointBefore(byte[] value, int index, boolean checked) {
        char c2;
        --index;
        if (checked) {
            StringUTF16.checkIndex(index, value);
        }
        if (Character.isLowSurrogate(c2 = StringUTF16.getChar(value, index)) && index > 0) {
            char c1;
            --index;
            if (checked) {
                StringUTF16.checkIndex(index, value);
            }
            if (Character.isHighSurrogate(c1 = StringUTF16.getChar(value, index))) {
                return Character.toCodePoint(c1, c2);
            }
        }
        return c2;
    }

    public static int codePointBefore(byte[] value, int index) {
        return StringUTF16.codePointBefore(value, index, false);
    }

    private static int codePointCount(byte[] value, int beginIndex, int endIndex, boolean checked) {
        if (!$assertionsDisabled && beginIndex > endIndex) {
            throw new AssertionError();
        }
        int count = endIndex - beginIndex;
        int i = beginIndex;
        if (checked && i < endIndex) {
            StringUTF16.checkBoundsBeginEnd(i, endIndex, value);
        }
        while (i < endIndex - 1) {
            if (!Character.isHighSurrogate(StringUTF16.getChar(value, i++)) || !Character.isLowSurrogate(StringUTF16.getChar(value, i))) continue;
            --count;
            ++i;
        }
        return count;
    }

    public static int codePointCount(byte[] value, int beginIndex, int endIndex) {
        return StringUTF16.codePointCount(value, beginIndex, endIndex, false);
    }

    public static char[] toChars(byte[] value) {
        char[] dst = new char[value.length >> 1];
        StringUTF16.getChars(value, 0, dst.length, dst, 0);
        return dst;
    }

    @IntrinsicCandidate
    public static byte[] toBytes(char[] value, int off, int len) {
        byte[] val = StringUTF16.newBytesFor(len);
        for (int i = 0; i < len; ++i) {
            StringUTF16.putChar(val, i, value[off]);
            ++off;
        }
        return val;
    }

    public static byte[] compress(char[] val, int off, int len) {
        byte[] ret = new byte[len];
        if (StringUTF16.compress(val, off, ret, 0, len) == len) {
            return ret;
        }
        return null;
    }

    public static byte[] compress(byte[] val, int off, int len) {
        byte[] ret = new byte[len];
        if (StringUTF16.compress(val, off, ret, 0, len) == len) {
            return ret;
        }
        return null;
    }

    @IntrinsicCandidate
    public static int compress(char[] src, int srcOff, byte[] dst, int dstOff, int len) {
        for (int i = 0; i < len; ++i) {
            char c = src[srcOff];
            if (c > '\u00ff') {
                len = 0;
                break;
            }
            dst[dstOff] = (byte)c;
            ++srcOff;
            ++dstOff;
        }
        return len;
    }

    @IntrinsicCandidate
    public static int compress(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        StringUTF16.checkBoundsOffCount(srcOff, len, src);
        for (int i = 0; i < len; ++i) {
            char c = StringUTF16.getChar(src, srcOff);
            if (c > '\u00ff') {
                len = 0;
                break;
            }
            dst[dstOff] = (byte)c;
            ++srcOff;
            ++dstOff;
        }
        return len;
    }

    public static byte[] toBytes(int[] val, int index, int len) {
        int end = index + len;
        int n = len;
        for (int i = index; i < end; ++i) {
            int cp = val[i];
            if (Character.isBmpCodePoint(cp)) continue;
            if (Character.isValidCodePoint(cp)) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(cp));
        }
        byte[] buf = StringUTF16.newBytesFor(n);
        int i = index;
        int j = 0;
        while (i < end) {
            int cp = val[i];
            if (Character.isBmpCodePoint(cp)) {
                StringUTF16.putChar(buf, j, cp);
            } else {
                StringUTF16.putChar(buf, j++, Character.highSurrogate(cp));
                StringUTF16.putChar(buf, j, Character.lowSurrogate(cp));
            }
            ++i;
            ++j;
        }
        return buf;
    }

    public static byte[] toBytes(char c) {
        byte[] result = new byte[2];
        StringUTF16.putChar(result, 0, c);
        return result;
    }

    static byte[] toBytesSupplementary(int cp) {
        byte[] result = new byte[4];
        StringUTF16.putChar(result, 0, Character.highSurrogate(cp));
        StringUTF16.putChar(result, 1, Character.lowSurrogate(cp));
        return result;
    }

    @IntrinsicCandidate
    public static void getChars(byte[] value, int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < srcEnd) {
            StringUTF16.checkBoundsOffCount(srcBegin, srcEnd - srcBegin, value);
        }
        for (int i = srcBegin; i < srcEnd; ++i) {
            dst[dstBegin++] = StringUTF16.getChar(value, i);
        }
    }

    public static void getBytes(byte[] value, int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        srcEnd <<= 1;
        for (int i = (srcBegin <<= 1) + (1 >> LO_BYTE_SHIFT); i < srcEnd; i += 2) {
            dst[dstBegin++] = value[i];
        }
    }

    @IntrinsicCandidate
    public static boolean equals(byte[] value, byte[] other) {
        if (value.length == other.length) {
            int len = value.length >> 1;
            for (int i = 0; i < len; ++i) {
                if (StringUTF16.getChar(value, i) == StringUTF16.getChar(other, i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @IntrinsicCandidate
    public static int compareTo(byte[] value, byte[] other) {
        int len1 = StringUTF16.length(value);
        int len2 = StringUTF16.length(other);
        return StringUTF16.compareValues(value, other, len1, len2);
    }

    public static int compareTo(byte[] value, byte[] other, int len1, int len2) {
        StringUTF16.checkOffset(len1, value);
        StringUTF16.checkOffset(len2, other);
        return StringUTF16.compareValues(value, other, len1, len2);
    }

    private static int compareValues(byte[] value, byte[] other, int len1, int len2) {
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            char c2;
            char c1 = StringUTF16.getChar(value, k);
            if (c1 == (c2 = StringUTF16.getChar(other, k))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @IntrinsicCandidate
    public static int compareToLatin1(byte[] value, byte[] other) {
        return -StringLatin1.compareToUTF16(other, value);
    }

    public static int compareToLatin1(byte[] value, byte[] other, int len1, int len2) {
        return -StringLatin1.compareToUTF16(other, value, len2, len1);
    }

    public static int compareToCI(byte[] value, byte[] other) {
        return StringUTF16.compareToCIImpl(value, 0, StringUTF16.length(value), other, 0, StringUTF16.length(other));
    }

    private static int compareToCIImpl(byte[] value, int toffset, int tlen, byte[] other, int ooffset, int olen) {
        int tlast = toffset + tlen;
        int olast = ooffset + olen;
        if (!($assertionsDisabled || toffset >= 0 && ooffset >= 0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tlast > StringUTF16.length(value)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && olast > StringUTF16.length(other)) {
            throw new AssertionError();
        }
        int k1 = toffset;
        for (int k2 = ooffset; k1 < tlast && k2 < olast; ++k1, ++k2) {
            int diff;
            int cp2;
            int cp1 = StringUTF16.getChar(value, k1);
            if (cp1 == (cp2 = StringUTF16.getChar(other, k2)) || StringUTF16.compareCodePointCI(cp1, cp2) == 0) continue;
            if ((cp1 = StringUTF16.codePointIncluding(value, cp1, k1, toffset, tlast)) < 0) {
                ++k1;
                cp1 = -cp1;
            }
            if ((cp2 = StringUTF16.codePointIncluding(other, cp2, k2, ooffset, olast)) < 0) {
                ++k2;
                cp2 = -cp2;
            }
            if ((diff = StringUTF16.compareCodePointCI(cp1, cp2)) == 0) continue;
            return diff;
        }
        return tlen - olen;
    }

    private static int compareCodePointCI(int cp1, int cp2) {
        if ((cp1 = Character.toUpperCase(cp1)) != (cp2 = Character.toUpperCase(cp2)) && (cp1 = Character.toLowerCase(cp1)) != (cp2 = Character.toLowerCase(cp2))) {
            return cp1 - cp2;
        }
        return 0;
    }

    private static int codePointIncluding(byte[] ba, int cp, int index, int start, int end) {
        char c;
        if (!Character.isSurrogate((char)cp)) {
            return cp;
        }
        if (Character.isLowSurrogate((char)cp)) {
            char c2;
            if (index > start && Character.isHighSurrogate(c2 = StringUTF16.getChar(ba, index - 1))) {
                return Character.toCodePoint(c2, (char)cp);
            }
        } else if (index + 1 < end && Character.isLowSurrogate(c = StringUTF16.getChar(ba, index + 1))) {
            return -Character.toCodePoint((char)cp, c);
        }
        return cp;
    }

    public static int compareToCI_Latin1(byte[] value, byte[] other) {
        return -StringLatin1.compareToCI_UTF16(other, value);
    }

    public static int hashCode(byte[] value) {
        int h = 0;
        int length = value.length >> 1;
        for (int i = 0; i < length; ++i) {
            h = 31 * h + StringUTF16.getChar(value, i);
        }
        return h;
    }

    public static int indexOf(byte[] value, int ch, int fromIndex) {
        int max = value.length >> 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        if (ch < 65536) {
            return StringUTF16.indexOfChar(value, ch, fromIndex, max);
        }
        return StringUTF16.indexOfSupplementary(value, ch, fromIndex, max);
    }

    @IntrinsicCandidate
    public static int indexOf(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length < str.length) {
            return -1;
        }
        return StringUTF16.indexOfUnsafe(value, StringUTF16.length(value), str, StringUTF16.length(str), 0);
    }

    @IntrinsicCandidate
    public static int indexOf(byte[] value, int valueCount, byte[] str, int strCount, int fromIndex) {
        StringUTF16.checkBoundsBeginEnd(fromIndex, valueCount, value);
        StringUTF16.checkBoundsBeginEnd(0, strCount, str);
        return StringUTF16.indexOfUnsafe(value, valueCount, str, strCount, fromIndex);
    }

    private static int indexOfUnsafe(byte[] value, int valueCount, byte[] str, int strCount, int fromIndex) {
        if (!$assertionsDisabled && fromIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && strCount <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && strCount > StringUTF16.length(str)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && valueCount < strCount) {
            throw new AssertionError();
        }
        char first = StringUTF16.getChar(str, 0);
        int max = valueCount - strCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (StringUTF16.getChar(value, i) != first) {
                while (++i <= max && StringUTF16.getChar(value, i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + strCount - 1;
            int k = 1;
            while (j < end && StringUTF16.getChar(value, j) == StringUTF16.getChar(str, k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @IntrinsicCandidate
    public static int indexOfLatin1(byte[] value, byte[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (StringUTF16.length(value) < str.length) {
            return -1;
        }
        return StringUTF16.indexOfLatin1Unsafe(value, StringUTF16.length(value), str, str.length, 0);
    }

    @IntrinsicCandidate
    public static int indexOfLatin1(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        StringUTF16.checkBoundsBeginEnd(fromIndex, srcCount, src);
        String.checkBoundsBeginEnd(0, tgtCount, tgt.length);
        return StringUTF16.indexOfLatin1Unsafe(src, srcCount, tgt, tgtCount, fromIndex);
    }

    public static int indexOfLatin1Unsafe(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        if (!$assertionsDisabled && fromIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount > tgt.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && srcCount < tgtCount) {
            throw new AssertionError();
        }
        char first = (char)(tgt[0] & 0xFF);
        int max = srcCount - tgtCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (StringUTF16.getChar(src, i) != first) {
                while (++i <= max && StringUTF16.getChar(src, i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + tgtCount - 1;
            int k = 1;
            while (j < end && StringUTF16.getChar(src, j) == (tgt[k] & 0xFF)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @IntrinsicCandidate
    private static int indexOfChar(byte[] value, int ch, int fromIndex, int max) {
        StringUTF16.checkBoundsBeginEnd(fromIndex, max, value);
        return StringUTF16.indexOfCharUnsafe(value, ch, fromIndex, max);
    }

    private static int indexOfCharUnsafe(byte[] value, int ch, int fromIndex, int max) {
        for (int i = fromIndex; i < max; ++i) {
            if (StringUTF16.getChar(value, i) != ch) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfSupplementary(byte[] value, int ch, int fromIndex, int max) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            StringUTF16.checkBoundsBeginEnd(fromIndex, max, value);
            for (int i = fromIndex; i < max - 1; ++i) {
                if (StringUTF16.getChar(value, i) != hi || StringUTF16.getChar(value, i + 1) != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        int start;
        if (!$assertionsDisabled && fromIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount > StringUTF16.length(tgt)) {
            throw new AssertionError();
        }
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        StringUTF16.checkIndex(strLastIndex, tgt);
        char strLastChar = StringUTF16.getChar(tgt, strLastIndex);
        StringUTF16.checkIndex(i, src);
        block0: while (true) {
            if (i >= min && StringUTF16.getChar(src, i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if (StringUTF16.getChar(src, j--) == StringUTF16.getChar(tgt, k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static int lastIndexOf(byte[] value, int ch, int fromIndex) {
        if (ch < 65536) {
            for (int i = Math.min(fromIndex, (value.length >> 1) - 1); i >= 0; --i) {
                if (StringUTF16.getChar(value, i) != ch) continue;
                return i;
            }
            return -1;
        }
        return StringUTF16.lastIndexOfSupplementary(value, ch, fromIndex);
    }

    private static int lastIndexOfSupplementary(byte[] value, int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = Math.min(fromIndex, (value.length >> 1) - 2); i >= 0; --i) {
                if (StringUTF16.getChar(value, i) != hi || StringUTF16.getChar(value, i + 1) != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public static String replace(byte[] value, char oldChar, char newChar) {
        int len = value.length >> 1;
        int i = -1;
        while (++i < len && StringUTF16.getChar(value, i) != oldChar) {
        }
        if (i < len) {
            byte[] val;
            byte[] buf = new byte[value.length];
            for (int j = 0; j < i; ++j) {
                StringUTF16.putChar(buf, j, StringUTF16.getChar(value, j));
            }
            while (i < len) {
                char c = StringUTF16.getChar(value, i);
                StringUTF16.putChar(buf, i, c == oldChar ? newChar : c);
                ++i;
            }
            if (String.COMPACT_STRINGS && !StringLatin1.canEncode(oldChar) && StringLatin1.canEncode(newChar) && (val = StringUTF16.compress(buf, 0, len)) != null) {
                return new String(val, 0);
            }
            return new String(buf, 1);
        }
        return null;
    }

    public static String replace(byte[] value, int valLen, boolean valLat1, byte[] targ, int targLen, boolean targLat1, byte[] repl, int replLen, boolean replLat1) {
        byte[] lat1Result;
        int resultLen;
        int j;
        int i;
        if (!$assertionsDisabled && targLen <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && valLat1 && targLat1 && replLat1) {
            throw new AssertionError();
        }
        if (String.COMPACT_STRINGS && valLat1 && !targLat1) {
            return null;
        }
        int n = String.COMPACT_STRINGS && valLat1 ? StringLatin1.indexOf(value, targ) : (i = String.COMPACT_STRINGS && targLat1 ? StringUTF16.indexOfLatin1(value, targ) : StringUTF16.indexOf(value, targ));
        if (i < 0) {
            return null;
        }
        int p = 0;
        int[] pos = new int[16];
        pos[0] = i;
        i += targLen;
        while ((String.COMPACT_STRINGS && valLat1 ? StringLatin1.indexOf(value, valLen, targ, targLen, i) : (j = String.COMPACT_STRINGS && targLat1 ? StringUTF16.indexOfLatin1(value, valLen, targ, targLen, i) : StringUTF16.indexOf(value, valLen, targ, targLen, i))) > 0) {
            if (++p == pos.length) {
                pos = Arrays.copyOf(pos, ArraysSupport.newLength(p, 1, p >> 1));
            }
            pos[p] = j;
            i = j + targLen;
        }
        try {
            resultLen = Math.addExact(valLen, Math.multiplyExact(++p, replLen - targLen));
        }
        catch (ArithmeticException ignored) {
            throw new OutOfMemoryError("Required length exceeds implementation limit");
        }
        if (resultLen == 0) {
            return "";
        }
        byte[] result = StringUTF16.newBytesFor(resultLen);
        int posFrom = 0;
        int posTo = 0;
        for (int q = 0; q < p; ++q) {
            int k;
            int nextPos = pos[q];
            if (String.COMPACT_STRINGS && valLat1) {
                while (posFrom < nextPos) {
                    char c = (char)(value[posFrom++] & 0xFF);
                    StringUTF16.putChar(result, posTo++, c);
                }
            } else {
                while (posFrom < nextPos) {
                    StringUTF16.putChar(result, posTo++, StringUTF16.getChar(value, posFrom++));
                }
            }
            posFrom += targLen;
            if (String.COMPACT_STRINGS && replLat1) {
                for (k = 0; k < replLen; ++k) {
                    char c = (char)(repl[k] & 0xFF);
                    StringUTF16.putChar(result, posTo++, c);
                }
                continue;
            }
            for (k = 0; k < replLen; ++k) {
                StringUTF16.putChar(result, posTo++, StringUTF16.getChar(repl, k));
            }
        }
        if (String.COMPACT_STRINGS && valLat1) {
            while (posFrom < valLen) {
                char c = (char)(value[posFrom++] & 0xFF);
                StringUTF16.putChar(result, posTo++, c);
            }
        } else {
            while (posFrom < valLen) {
                StringUTF16.putChar(result, posTo++, StringUTF16.getChar(value, posFrom++));
            }
        }
        if (String.COMPACT_STRINGS && replLat1 && !targLat1 && (lat1Result = StringUTF16.compress(result, 0, resultLen)) != null) {
            return new String(lat1Result, 0);
        }
        return new String(result, 1);
    }

    public static boolean regionMatchesCI(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        return StringUTF16.compareToCIImpl(value, toffset, len, other, ooffset, len) == 0;
    }

    public static boolean regionMatchesCI_Latin1(byte[] value, int toffset, byte[] other, int ooffset, int len) {
        return StringLatin1.regionMatchesCI_UTF16(other, ooffset, value, toffset, len);
    }

    public static String toLowerCase(String str, byte[] value, Locale locale) {
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean hasSurr = false;
        int len = value.length >> 1;
        for (first = 0; first < len; ++first) {
            char cp = StringUTF16.getChar(value, first);
            if (Character.isSurrogate(cp)) {
                hasSurr = true;
                break;
            }
            if (cp != Character.toLowerCase((int)cp)) break;
        }
        if (first == len) {
            return str;
        }
        byte[] result = new byte[value.length];
        System.arraycopy(value, 0, result, 0, first << 1);
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringUTF16.toLowerCaseEx(str, value, result, first, locale, true);
        }
        if (hasSurr) {
            return StringUTF16.toLowerCaseEx(str, value, result, first, locale, false);
        }
        int bits = 0;
        for (int i = first; i < len; ++i) {
            int cp = StringUTF16.getChar(value, i);
            if (cp == 931 || Character.isSurrogate((char)cp)) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, false);
            }
            if (cp == 304) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, true);
            }
            if (!Character.isBmpCodePoint(cp = Character.toLowerCase(cp))) {
                return StringUTF16.toLowerCaseEx(str, value, result, i, locale, false);
            }
            bits |= cp;
            StringUTF16.putChar(result, i, cp);
        }
        if (bits > 255) {
            return new String(result, 1);
        }
        return StringUTF16.newString(result, 0, len);
    }

    private static String toLowerCaseEx(String str, byte[] value, byte[] result, int first, Locale locale, boolean localeDependent) {
        int srcCount;
        if (!$assertionsDisabled && result.length != value.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first < 0) {
            throw new AssertionError();
        }
        int resultOffset = first;
        int length = value.length >> 1;
        for (int i = first; i < length; i += srcCount) {
            int lowerChar;
            int srcChar = StringUTF16.getChar(value, i);
            srcCount = 1;
            if (Character.isSurrogate((char)srcChar)) {
                srcChar = StringUTF16.codePointAt(value, i, length);
                srcCount = Character.charCount(srcChar);
            }
            if (Character.isBmpCodePoint(lowerChar = localeDependent || srcChar == 931 || srcChar == 304 ? ConditionalSpecialCasing.toLowerCaseEx(str, i, locale) : Character.toLowerCase(srcChar))) {
                StringUTF16.putChar(result, resultOffset++, lowerChar);
                continue;
            }
            char[] lowerCharArray = lowerChar == -1 ? ConditionalSpecialCasing.toLowerCaseCharArray(str, i, locale) : Character.toChars(lowerChar);
            int mapLen = lowerCharArray.length;
            if (mapLen > srcCount) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - srcCount);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            if (!$assertionsDisabled && resultOffset < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && resultOffset + mapLen > StringUTF16.length(result)) {
                throw new AssertionError();
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, lowerCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String toUpperCase(String str, byte[] value, Locale locale) {
        int first;
        if (locale == null) {
            throw new NullPointerException();
        }
        boolean hasSurr = false;
        int len = value.length >> 1;
        for (first = 0; first < len; ++first) {
            char cp = StringUTF16.getChar(value, first);
            if (Character.isSurrogate(cp)) {
                hasSurr = true;
                break;
            }
            if (cp != Character.toUpperCaseEx(cp)) break;
        }
        if (first == len) {
            return str;
        }
        byte[] result = new byte[value.length];
        System.arraycopy(value, 0, result, 0, first << 1);
        String lang = locale.getLanguage();
        if (lang == "tr" || lang == "az" || lang == "lt") {
            return StringUTF16.toUpperCaseEx(str, value, result, first, locale, true);
        }
        if (hasSurr) {
            return StringUTF16.toUpperCaseEx(str, value, result, first, locale, false);
        }
        int bits = 0;
        for (int i = first; i < len; ++i) {
            int cp = StringUTF16.getChar(value, i);
            if (Character.isSurrogate((char)cp)) {
                return StringUTF16.toUpperCaseEx(str, value, result, i, locale, false);
            }
            if (!Character.isBmpCodePoint(cp = Character.toUpperCaseEx(cp))) {
                return StringUTF16.toUpperCaseEx(str, value, result, i, locale, false);
            }
            bits |= cp;
            StringUTF16.putChar(result, i, cp);
        }
        if (bits > 255) {
            return new String(result, 1);
        }
        return StringUTF16.newString(result, 0, len);
    }

    private static String toUpperCaseEx(String str, byte[] value, byte[] result, int first, Locale locale, boolean localeDependent) {
        int srcCount;
        if (!$assertionsDisabled && result.length != value.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && first < 0) {
            throw new AssertionError();
        }
        int resultOffset = first;
        int length = value.length >> 1;
        for (int i = first; i < length; i += srcCount) {
            int upperChar;
            int srcChar = StringUTF16.getChar(value, i);
            srcCount = 1;
            if (Character.isSurrogate((char)srcChar)) {
                srcChar = StringUTF16.codePointAt(value, i, length);
                srcCount = Character.charCount(srcChar);
            }
            if (Character.isBmpCodePoint(upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(str, i, locale) : Character.toUpperCaseEx(srcChar))) {
                StringUTF16.putChar(result, resultOffset++, upperChar);
                continue;
            }
            char[] upperCharArray = upperChar == -1 ? (localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(str, i, locale) : Character.toUpperCaseCharArray(srcChar)) : Character.toChars(upperChar);
            int mapLen = upperCharArray.length;
            if (mapLen > srcCount) {
                byte[] result2 = StringUTF16.newBytesFor((result.length >> 1) + mapLen - srcCount);
                System.arraycopy(result, 0, result2, 0, resultOffset << 1);
                result = result2;
            }
            if (!$assertionsDisabled && resultOffset < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && resultOffset + mapLen > StringUTF16.length(result)) {
                throw new AssertionError();
            }
            for (int x = 0; x < mapLen; ++x) {
                StringUTF16.putChar(result, resultOffset++, upperCharArray[x]);
            }
        }
        return StringUTF16.newString(result, 0, resultOffset);
    }

    public static String trim(byte[] value) {
        int st;
        int length;
        int len = length = value.length >> 1;
        for (st = 0; st < len && StringUTF16.getChar(value, st) <= ' '; ++st) {
        }
        while (st < len && StringUTF16.getChar(value, len - 1) <= ' ') {
            --len;
        }
        return st > 0 || len < length ? new String(Arrays.copyOfRange(value, st << 1, len << 1), 1) : null;
    }

    public static int indexOfNonWhitespace(byte[] value) {
        int left;
        int codepoint;
        int length = value.length >> 1;
        for (left = 0; left < length && ((codepoint = StringUTF16.codePointAt(value, left, length)) == 32 || codepoint == 9 || Character.isWhitespace(codepoint)); left += Character.charCount(codepoint)) {
        }
        return left;
    }

    public static int lastIndexOfNonWhitespace(byte[] value) {
        int length;
        int right;
        int codepoint;
        for (right = length = value.length >>> 1; 0 < right && ((codepoint = StringUTF16.codePointBefore(value, right)) == 32 || codepoint == 9 || Character.isWhitespace(codepoint)); right -= Character.charCount(codepoint)) {
        }
        return right;
    }

    public static String strip(byte[] value) {
        int length = value.length >>> 1;
        int left = StringUTF16.indexOfNonWhitespace(value);
        if (left == length) {
            return "";
        }
        int right = StringUTF16.lastIndexOfNonWhitespace(value);
        boolean ifChanged = left > 0 || right < length;
        return ifChanged ? StringUTF16.newString(value, left, right - left) : null;
    }

    public static String stripLeading(byte[] value) {
        int length = value.length >>> 1;
        int left = StringUTF16.indexOfNonWhitespace(value);
        return left != 0 ? StringUTF16.newString(value, left, length - left) : null;
    }

    public static String stripTrailing(byte[] value) {
        int length = value.length >>> 1;
        int right = StringUTF16.lastIndexOfNonWhitespace(value);
        return right != length ? StringUTF16.newString(value, 0, right) : null;
    }

    static Stream<String> lines(byte[] value) {
        return StreamSupport.stream(LinesSpliterator.spliterator(value), false);
    }

    private static void putChars(byte[] val, int index, char[] str, int off, int end) {
        while (off < end) {
            StringUTF16.putChar(val, index++, str[off++]);
        }
    }

    public static String newString(byte[] val, int index, int len) {
        byte[] buf;
        if (len == 0) {
            return "";
        }
        if (String.COMPACT_STRINGS && (buf = StringUTF16.compress(val, index, len)) != null) {
            return new String(buf, 0);
        }
        int last = index + len;
        return new String(Arrays.copyOfRange(val, index << 1, last << 1), 1);
    }

    public static void fillNull(byte[] val, int index, int end) {
        Arrays.fill(val, index << 1, end << 1, (byte)0);
    }

    public static void putCharSB(byte[] val, int index, int c) {
        StringUTF16.checkIndex(index, val);
        StringUTF16.putChar(val, index, c);
    }

    public static void putCharsSB(byte[] val, int index, char[] ca, int off, int end) {
        StringUTF16.checkBoundsBeginEnd(index, index + end - off, val);
        StringUTF16.putChars(val, index, ca, off, end);
    }

    public static void putCharsSB(byte[] val, int index, CharSequence s, int off, int end) {
        StringUTF16.checkBoundsBeginEnd(index, index + end - off, val);
        for (int i = off; i < end; ++i) {
            StringUTF16.putChar(val, index++, s.charAt(i));
        }
    }

    public static int codePointAtSB(byte[] val, int index, int end) {
        return StringUTF16.codePointAt(val, index, end, true);
    }

    public static int codePointBeforeSB(byte[] val, int index) {
        return StringUTF16.codePointBefore(val, index, true);
    }

    public static int codePointCountSB(byte[] val, int beginIndex, int endIndex) {
        return StringUTF16.codePointCount(val, beginIndex, endIndex, true);
    }

    public static int getChars(int i, int begin, int end, byte[] value) {
        StringUTF16.checkBoundsBeginEnd(begin, end, value);
        int pos = StringUTF16.getChars(i, end, value);
        if (!$assertionsDisabled && begin != pos) {
            throw new AssertionError();
        }
        return pos;
    }

    public static int getChars(long l, int begin, int end, byte[] value) {
        StringUTF16.checkBoundsBeginEnd(begin, end, value);
        int pos = StringUTF16.getChars(l, end, value);
        if (!$assertionsDisabled && begin != pos) {
            throw new AssertionError();
        }
        return pos;
    }

    public static boolean contentEquals(byte[] v1, byte[] v2, int len) {
        StringUTF16.checkBoundsOffCount(0, len, v2);
        for (int i = 0; i < len; ++i) {
            if ((char)(v1[i] & 0xFF) == StringUTF16.getChar(v2, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(byte[] value, CharSequence cs, int len) {
        StringUTF16.checkOffset(len, value);
        for (int i = 0; i < len; ++i) {
            if (StringUTF16.getChar(value, i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static int putCharsAt(byte[] value, int i, char c1, char c2, char c3, char c4) {
        int end = i + 4;
        StringUTF16.checkBoundsBeginEnd(i, end, value);
        StringUTF16.putChar(value, i++, c1);
        StringUTF16.putChar(value, i++, c2);
        StringUTF16.putChar(value, i++, c3);
        StringUTF16.putChar(value, i++, c4);
        if (!$assertionsDisabled && i != end) {
            throw new AssertionError();
        }
        return end;
    }

    public static int putCharsAt(byte[] value, int i, char c1, char c2, char c3, char c4, char c5) {
        int end = i + 5;
        StringUTF16.checkBoundsBeginEnd(i, end, value);
        StringUTF16.putChar(value, i++, c1);
        StringUTF16.putChar(value, i++, c2);
        StringUTF16.putChar(value, i++, c3);
        StringUTF16.putChar(value, i++, c4);
        StringUTF16.putChar(value, i++, c5);
        if (!$assertionsDisabled && i != end) {
            throw new AssertionError();
        }
        return end;
    }

    public static char charAt(byte[] value, int index) {
        StringUTF16.checkIndex(index, value);
        return StringUTF16.getChar(value, index);
    }

    public static void reverse(byte[] val, int count) {
        StringUTF16.checkOffset(count, val);
        int n = count - 1;
        boolean hasSurrogates = false;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            int k = n - j;
            char cj = StringUTF16.getChar(val, j);
            char ck = StringUTF16.getChar(val, k);
            StringUTF16.putChar(val, j, ck);
            StringUTF16.putChar(val, k, cj);
            if (!Character.isSurrogate(cj) && !Character.isSurrogate(ck)) continue;
            hasSurrogates = true;
        }
        if (hasSurrogates) {
            StringUTF16.reverseAllValidSurrogatePairs(val, count);
        }
    }

    private static void reverseAllValidSurrogatePairs(byte[] val, int count) {
        for (int i = 0; i < count - 1; ++i) {
            char c1;
            char c2 = StringUTF16.getChar(val, i);
            if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c1 = StringUTF16.getChar(val, i + 1))) continue;
            StringUTF16.putChar(val, i++, c1);
            StringUTF16.putChar(val, i, c2);
        }
    }

    public static void inflate(byte[] src, int srcOff, byte[] dst, int dstOff, int len) {
        StringUTF16.checkBoundsOffCount(dstOff, len, dst);
        for (int i = 0; i < len; ++i) {
            StringUTF16.putChar(dst, dstOff++, src[srcOff++] & 0xFF);
        }
    }

    public static int lastIndexOfLatin1(byte[] src, int srcCount, byte[] tgt, int tgtCount, int fromIndex) {
        int start;
        if (!$assertionsDisabled && fromIndex < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && tgtCount > tgt.length) {
            throw new AssertionError();
        }
        int min = tgtCount - 1;
        int i = min + fromIndex;
        int strLastIndex = tgtCount - 1;
        char strLastChar = (char)(tgt[strLastIndex] & 0xFF);
        StringUTF16.checkIndex(i, src);
        block0: while (true) {
            if (i >= min && StringUTF16.getChar(src, i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - strLastIndex;
            int k = strLastIndex - 1;
            while (j > start) {
                if (StringUTF16.getChar(src, j--) == (tgt[k--] & 0xFF)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    private static native boolean isBigEndian();

    static int getChars(int i, int index, byte[] buf) {
        int r;
        int q;
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0;
        if (!negative) {
            i = -i;
        }
        while (i <= -100) {
            q = i / 100;
            r = q * 100 - i;
            i = q;
            StringUTF16.putChar(buf, --charPos, Integer.DigitOnes[r]);
            StringUTF16.putChar(buf, --charPos, Integer.DigitTens[r]);
        }
        q = i / 10;
        r = q * 10 - i;
        StringUTF16.putChar(buf, --charPos, 48 + r);
        if (q < 0) {
            StringUTF16.putChar(buf, --charPos, 48 - q);
        }
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return charPos;
    }

    static int getChars(long i, int index, byte[] buf) {
        int q2;
        int r;
        boolean negative;
        int charPos = index;
        boolean bl = negative = i < 0L;
        if (!negative) {
            i = -i;
        }
        while (i <= Integer.MIN_VALUE) {
            long q = i / 100L;
            r = (int)(q * 100L - i);
            i = q;
            StringUTF16.putChar(buf, --charPos, Integer.DigitOnes[r]);
            StringUTF16.putChar(buf, --charPos, Integer.DigitTens[r]);
        }
        int i2 = (int)i;
        while (i2 <= -100) {
            q2 = i2 / 100;
            r = q2 * 100 - i2;
            i2 = q2;
            StringUTF16.putChar(buf, --charPos, Integer.DigitOnes[r]);
            StringUTF16.putChar(buf, --charPos, Integer.DigitTens[r]);
        }
        q2 = i2 / 10;
        r = q2 * 10 - i2;
        StringUTF16.putChar(buf, --charPos, 48 + r);
        if (q2 < 0) {
            StringUTF16.putChar(buf, --charPos, 48 - q2);
        }
        if (negative) {
            StringUTF16.putChar(buf, --charPos, 45);
        }
        return charPos;
    }

    public static void checkIndex(int off, byte[] val) {
        String.checkIndex(off, StringUTF16.length(val));
    }

    public static void checkOffset(int off, byte[] val) {
        String.checkOffset(off, StringUTF16.length(val));
    }

    public static void checkBoundsBeginEnd(int begin, int end, byte[] val) {
        String.checkBoundsBeginEnd(begin, end, StringUTF16.length(val));
    }

    public static void checkBoundsOffCount(int offset, int count, byte[] val) {
        String.checkBoundsOffCount(offset, count, StringUTF16.length(val));
    }

    static {
        boolean bl = $assertionsDisabled = !StringUTF16.class.desiredAssertionStatus();
        if (StringUTF16.isBigEndian()) {
            HI_BYTE_SHIFT = 8;
            LO_BYTE_SHIFT = 0;
        } else {
            HI_BYTE_SHIFT = 0;
            LO_BYTE_SHIFT = 8;
        }
    }

    private static final class LinesSpliterator
    implements Spliterator<String> {
        private byte[] value;
        private int index;
        private final int fence;

        private LinesSpliterator(byte[] value, int start, int length) {
            this.value = value;
            this.index = start;
            this.fence = start + length;
        }

        private int indexOfLineSeparator(int start) {
            for (int current = start; current < this.fence; ++current) {
                char ch = StringUTF16.getChar(this.value, current);
                if (ch != '\n' && ch != '\r') continue;
                return current;
            }
            return this.fence;
        }

        private int skipLineSeparator(int start) {
            if (start < this.fence) {
                int next;
                if (StringUTF16.getChar(this.value, start) == '\r' && (next = start + 1) < this.fence && StringUTF16.getChar(this.value, next) == '\n') {
                    return next + 1;
                }
                return start + 1;
            }
            return this.fence;
        }

        private String next() {
            int start = this.index;
            int end = this.indexOfLineSeparator(start);
            this.index = this.skipLineSeparator(end);
            return StringUTF16.newString(this.value, start, end - start);
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException("tryAdvance action missing");
            }
            if (this.index != this.fence) {
                action.accept(this.next());
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException("forEachRemaining action missing");
            }
            while (this.index != this.fence) {
                action.accept(this.next());
            }
        }

        @Override
        public Spliterator<String> trySplit() {
            int half = this.fence + this.index >>> 1;
            int mid = this.skipLineSeparator(this.indexOfLineSeparator(half));
            if (mid < this.fence) {
                int start = this.index;
                this.index = mid;
                return new LinesSpliterator(this.value, start, mid - start);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index + 1;
        }

        @Override
        public int characteristics() {
            return 1296;
        }

        static LinesSpliterator spliterator(byte[] value) {
            return new LinesSpliterator(value, 0, value.length >>> 1);
        }
    }

    static class CodePointsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CodePointsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length >> 1, acs);
        }

        CodePointsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int midOneLess;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                return null;
            }
            if (Character.isLowSurrogate(StringUTF16.charAt(this.array, mid)) && Character.isHighSurrogate(StringUTF16.charAt(this.array, midOneLess = mid - 1))) {
                if (lo >= midOneLess) {
                    return null;
                }
                this.index = midOneLess;
                return new CodePointsSpliterator(this.array, lo, this.index, this.cs);
            }
            this.index = mid;
            return new CodePointsSpliterator(this.array, lo, this.index, this.cs);
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >> 1 >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                while ((i = CodePointsSpliterator.advance(a, i, hi, action)) < hi) {
                }
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                this.index = CodePointsSpliterator.advance(this.array, this.index, this.fence, action);
                return true;
            }
            return false;
        }

        private static int advance(byte[] a, int i, int hi, IntConsumer action) {
            char c2;
            int c1;
            int cp = c1 = StringUTF16.charAt(a, i++);
            if (Character.isHighSurrogate((char)c1) && i < hi && Character.isLowSurrogate(c2 = StringUTF16.charAt(a, i))) {
                ++i;
                cp = Character.toCodePoint((char)c1, c2);
            }
            action.accept(cp);
            return i;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }

    static class CharsSpliterator
    implements Spliterator.OfInt {
        private final byte[] array;
        private int index;
        private final int fence;
        private final int cs;

        CharsSpliterator(byte[] array, int acs) {
            this(array, 0, array.length >> 1, acs);
        }

        CharsSpliterator(byte[] array, int origin, int fence, int acs) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.cs = acs | 0x10 | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            CharsSpliterator charsSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                charsSpliterator = null;
            } else {
                this.index = mid;
                CharsSpliterator charsSpliterator2 = new CharsSpliterator(this.array, lo, this.index, this.cs);
                charsSpliterator = charsSpliterator2;
            }
            return charsSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            byte[] a = this.array;
            int hi = this.fence;
            if (this.array.length >> 1 >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(StringUTF16.charAt(a, i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            if ((i = this.index++) >= 0 && i < this.fence) {
                action.accept(StringUTF16.charAt(this.array, i));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.cs;
        }
    }
}

