/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatFactory;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import jdk.internal.logger.LazyLoggers;
import jdk.internal.logger.LocalizedLoggerWrapper;
import jdk.internal.logger.LoggerFinderLoader;
import jdk.internal.misc.Unsafe;
import jdk.internal.misc.VM;
import jdk.internal.module.ModuleBootstrap;
import jdk.internal.module.ServicesCatalog;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.ConstantPool;
import jdk.internal.reflect.Reflection;
import jdk.internal.util.StaticProperty;
import jdk.internal.util.SystemProps;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import jdk.internal.vm.annotation.Stable;
import sun.nio.ch.Interruptible;
import sun.nio.fs.DefaultFileSystemProvider;
import sun.reflect.annotation.AnnotationType;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final int NEVER = 1;
    private static final int MAYBE = 2;
    @Stable
    private static int allowSecurityManager;
    private static volatile SecurityManager security;
    private static volatile Console cons;
    @Stable
    private static volatile PrintStream initialErrStream;
    private static Properties props;
    private static String lineSeparator;
    static ModuleLayer bootLayer;

    private static native void registerNatives();

    private System() {
    }

    private static boolean allowSecurityManager() {
        return allowSecurityManager != 1;
    }

    public static void setIn(InputStream in) {
        System.checkIO();
        System.setIn0(in);
    }

    public static void setOut(PrintStream out) {
        System.checkIO();
        System.setOut0(out);
    }

    public static void setErr(PrintStream err) {
        System.checkIO();
        System.setErr0(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Console console() {
        Console c = cons;
        if (c != null) return c;
        Class<System> clazz = System.class;
        synchronized (System.class) {
            c = cons;
            if (c != null) return c;
            cons = c = SharedSecrets.getJavaIOAccess().console();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return c;
        }
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    private static void checkIO() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    private static URL codeSource(Class<?> clazz) {
        PrivilegedAction<ProtectionDomain> pa = clazz::getProtectionDomain;
        CodeSource cs = AccessController.doPrivileged(pa).getCodeSource();
        return cs != null ? cs.getLocation() : null;
    }

    @Deprecated(since="17", forRemoval=true)
    @CallerSensitive
    public static void setSecurityManager(SecurityManager sm) {
        if (System.allowSecurityManager()) {
            Class<?> callerClass = Reflection.getCallerClass();
            if (CallersHolder.callers.putIfAbsent(callerClass, true) == null) {
                URL url = System.codeSource(callerClass);
                String source = url == null ? callerClass.getName() : callerClass.getName() + " (" + url + ")";
                initialErrStream.printf("WARNING: A terminally deprecated method in java.lang.System has been called\nWARNING: System::setSecurityManager has been called by %s\nWARNING: Please consider reporting this to the maintainers of %s\nWARNING: System::setSecurityManager will be removed in a future release\n", source, callerClass.getName());
            }
            System.implSetSecurityManager(sm);
        } else if (sm != null) {
            throw new UnsupportedOperationException("The Security Manager is deprecated and will be removed in a future release");
        }
    }

    private static void implSetSecurityManager(SecurityManager sm) {
        if (security == null) {
            Object.class.getResource("java/lang/ANY");
            DefaultFileSystemProvider.theFileSystem();
        }
        if (sm != null) {
            try {
                sm.checkPackageAccess("java.lang");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.setSecurityManager0(sm);
    }

    private static synchronized void setSecurityManager0(final SecurityManager s) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (s != null && s.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    s.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
            });
        }
        security = s;
    }

    @Deprecated(since="17", forRemoval=true)
    public static SecurityManager getSecurityManager() {
        if (System.allowSecurityManager()) {
            return security;
        }
        return null;
    }

    @IntrinsicCandidate
    public static native long currentTimeMillis();

    @IntrinsicCandidate
    public static native long nanoTime();

    @IntrinsicCandidate
    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    @IntrinsicCandidate
    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return props;
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void setProperties(Properties props) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        if (props == null) {
            Map<String, String> tempProps = SystemProps.initProperties();
            VersionProps.init(tempProps);
            props = System.createProperties(tempProps);
        }
        System.props = props;
    }

    public static String getProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String def) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return props.getProperty(key, def);
    }

    public static String setProperty(String key, String value) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.setProperty(key, value);
    }

    public static String clearProperty(String key) {
        System.checkKey(key);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return (String)props.remove(key);
    }

    private static void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key can't be empty");
        }
    }

    public static String getenv(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv." + name));
        }
        return ProcessEnvironment.getenv(name);
    }

    public static Map<String, String> getenv() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv.*"));
        }
        return ProcessEnvironment.getenv();
    }

    @CallerSensitive
    public static Logger getLogger(String name) {
        Objects.requireNonNull(name);
        Class<?> caller = Reflection.getCallerClass();
        if (caller == null) {
            throw new IllegalCallerException("no caller frame");
        }
        return LazyLoggers.getLogger(name, caller.getModule());
    }

    @CallerSensitive
    public static Logger getLogger(String name, ResourceBundle bundle) {
        ResourceBundle rb = Objects.requireNonNull(bundle);
        Objects.requireNonNull(name);
        Class<?> caller = Reflection.getCallerClass();
        if (caller == null) {
            throw new IllegalCallerException("no caller frame");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            PrivilegedAction<Logger> pa = () -> LoggerFinder.accessProvider().getLocalizedLogger(name, rb, caller.getModule());
            return AccessController.doPrivileged(pa, null, LoggerFinder.LOGGERFINDER_PERMISSION);
        }
        return LoggerFinder.accessProvider().getLocalizedLogger(name, rb, caller.getModule());
    }

    public static void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @CallerSensitive
    public static void load(String filename) {
        Runtime.getRuntime().load0(Reflection.getCallerClass(), filename);
    }

    @CallerSensitive
    public static void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary0(Reflection.getCallerClass(), libname);
    }

    public static native String mapLibraryName(String var0);

    private static PrintStream newPrintStream(FileOutputStream fos, String enc) {
        if (enc != null) {
            try {
                return new PrintStream((OutputStream)new BufferedOutputStream(fos, 128), true, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new PrintStream(new BufferedOutputStream(fos, 128), true);
    }

    private static void logInitException(boolean printToStderr, boolean printStackTrace, String msg, Throwable e) {
        PrintStream log;
        if (VM.initLevel() < 1) {
            throw new InternalError("system classes not initialized");
        }
        PrintStream printStream = log = printToStderr ? err : out;
        if (msg != null) {
            log.println(msg);
        }
        if (printStackTrace) {
            e.printStackTrace(log);
        } else {
            log.println(e);
            for (Throwable suppressed : e.getSuppressed()) {
                log.println("Suppressed: " + suppressed);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                log.println("Caused by: " + cause);
            }
        }
    }

    private static Properties createProperties(Map<String, String> initialProps) {
        Properties properties = new Properties(initialProps.size());
        block10: for (Map.Entry<String, String> entry : initialProps.entrySet()) {
            String prop;
            switch (prop = entry.getKey()) {
                case "sun.nio.MaxDirectMemorySize": 
                case "sun.nio.PageAlignDirectMemory": 
                case "java.lang.Integer.IntegerCache.high": 
                case "sun.java.launcher.diag": 
                case "jdk.boot.class.path.append": {
                    continue block10;
                }
            }
            properties.put(prop, entry.getValue());
        }
        return properties;
    }

    private static void initPhase1() {
        System.setJavaLangAccess();
        Map<String, String> tempProps = SystemProps.initProperties();
        VersionProps.init(tempProps);
        VM.saveProperties(tempProps);
        props = System.createProperties(tempProps);
        StaticProperty.javaHome();
        lineSeparator = props.getProperty("line.separator");
        FileInputStream fdIn = new FileInputStream(FileDescriptor.in);
        FileOutputStream fdOut = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fdErr = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fdIn));
        System.setOut0(System.newPrintStream(fdOut, props.getProperty("sun.stdout.encoding")));
        System.setErr0(System.newPrintStream(fdErr, props.getProperty("sun.stderr.encoding")));
        Terminator.setup();
        VM.initializeOSEnvironment();
        Thread current = Thread.currentThread();
        current.getThreadGroup().add(current);
        VM.initLevel(1);
    }

    private static int initPhase2(boolean printToStderr, boolean printStackTrace) {
        try {
            bootLayer = ModuleBootstrap.boot();
        }
        catch (Error | Exception e) {
            System.logInitException(printToStderr, printStackTrace, "Error occurred during initialization of boot layer", e);
            return -1;
        }
        VM.initLevel(2);
        return 0;
    }

    private static void initPhase3() {
        Unsafe.getUnsafe().ensureClassInitialized(StringConcatFactory.class);
        String smProp = System.getProperty("java.security.manager");
        boolean needWarning = false;
        if (smProp != null) {
            switch (smProp) {
                case "disallow": {
                    allowSecurityManager = 1;
                    break;
                }
                case "allow": {
                    allowSecurityManager = 2;
                    break;
                }
                case "": 
                case "default": {
                    System.implSetSecurityManager(new SecurityManager());
                    allowSecurityManager = 2;
                    needWarning = true;
                    break;
                }
                default: {
                    try {
                        ClassLoader cl = ClassLoader.getBuiltinAppClassLoader();
                        Class<?> c = Class.forName(smProp, false, cl);
                        Constructor<?> ctor = c.getConstructor(new Class[0]);
                        if (!(SecurityManager.class.isAssignableFrom(c) && Modifier.isPublic(c.getModifiers()) && Modifier.isPublic(ctor.getModifiers()))) {
                            throw new Error("Could not create SecurityManager: " + ctor.toString());
                        }
                        ctor.setAccessible(true);
                        SecurityManager sm = (SecurityManager)ctor.newInstance(new Object[0]);
                        System.implSetSecurityManager(sm);
                        needWarning = true;
                    }
                    catch (Exception e) {
                        throw new InternalError("Could not create SecurityManager", e);
                    }
                    allowSecurityManager = 2;
                    break;
                }
            }
        } else {
            allowSecurityManager = 2;
        }
        if (needWarning) {
            err.println("WARNING: A command line option has enabled the Security Manager\nWARNING: The Security Manager is deprecated and will be removed in a future release");
        }
        initialErrStream = err;
        VM.initLevel(3);
        ClassLoader scl = ClassLoader.initSystemClassLoader();
        Thread.currentThread().setContextClassLoader(scl);
        VM.initLevel(4);
    }

    private static void setJavaLangAccess() {
        SharedSecrets.setJavaLangAccess(new JavaLangAccess(){

            @Override
            public List<Method> getDeclaredPublicMethods(Class<?> klass, String name, Class<?> ... parameterTypes) {
                return klass.getDeclaredPublicMethods(name, parameterTypes);
            }

            @Override
            public ConstantPool getConstantPool(Class<?> klass) {
                return klass.getConstantPool();
            }

            @Override
            public boolean casAnnotationType(Class<?> klass, AnnotationType oldType, AnnotationType newType) {
                return klass.casAnnotationType(oldType, newType);
            }

            @Override
            public AnnotationType getAnnotationType(Class<?> klass) {
                return klass.getAnnotationType();
            }

            @Override
            public Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap(Class<?> klass) {
                return klass.getDeclaredAnnotationMap();
            }

            @Override
            public byte[] getRawClassAnnotations(Class<?> klass) {
                return klass.getRawAnnotations();
            }

            @Override
            public byte[] getRawClassTypeAnnotations(Class<?> klass) {
                return klass.getRawTypeAnnotations();
            }

            @Override
            public byte[] getRawExecutableTypeAnnotations(Executable executable) {
                return Class.getExecutableTypeAnnotationBytes(executable);
            }

            @Override
            public <E extends Enum<E>> E[] getEnumConstantsShared(Class<E> klass) {
                return (Enum[])klass.getEnumConstantsShared();
            }

            @Override
            public void blockedOn(Interruptible b) {
                Thread.blockedOn(b);
            }

            @Override
            public void registerShutdownHook(int slot, boolean registerShutdownInProgress, Runnable hook) {
                Shutdown.add(slot, registerShutdownInProgress, hook);
            }

            @Override
            public Thread newThreadWithAcc(Runnable target, AccessControlContext acc) {
                return new Thread(target, acc);
            }

            @Override
            public void invokeFinalize(Object o) throws Throwable {
                o.finalize();
            }

            @Override
            public ConcurrentHashMap<?, ?> createOrGetClassLoaderValueMap(ClassLoader cl) {
                return cl.createOrGetClassLoaderValueMap();
            }

            @Override
            public Class<?> defineClass(ClassLoader loader, String name, byte[] b, ProtectionDomain pd, String source) {
                return ClassLoader.defineClass1(loader, name, b, 0, b.length, pd, source);
            }

            @Override
            public Class<?> defineClass(ClassLoader loader, Class<?> lookup, String name, byte[] b, ProtectionDomain pd, boolean initialize, int flags, Object classData) {
                return ClassLoader.defineClass0(loader, lookup, name, b, 0, b.length, pd, initialize, flags, classData);
            }

            @Override
            public Class<?> findBootstrapClassOrNull(String name) {
                return ClassLoader.findBootstrapClassOrNull(name);
            }

            @Override
            public Package definePackage(ClassLoader cl, String name, Module module) {
                return cl.definePackage(name, module);
            }

            @Override
            public String fastUUID(long lsb, long msb) {
                return Long.fastUUID(lsb, msb);
            }

            @Override
            public void addNonExportedPackages(ModuleLayer layer) {
                SecurityManager.addNonExportedPackages(layer);
            }

            @Override
            public void invalidatePackageAccessCache() {
                SecurityManager.invalidatePackageAccessCache();
            }

            @Override
            public Module defineModule(ClassLoader loader, ModuleDescriptor descriptor, URI uri) {
                return new Module(null, loader, descriptor, uri);
            }

            @Override
            public Module defineUnnamedModule(ClassLoader loader) {
                return new Module(loader);
            }

            @Override
            public void addReads(Module m1, Module m2) {
                m1.implAddReads(m2);
            }

            @Override
            public void addReadsAllUnnamed(Module m) {
                m.implAddReadsAllUnnamed();
            }

            @Override
            public void addExports(Module m, String pn) {
                m.implAddExports(pn);
            }

            @Override
            public void addExports(Module m, String pn, Module other) {
                m.implAddExports(pn, other);
            }

            @Override
            public void addExportsToAllUnnamed(Module m, String pn) {
                m.implAddExportsToAllUnnamed(pn);
            }

            @Override
            public void addOpens(Module m, String pn, Module other) {
                m.implAddOpens(pn, other);
            }

            @Override
            public void addOpensToAllUnnamed(Module m, String pn) {
                m.implAddOpensToAllUnnamed(pn);
            }

            @Override
            public void addOpensToAllUnnamed(Module m, Set<String> concealedPackages, Set<String> exportedPackages) {
                m.implAddOpensToAllUnnamed(concealedPackages, exportedPackages);
            }

            @Override
            public void addUses(Module m, Class<?> service) {
                m.implAddUses(service);
            }

            @Override
            public boolean isReflectivelyExported(Module m, String pn, Module other) {
                return m.isReflectivelyExported(pn, other);
            }

            @Override
            public boolean isReflectivelyOpened(Module m, String pn, Module other) {
                return m.isReflectivelyOpened(pn, other);
            }

            @Override
            public Module addEnableNativeAccess(Module m) {
                return m.implAddEnableNativeAccess();
            }

            @Override
            public void addEnableNativeAccessAllUnnamed() {
                Module.implAddEnableNativeAccessAllUnnamed();
            }

            @Override
            public boolean isEnableNativeAccess(Module m) {
                return m.implIsEnableNativeAccess();
            }

            @Override
            public ServicesCatalog getServicesCatalog(ModuleLayer layer) {
                return layer.getServicesCatalog();
            }

            @Override
            public void bindToLoader(ModuleLayer layer, ClassLoader loader) {
                layer.bindToLoader(loader);
            }

            @Override
            public Stream<ModuleLayer> layers(ModuleLayer layer) {
                return layer.layers();
            }

            @Override
            public Stream<ModuleLayer> layers(ClassLoader loader) {
                return ModuleLayer.layers(loader);
            }

            @Override
            public String newStringNoRepl(byte[] bytes, Charset cs) throws CharacterCodingException {
                return String.newStringNoRepl(bytes, cs);
            }

            @Override
            public byte[] getBytesNoRepl(String s, Charset cs) throws CharacterCodingException {
                return String.getBytesNoRepl(s, cs);
            }

            @Override
            public String newStringUTF8NoRepl(byte[] bytes, int off, int len) {
                return String.newStringUTF8NoRepl(bytes, off, len);
            }

            @Override
            public byte[] getBytesUTF8NoRepl(String s) {
                return String.getBytesUTF8NoRepl(s);
            }

            @Override
            public void inflateBytesToChars(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
                StringLatin1.inflate(src, srcOff, dst, dstOff, len);
            }

            @Override
            public int decodeASCII(byte[] src, int srcOff, char[] dst, int dstOff, int len) {
                return String.decodeASCII(src, srcOff, dst, dstOff, len);
            }

            @Override
            public int encodeASCII(char[] src, int srcOff, byte[] dst, int dstOff, int len) {
                return StringCoding.implEncodeAsciiArray(src, srcOff, dst, dstOff, len);
            }

            @Override
            public void setCause(Throwable t, Throwable cause) {
                t.setCause(cause);
            }

            @Override
            public ProtectionDomain protectionDomain(Class<?> c) {
                return c.protectionDomain();
            }

            @Override
            public MethodHandle stringConcatHelper(String name, MethodType methodType) {
                return StringConcatHelper.lookupStatic(name, methodType);
            }

            @Override
            public long stringConcatInitialCoder() {
                return StringConcatHelper.initialCoder();
            }

            @Override
            public long stringConcatMix(long lengthCoder, String constant) {
                return StringConcatHelper.mix(lengthCoder, constant);
            }

            @Override
            public String join(String prefix, String suffix, String delimiter, String[] elements, int size) {
                return String.join(prefix, suffix, delimiter, elements, size);
            }

            @Override
            public Object classData(Class<?> c) {
                return c.getClassData();
            }

            @Override
            public long findNative(ClassLoader loader, String entry) {
                return ClassLoader.findNative(loader, entry);
            }

            @Override
            public void exit(int statusCode) {
                Shutdown.exit(statusCode);
            }
        });
    }

    static {
        System.registerNatives();
        in = null;
        out = null;
        err = null;
    }

    private static class CallersHolder {
        static final Map<Class<?>, Boolean> callers = Collections.synchronizedMap(new WeakHashMap());

        private CallersHolder() {
        }
    }

    public static interface Logger {
        public String getName();

        public boolean isLoggable(Level var1);

        default public void log(Level level, String msg) {
            this.log(level, (ResourceBundle)null, msg, (Object[])null);
        }

        default public void log(Level level, Supplier<String> msgSupplier) {
            Objects.requireNonNull(msgSupplier);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, (ResourceBundle)null, msgSupplier.get(), (Object[])null);
            }
        }

        default public void log(Level level, Object obj) {
            Objects.requireNonNull(obj);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, (ResourceBundle)null, obj.toString(), (Object[])null);
            }
        }

        default public void log(Level level, String msg, Throwable thrown) {
            this.log(level, null, msg, thrown);
        }

        default public void log(Level level, Supplier<String> msgSupplier, Throwable thrown) {
            Objects.requireNonNull(msgSupplier);
            if (this.isLoggable(Objects.requireNonNull(level))) {
                this.log(level, null, msgSupplier.get(), thrown);
            }
        }

        default public void log(Level level, String format, Object ... params) {
            this.log(level, null, format, params);
        }

        public void log(Level var1, ResourceBundle var2, String var3, Throwable var4);

        public void log(Level var1, ResourceBundle var2, String var3, Object ... var4);

        public static enum Level {
            ALL(Integer.MIN_VALUE),
            TRACE(400),
            DEBUG(500),
            INFO(800),
            WARNING(900),
            ERROR(1000),
            OFF(Integer.MAX_VALUE);

            private final int severity;

            private Level(int severity) {
                this.severity = severity;
            }

            public final String getName() {
                return this.name();
            }

            public final int getSeverity() {
                return this.severity;
            }
        }
    }

    public static abstract class LoggerFinder {
        static final RuntimePermission LOGGERFINDER_PERMISSION = new RuntimePermission("loggerFinder");
        private static volatile LoggerFinder service;

        protected LoggerFinder() {
            this(LoggerFinder.checkPermission());
        }

        private LoggerFinder(Void unused) {
        }

        private static Void checkPermission() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(LOGGERFINDER_PERMISSION);
            }
            return null;
        }

        public abstract Logger getLogger(String var1, Module var2);

        public Logger getLocalizedLogger(String name, ResourceBundle bundle, Module module) {
            return new LocalizedLoggerWrapper<Logger>(this.getLogger(name, module), bundle);
        }

        public static LoggerFinder getLoggerFinder() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(LOGGERFINDER_PERMISSION);
            }
            return LoggerFinder.accessProvider();
        }

        static LoggerFinder accessProvider() {
            if (service == null) {
                PrivilegedAction<LoggerFinder> pa = () -> LoggerFinderLoader.getLoggerFinder();
                service = AccessController.doPrivileged(pa, null, LOGGERFINDER_PERMISSION);
            }
            return service;
        }
    }
}

