/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessControlContext;
import java.util.concurrent.locks.LockSupport;
import org.qbicc.runtime.Build;
import org.qbicc.runtime.CNative;
import org.qbicc.runtime.linux.Futex;
import org.qbicc.runtime.patcher.Add;
import org.qbicc.runtime.patcher.PatchClass;
import org.qbicc.runtime.patcher.Replace;
import org.qbicc.runtime.posix.PThread;
import org.qbicc.runtime.posix.Time;
import org.qbicc.runtime.stdc.Stdint;
import org.qbicc.runtime.stdc.Time;

@PatchClass(value=Thread.class)
public class Thread$_patch {
    String name;
    ThreadGroup group;
    boolean daemon;
    int priority;
    ClassLoader contextClassLoader;
    AccessControlContext inheritedAccessControlContext;
    Runnable target;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals;
    long stackSize;
    long tid;
    int threadStatus;
    @Add
    PThread.pthread_mutex_t mutex;
    @Add
    PThread.pthread_cond_t cond;
    @Add
    Stdint.uint32_t parkFlag;
    @Add
    private static final long MAX_NANOS_PER_MS_TIME = 9223372036853L;
    static final int STATE_ALIVE = 1;
    static final int STATE_TERMINATED = 2;
    static final int STATE_RUNNABLE = 4;
    static final int STATE_WAITING = 16;
    static final int STATE_WAITING_WITH_TIMEOUT = 32;
    static final int STATE_BLOCKED = 1024;

    native void setPriority(int var1);

    static native long nextThreadID();

    @Replace
    Thread$_patch(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        Thread parent = Thread.currentThread();
        if (g == null) {
            g = parent.getThreadGroup();
        }
        g.addUnstarted();
        this.group = g;
        this.daemon = parent.isDaemon();
        this.priority = parent.getPriority();
        this.contextClassLoader = parent.getContextClassLoader();
        this.inheritedAccessControlContext = null;
        this.target = target;
        this.setPriority(this.priority);
        if (inheritThreadLocals && parent.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parent.inheritableThreadLocals);
        }
        this.stackSize = stackSize;
        this.tid = Thread$_patch.nextThreadID();
        this.parkFlag = (Stdint.uint32_t)CNative.zero();
        if (Build.isTarget() && !Build.Target.isLinux()) {
            CNative.c_int res = PThread.pthread_mutex_init((PThread.pthread_mutex_t_ptr)((PThread.pthread_mutex_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)this).sel()).mutex)), (PThread.const_pthread_mutexattr_t_ptr)((PThread.const_pthread_mutexattr_t_ptr)CNative.zero()));
            if (res.isNonNull()) {
                throw new InternalError("Failed to initialize thread park mutex");
            }
            res = PThread.pthread_cond_init((PThread.pthread_cond_t_ptr)((PThread.pthread_cond_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)this).sel()).cond)), (PThread.pthread_condattr_t_ptr)((PThread.pthread_condattr_t_ptr)CNative.zero()));
            if (res.isNonNull()) {
                throw new InternalError("Failed to initialize thread park condition");
            }
        }
    }

    @Replace
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Replace
    public static void sleep(long millis, int nanos) throws InterruptedException {
        if (millis < 0L || millis == 0L && nanos <= 0) {
            return;
        }
        while (nanos > 1000000) {
            if (millis < Long.MAX_VALUE) {
                ++millis;
            } else {
                nanos = 999999;
                break;
            }
            nanos -= 1000000;
        }
        long end = System.nanoTime();
        do {
            long start = end;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            LockSupport.parkNanos(Math.min(millis, 9223372036853L) * 1000000L + (long)nanos);
            end = System.nanoTime();
            millis -= Long.divideUnsigned(end - start, 1000000L);
            nanos -= (int)Long.remainderUnsigned(end - start, 1000000L);
            while (nanos < 0) {
                --millis;
                nanos = (int)((long)nanos + 1000000L);
            }
        } while (millis >= 0L && (millis != 0L || nanos > 0));
    }

    @Add
    void blocked() {
        CNative.addr_of((int)((Thread$_patch)CNative.refToPtr((Object)this).sel()).threadStatus).getAndBitwiseOrOpaque((Object)((Stdint.int32_t)CNative.word((int)1024)));
    }

    @Add
    void unblocked() {
        CNative.addr_of((int)((Thread$_patch)CNative.refToPtr((Object)this).sel()).threadStatus).getAndBitwiseAndOpaque((Object)((Stdint.int32_t)CNative.word((int)-1025)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Add
    static void park(boolean isAbsolute, long time) {
        block19: {
            Thread thread = Thread.currentThread();
            Thread$_patch patchThread = (Thread$_patch)((Object)thread);
            Stdint.uint32_t_ptr ptr2 = (Stdint.uint32_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)patchThread).sel()).parkFlag);
            if (ptr2.compareAndSet((Object)((Stdint.uint32_t)CNative.word((int)1)), (Object)((Stdint.uint32_t)CNative.zero()))) {
                return;
            }
            int flag = time == 0L && !isAbsolute ? 16 : 32;
            CNative.addr_of((int)((Thread$_patch)CNative.refToPtr((Object)patchThread).sel()).threadStatus).getAndBitwiseOrOpaque((Object)((Stdint.int32_t)CNative.word((int)flag)));
            try {
                if (Build.Target.isLinux()) {
                    Time.struct_timespec timespec = (Time.struct_timespec)CNative.auto();
                    if (isAbsolute) {
                        timespec.tv_sec = (Time.time_t)CNative.word((long)(time / 1000L));
                        timespec.tv_nsec = (CNative.c_long)CNative.word((long)(time * 1000000L));
                        Futex.futex_wait_absolute((Stdint.uint32_t_ptr)ptr2, (Stdint.uint32_t)((Stdint.uint32_t)CNative.word((int)0)), (Time.const_struct_timespec_ptr)((Time.const_struct_timespec_ptr)CNative.addr_of((CNative.object)timespec)));
                    } else if (time == 0L) {
                        Futex.futex_wait((Stdint.uint32_t_ptr)ptr2, (Stdint.uint32_t)((Stdint.uint32_t)CNative.word((int)0)), (Time.const_struct_timespec_ptr)((Time.const_struct_timespec_ptr)CNative.zero()));
                    } else {
                        timespec.tv_sec = (Time.time_t)CNative.word((long)(time / 1000000000L));
                        timespec.tv_nsec = (CNative.c_long)CNative.word((long)(time % 1000000000L));
                        Futex.futex_wait((Stdint.uint32_t_ptr)ptr2, (Stdint.uint32_t)((Stdint.uint32_t)CNative.word((int)0)), (Time.const_struct_timespec_ptr)((Time.const_struct_timespec_ptr)CNative.addr_of((CNative.object)timespec)));
                    }
                    ptr2.storeRelease((Object)((Stdint.uint32_t)CNative.zero()));
                    break block19;
                }
                if (Build.Target.isPosix()) {
                    Time.struct_timespec timespec = (Time.struct_timespec)CNative.auto();
                    PThread.pthread_mutex_t_ptr mutexPtr = (PThread.pthread_mutex_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)patchThread).sel()).mutex);
                    if (PThread.pthread_mutex_lock((PThread.pthread_mutex_t_ptr)mutexPtr).isNonZero()) {
                        throw new InternalError("mutex operation failed");
                    }
                    try {
                        PThread.pthread_cond_t_ptr condPtr = (PThread.pthread_cond_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)patchThread).sel()).cond);
                        if (isAbsolute) {
                            timespec.tv_sec = (Time.time_t)CNative.word((long)(time / 1000L));
                            timespec.tv_nsec = (CNative.c_long)CNative.word((long)(time * 1000000L));
                            PThread.pthread_cond_timedwait((PThread.pthread_cond_t_ptr)condPtr, (PThread.pthread_mutex_t_ptr)mutexPtr, (Time.const_struct_timespec_ptr)((Time.const_struct_timespec_ptr)CNative.addr_of((CNative.object)timespec)));
                        } else if (time == 0L) {
                            PThread.pthread_cond_wait((PThread.pthread_cond_t_ptr)condPtr, (PThread.pthread_mutex_t_ptr)mutexPtr);
                        } else {
                            Time.clock_gettime((Time.clockid_t)Time.CLOCK_REALTIME, (Time.struct_timespec_ptr)((Time.struct_timespec_ptr)CNative.addr_of((CNative.object)timespec)));
                            long sec = timespec.tv_sec.longValue() + time / 1000000000L;
                            long nsec = timespec.tv_nsec.longValue() + time % 1000000000L;
                            if (nsec >= 1000000000L) {
                                ++sec;
                                nsec -= 1000000000L;
                            }
                            timespec.tv_sec = (Time.time_t)CNative.word((long)sec);
                            timespec.tv_nsec = (CNative.c_long)CNative.word((long)nsec);
                            PThread.pthread_cond_timedwait((PThread.pthread_cond_t_ptr)condPtr, (PThread.pthread_mutex_t_ptr)mutexPtr, (Time.const_struct_timespec_ptr)((Time.const_struct_timespec_ptr)CNative.addr_of((CNative.object)timespec)));
                        }
                        break block19;
                    }
                    finally {
                        PThread.pthread_mutex_unlock((PThread.pthread_mutex_t_ptr)mutexPtr);
                    }
                }
                throw new UnsupportedOperationException();
            }
            finally {
                CNative.addr_of((int)((Thread$_patch)CNative.refToPtr((Object)patchThread).sel()).threadStatus).getAndBitwiseAndOpaque((Object)((Stdint.int32_t)CNative.word((int)(~flag))));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Add
    void unpark() {
        Stdint.uint32_t_ptr ptr2 = (Stdint.uint32_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)this).sel()).parkFlag);
        if (Build.Target.isLinux()) {
            if (ptr2.compareAndSet((Object)((Stdint.uint32_t)CNative.zero()), (Object)((Stdint.uint32_t)CNative.word((int)1)))) {
                Futex.futex_wake_all((Stdint.uint32_t_ptr)ptr2);
            }
        } else if (Build.Target.isPosix()) {
            if (ptr2.compareAndSet((Object)((Stdint.uint32_t)CNative.zero()), (Object)((Stdint.uint32_t)CNative.word((int)1)))) {
                PThread.pthread_mutex_t_ptr mutexPtr = (PThread.pthread_mutex_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)this).sel()).mutex);
                if (PThread.pthread_mutex_lock((PThread.pthread_mutex_t_ptr)mutexPtr).isNonZero()) {
                    throw new InternalError("mutex operation failed");
                }
                try {
                    PThread.pthread_cond_t_ptr condPtr = (PThread.pthread_cond_t_ptr)CNative.addr_of((CNative.object)((Thread$_patch)CNative.refToPtr((Object)this).sel()).cond);
                    if (PThread.pthread_cond_broadcast((PThread.pthread_cond_t_ptr)condPtr).isNonZero()) {
                        throw new InternalError("mutex condition operation failed");
                    }
                }
                finally {
                    PThread.pthread_mutex_unlock((PThread.pthread_mutex_t_ptr)mutexPtr);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

