/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import jdk.internal.misc.TerminatingThreadLocal;
import jdk.internal.misc.VM;
import jdk.internal.reflect.CallerSensitive;
import jdk.internal.reflect.Reflection;
import jdk.internal.vm.annotation.Contended;
import jdk.internal.vm.annotation.IntrinsicCandidate;
import sun.nio.ch.Interruptible;
import sun.security.util.SecurityConstants;

public class Thread
implements Runnable {
    private volatile String name;
    private int priority;
    private boolean daemon = false;
    private volatile boolean interrupted;
    private boolean stillborn = false;
    private long eetop;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private final long stackSize;
    private final long tid;
    private static long threadSeqNumber;
    private volatile int threadStatus;
    volatile Object parkBlocker;
    private volatile Interruptible blocker;
    private final Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    @Contended(value="tlr")
    long threadLocalRandomSeed;
    @Contended(value="tlr")
    int threadLocalRandomProbe;
    @Contended(value="tlr")
    int threadLocalRandomSecondarySeed;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void blockedOn(Interruptible b) {
        Thread me = Thread.currentThread();
        Object object2 = me.blockerLock;
        synchronized (object2) {
            me.blocker = b;
        }
    }

    @IntrinsicCandidate
    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos > 0 && millis < Long.MAX_VALUE) {
            ++millis;
        }
        Thread.sleep(millis);
    }

    @IntrinsicCandidate
    public static void onSpinWait() {
    }

    private Thread(ThreadGroup g, Runnable target, String name, long stackSize, AccessControlContext acc, boolean inheritThreadLocals) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        Thread parent = Thread.currentThread();
        SecurityManager security = System.getSecurityManager();
        if (g == null) {
            if (security != null) {
                g = security.getThreadGroup();
            }
            if (g == null) {
                g = parent.getThreadGroup();
            }
        }
        g.checkAccess();
        if (security != null && Thread.isCCLOverridden(this.getClass())) {
            security.checkPermission(SecurityConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        g.addUnstarted();
        this.group = g;
        this.daemon = parent.isDaemon();
        this.priority = parent.getPriority();
        this.contextClassLoader = security == null || Thread.isCCLOverridden(parent.getClass()) ? parent.getContextClassLoader() : parent.contextClassLoader;
        this.inheritedAccessControlContext = acc != null ? acc : AccessController.getContext();
        this.target = target;
        this.setPriority(this.priority);
        if (inheritThreadLocals && parent.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(parent.inheritableThreadLocals);
        }
        this.stackSize = stackSize;
        this.tid = Thread.nextThreadID();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Thread() {
        this(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable target) {
        this(null, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    Thread(Runnable target, AccessControlContext acc) {
        this(null, target, "Thread-" + Thread.nextThreadNum(), 0L, acc, false);
    }

    public Thread(ThreadGroup group, Runnable target) {
        this(group, target, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String name) {
        this(null, null, name, 0L);
    }

    public Thread(ThreadGroup group, String name) {
        this(group, null, name, 0L);
    }

    public Thread(Runnable target, String name) {
        this(null, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name) {
        this(group, target, name, 0L);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize) {
        this(group, target, name, stackSize, null, true);
    }

    public Thread(ThreadGroup group, Runnable target, String name, long stackSize, boolean inheritThreadLocals) {
        this(group, target, name, stackSize, null, inheritThreadLocals);
    }

    public synchronized void start() {
        if (this.threadStatus != 0) {
            throw new IllegalThreadStateException();
        }
        this.group.add(this);
        boolean started = false;
        try {
            this.start0();
            started = true;
        }
        finally {
            try {
                if (!started) {
                    this.group.threadStartFailed(this);
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.threadLocals != null && TerminatingThreadLocal.REGISTRY.isPresent()) {
            TerminatingThreadLocal.threadTerminated();
        }
        if (this.group != null) {
            this.group.threadTerminated(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    @Deprecated(since="1.2")
    public final void stop() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            this.checkAccess();
            if (this != Thread.currentThread()) {
                security.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        if (this.threadStatus != 0) {
            this.resume();
        }
        this.stop0(new ThreadDeath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
            Object object2 = this.blockerLock;
            synchronized (object2) {
                Interruptible b = this.blocker;
                if (b != null) {
                    this.interrupted = true;
                    this.interrupt0();
                    b.interrupt(this);
                    return;
                }
            }
        }
        this.interrupted = true;
        this.interrupt0();
    }

    public static boolean interrupted() {
        Thread t = Thread.currentThread();
        boolean interrupted = t.interrupted;
        if (interrupted) {
            t.interrupted = false;
            Thread.clearInterruptEvent();
        }
        return interrupted;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public final native boolean isAlive();

    @Deprecated(since="1.2", forRemoval=true)
    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    @Deprecated(since="1.2", forRemoval=true)
    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int newPriority) {
        this.checkAccess();
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        ThreadGroup g = this.getThreadGroup();
        if (g != null) {
            if (newPriority > g.getMaxPriority()) {
                newPriority = g.getMaxPriority();
            }
            this.priority = newPriority;
            this.setPriority0(this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final synchronized void setName(String name) {
        this.checkAccess();
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = name;
        if (this.threadStatus != 0) {
            this.setNativeName(name);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] tarray) {
        return Thread.currentThread().getThreadGroup().enumerate(tarray);
    }

    @Deprecated(since="1.2", forRemoval=true)
    public int countStackFrames() {
        throw new UnsupportedOperationException();
    }

    public final synchronized void join(long millis) throws InterruptedException {
        if (millis > 0L) {
            if (this.isAlive()) {
                long startTime = System.nanoTime();
                long delay = millis;
                do {
                    this.wait(delay);
                } while (this.isAlive() && (delay = millis - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime)) > 0L);
            }
        } else if (millis == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            throw new IllegalArgumentException("timeout value is negative");
        }
    }

    public final synchronized void join(long millis, int nanos) throws InterruptedException {
        if (millis < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (nanos < 0 || nanos > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (nanos > 0 && millis < Long.MAX_VALUE) {
            ++millis;
        }
        this.join(millis);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean on) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = on;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    @Deprecated(since="17", forRemoval=true)
    public final void checkAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup group = this.getThreadGroup();
        if (group != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + group.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + ",]";
    }

    @CallerSensitive
    public ClassLoader getContextClassLoader() {
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(this.contextClassLoader, Reflection.getCallerClass());
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = cl;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        if (this != Thread.currentThread()) {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            }
            if (!this.isAlive()) {
                return EMPTY_STACK_TRACE;
            }
            StackTraceElement[][] stackTraceArray = Thread.dumpThreads(new Thread[]{this});
            StackTraceElement[] stackTrace = stackTraceArray[0];
            if (stackTrace == null) {
                stackTrace = EMPTY_STACK_TRACE;
            }
            return stackTrace;
        }
        return new Exception().getStackTrace();
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            security.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threads = Thread.getThreads();
        StackTraceElement[][] traces = Thread.dumpThreads(threads);
        HashMap<Thread, StackTraceElement[]> m = new HashMap<Thread, StackTraceElement[]>(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            StackTraceElement[] stackTrace = traces[i];
            if (stackTrace == null) continue;
            m.put(threads[i], stackTrace);
        }
        return m;
    }

    private static boolean isCCLOverridden(Class<?> cl) {
        if (cl == Thread.class) {
            return false;
        }
        Thread.processQueue(Caches.subclassAuditsQueue, Caches.subclassAudits);
        WeakClassKey key = new WeakClassKey(cl, Caches.subclassAuditsQueue);
        Boolean result = (Boolean)Caches.subclassAudits.get(key);
        if (result == null) {
            result = Thread.auditSubclass(cl);
            Caches.subclassAudits.putIfAbsent(key, result);
        }
        return result;
    }

    private static boolean auditSubclass(final Class<?> subcl) {
        Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                for (Class cl = subcl; cl != Thread.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] params = new Class[]{ClassLoader.class};
                            cl.getDeclaredMethod("setContextClassLoader", params);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return result;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return VM.toThreadState(this.threadStatus);
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = eh;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler eh) {
        this.checkAccess();
        this.uncaughtExceptionHandler = eh;
    }

    private void dispatchUncaughtException(Throwable e) {
        this.getUncaughtExceptionHandler().uncaughtException(this, e);
    }

    static void processQueue(ReferenceQueue<Class<?>> queue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> map) {
        Reference<Class<?>> ref;
        while ((ref = queue.poll()) != null) {
            map.remove(ref);
        }
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    private static native void clearInterruptEvent();

    private native void setNativeName(String var1);

    static {
        Thread.registerNatives();
        EMPTY_STACK_TRACE = new StackTraceElement[0];
    }

    @FunctionalInterface
    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Boolean> subclassAudits = new ConcurrentHashMap<WeakClassKey, Boolean>();
        static final ReferenceQueue<Class<?>> subclassAuditsQueue = new ReferenceQueue();

        private Caches() {
        }
    }

    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> cl, ReferenceQueue<Class<?>> refQueue) {
            super(cl, refQueue);
            this.hash = System.identityHashCode(cl);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakClassKey) {
                Class referent = (Class)this.get();
                return referent != null && ((WeakClassKey)obj).refersTo(referent);
            }
            return false;
        }
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

