/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class VersionProps {
    private static final String launcher_name = "qbicc";
    private static final String java_version = "17.0.1";
    private static final String java_version_date = "2022-02-10";
    private static final String java_runtime_name = "qbicc runtime environment";
    private static final String java_runtime_version = "17.0.1+17.alpha.0.9";
    private static final String VERSION_NUMBER = "17.0.1";
    private static final String VERSION_SPECIFICATION = "17";
    private static final String VERSION_BUILD = "0";
    private static final String VERSION_PRE = "";
    private static final String VERSION_OPT = "";
    private static final boolean isLTS = "".startsWith("LTS");
    private static final String CLASSFILE_MAJOR_MINOR = "61.0";
    private static final String VENDOR = "qbicc community";
    private static final String VENDOR_URL = "https://github.com/qbicc";
    private static String VENDOR_VERSION = "";
    private static String VENDOR_URL_BUG = "https://github.com/qbicc/qbicc-class-library/issues";
    private static String VENDOR_URL_VM_BUG = "https://github.com/qbicc/qbicc/issues";

    VersionProps() {
    }

    public static void init(Map<String, String> props) {
        props.put("java.version", "17.0.1");
        props.put("java.version.date", java_version_date);
        props.put("java.runtime.version", java_runtime_version);
        props.put("java.runtime.name", java_runtime_name);
        if (!VENDOR_VERSION.isEmpty()) {
            props.put("java.vendor.version", VENDOR_VERSION);
        }
        props.put("java.class.version", CLASSFILE_MAJOR_MINOR);
        props.put("java.specification.version", VERSION_SPECIFICATION);
        props.put("java.specification.name", "Java Platform API Specification");
        props.put("java.specification.vendor", "Oracle Corporation");
        props.put("java.vendor", VENDOR);
        props.put("java.vendor.url", VENDOR_URL);
        props.put("java.vendor.url.bug", VENDOR_URL_BUG);
    }

    private static int parseVersionNumber(String version, int prevIndex, int index) {
        if (index - prevIndex > 1 && Character.digit(version.charAt(prevIndex), 10) <= 0) {
            throw new IllegalArgumentException("Leading zeros not supported (" + version.substring(prevIndex, index) + ")");
        }
        return Integer.parseInt(version, prevIndex, index, 10);
    }

    static List<Integer> parseVersionNumbers(String version) {
        int size = 0;
        int prevIndex = 0;
        do {
            prevIndex = version.indexOf(46, prevIndex) + 1;
            ++size;
        } while (prevIndex > 0);
        Object[] verNumbers = new Integer[size];
        int n = 0;
        prevIndex = 0;
        int index = version.indexOf(46);
        while (index > -1) {
            verNumbers[n] = VersionProps.parseVersionNumber(version, prevIndex, index);
            prevIndex = index + 1;
            index = version.indexOf(46, prevIndex);
            ++n;
        }
        verNumbers[n] = VersionProps.parseVersionNumber(version, prevIndex, version.length());
        if (verNumbers[0] == 0 || verNumbers[n] == 0) {
            throw new IllegalArgumentException("Leading/trailing zeros not allowed (" + Arrays.toString(verNumbers) + ")");
        }
        return List.of(verNumbers);
    }

    static List<Integer> versionNumbers() {
        return VersionProps.parseVersionNumbers("17.0.1");
    }

    static Optional<String> pre() {
        return VersionProps.optionalOf("");
    }

    static Optional<Integer> build() {
        return VERSION_BUILD.isEmpty() ? Optional.empty() : Optional.of(Integer.parseInt(VERSION_BUILD));
    }

    static Optional<String> optional() {
        return VersionProps.optionalOf("");
    }

    private static Optional<String> optionalOf(String value) {
        if (!value.isEmpty()) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static void print(boolean err) {
        VersionProps.print(err, false);
    }

    public static void println(boolean err) {
        VersionProps.print(err, true);
    }

    private static void print(boolean err, boolean newln) {
        PrintStream ps;
        PrintStream printStream = ps = err ? System.err : System.out;
        if (err) {
            ps.println("qbicc version \"17.0.1\" 2022-02-10" + (isLTS ? " LTS" : ""));
        } else {
            ps.println("qbicc 17.0.1 2022-02-10" + (isLTS ? " LTS" : ""));
        }
        String jdk_debug_level = System.getProperty("jdk.debug", "release");
        jdk_debug_level = "release".equals(jdk_debug_level) ? "" : jdk_debug_level + " ";
        String vendor_version = VENDOR_VERSION.isEmpty() ? "" : " " + VENDOR_VERSION;
        ps.println(java_runtime_name + vendor_version + " (" + jdk_debug_level + "build " + java_runtime_version + ")");
        String java_vm_name = System.getProperty("java.vm.name");
        String java_vm_version = System.getProperty("java.vm.version");
        String java_vm_info = System.getProperty("java.vm.info");
        ps.println(java_vm_name + vendor_version + " (" + jdk_debug_level + "build " + java_vm_version + ", " + java_vm_info + ")");
    }
}

