/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.internal.ref.CleanerFactory;
import sun.security.action.GetPropertyAction;

final class WindowsProcessImpl
extends ProcessImpl {
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_WIN32_SAFE = 2;
    private static final int VERIFICATION_LEGACY = 3;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '\"', '<', '>', '&', '|', '^'}, {' ', '\t', '\"', '<', '>'}, {' ', '\t', '\"', '<', '>'}, {' ', '\t'}};
    private static final char DOUBLEQUOTE = '\"';
    private static final char BACKSLASH = '\\';
    private final long handle;
    private final ProcessHandle processHandle;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = WindowsProcessImpl.getStillActive();

    private static FileOutputStream newFileOutputStream(File f, boolean append) throws IOException {
        if (append) {
            String path = f.getPath();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkWrite(path);
            }
            long handle = WindowsProcessImpl.openForAtomicAppend(path);
            final FileDescriptor fd = new FileDescriptor();
            fdAccess.setHandle(fd, handle);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fd);
                }
            });
        }
        return new FileOutputStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] cmdarray, Map<String, String> environment, String dir, ProcessBuilder.Redirect[] redirects, boolean redirectErrorStream) throws IOException {
        String envblock = ProcessEnvironment.toEnvironmentBlock(environment);
        FileInputStream f0 = null;
        FileOutputStream f1 = null;
        FileOutputStream f2 = null;
        try {
            long[] stdHandles;
            boolean forceNullOutputStream = false;
            if (redirects == null) {
                stdHandles = new long[]{-1L, -1L, -1L};
            } else {
                stdHandles = new long[3];
                if (redirects[0] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[0] = -1L;
                } else if (redirects[0] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[0] = fdAccess.getHandle(FileDescriptor.in);
                } else if (redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[0] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd());
                } else {
                    f0 = new FileInputStream(redirects[0].file());
                    stdHandles[0] = fdAccess.getHandle(f0.getFD());
                }
                if (redirects[1] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[1] = -1L;
                } else if (redirects[1] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[1] = fdAccess.getHandle(FileDescriptor.out);
                } else if (redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[1] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd());
                    forceNullOutputStream = true;
                } else {
                    f1 = WindowsProcessImpl.newFileOutputStream(redirects[1].file(), redirects[1].append());
                    stdHandles[1] = fdAccess.getHandle(f1.getFD());
                }
                if (redirects[2] == ProcessBuilder.Redirect.PIPE) {
                    stdHandles[2] = -1L;
                } else if (redirects[2] == ProcessBuilder.Redirect.INHERIT) {
                    stdHandles[2] = fdAccess.getHandle(FileDescriptor.err);
                } else if (redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    stdHandles[2] = fdAccess.getHandle(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd());
                } else {
                    f2 = WindowsProcessImpl.newFileOutputStream(redirects[2].file(), redirects[2].append());
                    stdHandles[2] = fdAccess.getHandle(f2.getFD());
                }
            }
            WindowsProcessImpl p = new WindowsProcessImpl(cmdarray, envblock, dir, stdHandles, forceNullOutputStream, redirectErrorStream);
            if (redirects != null) {
                if (stdHandles[0] >= 0L && redirects[0] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[0]).getFd(), stdHandles[0]);
                }
                if (stdHandles[1] >= 0L && redirects[1] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[1]).getFd(), stdHandles[1]);
                }
                if (stdHandles[2] >= 0L && redirects[2] instanceof ProcessBuilder.RedirectPipeImpl) {
                    fdAccess.setHandle(((ProcessBuilder.RedirectPipeImpl)redirects[2]).getFd(), stdHandles[2]);
                }
            }
            WindowsProcessImpl windowsProcessImpl = p;
            return windowsProcessImpl;
        }
        finally {
            try {
                if (f0 != null) {
                    f0.close();
                }
            }
            finally {
                try {
                    if (f1 != null) {
                        f1.close();
                    }
                }
                finally {
                    if (f2 != null) {
                        f2.close();
                    }
                }
            }
        }
    }

    private static String[] getTokensFromCommand(String command) {
        ArrayList<String> matchList = new ArrayList<String>(8);
        Matcher regexMatcher = LazyPattern.PATTERN.matcher(command);
        while (regexMatcher.find()) {
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[matchList.size()]);
    }

    private static String createCommandLine(int verificationType, String executablePath, String[] cmd) {
        StringBuilder cmdbuf = new StringBuilder(80);
        cmdbuf.append(executablePath);
        for (int i = 1; i < cmd.length; ++i) {
            cmdbuf.append(' ');
            String s = cmd[i];
            if (WindowsProcessImpl.needsEscaping(verificationType, s)) {
                cmdbuf.append('\"');
                if (verificationType == 2) {
                    int length = s.length();
                    for (int j = 0; j < length; ++j) {
                        char c = s.charAt(j);
                        if (c == '\"') {
                            int count = WindowsProcessImpl.countLeadingBackslash(verificationType, s, j);
                            while (count-- > 0) {
                                cmdbuf.append('\\');
                            }
                            cmdbuf.append('\\');
                        }
                        cmdbuf.append(c);
                    }
                } else {
                    cmdbuf.append(s);
                }
                int count = WindowsProcessImpl.countLeadingBackslash(verificationType, s, s.length());
                while (count-- > 0) {
                    cmdbuf.append('\\');
                }
                cmdbuf.append('\"');
                continue;
            }
            cmdbuf.append(s);
        }
        return cmdbuf.toString();
    }

    private static String unQuote(String str) {
        if (!str.startsWith("\"") || !str.endsWith("\"") || str.length() < 2) {
            return str;
        }
        if (str.endsWith("\\\"")) {
            return str;
        }
        return str.substring(1, str.length() - 1);
    }

    private static boolean needsEscaping(int verificationType, String arg) {
        if (arg.isEmpty()) {
            return true;
        }
        String unquotedArg = WindowsProcessImpl.unQuote(arg);
        boolean argIsQuoted = !arg.equals(unquotedArg);
        boolean embeddedQuote = unquotedArg.indexOf(34) >= 0;
        switch (verificationType) {
            case 0: {
                if (!embeddedQuote) break;
                throw new IllegalArgumentException("Argument has embedded quote, use the explicit CMD.EXE call.");
            }
            case 2: {
                if (!argIsQuoted || !embeddedQuote) break;
                throw new IllegalArgumentException("Malformed argument has embedded quote: " + unquotedArg);
            }
        }
        if (!argIsQuoted) {
            char[] testEscape = ESCAPE_VERIFICATION[verificationType];
            for (int i = 0; i < testEscape.length; ++i) {
                if (arg.indexOf(testEscape[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String path) throws IOException {
        String name = WindowsProcessImpl.unQuote(path);
        if (name.indexOf(34) >= 0) {
            throw new IllegalArgumentException("Executable name has embedded quote, split the arguments: " + name);
        }
        File fileToRun = new File(name);
        return fileToRun.getPath();
    }

    private boolean isExe(String executablePath) {
        File file = new File(executablePath);
        String upName = file.getName().toUpperCase(Locale.ROOT);
        return upName.endsWith(".EXE") || upName.indexOf(46) < 0;
    }

    private boolean isShellFile(String executablePath) {
        String upPath = executablePath.toUpperCase();
        return upPath.endsWith(".CMD") || upPath.endsWith(".BAT");
    }

    private String quoteString(String arg) {
        StringBuilder argbuf = new StringBuilder(arg.length() + 2);
        return argbuf.append('\"').append(arg).append('\"').toString();
    }

    private static int countLeadingBackslash(int verificationType, CharSequence input, int start) {
        int j;
        if (verificationType == 0) {
            return 0;
        }
        for (j = start - 1; j >= 0 && input.charAt(j) == '\\'; --j) {
        }
        return start - 1 - j;
    }

    private WindowsProcessImpl(String[] cmd, String envblock, String path, final long[] stdHandles, final boolean forceNullOutputStream, boolean redirectErrorStream) throws IOException {
        String cmdstr;
        boolean allowAmbiguousCommands;
        SecurityManager security = System.getSecurityManager();
        String value = GetPropertyAction.privilegedGetProperty("jdk.lang.Process.allowAmbiguousCommands", security == null ? "true" : "false");
        boolean bl = allowAmbiguousCommands = !"false".equalsIgnoreCase(value);
        if (allowAmbiguousCommands && security == null) {
            executablePath = new File(cmd[0]).getPath();
            if (WindowsProcessImpl.needsEscaping(3, executablePath)) {
                executablePath = this.quoteString(executablePath);
            }
            cmdstr = WindowsProcessImpl.createCommandLine(3, executablePath, cmd);
        } else {
            boolean isShell;
            block6: {
                try {
                    executablePath = WindowsProcessImpl.getExecutablePath(cmd[0]);
                }
                catch (IllegalArgumentException e) {
                    StringBuilder join = new StringBuilder();
                    for (String s : cmd) {
                        join.append(s).append(' ');
                    }
                    cmd = WindowsProcessImpl.getTokensFromCommand(join.toString());
                    executablePath = WindowsProcessImpl.getExecutablePath(cmd[0]);
                    if (security == null) break block6;
                    security.checkExec(executablePath);
                }
            }
            boolean bl2 = allowAmbiguousCommands ? this.isShellFile(executablePath) : (isShell = !this.isExe(executablePath));
            cmdstr = WindowsProcessImpl.createCommandLine(isShell ? 0 : (allowAmbiguousCommands ? 1 : 2), this.quoteString(executablePath), cmd);
        }
        long local_handle = this.handle = WindowsProcessImpl.create(cmdstr, envblock, path, stdHandles, redirectErrorStream);
        CleanerFactory.cleaner().register(this, () -> WindowsProcessImpl.closeHandle(local_handle));
        this.processHandle = ProcessHandleImpl.getInternal(WindowsProcessImpl.getProcessId0(this.handle));
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (stdHandles[0] == -1L) {
                    WindowsProcessImpl.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    FileDescriptor stdin_fd = new FileDescriptor();
                    ProcessImpl.fdAccess.setHandle(stdin_fd, stdHandles[0]);
                    ProcessImpl.fdAccess.registerCleanup(stdin_fd);
                    WindowsProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(stdin_fd));
                }
                if (stdHandles[1] == -1L || forceNullOutputStream) {
                    WindowsProcessImpl.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stdout_fd = new FileDescriptor();
                    ProcessImpl.fdAccess.setHandle(stdout_fd, stdHandles[1]);
                    ProcessImpl.fdAccess.registerCleanup(stdout_fd);
                    WindowsProcessImpl.this.stdout_stream = new BufferedInputStream(new Process.PipeInputStream(stdout_fd));
                }
                if (stdHandles[2] == -1L) {
                    WindowsProcessImpl.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    FileDescriptor stderr_fd = new FileDescriptor();
                    ProcessImpl.fdAccess.setHandle(stderr_fd, stdHandles[2]);
                    ProcessImpl.fdAccess.registerCleanup(stderr_fd);
                    WindowsProcessImpl.this.stderr_stream = new Process.PipeInputStream(stderr_fd);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int exitCode = WindowsProcessImpl.getExitCodeProcess(this.handle);
        if (exitCode == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return exitCode;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        WindowsProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        if (WindowsProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + remainingNanos;
        do {
            long msTimeout;
            if ((msTimeout = TimeUnit.NANOSECONDS.toMillis(remainingNanos + 999999L)) < 0L) {
                msTimeout = Integer.MAX_VALUE;
            }
            WindowsProcessImpl.waitForTimeoutInterruptibly(this.handle, msTimeout);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (WindowsProcessImpl.getExitCodeProcess(this.handle) == STILL_ACTIVE) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return WindowsProcessImpl.getExitCodeProcess(this.handle) != STILL_ACTIVE;
    }

    private static native void waitForTimeoutInterruptibly(long var0, long var2);

    @Override
    public void destroy() {
        WindowsProcessImpl.terminateProcess(this.handle);
    }

    @Override
    public CompletableFuture<Process> onExit() {
        return ProcessHandleImpl.completion(this.pid(), false).handleAsync((exitStatus, unusedThrowable) -> this);
    }

    @Override
    public ProcessHandle toHandle() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("manageProcess"));
        }
        return this.processHandle;
    }

    @Override
    public boolean supportsNormalTermination() {
        return ProcessImpl.SUPPORTS_NORMAL_TERMINATION;
    }

    @Override
    public Process destroyForcibly() {
        this.destroy();
        return this;
    }

    private static native void terminateProcess(long var0);

    @Override
    public long pid() {
        return this.processHandle.pid();
    }

    private static native int getProcessId0(long var0);

    @Override
    public boolean isAlive() {
        return WindowsProcessImpl.isProcessAlive(this.handle);
    }

    private static native boolean isProcessAlive(long var0);

    public String toString() {
        int exitCode = WindowsProcessImpl.getExitCodeProcess(this.handle);
        return "Process[pid=" + this.pid() + ", exitValue=" + (exitCode == STILL_ACTIVE ? "\"not exited\"" : Integer.valueOf(exitCode)) + "]";
    }

    private static synchronized native long create(String var0, String var1, String var2, long[] var3, boolean var4) throws IOException;

    private static native long openForAtomicAppend(String var0) throws IOException;

    private static native boolean closeHandle(long var0);

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

