/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantUtils;
import java.lang.constant.PrimitiveClassDescImpl;
import java.lang.constant.ReferenceClassDescImpl;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.invoke.util.Wrapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassDesc
extends ConstantDesc,
TypeDescriptor.OfField<ClassDesc> {
    public static ClassDesc of(String name) {
        ConstantUtils.validateBinaryClassName(Objects.requireNonNull(name));
        return ClassDesc.ofDescriptor("L" + ConstantUtils.binaryToInternal(name) + ";");
    }

    public static ClassDesc of(String packageName, String className) {
        ConstantUtils.validateBinaryClassName(Objects.requireNonNull(packageName));
        if (packageName.isEmpty()) {
            return ClassDesc.of(className);
        }
        ConstantUtils.validateMemberName(Objects.requireNonNull(className), false);
        return ClassDesc.ofDescriptor("L" + ConstantUtils.binaryToInternal(packageName) + (packageName.length() > 0 ? "/" : "") + className + ";");
    }

    public static ClassDesc ofDescriptor(String descriptor) {
        Objects.requireNonNull(descriptor);
        if (descriptor.isEmpty()) {
            throw new IllegalArgumentException("not a valid reference type descriptor: " + descriptor);
        }
        int depth = ConstantUtils.arrayDepth(descriptor);
        if (depth > 255) {
            throw new IllegalArgumentException("Cannot create an array type descriptor with more than 255 dimensions");
        }
        return descriptor.length() == 1 ? new PrimitiveClassDescImpl(descriptor) : new ReferenceClassDescImpl(descriptor);
    }

    @Override
    default public ClassDesc arrayType() {
        int depth = ConstantUtils.arrayDepth(this.descriptorString());
        if (depth >= 255) {
            throw new IllegalStateException("Cannot create an array type descriptor with more than 255 dimensions");
        }
        return this.arrayType(1);
    }

    default public ClassDesc arrayType(int rank) {
        int currentDepth = ConstantUtils.arrayDepth(this.descriptorString());
        if (rank <= 0 || currentDepth + rank > 255) {
            throw new IllegalArgumentException("rank: " + currentDepth + rank);
        }
        return ClassDesc.ofDescriptor("[".repeat(rank) + this.descriptorString());
    }

    default public ClassDesc nested(String nestedName) {
        ConstantUtils.validateMemberName(nestedName, false);
        if (!this.isClassOrInterface()) {
            throw new IllegalStateException("Outer class is not a class or interface type");
        }
        return ClassDesc.ofDescriptor(ConstantUtils.dropLastChar(this.descriptorString()) + "$" + nestedName + ";");
    }

    default public ClassDesc nested(String firstNestedName, String ... moreNestedNames) {
        if (!this.isClassOrInterface()) {
            throw new IllegalStateException("Outer class is not a class or interface type");
        }
        ConstantUtils.validateMemberName(firstNestedName, false);
        Objects.requireNonNull(moreNestedNames);
        for (String addNestedNames : moreNestedNames) {
            ConstantUtils.validateMemberName(addNestedNames, false);
        }
        return moreNestedNames.length == 0 ? this.nested(firstNestedName) : this.nested(firstNestedName + Stream.of(moreNestedNames).collect(Collectors.joining("$", "$", "")));
    }

    @Override
    default public boolean isArray() {
        return this.descriptorString().startsWith("[");
    }

    @Override
    default public boolean isPrimitive() {
        return this.descriptorString().length() == 1;
    }

    default public boolean isClassOrInterface() {
        return this.descriptorString().startsWith("L");
    }

    @Override
    default public ClassDesc componentType() {
        return this.isArray() ? ClassDesc.ofDescriptor(this.descriptorString().substring(1)) : null;
    }

    default public String packageName() {
        if (!this.isClassOrInterface()) {
            return "";
        }
        String className = ConstantUtils.internalToBinary(ConstantUtils.dropFirstAndLastChar(this.descriptorString()));
        int index = className.lastIndexOf(46);
        return index == -1 ? "" : className.substring(0, index);
    }

    default public String displayName() {
        if (this.isPrimitive()) {
            return Wrapper.forBasicType(this.descriptorString().charAt(0)).primitiveSimpleName();
        }
        if (this.isClassOrInterface()) {
            return this.descriptorString().substring(Math.max(1, this.descriptorString().lastIndexOf(47) + 1), this.descriptorString().length() - 1);
        }
        if (this.isArray()) {
            int depth = ConstantUtils.arrayDepth(this.descriptorString());
            ClassDesc c = this;
            for (int i = 0; i < depth; ++i) {
                c = c.componentType();
            }
            return c.displayName() + "[]".repeat(depth);
        }
        throw new IllegalStateException(this.descriptorString());
    }

    @Override
    public String descriptorString();

    public boolean equals(Object var1);
}

