/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodHandleDesc;
import jdk.internal.vm.annotation.Stable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DirectMethodHandleDesc
extends MethodHandleDesc {
    public Kind kind();

    public int refKind();

    public boolean isOwnerInterface();

    public ClassDesc owner();

    public String methodName();

    public String lookupDescriptor();

    public static enum Kind {
        STATIC(6),
        INTERFACE_STATIC(6, true),
        VIRTUAL(5),
        INTERFACE_VIRTUAL(9, true),
        SPECIAL(7),
        INTERFACE_SPECIAL(7, true),
        CONSTRUCTOR(8),
        GETTER(1),
        SETTER(3),
        STATIC_GETTER(2),
        STATIC_SETTER(4);

        public final int refKind;
        public final boolean isInterface;
        @Stable
        private static final Kind[] TABLE;

        private Kind(int refKind) {
            this(refKind, false);
        }

        private Kind(int refKind, boolean isInterface) {
            this.refKind = refKind;
            this.isInterface = isInterface;
        }

        public static Kind valueOf(int refKind) {
            return Kind.valueOf(refKind, refKind == 9);
        }

        public static Kind valueOf(int refKind, boolean isInterface) {
            int i = Kind.tableIndex(refKind, isInterface);
            if (i >= 2 && i < TABLE.length) {
                return TABLE[i];
            }
            throw new IllegalArgumentException(String.format("refKind=%d isInterface=%s", refKind, isInterface));
        }

        private static int tableIndex(int refKind, boolean isInterface) {
            if (refKind < 0) {
                return refKind;
            }
            return refKind * 2 + (isInterface ? 1 : 0);
        }

        boolean isVirtualMethod() {
            switch (this) {
                case VIRTUAL: 
                case SPECIAL: 
                case INTERFACE_VIRTUAL: 
                case INTERFACE_SPECIAL: {
                    return true;
                }
            }
            return false;
        }

        static {
            int max = 0;
            for (Kind k : Kind.values()) {
                max = Math.max(max, Kind.tableIndex(k.refKind, true));
            }
            TABLE = new Kind[max + 1];
            for (Kind kind : Kind.values()) {
                int i = Kind.tableIndex(kind.refKind, kind.isInterface);
                if (i >= TABLE.length || TABLE[i] != null) {
                    throw new AssertionError((Object)("TABLE entry for " + (Object)((Object)kind)));
                }
                Kind.TABLE[i] = kind;
            }
            int ii = Kind.tableIndex(9, false);
            if (TABLE[ii] != null) {
                throw new AssertionError((Object)("TABLE entry for (invokeInterface, false) used by " + (Object)((Object)TABLE[ii])));
            }
            Kind.TABLE[ii] = INTERFACE_VIRTUAL;
            for (Kind kind : Kind.values()) {
                int i;
                if (kind.isInterface || TABLE[i = Kind.tableIndex(kind.refKind, true)] != null) continue;
                Kind.TABLE[i] = kind;
            }
        }
    }
}

