/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.ConstantUtils;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;

final class DirectMethodHandleDescImpl
implements DirectMethodHandleDesc {
    private final DirectMethodHandleDesc.Kind kind;
    private final ClassDesc owner;
    private final String name;
    private final MethodTypeDesc invocationType;

    DirectMethodHandleDescImpl(DirectMethodHandleDesc.Kind kind, ClassDesc owner, String name, MethodTypeDesc type) {
        if (kind == DirectMethodHandleDesc.Kind.CONSTRUCTOR) {
            name = "<init>";
        }
        Objects.requireNonNull(kind);
        ConstantUtils.validateClassOrInterface(Objects.requireNonNull(owner));
        ConstantUtils.validateMemberName(Objects.requireNonNull(name), true);
        Objects.requireNonNull(type);
        switch (kind) {
            case CONSTRUCTOR: {
                DirectMethodHandleDescImpl.validateConstructor(type);
                break;
            }
            case GETTER: {
                DirectMethodHandleDescImpl.validateFieldType(type, false, true);
                break;
            }
            case SETTER: {
                DirectMethodHandleDescImpl.validateFieldType(type, true, true);
                break;
            }
            case STATIC_GETTER: {
                DirectMethodHandleDescImpl.validateFieldType(type, false, false);
                break;
            }
            case STATIC_SETTER: {
                DirectMethodHandleDescImpl.validateFieldType(type, true, false);
            }
        }
        this.kind = kind;
        this.owner = owner;
        this.name = name;
        this.invocationType = kind.isVirtualMethod() ? type.insertParameterTypes(0, owner) : (kind == DirectMethodHandleDesc.Kind.CONSTRUCTOR ? type.changeReturnType(owner) : type);
    }

    private static void validateFieldType(MethodTypeDesc type, boolean isSetter, boolean isVirtual) {
        boolean isVoid = type.returnType().descriptorString().equals("V");
        int expectedParams = (isSetter ? 1 : 0) + (isVirtual ? 1 : 0);
        if (isVoid != isSetter || type.parameterCount() != expectedParams || isVirtual && type.parameterType(0).isPrimitive()) {
            String expectedType = String.format("(%s%s)%s", isVirtual ? "R" : "", isSetter ? "T" : "", isSetter ? "V" : "T");
            throw new IllegalArgumentException(String.format("Expected type of %s for getter, found %s", expectedType, type));
        }
    }

    private static void validateConstructor(MethodTypeDesc type) {
        if (!type.returnType().descriptorString().equals("V")) {
            throw new IllegalArgumentException(String.format("Expected type of (T*)V for constructor, found %s", type));
        }
    }

    @Override
    public DirectMethodHandleDesc.Kind kind() {
        return this.kind;
    }

    @Override
    public int refKind() {
        return this.kind.refKind;
    }

    @Override
    public boolean isOwnerInterface() {
        return this.kind.isInterface;
    }

    @Override
    public ClassDesc owner() {
        return this.owner;
    }

    @Override
    public String methodName() {
        return this.name;
    }

    @Override
    public MethodTypeDesc invocationType() {
        return this.invocationType;
    }

    @Override
    public String lookupDescriptor() {
        return switch (this.kind) {
            case DirectMethodHandleDesc.Kind.VIRTUAL, DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> this.invocationType.dropParameterTypes(0, 1).descriptorString();
            case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.INTERFACE_STATIC -> this.invocationType.descriptorString();
            case DirectMethodHandleDesc.Kind.CONSTRUCTOR -> this.invocationType.changeReturnType(ConstantDescs.CD_void).descriptorString();
            case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER -> this.invocationType.returnType().descriptorString();
            case DirectMethodHandleDesc.Kind.SETTER -> this.invocationType.parameterType(1).descriptorString();
            case DirectMethodHandleDesc.Kind.STATIC_SETTER -> this.invocationType.parameterType(0).descriptorString();
            default -> throw new IllegalStateException(this.kind.toString());
        };
    }

    @Override
    public MethodHandle resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        Class resolvedOwner = (Class)this.owner.resolveConstantDesc(lookup);
        MethodType invocationType = (MethodType)this.invocationType().resolveConstantDesc(lookup);
        return switch (this.kind) {
            case DirectMethodHandleDesc.Kind.STATIC, DirectMethodHandleDesc.Kind.INTERFACE_STATIC -> lookup.findStatic(resolvedOwner, this.name, invocationType);
            case DirectMethodHandleDesc.Kind.VIRTUAL, DirectMethodHandleDesc.Kind.INTERFACE_VIRTUAL -> lookup.findVirtual(resolvedOwner, this.name, invocationType.dropParameterTypes(0, 1));
            case DirectMethodHandleDesc.Kind.SPECIAL, DirectMethodHandleDesc.Kind.INTERFACE_SPECIAL -> lookup.findSpecial(resolvedOwner, this.name, invocationType.dropParameterTypes(0, 1), lookup.lookupClass());
            case DirectMethodHandleDesc.Kind.CONSTRUCTOR -> lookup.findConstructor(resolvedOwner, invocationType.changeReturnType(Void.TYPE));
            case DirectMethodHandleDesc.Kind.GETTER -> lookup.findGetter(resolvedOwner, this.name, (Class<?>)invocationType.returnType());
            case DirectMethodHandleDesc.Kind.STATIC_GETTER -> lookup.findStaticGetter(resolvedOwner, this.name, (Class<?>)invocationType.returnType());
            case DirectMethodHandleDesc.Kind.SETTER -> lookup.findSetter(resolvedOwner, this.name, (Class<?>)invocationType.parameterType(1));
            case DirectMethodHandleDesc.Kind.STATIC_SETTER -> lookup.findStaticSetter(resolvedOwner, this.name, (Class<?>)invocationType.parameterType(0));
            default -> throw new IllegalStateException(this.kind.name());
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectMethodHandleDescImpl desc = (DirectMethodHandleDescImpl)o;
        return this.kind == desc.kind && Objects.equals(this.owner, desc.owner) && Objects.equals(this.name, desc.name) && Objects.equals(this.invocationType, desc.invocationType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.owner, this.name, this.invocationType});
    }

    public String toString() {
        return String.format("MethodHandleDesc[%s/%s::%s%s]", new Object[]{this.kind, this.owner.displayName(), this.name, this.invocationType.displayDescriptor()});
    }
}

