/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.ConstantUtils;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DynamicCallSiteDesc {
    private final DirectMethodHandleDesc bootstrapMethod;
    private final ConstantDesc[] bootstrapArgs;
    private final String invocationName;
    private final MethodTypeDesc invocationType;

    private DynamicCallSiteDesc(DirectMethodHandleDesc bootstrapMethod, String invocationName, MethodTypeDesc invocationType, ConstantDesc[] bootstrapArgs) {
        this.invocationName = ConstantUtils.validateMemberName(Objects.requireNonNull(invocationName), true);
        this.invocationType = Objects.requireNonNull(invocationType);
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod);
        this.bootstrapArgs = Objects.requireNonNull((ConstantDesc[])bootstrapArgs.clone());
        for (int i = 0; i < this.bootstrapArgs.length; ++i) {
            Objects.requireNonNull(this.bootstrapArgs[i]);
        }
        if (invocationName.length() == 0) {
            throw new IllegalArgumentException("Illegal invocation name: " + invocationName);
        }
    }

    public static DynamicCallSiteDesc of(DirectMethodHandleDesc bootstrapMethod, String invocationName, MethodTypeDesc invocationType, ConstantDesc ... bootstrapArgs) {
        return new DynamicCallSiteDesc(bootstrapMethod, invocationName, invocationType, bootstrapArgs);
    }

    public static DynamicCallSiteDesc of(DirectMethodHandleDesc bootstrapMethod, String invocationName, MethodTypeDesc invocationType) {
        return new DynamicCallSiteDesc(bootstrapMethod, invocationName, invocationType, ConstantUtils.EMPTY_CONSTANTDESC);
    }

    public static DynamicCallSiteDesc of(DirectMethodHandleDesc bootstrapMethod, MethodTypeDesc invocationType) {
        return DynamicCallSiteDesc.of(bootstrapMethod, "_", invocationType);
    }

    public DynamicCallSiteDesc withArgs(ConstantDesc ... bootstrapArgs) {
        return new DynamicCallSiteDesc(this.bootstrapMethod, this.invocationName, this.invocationType, bootstrapArgs);
    }

    public DynamicCallSiteDesc withNameAndType(String invocationName, MethodTypeDesc invocationType) {
        return new DynamicCallSiteDesc(this.bootstrapMethod, invocationName, invocationType, this.bootstrapArgs);
    }

    public String invocationName() {
        return this.invocationName;
    }

    public MethodTypeDesc invocationType() {
        return this.invocationType;
    }

    public MethodHandleDesc bootstrapMethod() {
        return this.bootstrapMethod;
    }

    public ConstantDesc[] bootstrapArgs() {
        return (ConstantDesc[])this.bootstrapArgs.clone();
    }

    public CallSite resolveCallSiteDesc(MethodHandles.Lookup lookup) throws Throwable {
        assert (this.bootstrapMethod.invocationType().parameterType(1).equals(ConstantDescs.CD_String));
        MethodHandle bsm = (MethodHandle)this.bootstrapMethod.resolveConstantDesc(lookup);
        Object[] args = new Object[this.bootstrapArgs.length + 3];
        args[0] = lookup;
        args[1] = this.invocationName;
        args[2] = this.invocationType.resolveConstantDesc(lookup);
        System.arraycopy(this.bootstrapArgs, 0, args, 3, this.bootstrapArgs.length);
        return (CallSite)bsm.invokeWithArguments(args);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicCallSiteDesc specifier = (DynamicCallSiteDesc)o;
        return Objects.equals(this.bootstrapMethod, specifier.bootstrapMethod) && Arrays.equals(this.bootstrapArgs, specifier.bootstrapArgs) && Objects.equals(this.invocationName, specifier.invocationName) && Objects.equals(this.invocationType, specifier.invocationType);
    }

    public final int hashCode() {
        int result = Objects.hash(this.bootstrapMethod, this.invocationName, this.invocationType);
        result = 31 * result + Arrays.hashCode(this.bootstrapArgs);
        return result;
    }

    public String toString() {
        return String.format("DynamicCallSiteDesc[%s::%s(%s%s):%s]", this.bootstrapMethod.owner().displayName(), this.bootstrapMethod.methodName(), this.invocationName.equals("_") ? "" : this.invocationName + "/", Stream.of(this.bootstrapArgs).map(Object::toString).collect(Collectors.joining(",")), this.invocationType.displayDescriptor());
    }
}

