/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.ConstantUtils;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class DynamicConstantDesc<T>
implements ConstantDesc {
    private final DirectMethodHandleDesc bootstrapMethod;
    private final ConstantDesc[] bootstrapArgs;
    private final String constantName;
    private final ClassDesc constantType;

    protected DynamicConstantDesc(DirectMethodHandleDesc bootstrapMethod, String constantName, ClassDesc constantType, ConstantDesc ... bootstrapArgs) {
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod);
        this.constantName = ConstantUtils.validateMemberName(Objects.requireNonNull(constantName), true);
        this.constantType = Objects.requireNonNull(constantType);
        this.bootstrapArgs = (ConstantDesc[])Objects.requireNonNull(bootstrapArgs).clone();
        if (constantName.length() == 0) {
            throw new IllegalArgumentException("Illegal invocation name: " + constantName);
        }
    }

    public static <T> ConstantDesc ofCanonical(DirectMethodHandleDesc bootstrapMethod, String constantName, ClassDesc constantType, ConstantDesc[] bootstrapArgs) {
        return DynamicConstantDesc.ofNamed(bootstrapMethod, constantName, constantType, bootstrapArgs).tryCanonicalize();
    }

    public static <T> DynamicConstantDesc<T> ofNamed(DirectMethodHandleDesc bootstrapMethod, String constantName, ClassDesc constantType, ConstantDesc ... bootstrapArgs) {
        return new AnonymousDynamicConstantDesc(bootstrapMethod, constantName, constantType, bootstrapArgs);
    }

    public static <T> DynamicConstantDesc<T> of(DirectMethodHandleDesc bootstrapMethod, ConstantDesc ... bootstrapArgs) {
        return DynamicConstantDesc.ofNamed(bootstrapMethod, "_", bootstrapMethod.invocationType().returnType(), bootstrapArgs);
    }

    public static <T> DynamicConstantDesc<T> of(DirectMethodHandleDesc bootstrapMethod) {
        return DynamicConstantDesc.of(bootstrapMethod, ConstantUtils.EMPTY_CONSTANTDESC);
    }

    public String constantName() {
        return this.constantName;
    }

    public ClassDesc constantType() {
        return this.constantType;
    }

    public DirectMethodHandleDesc bootstrapMethod() {
        return this.bootstrapMethod;
    }

    public ConstantDesc[] bootstrapArgs() {
        return (ConstantDesc[])this.bootstrapArgs.clone();
    }

    public List<ConstantDesc> bootstrapArgsList() {
        return List.of(this.bootstrapArgs);
    }

    public T resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        try {
            MethodHandle bsm = (MethodHandle)this.bootstrapMethod.resolveConstantDesc(lookup);
            if (bsm.type().parameterCount() < 2 || !MethodHandles.Lookup.class.isAssignableFrom((Class<?>)bsm.type().parameterType(0))) {
                throw new BootstrapMethodError("Invalid bootstrap method declared for resolving a dynamic constant: " + this.bootstrapMethod);
            }
            Object[] bsmArgs = new Object[3 + this.bootstrapArgs.length];
            bsmArgs[0] = lookup;
            bsmArgs[1] = this.constantName;
            bsmArgs[2] = this.constantType.resolveConstantDesc(lookup);
            for (int i = 0; i < this.bootstrapArgs.length; ++i) {
                bsmArgs[3 + i] = this.bootstrapArgs[i].resolveConstantDesc(lookup);
            }
            return (T)bsm.invokeWithArguments(bsmArgs);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new BootstrapMethodError(t);
        }
    }

    private ConstantDesc tryCanonicalize() {
        Function<DynamicConstantDesc<?>, ConstantDesc> f = CanonicalMapHolder.CANONICAL_MAP.get(this.bootstrapMethod);
        if (f != null) {
            try {
                return f.apply(this);
            }
            catch (Throwable t) {
                return this;
            }
        }
        return this;
    }

    private static ConstantDesc canonicalizeNull(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 0) {
            return desc;
        }
        return ConstantDescs.NULL;
    }

    private static ConstantDesc canonicalizeEnum(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 0 || desc.constantName == null) {
            return desc;
        }
        return Enum.EnumDesc.of(desc.constantType, desc.constantName);
    }

    private static ConstantDesc canonicalizePrimitiveClass(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 0 || !desc.constantType().equals(ConstantDescs.CD_Class) || desc.constantName == null) {
            return desc;
        }
        return ClassDesc.ofDescriptor(desc.constantName);
    }

    private static ConstantDesc canonicalizeStaticFieldVarHandle(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 2 || !desc.constantType().equals(ConstantDescs.CD_VarHandle)) {
            return desc;
        }
        return VarHandle.VarHandleDesc.ofStaticField((ClassDesc)desc.bootstrapArgs[0], desc.constantName, (ClassDesc)desc.bootstrapArgs[1]);
    }

    private static ConstantDesc canonicalizeFieldVarHandle(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 2 || !desc.constantType().equals(ConstantDescs.CD_VarHandle)) {
            return desc;
        }
        return VarHandle.VarHandleDesc.ofField((ClassDesc)desc.bootstrapArgs[0], desc.constantName, (ClassDesc)desc.bootstrapArgs[1]);
    }

    private static ConstantDesc canonicalizeArrayVarHandle(DynamicConstantDesc<?> desc) {
        if (desc.bootstrapArgs.length != 1 || !desc.constantType().equals(ConstantDescs.CD_VarHandle)) {
            return desc;
        }
        return VarHandle.VarHandleDesc.ofArray((ClassDesc)desc.bootstrapArgs[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DynamicConstantDesc)) return false;
        DynamicConstantDesc desc = (DynamicConstantDesc)o;
        if (!Objects.equals(this.bootstrapMethod, desc.bootstrapMethod)) return false;
        if (!Arrays.equals(this.bootstrapArgs, desc.bootstrapArgs)) return false;
        if (!Objects.equals(this.constantName, desc.constantName)) return false;
        if (!Objects.equals(this.constantType, desc.constantType)) return false;
        return true;
    }

    public final int hashCode() {
        int result = Objects.hash(this.bootstrapMethod, this.constantName, this.constantType);
        result = 31 * result + Arrays.hashCode(this.bootstrapArgs);
        return result;
    }

    public String toString() {
        return String.format("DynamicConstantDesc[%s::%s(%s%s)%s]", this.bootstrapMethod.owner().displayName(), this.bootstrapMethod.methodName(), this.constantName.equals("_") ? "" : this.constantName + "/", Stream.of(this.bootstrapArgs).map(Object::toString).collect(Collectors.joining(",")), this.constantType.displayName());
    }

    private static class AnonymousDynamicConstantDesc<T>
    extends DynamicConstantDesc<T> {
        AnonymousDynamicConstantDesc(DirectMethodHandleDesc bootstrapMethod, String constantName, ClassDesc constantType, ConstantDesc ... bootstrapArgs) {
            super(bootstrapMethod, constantName, constantType, bootstrapArgs);
        }
    }

    private static final class CanonicalMapHolder {
        static final Map<MethodHandleDesc, Function<DynamicConstantDesc<?>, ConstantDesc>> CANONICAL_MAP = Map.ofEntries(Map.entry(ConstantDescs.BSM_PRIMITIVE_CLASS, DynamicConstantDesc::canonicalizePrimitiveClass), Map.entry(ConstantDescs.BSM_ENUM_CONSTANT, DynamicConstantDesc::canonicalizeEnum), Map.entry(ConstantDescs.BSM_NULL_CONSTANT, DynamicConstantDesc::canonicalizeNull), Map.entry(ConstantDescs.BSM_VARHANDLE_STATIC_FIELD, DynamicConstantDesc::canonicalizeStaticFieldVarHandle), Map.entry(ConstantDescs.BSM_VARHANDLE_FIELD, DynamicConstantDesc::canonicalizeFieldVarHandle), Map.entry(ConstantDescs.BSM_VARHANDLE_ARRAY, DynamicConstantDesc::canonicalizeArrayVarHandle));

        private CanonicalMapHolder() {
        }
    }
}

