/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.AsTypeMethodHandleDesc;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DirectMethodHandleDescImpl;
import java.lang.constant.MethodTypeDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodHandleDesc
extends ConstantDesc {
    public static DirectMethodHandleDesc of(DirectMethodHandleDesc.Kind kind, ClassDesc owner, String name, String lookupDescriptor) {
        switch (kind) {
            case GETTER: 
            case SETTER: 
            case STATIC_GETTER: 
            case STATIC_SETTER: {
                return MethodHandleDesc.ofField(kind, owner, name, ClassDesc.ofDescriptor(lookupDescriptor));
            }
        }
        return new DirectMethodHandleDescImpl(kind, owner, name, MethodTypeDesc.ofDescriptor(lookupDescriptor));
    }

    public static DirectMethodHandleDesc ofMethod(DirectMethodHandleDesc.Kind kind, ClassDesc owner, String name, MethodTypeDesc lookupMethodType) {
        switch (kind) {
            case GETTER: 
            case SETTER: 
            case STATIC_GETTER: 
            case STATIC_SETTER: {
                throw new IllegalArgumentException(kind.toString());
            }
            case VIRTUAL: 
            case SPECIAL: 
            case INTERFACE_VIRTUAL: 
            case INTERFACE_SPECIAL: 
            case INTERFACE_STATIC: 
            case STATIC: 
            case CONSTRUCTOR: {
                return new DirectMethodHandleDescImpl(kind, owner, name, lookupMethodType);
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    public static DirectMethodHandleDesc ofField(DirectMethodHandleDesc.Kind kind, ClassDesc owner, String fieldName, ClassDesc fieldType) {
        MethodTypeDesc mtr = switch (kind) {
            case DirectMethodHandleDesc.Kind.GETTER -> MethodTypeDesc.of(fieldType, owner);
            case DirectMethodHandleDesc.Kind.SETTER -> MethodTypeDesc.of(ConstantDescs.CD_void, owner, fieldType);
            case DirectMethodHandleDesc.Kind.STATIC_GETTER -> MethodTypeDesc.of(fieldType, new ClassDesc[0]);
            case DirectMethodHandleDesc.Kind.STATIC_SETTER -> MethodTypeDesc.of(ConstantDescs.CD_void, fieldType);
            default -> throw new IllegalArgumentException(kind.toString());
        };
        return new DirectMethodHandleDescImpl(kind, owner, fieldName, mtr);
    }

    public static DirectMethodHandleDesc ofConstructor(ClassDesc owner, ClassDesc ... paramTypes) {
        return MethodHandleDesc.ofMethod(DirectMethodHandleDesc.Kind.CONSTRUCTOR, owner, "_", MethodTypeDesc.of(ConstantDescs.CD_void, paramTypes));
    }

    default public MethodHandleDesc asType(MethodTypeDesc type) {
        return this.invocationType().equals(type) ? this : new AsTypeMethodHandleDesc(this, type);
    }

    public MethodTypeDesc invocationType();

    public boolean equals(Object var1);
}

