/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.MethodTypeDescImpl;
import java.lang.invoke.TypeDescriptor;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodTypeDesc
extends ConstantDesc,
TypeDescriptor.OfMethod<ClassDesc, MethodTypeDesc> {
    public static MethodTypeDesc ofDescriptor(String descriptor) {
        return MethodTypeDescImpl.ofDescriptor(descriptor);
    }

    public static MethodTypeDesc of(ClassDesc returnDesc, ClassDesc ... paramDescs) {
        return new MethodTypeDescImpl(returnDesc, paramDescs);
    }

    @Override
    public ClassDesc returnType();

    @Override
    public int parameterCount();

    @Override
    public ClassDesc parameterType(int var1);

    @Override
    public List<ClassDesc> parameterList();

    public ClassDesc[] parameterArray();

    @Override
    public MethodTypeDesc changeReturnType(ClassDesc var1);

    @Override
    public MethodTypeDesc changeParameterType(int var1, ClassDesc var2);

    @Override
    public MethodTypeDesc dropParameterTypes(int var1, int var2);

    public MethodTypeDesc insertParameterTypes(int var1, ClassDesc ... var2);

    @Override
    default public String descriptorString() {
        return String.format("(%s)%s", Stream.of(this.parameterArray()).map(ClassDesc::descriptorString).collect(Collectors.joining()), this.returnType().descriptorString());
    }

    default public String displayDescriptor() {
        return String.format("(%s)%s", Stream.of(this.parameterArray()).map(ClassDesc::displayName).collect(Collectors.joining(",")), this.returnType().displayName());
    }

    public boolean equals(Object var1);
}

