/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantUtils;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class MethodTypeDescImpl
implements MethodTypeDesc {
    private final ClassDesc returnType;
    private final ClassDesc[] argTypes;

    MethodTypeDescImpl(ClassDesc returnType, ClassDesc[] argTypes) {
        this.returnType = Objects.requireNonNull(returnType);
        this.argTypes = Objects.requireNonNull(argTypes);
        for (ClassDesc cr : argTypes) {
            if (!cr.isPrimitive() || !cr.descriptorString().equals("V")) continue;
            throw new IllegalArgumentException("Void parameters not permitted");
        }
    }

    static MethodTypeDescImpl ofDescriptor(String descriptor) {
        Objects.requireNonNull(descriptor);
        List<String> types = ConstantUtils.parseMethodDescriptor(descriptor);
        ClassDesc[] paramTypes = (ClassDesc[])types.stream().skip(1L).map(ClassDesc::ofDescriptor).toArray(ClassDesc[]::new);
        return new MethodTypeDescImpl(ClassDesc.ofDescriptor(types.get(0)), paramTypes);
    }

    @Override
    public ClassDesc returnType() {
        return this.returnType;
    }

    @Override
    public int parameterCount() {
        return this.argTypes.length;
    }

    @Override
    public ClassDesc parameterType(int index) {
        return this.argTypes[index];
    }

    @Override
    public List<ClassDesc> parameterList() {
        return List.of(this.argTypes);
    }

    @Override
    public ClassDesc[] parameterArray() {
        return (ClassDesc[])this.argTypes.clone();
    }

    @Override
    public MethodTypeDesc changeReturnType(ClassDesc returnType) {
        return MethodTypeDesc.of(returnType, this.argTypes);
    }

    @Override
    public MethodTypeDesc changeParameterType(int index, ClassDesc paramType) {
        ClassDesc[] newArgs = (ClassDesc[])this.argTypes.clone();
        newArgs[index] = paramType;
        return MethodTypeDesc.of(this.returnType, newArgs);
    }

    @Override
    public MethodTypeDesc dropParameterTypes(int start, int end) {
        if (start < 0 || start >= this.argTypes.length || end < 0 || end > this.argTypes.length || start > end) {
            throw new IndexOutOfBoundsException();
        }
        ClassDesc[] newArgs = new ClassDesc[this.argTypes.length - (end - start)];
        System.arraycopy(this.argTypes, 0, newArgs, 0, start);
        System.arraycopy(this.argTypes, end, newArgs, start, this.argTypes.length - end);
        return MethodTypeDesc.of(this.returnType, newArgs);
    }

    @Override
    public MethodTypeDesc insertParameterTypes(int pos, ClassDesc ... paramTypes) {
        if (pos < 0 || pos > this.argTypes.length) {
            throw new IndexOutOfBoundsException(pos);
        }
        ClassDesc[] newArgs = new ClassDesc[this.argTypes.length + paramTypes.length];
        System.arraycopy(this.argTypes, 0, newArgs, 0, pos);
        System.arraycopy(paramTypes, 0, newArgs, pos, paramTypes.length);
        System.arraycopy(this.argTypes, pos, newArgs, pos + paramTypes.length, this.argTypes.length - pos);
        return MethodTypeDesc.of(this.returnType, newArgs);
    }

    @Override
    public MethodType resolveConstantDesc(final MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        MethodType mtype = AccessController.doPrivileged(new PrivilegedAction<MethodType>(){

            @Override
            public MethodType run() {
                return MethodType.fromMethodDescriptorString(MethodTypeDescImpl.this.descriptorString(), lookup.lookupClass().getClassLoader());
            }
        });
        lookup.accessClass((Class<?>)mtype.returnType());
        for (Class<?> paramType : mtype.parameterArray()) {
            lookup.accessClass(paramType);
        }
        return mtype;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodTypeDescImpl constant = (MethodTypeDescImpl)o;
        return this.returnType.equals(constant.returnType) && Arrays.equals(this.argTypes, constant.argTypes);
    }

    public int hashCode() {
        int result = this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.argTypes);
        return result;
    }

    public String toString() {
        return String.format("MethodTypeDesc[%s]", this.displayDescriptor());
    }
}

