/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import sun.invoke.util.Wrapper;

final class PrimitiveClassDescImpl
extends DynamicConstantDesc<Class<?>>
implements ClassDesc {
    private final String descriptor;

    PrimitiveClassDescImpl(String descriptor) {
        super(ConstantDescs.BSM_PRIMITIVE_CLASS, Objects.requireNonNull(descriptor), ConstantDescs.CD_Class, new ConstantDesc[0]);
        if (descriptor.length() != 1 || "VIJCSBFDZ".indexOf(descriptor.charAt(0)) < 0) {
            throw new IllegalArgumentException(String.format("not a valid primitive type descriptor: %s", descriptor));
        }
        this.descriptor = descriptor;
    }

    @Override
    public String descriptorString() {
        return this.descriptor;
    }

    @Override
    public Class<?> resolveConstantDesc(MethodHandles.Lookup lookup) {
        return Wrapper.forBasicType(this.descriptorString().charAt(0)).primitiveType();
    }

    @Override
    public String toString() {
        return String.format("PrimitiveClassDesc[%s]", this.displayName());
    }
}

