/*
 * Decompiled with CFR 0.152.
 */
package java.lang.constant;

import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantUtils;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;

final class ReferenceClassDescImpl
implements ClassDesc {
    private final String descriptor;

    ReferenceClassDescImpl(String descriptor) {
        Objects.requireNonNull(descriptor);
        int len = ConstantUtils.skipOverFieldSignature(descriptor, 0, descriptor.length(), false);
        if (len == 0 || len == 1 || len != descriptor.length()) {
            throw new IllegalArgumentException(String.format("not a valid reference type descriptor: %s", descriptor));
        }
        this.descriptor = descriptor;
    }

    @Override
    public String descriptorString() {
        return this.descriptor;
    }

    @Override
    public Class<?> resolveConstantDesc(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
        ClassDesc c = this;
        int depth = ConstantUtils.arrayDepth(this.descriptorString());
        for (int i = 0; i < depth; ++i) {
            c = c.componentType();
        }
        if (c.isPrimitive()) {
            return lookup.findClass(this.descriptorString());
        }
        TypeDescriptor.OfField<Class<?>> clazz = lookup.findClass(ConstantUtils.internalToBinary(ConstantUtils.dropFirstAndLastChar(c.descriptorString())));
        for (int i = 0; i < depth; ++i) {
            clazz = clazz.arrayType();
        }
        return clazz;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDesc constant = (ClassDesc)o;
        return this.descriptor.equals(constant.descriptorString());
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public String toString() {
        return String.format("ClassDesc[%s]", this.displayName());
    }
}

