/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BootstrapCallInfo;
import java.lang.invoke.ConstantGroup;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jdk.internal.vm.annotation.Stable;

abstract class AbstractConstantGroup
implements ConstantGroup {
    protected final int size;

    AbstractConstantGroup(int size) {
        this.size = size;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public abstract Object get(int var1) throws LinkageError;

    @Override
    public abstract Object get(int var1, Object var2);

    @Override
    public abstract boolean isPresent(int var1);

    public String toString() {
        return this.asList("*").toString();
    }

    static class BSCIWithCache<T>
    extends WithCache
    implements BootstrapCallInfo<T> {
        private final MethodHandle bsm;
        private final String name;
        private final T type;

        @Override
        public String toString() {
            return this.bsm + "/" + this.name + ":" + this.type + super.toString();
        }

        BSCIWithCache(MethodHandle bsm, String name, T type, int size) {
            super(size);
            this.type = type;
            this.bsm = bsm;
            this.name = name;
            assert (type instanceof Class || type instanceof MethodType);
        }

        @Override
        public MethodHandle bootstrapMethod() {
            return this.bsm;
        }

        @Override
        public String invocationName() {
            return this.name;
        }

        @Override
        public T invocationType() {
            return this.type;
        }
    }

    static abstract class WithCache
    extends AbstractConstantGroup {
        @Stable
        final Object[] cache;
        static final Object RESOLVED_TO_NULL = new Object();
        static final Object NOT_PRESENT = new Object();

        WithCache(int size) {
            super(size);
            this.cache = new Object[size];
        }

        void initializeCache(List<Object> cacheContents, Object ifNotPresent) {
            for (int i = 0; i < this.cache.length; ++i) {
                Object x = cacheContents.get(i);
                if (x == ifNotPresent) continue;
                if (x == null) {
                    x = RESOLVED_TO_NULL;
                }
                this.cache[i] = x;
            }
        }

        @Override
        public Object get(int i) {
            Object x = this.cache[i];
            if (x == null) {
                x = this.fillCache(i);
            }
            return WithCache.unwrapNull(x);
        }

        @Override
        public Object get(int i, Object ifNotAvailable) {
            Object x = this.cache[i];
            if (x == null) {
                return ifNotAvailable;
            }
            return WithCache.unwrapNull(x);
        }

        @Override
        public boolean isPresent(int i) {
            return this.cache[i] != null;
        }

        Object fillCache(int i) {
            throw new NoSuchElementException("constant group does not contain element #" + i);
        }

        static Object wrapNull(Object x) {
            return x == null ? RESOLVED_TO_NULL : x;
        }

        static Object unwrapNull(Object x) {
            assert (x != null);
            return x == RESOLVED_TO_NULL ? null : x;
        }
    }

    static class AsList
    extends AbstractList<Object> {
        private final ConstantGroup self;
        private final int size;
        private final int offset;
        private final boolean resolving;
        private final Object ifNotPresent;

        private AsList(ConstantGroup self, int start, int end, boolean resolving, Object ifNotPresent) {
            this.self = self;
            this.size = end - start;
            this.offset = start;
            this.resolving = resolving;
            this.ifNotPresent = ifNotPresent;
            MethodHandleStatics.rangeCheck2(start, end, self.size());
        }

        AsList(ConstantGroup self, int start, int end) {
            this(self, start, end, true, null);
        }

        AsList(ConstantGroup self, int start, int end, Object ifNotPresent) {
            this(self, start, end, false, ifNotPresent);
        }

        private int mapIndex(int index) {
            return MethodHandleStatics.rangeCheck1(index, this.size) + this.offset;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public Object get(int index) {
            if (this.resolving) {
                return this.self.get(this.mapIndex(index));
            }
            return this.self.get(this.mapIndex(index), this.ifNotPresent);
        }

        @Override
        public Iterator<Object> iterator() {
            if (this.resolving) {
                return new AsIterator(this.self, this.offset, this.offset + this.size);
            }
            return new AsIterator(this.self, this.offset, this.offset + this.size, this.ifNotPresent);
        }

        @Override
        public List<Object> subList(int start, int end) {
            MethodHandleStatics.rangeCheck2(start, end, this.size);
            return new AsList(this.self, this.offset + start, this.offset + end, this.resolving, this.ifNotPresent);
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int pad = a.length - this.size;
            if (pad < 0) {
                pad = 0;
                a = Arrays.copyOf(a, this.size);
            }
            if (this.resolving) {
                this.self.copyConstants(this.offset, this.offset + this.size, a, 0);
            } else {
                this.self.copyConstants(this.offset, this.offset + this.size, a, 0, this.ifNotPresent);
            }
            if (pad > 0) {
                a[this.size] = null;
            }
            return a;
        }
    }

    static class SubGroup
    extends AbstractConstantGroup {
        private final ConstantGroup self;
        private final int offset;

        SubGroup(ConstantGroup self, int start, int end) {
            super(end - start);
            this.self = self;
            this.offset = start;
            MethodHandleStatics.rangeCheck2(start, end, this.size);
        }

        private int mapIndex(int index) {
            return MethodHandleStatics.rangeCheck1(index, this.size) + this.offset;
        }

        @Override
        public Object get(int index) {
            return this.self.get(this.mapIndex(index));
        }

        @Override
        public Object get(int index, Object ifNotPresent) {
            return this.self.get(this.mapIndex(index), ifNotPresent);
        }

        @Override
        public boolean isPresent(int index) {
            return this.self.isPresent(this.mapIndex(index));
        }

        @Override
        public ConstantGroup subGroup(int start, int end) {
            MethodHandleStatics.rangeCheck2(start, end, this.size);
            return new SubGroup(this.self, this.offset + start, this.offset + end);
        }

        @Override
        public List<Object> asList() {
            return new AsList(this.self, this.offset, this.offset + this.size);
        }

        @Override
        public List<Object> asList(Object ifNotPresent) {
            return new AsList(this.self, this.offset, this.offset + this.size, ifNotPresent);
        }

        @Override
        public int copyConstants(int start, int end, Object[] buf, int pos) throws LinkageError {
            MethodHandleStatics.rangeCheck2(start, end, this.size);
            return this.self.copyConstants(this.offset + start, this.offset + end, buf, pos);
        }

        @Override
        public int copyConstants(int start, int end, Object[] buf, int pos, Object ifNotPresent) {
            MethodHandleStatics.rangeCheck2(start, end, this.size);
            return this.self.copyConstants(this.offset + start, this.offset + end, buf, pos, ifNotPresent);
        }
    }

    static class AsIterator
    implements Iterator<Object> {
        private final ConstantGroup self;
        private final int end;
        private final boolean resolving;
        private final Object ifNotPresent;
        private int index;

        private AsIterator(ConstantGroup self, int start, int end, boolean resolving, Object ifNotPresent) {
            this.self = self;
            this.end = end;
            this.index = start;
            this.resolving = resolving;
            this.ifNotPresent = ifNotPresent;
        }

        AsIterator(ConstantGroup self, int start, int end) {
            this(self, start, end, true, null);
        }

        AsIterator(ConstantGroup self, int start, int end, Object ifNotPresent) {
            this(self, start, end, false, ifNotPresent);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.end;
        }

        @Override
        public Object next() {
            int i = this.bumpIndex();
            if (this.resolving) {
                return this.self.get(i);
            }
            return this.self.get(i, this.ifNotPresent);
        }

        private int bumpIndex() {
            int i = this.index;
            if (i >= this.end) {
                throw new NoSuchElementException();
            }
            this.index = i + 1;
            return i;
        }
    }
}

