/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Modifier;
import sun.invoke.util.Wrapper;

abstract class AbstractValidatingLambdaMetafactory {
    final MethodHandles.Lookup caller;
    final Class<?> targetClass;
    final MethodType factoryType;
    final Class<?> interfaceClass;
    final String interfaceMethodName;
    final MethodType interfaceMethodType;
    final MethodHandle implementation;
    final MethodType implMethodType;
    final MethodHandleInfo implInfo;
    final int implKind;
    final boolean implIsInstanceMethod;
    final Class<?> implClass;
    final MethodType dynamicMethodType;
    final boolean isSerializable;
    final Class<?>[] altInterfaces;
    final MethodType[] altMethods;

    AbstractValidatingLambdaMetafactory(MethodHandles.Lookup caller, MethodType factoryType, String interfaceMethodName, MethodType interfaceMethodType, MethodHandle implementation, MethodType dynamicMethodType, boolean isSerializable, Class<?>[] altInterfaces, MethodType[] altMethods) throws LambdaConversionException {
        if (!caller.hasFullPrivilegeAccess()) {
            throw new LambdaConversionException(String.format("Invalid caller: %s", caller.lookupClass().getName()));
        }
        this.caller = caller;
        this.targetClass = caller.lookupClass();
        this.factoryType = factoryType;
        this.interfaceClass = factoryType.returnType();
        this.interfaceMethodName = interfaceMethodName;
        this.interfaceMethodType = interfaceMethodType;
        this.implementation = implementation;
        this.implMethodType = implementation.type();
        try {
            this.implInfo = caller.revealDirect(implementation);
        }
        catch (IllegalArgumentException e) {
            throw new LambdaConversionException(implementation + " is not direct or cannot be cracked");
        }
        switch (this.implInfo.getReferenceKind()) {
            case 5: 
            case 9: {
                this.implClass = this.implMethodType.parameterType(0);
                this.implKind = this.implClass.isInterface() ? 9 : 5;
                this.implIsInstanceMethod = true;
                break;
            }
            case 7: {
                this.implClass = this.implInfo.getDeclaringClass();
                this.implIsInstanceMethod = true;
                if (this.targetClass == this.implClass && Modifier.isPrivate(this.implInfo.getModifiers())) {
                    this.implKind = this.implClass.isInterface() ? 9 : 5;
                    break;
                }
                this.implKind = 7;
                break;
            }
            case 6: 
            case 8: {
                this.implClass = this.implInfo.getDeclaringClass();
                this.implKind = this.implInfo.getReferenceKind();
                this.implIsInstanceMethod = false;
                break;
            }
            default: {
                throw new LambdaConversionException(String.format("Unsupported MethodHandle kind: %s", this.implInfo));
            }
        }
        this.dynamicMethodType = dynamicMethodType;
        this.isSerializable = isSerializable;
        this.altInterfaces = altInterfaces;
        this.altMethods = altMethods;
        if (interfaceMethodName.isEmpty() || interfaceMethodName.indexOf(46) >= 0 || interfaceMethodName.indexOf(59) >= 0 || interfaceMethodName.indexOf(91) >= 0 || interfaceMethodName.indexOf(47) >= 0 || interfaceMethodName.indexOf(60) >= 0 || interfaceMethodName.indexOf(62) >= 0) {
            throw new LambdaConversionException(String.format("Method name '%s' is not legal", interfaceMethodName));
        }
        if (!this.interfaceClass.isInterface()) {
            throw new LambdaConversionException(String.format("%s is not an interface", this.interfaceClass.getName()));
        }
        for (Class<?> c : altInterfaces) {
            if (c.isInterface()) continue;
            throw new LambdaConversionException(String.format("%s is not an interface", c.getName()));
        }
    }

    abstract CallSite buildCallSite() throws LambdaConversionException;

    void validateMetafactoryArgs() throws LambdaConversionException {
        TypeDescriptor.OfField implParamType;
        int i;
        int implArity = this.implMethodType.parameterCount();
        int capturedArity = this.factoryType.parameterCount();
        int samArity = this.interfaceMethodType.parameterCount();
        int dynamicArity = this.dynamicMethodType.parameterCount();
        if (implArity != capturedArity + samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d captured parameters, %d functional interface method parameters, %d implementation parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, capturedArity, samArity, implArity));
        }
        if (dynamicArity != samArity) {
            throw new LambdaConversionException(String.format("Incorrect number of parameters for %s method %s; %d dynamic parameters, %d functional interface method parameters", this.implIsInstanceMethod ? "instance" : "static", this.implInfo, dynamicArity, samArity));
        }
        for (MethodType bridgeMT : this.altMethods) {
            if (bridgeMT.parameterCount() == samArity) continue;
            throw new LambdaConversionException(String.format("Incorrect number of parameters for bridge signature %s; incompatible with %s", bridgeMT, this.interfaceMethodType));
        }
        if (this.implIsInstanceMethod) {
            TypeDescriptor.OfField receiverClass;
            if (capturedArity == 0) {
                capturedStart = 0;
                samStart = 1;
                receiverClass = this.dynamicMethodType.parameterType(0);
            } else {
                capturedStart = 1;
                samStart = capturedArity;
                receiverClass = this.factoryType.parameterType(0);
            }
            if (!this.implClass.isAssignableFrom((Class<?>)receiverClass)) {
                throw new LambdaConversionException(String.format("Invalid receiver type %s; not a subtype of implementation type %s", receiverClass, this.implClass));
            }
        } else {
            capturedStart = 0;
            samStart = capturedArity;
        }
        for (i = capturedStart; i < capturedArity; ++i) {
            implParamType = this.implMethodType.parameterType(i);
            TypeDescriptor.OfField capturedParamType = this.factoryType.parameterType(i);
            if (capturedParamType.equals(implParamType)) continue;
            throw new LambdaConversionException(String.format("Type mismatch in captured lambda parameter %d: expecting %s, found %s", i, capturedParamType, implParamType));
        }
        for (i = samStart; i < implArity; ++i) {
            implParamType = this.implMethodType.parameterType(i);
            TypeDescriptor.OfField dynamicParamType = this.dynamicMethodType.parameterType(i - capturedArity);
            if (this.isAdaptableTo((Class<?>)dynamicParamType, (Class<?>)implParamType, true)) continue;
            throw new LambdaConversionException(String.format("Type mismatch for lambda argument %d: %s is not convertible to %s", i, dynamicParamType, implParamType));
        }
        TypeDescriptor.OfField expectedType = this.dynamicMethodType.returnType();
        TypeDescriptor.OfField actualReturnType = this.implMethodType.returnType();
        if (!this.isAdaptableToAsReturn((Class<?>)actualReturnType, (Class<?>)expectedType)) {
            throw new LambdaConversionException(String.format("Type mismatch for lambda return: %s is not convertible to %s", actualReturnType, expectedType));
        }
        this.checkDescriptor(this.interfaceMethodType);
        for (MethodType bridgeMT : this.altMethods) {
            this.checkDescriptor(bridgeMT);
        }
    }

    private void checkDescriptor(MethodType descriptor) throws LambdaConversionException {
        TypeDescriptor.OfField descriptorReturnType;
        for (int i = 0; i < this.dynamicMethodType.parameterCount(); ++i) {
            TypeDescriptor.OfField dynamicParamType = this.dynamicMethodType.parameterType(i);
            TypeDescriptor.OfField descriptorParamType = descriptor.parameterType(i);
            if (((Class)descriptorParamType).isAssignableFrom((Class<?>)dynamicParamType)) continue;
            String msg = String.format("Type mismatch for dynamic parameter %d: %s is not a subtype of %s", i, dynamicParamType, descriptorParamType);
            throw new LambdaConversionException(msg);
        }
        TypeDescriptor.OfField dynamicReturnType = this.dynamicMethodType.returnType();
        if (!this.isAdaptableToAsReturnStrict((Class<?>)dynamicReturnType, (Class<?>)(descriptorReturnType = descriptor.returnType()))) {
            String msg = String.format("Type mismatch for lambda expected return: %s is not convertible to %s", dynamicReturnType, descriptorReturnType);
            throw new LambdaConversionException(msg);
        }
    }

    private boolean isAdaptableTo(Class<?> fromType, Class<?> toType, boolean strict) {
        if (fromType.equals(toType)) {
            return true;
        }
        if (fromType.isPrimitive()) {
            Wrapper wfrom = Wrapper.forPrimitiveType(fromType);
            if (toType.isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return toType.isAssignableFrom(wfrom.wrapperType());
        }
        if (toType.isPrimitive()) {
            Wrapper wfrom;
            if (Wrapper.isWrapperType(fromType) && (wfrom = Wrapper.forWrapperType(fromType)).primitiveType().isPrimitive()) {
                Wrapper wto = Wrapper.forPrimitiveType(toType);
                return wto.isConvertibleFrom(wfrom);
            }
            return !strict;
        }
        return !strict || toType.isAssignableFrom(fromType);
    }

    private boolean isAdaptableToAsReturn(Class<?> fromType, Class<?> toType) {
        return toType.equals(Void.TYPE) || !fromType.equals(Void.TYPE) && this.isAdaptableTo(fromType, toType, false);
    }

    private boolean isAdaptableToAsReturnStrict(Class<?> fromType, Class<?> toType) {
        if (fromType.equals(Void.TYPE) || toType.equals(Void.TYPE)) {
            return fromType.equals(toType);
        }
        return this.isAdaptableTo(fromType, toType, true);
    }
}

