/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.AbstractConstantGroup;
import java.lang.invoke.BootstrapCallInfo;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantGroup;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import sun.invoke.util.Wrapper;

final class BootstrapMethodInvoker {
    private static final MethodType LMF_INDY_MT = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, MethodType.class, MethodHandle.class, MethodType.class);
    private static final MethodType LMF_ALT_MT = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
    private static final MethodType LMF_CONDY_MT = MethodType.methodType(Object.class, MethodHandles.Lookup.class, String.class, Class.class, MethodType.class, MethodHandle.class, MethodType.class);
    private static final MethodType SCF_MT = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Object[].class);

    BootstrapMethodInvoker() {
    }

    static <T> T invoke(Class<T> resultType, MethodHandle bootstrapMethod, String name, Object type, Object info, Class<?> callerClass) {
        MethodHandle pullModeBSM;
        boolean vmIsPushing;
        MethodHandles.Lookup caller = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
        boolean pullMode = MethodHandleNatives.isPullModeBSM(bootstrapMethod);
        boolean bl = vmIsPushing = !MethodHandleNatives.staticArgumentsPulled(info);
        if (vmIsPushing) {
            pullModeBSM = null;
            if (pullMode) {
                bootstrapMethod = BootstrapMethodInvoker.pushMePullYou(bootstrapMethod, true);
            }
        } else {
            pullModeBSM = pullMode ? bootstrapMethod : BootstrapMethodInvoker.pushMePullYou(bootstrapMethod, false);
            bootstrapMethod = null;
        }
        try {
            Object result;
            if (info == null) {
                if (type instanceof Class) {
                    Class c = (Class)type;
                    result = bootstrapMethod.invoke(caller, name, c);
                } else {
                    result = bootstrapMethod.invoke(caller, name, (MethodType)type);
                }
            } else if (!info.getClass().isArray()) {
                if (BootstrapMethodInvoker.isStringConcatFactoryBSM(bootstrapMethod.type())) {
                    result = bootstrapMethod.invokeExact(caller, name, (MethodType)type, (String)info, new Object[0]);
                } else {
                    info = BootstrapMethodInvoker.maybeReBox(info);
                    if (type instanceof Class) {
                        Class c = (Class)type;
                        result = bootstrapMethod.invoke(caller, name, c, info);
                    } else {
                        result = bootstrapMethod.invoke(caller, name, (MethodType)type, info);
                    }
                }
            } else if (info.getClass() == int[].class) {
                VM_BSCI<Object> bsci = new VM_BSCI<Object>(bootstrapMethod, name, type, caller, (int[])info);
                result = pullModeBSM.invoke(caller, bsci);
            } else {
                Object[] argv = (Object[])info;
                MethodType bsmType = bootstrapMethod.type();
                if (BootstrapMethodInvoker.isLambdaMetafactoryIndyBSM(bsmType) && argv.length == 3) {
                    result = bootstrapMethod.invokeExact(caller, name, (MethodType)type, (MethodType)argv[0], (MethodHandle)argv[1], (MethodType)argv[2]);
                } else if (BootstrapMethodInvoker.isLambdaMetafactoryCondyBSM(bsmType) && argv.length == 3) {
                    result = bootstrapMethod.invokeExact(caller, name, (Class)type, (MethodType)argv[0], (MethodHandle)argv[1], (MethodType)argv[2]);
                } else if (BootstrapMethodInvoker.isStringConcatFactoryBSM(bsmType) && argv.length >= 1) {
                    String recipe = (String)argv[0];
                    Object[] shiftedArgs = Arrays.copyOfRange(argv, 1, argv.length);
                    BootstrapMethodInvoker.maybeReBoxElements(shiftedArgs);
                    result = bootstrapMethod.invokeExact(caller, name, (MethodType)type, recipe, shiftedArgs);
                } else if (BootstrapMethodInvoker.isLambdaMetafactoryAltMetafactoryBSM(bsmType)) {
                    BootstrapMethodInvoker.maybeReBoxElements(argv);
                    result = bootstrapMethod.invokeExact(caller, name, (MethodType)type, argv);
                } else {
                    BootstrapMethodInvoker.maybeReBoxElements(argv);
                    if (type instanceof Class) {
                        Class c = (Class)type;
                        result = switch (argv.length) {
                            case 0 -> bootstrapMethod.invoke(caller, name, c);
                            case 1 -> bootstrapMethod.invoke(caller, name, c, argv[0]);
                            case 2 -> bootstrapMethod.invoke(caller, name, c, argv[0], argv[1]);
                            case 3 -> bootstrapMethod.invoke(caller, name, c, argv[0], argv[1], argv[2]);
                            case 4 -> bootstrapMethod.invoke(caller, name, c, argv[0], argv[1], argv[2], argv[3]);
                            case 5 -> bootstrapMethod.invoke(caller, name, c, argv[0], argv[1], argv[2], argv[3], argv[4]);
                            case 6 -> bootstrapMethod.invoke(caller, name, c, argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]);
                            default -> BootstrapMethodInvoker.invokeWithManyArguments(bootstrapMethod, caller, name, type, argv);
                        };
                    } else {
                        MethodType mt = (MethodType)type;
                        result = switch (argv.length) {
                            case 0 -> bootstrapMethod.invoke(caller, name, mt);
                            case 1 -> bootstrapMethod.invoke(caller, name, mt, argv[0]);
                            case 2 -> bootstrapMethod.invoke(caller, name, mt, argv[0], argv[1]);
                            case 3 -> bootstrapMethod.invoke(caller, name, mt, argv[0], argv[1], argv[2]);
                            case 4 -> bootstrapMethod.invoke(caller, name, mt, argv[0], argv[1], argv[2], argv[3]);
                            case 5 -> bootstrapMethod.invoke(caller, name, mt, argv[0], argv[1], argv[2], argv[3], argv[4]);
                            case 6 -> bootstrapMethod.invoke(caller, name, mt, argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]);
                            default -> BootstrapMethodInvoker.invokeWithManyArguments(bootstrapMethod, caller, name, type, argv);
                        };
                    }
                }
            }
            return BootstrapMethodInvoker.widenAndCast(result, resultType);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new BootstrapMethodError("bootstrap method initialization exception", ex);
        }
    }

    static <T> T widenAndCast(Object result, Class<T> resultType) throws Throwable {
        if (!resultType.isPrimitive()) {
            return resultType.cast(result);
        }
        Class<T> wrapperType = Wrapper.asWrapperType(resultType);
        if (wrapperType.isInstance(result)) {
            Object wrapper = result;
            return (T)wrapper;
        }
        MethodHandle funnel = MethodHandles.identity(resultType);
        result = funnel.invoke(result);
        return wrapperType.cast(result);
    }

    private static Object invokeWithManyArguments(MethodHandle bootstrapMethod, MethodHandles.Lookup caller, String name, Object type, Object[] argv) throws Throwable {
        int NON_SPREAD_ARG_COUNT = 3;
        int MAX_SAFE_SIZE = 124;
        if (argv.length >= 124) {
            Object[] newargv = new Object[3 + argv.length];
            newargv[0] = caller;
            newargv[1] = name;
            newargv[2] = type;
            System.arraycopy(argv, 0, newargv, 3, argv.length);
            return bootstrapMethod.invokeWithArguments(newargv);
        }
        MethodType invocationType = MethodType.genericMethodType(3 + argv.length);
        MethodHandle typedBSM = bootstrapMethod.asType(invocationType);
        MethodHandle spreader = invocationType.invokers().spreadInvoker(3);
        return spreader.invokeExact(typedBSM, caller, name, type, argv);
    }

    private static boolean isStringConcatFactoryBSM(MethodType bsmType) {
        return bsmType == SCF_MT;
    }

    private static boolean isLambdaMetafactoryCondyBSM(MethodType bsmType) {
        return bsmType == LMF_CONDY_MT;
    }

    private static boolean isLambdaMetafactoryIndyBSM(MethodType bsmType) {
        return bsmType == LMF_INDY_MT;
    }

    private static boolean isLambdaMetafactoryAltMetafactoryBSM(MethodType bsmType) {
        return bsmType == LMF_ALT_MT;
    }

    private static Object maybeReBox(Object x) {
        int xi;
        if (x instanceof Integer && (xi = ((Integer)x).intValue()) == (byte)xi) {
            x = xi;
        }
        return x;
    }

    private static void maybeReBoxElements(Object[] xa) {
        for (int i = 0; i < xa.length; ++i) {
            xa[i] = BootstrapMethodInvoker.maybeReBox(xa[i]);
        }
    }

    static MethodHandle pushMePullYou(MethodHandle bsm, boolean goToPushMode) {
        if (MethodHandleStatics.TRACE_METHOD_LINKAGE) {
            System.out.println("converting BSM of type " + bsm.type() + " to " + (goToPushMode ? "push mode" : "pull mode"));
        }
        assert (MethodHandleNatives.isPullModeBSM(bsm) == goToPushMode);
        if (goToPushMode) {
            return PushAdapter.MH_pushToBootstrapMethod.bindTo(bsm).withVarargs(true);
        }
        return PullAdapter.MH_pullFromBootstrapMethod.bindTo(bsm).withVarargs(false);
    }

    private static final class VM_BSCI<T>
    extends AbstractConstantGroup.BSCIWithCache<T> {
        private final int[] indexInfo;
        private final Class<?> caller;
        private static final int MIN_PF = 4;

        VM_BSCI(MethodHandle bsm, String name, T type, MethodHandles.Lookup lookup, int[] indexInfo) {
            super(bsm, name, type, indexInfo[0]);
            if (!lookup.hasFullPrivilegeAccess()) {
                throw new AssertionError((Object)"bad Lookup object");
            }
            this.caller = lookup.lookupClass();
            this.indexInfo = indexInfo;
            this.prefetchIntoCache(0, this.size());
        }

        @Override
        Object fillCache(int i) {
            Object res;
            Object[] buf = new Object[]{null};
            this.copyConstants(i, i + 1, buf, 0);
            this.cache[i] = res = VM_BSCI.wrapNull(buf[0]);
            int next = i + 1;
            if (next < this.cache.length && this.cache[next] == null) {
                this.maybePrefetchIntoCache(next, false);
            }
            return res;
        }

        @Override
        public int copyConstants(int start, int end, Object[] buf, int pos) {
            Object x;
            int i;
            int bufi = pos;
            for (i = start; i < end && (x = this.cache[i]) != null; ++i) {
                buf[bufi++] = VM_BSCI.unwrapNull(x);
            }
            if (i >= end) {
                return i;
            }
            Object[] temp = new Object[end - i];
            if (MethodHandleStatics.TRACE_METHOD_LINKAGE) {
                System.out.println("resolving more BSM arguments: " + Arrays.asList(this.caller.getSimpleName(), Arrays.toString(this.indexInfo), i, end));
            }
            MethodHandleNatives.copyOutBootstrapArguments(this.caller, this.indexInfo, i, end, temp, 0, true, null);
            for (Object x2 : temp) {
                x2 = BootstrapMethodInvoker.maybeReBox(x2);
                buf[bufi++] = x2;
                this.cache[i++] = VM_BSCI.wrapNull(x2);
            }
            if (end < this.cache.length && this.cache[end] == null) {
                this.maybePrefetchIntoCache(end, true);
            }
            return i;
        }

        private void maybePrefetchIntoCache(int i, boolean bulk) {
            int len = this.cache.length;
            assert (0 <= i && i <= len);
            int pfLimit = i;
            if (bulk) {
                pfLimit += i;
            }
            if (pfLimit < i + 4) {
                pfLimit = i + 4;
            }
            if (pfLimit > len || pfLimit < 0) {
                pfLimit = len;
            }
            int empty = 0;
            int nonEmpty = 0;
            int lastEmpty = i;
            for (int j = i; j < pfLimit; ++j) {
                if (this.cache[j] == null) {
                    ++empty;
                    lastEmpty = j;
                    continue;
                }
                if (++nonEmpty > empty) {
                    pfLimit = lastEmpty + 1;
                    break;
                }
                if (pfLimit >= len) continue;
                ++pfLimit;
            }
            if (bulk && empty < 4 && pfLimit < len) {
                return;
            }
            this.prefetchIntoCache(i, pfLimit);
        }

        private void prefetchIntoCache(int i, int pfLimit) {
            if (pfLimit <= i) {
                return;
            }
            Object[] temp = new Object[pfLimit - i];
            if (MethodHandleStatics.TRACE_METHOD_LINKAGE) {
                System.out.println("prefetching BSM arguments: " + Arrays.asList(this.caller.getSimpleName(), Arrays.toString(this.indexInfo), i, pfLimit));
            }
            MethodHandleNatives.copyOutBootstrapArguments(this.caller, this.indexInfo, i, pfLimit, temp, 0, false, NOT_PRESENT);
            for (Object x : temp) {
                if (x != NOT_PRESENT && this.cache[i] == null) {
                    this.cache[i] = VM_BSCI.wrapNull(BootstrapMethodInvoker.maybeReBox(x));
                }
                ++i;
            }
        }
    }

    static final class PushAdapter {
        static final MethodHandle MH_pushToBootstrapMethod;

        PushAdapter() {
        }

        static Object pushToBootstrapMethod(MethodHandle pullModeBSM, MethodHandles.Lookup lookup, String name, Object type, Object ... arguments) throws Throwable {
            ConstantGroup cons = ConstantGroup.makeConstantGroup(Arrays.asList(arguments));
            BootstrapCallInfo<Object> bsci = BootstrapCallInfo.makeBootstrapCallInfo(pullModeBSM, name, type, cons);
            if (MethodHandleStatics.TRACE_METHOD_LINKAGE) {
                System.out.println("pull-mode BSM gets pushed arguments from fake BSCI");
            }
            return pullModeBSM.invoke(lookup, bsci);
        }

        static {
            Class<PushAdapter> THIS_CLASS = PushAdapter.class;
            try {
                MH_pushToBootstrapMethod = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "pushToBootstrapMethod", MethodType.methodType(Object.class, MethodHandle.class, MethodHandles.Lookup.class, String.class, Object.class, Object[].class));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
        }
    }

    static final class PullAdapter {
        static final MethodHandle MH_pullFromBootstrapMethod;

        PullAdapter() {
        }

        static Object pullFromBootstrapMethod(MethodHandle pushModeBSM, MethodHandles.Lookup lookup, BootstrapCallInfo<?> bsci) throws Throwable {
            int argc = bsci.size();
            switch (argc) {
                case 0: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType());
                }
                case 1: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0));
                }
                case 2: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0), bsci.get(1));
                }
                case 3: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0), bsci.get(1), bsci.get(2));
                }
                case 4: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0), bsci.get(1), bsci.get(2), bsci.get(3));
                }
                case 5: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0), bsci.get(1), bsci.get(2), bsci.get(3), bsci.get(4));
                }
                case 6: {
                    return pushModeBSM.invoke(lookup, bsci.invocationName(), bsci.invocationType(), bsci.get(0), bsci.get(1), bsci.get(2), bsci.get(3), bsci.get(4), bsci.get(5));
                }
            }
            int NON_SPREAD_ARG_COUNT = 3;
            int MAX_SAFE_SIZE = 124;
            if (argc >= 124) {
                Object[] newargv = new Object[3 + argc];
                newargv[0] = lookup;
                newargv[1] = bsci.invocationName();
                newargv[2] = bsci.invocationType();
                bsci.copyConstants(0, argc, newargv, 3);
                return pushModeBSM.invokeWithArguments(newargv);
            }
            MethodType invocationType = MethodType.genericMethodType(3 + argc);
            MethodHandle typedBSM = pushModeBSM.asType(invocationType);
            MethodHandle spreader = invocationType.invokers().spreadInvoker(3);
            Object[] argv = new Object[argc];
            bsci.copyConstants(0, argc, argv, 0);
            return spreader.invokeExact(typedBSM, lookup, bsci.invocationName(), bsci.invocationType(), argv);
        }

        static {
            Class<PullAdapter> THIS_CLASS = PullAdapter.class;
            try {
                MH_pullFromBootstrapMethod = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "pullFromBootstrapMethod", MethodType.methodType(Object.class, MethodHandle.class, MethodHandles.Lookup.class, BootstrapCallInfo.class));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
        }
    }
}

