/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.ClassSpecializer;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.ValueConversions;

abstract class BoundMethodHandle
extends MethodHandle {
    private static final int FIELD_COUNT_THRESHOLD = 12;
    private static final int FORM_EXPRESSION_THRESHOLD = 24;
    static final Specializer SPECIALIZER = new Specializer();

    BoundMethodHandle(MethodType type, LambdaForm form) {
        super(type, form);
        assert (this.speciesData() == BoundMethodHandle.speciesDataFor(form));
    }

    static BoundMethodHandle bindSingle(MethodType type, LambdaForm form, LambdaForm.BasicType xtype, Object x) {
        try {
            return switch (xtype) {
                case LambdaForm.BasicType.L_TYPE -> BoundMethodHandle.bindSingle(type, form, x);
                case LambdaForm.BasicType.I_TYPE -> ((SpeciesData)SPECIALIZER.topSpecies()).extendWith(LambdaForm.BasicType.I_TYPE_NUM).factory().invokeBasic(type, form, ValueConversions.widenSubword(x));
                case LambdaForm.BasicType.J_TYPE -> ((SpeciesData)SPECIALIZER.topSpecies()).extendWith(LambdaForm.BasicType.J_TYPE_NUM).factory().invokeBasic(type, form, (Long)x);
                case LambdaForm.BasicType.F_TYPE -> ((SpeciesData)SPECIALIZER.topSpecies()).extendWith(LambdaForm.BasicType.F_TYPE_NUM).factory().invokeBasic(type, form, ((Float)x).floatValue());
                case LambdaForm.BasicType.D_TYPE -> ((SpeciesData)SPECIALIZER.topSpecies()).extendWith(LambdaForm.BasicType.D_TYPE_NUM).factory().invokeBasic(type, form, (Double)x);
                default -> throw MethodHandleStatics.newInternalError("unexpected xtype: " + (Object)((Object)xtype));
            };
        }
        catch (Throwable t) {
            throw MethodHandleStatics.uncaughtException(t);
        }
    }

    LambdaFormEditor editor() {
        return this.form.editor();
    }

    static BoundMethodHandle bindSingle(MethodType type, LambdaForm form, Object x) {
        return Species_L.make(type, form, x);
    }

    @Override
    BoundMethodHandle bindArgumentL(int pos, Object value) {
        return this.editor().bindArgumentL(this, pos, value);
    }

    BoundMethodHandle bindArgumentI(int pos, int value) {
        return this.editor().bindArgumentI(this, pos, value);
    }

    BoundMethodHandle bindArgumentJ(int pos, long value) {
        return this.editor().bindArgumentJ(this, pos, value);
    }

    BoundMethodHandle bindArgumentF(int pos, float value) {
        return this.editor().bindArgumentF(this, pos, value);
    }

    BoundMethodHandle bindArgumentD(int pos, double value) {
        return this.editor().bindArgumentD(this, pos, value);
    }

    @Override
    BoundMethodHandle rebind() {
        if (!this.tooComplex()) {
            return this;
        }
        return BoundMethodHandle.makeReinvoker(this);
    }

    private boolean tooComplex() {
        return this.fieldCount() > 12 || this.form.expressionCount() > 24;
    }

    static BoundMethodHandle makeReinvoker(MethodHandle target) {
        LambdaForm form = DelegatingMethodHandle.makeReinvokerForm(target, 7, Species_L.BMH_SPECIES, Species_L.BMH_SPECIES.getterFunction(0));
        return Species_L.make(target.type(), form, target);
    }

    abstract SpeciesData speciesData();

    static SpeciesData speciesDataFor(LambdaForm form) {
        Object c = form.names[0].constraint;
        if (c instanceof SpeciesData) {
            return (SpeciesData)c;
        }
        return (SpeciesData)SPECIALIZER.topSpecies();
    }

    final int fieldCount() {
        return this.speciesData().fieldCount();
    }

    @Override
    Object internalProperties() {
        return "\n& BMH=" + this.internalValues();
    }

    @Override
    final String internalValues() {
        int count = this.fieldCount();
        if (count == 1) {
            return "[" + this.arg(0) + "]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < count; ++i) {
            sb.append("\n  ").append(i).append(": ( ").append(this.arg(i)).append(" )");
        }
        return sb.append("\n]").toString();
    }

    final Object arg(int i) {
        try {
            Class<?> fieldType = this.speciesData().fieldTypes().get(i);
            switch (LambdaForm.BasicType.basicType(fieldType)) {
                case L_TYPE: {
                    return this.speciesData().getter(i).invokeBasic(this);
                }
                case I_TYPE: {
                    return this.speciesData().getter(i).invokeBasic(this);
                }
                case J_TYPE: {
                    return this.speciesData().getter(i).invokeBasic(this);
                }
                case F_TYPE: {
                    return Float.valueOf(this.speciesData().getter(i).invokeBasic(this));
                }
                case D_TYPE: {
                    return this.speciesData().getter(i).invokeBasic(this);
                }
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        throw new InternalError("unexpected type: " + (String)this.speciesData().key() + "." + i);
    }

    @Override
    abstract BoundMethodHandle copyWith(MethodType var1, LambdaForm var2);

    abstract BoundMethodHandle copyWithExtendL(MethodType var1, LambdaForm var2, Object var3);

    abstract BoundMethodHandle copyWithExtendI(MethodType var1, LambdaForm var2, int var3);

    abstract BoundMethodHandle copyWithExtendJ(MethodType var1, LambdaForm var2, long var3);

    abstract BoundMethodHandle copyWithExtendF(MethodType var1, LambdaForm var2, float var3);

    abstract BoundMethodHandle copyWithExtendD(MethodType var1, LambdaForm var2, double var3);

    static SpeciesData speciesData_L() {
        return Species_L.BMH_SPECIES;
    }

    static SpeciesData speciesData_LL() {
        return (SpeciesData)SPECIALIZER.findSpecies("LL");
    }

    static SpeciesData speciesData_LLL() {
        return (SpeciesData)SPECIALIZER.findSpecies("LLL");
    }

    static SpeciesData speciesData_LLLL() {
        return (SpeciesData)SPECIALIZER.findSpecies("LLLL");
    }

    static SpeciesData speciesData_LLLLL() {
        return (SpeciesData)SPECIALIZER.findSpecies("LLLLL");
    }

    static {
        SimpleMethodHandle.BMH_SPECIES = (SpeciesData)SPECIALIZER.findSpecies("");
        Species_L.BMH_SPECIES = (SpeciesData)SPECIALIZER.findSpecies("L");
    }

    static final class SpeciesData
    extends ClassSpecializer.SpeciesData {
        @Stable
        private final SpeciesData[] extensions;

        public SpeciesData(Specializer outer, String key) {
            Specializer specializer = outer;
            Objects.requireNonNull(specializer);
            super(specializer, key);
            this.extensions = new SpeciesData[LambdaForm.BasicType.ARG_TYPE_LIMIT];
        }

        @Override
        protected String deriveClassName() {
            String typeString = this.deriveTypeString();
            if (typeString.isEmpty()) {
                return SimpleMethodHandle.class.getName();
            }
            return BoundMethodHandle.class.getName() + "$Species_" + typeString;
        }

        protected List<Class<?>> deriveFieldTypes(String key) {
            ArrayList types = new ArrayList(key.length());
            for (int i = 0; i < key.length(); ++i) {
                types.add(LambdaForm.BasicType.basicType(key.charAt(i)).basicTypeClass());
            }
            return types;
        }

        @Override
        protected String deriveTypeString() {
            return (String)this.key();
        }

        @Override
        protected MethodHandle deriveTransformHelper(MemberName transform, int whichtm) {
            if (whichtm == Specializer.TN_COPY_NO_EXTEND) {
                return this.factory();
            }
            if (whichtm < LambdaForm.BasicType.ARG_TYPE_LIMIT) {
                return this.extendWith((byte)whichtm).factory();
            }
            throw MethodHandleStatics.newInternalError("bad transform");
        }

        @Override
        protected <X> List<X> deriveTransformHelperArguments(MemberName transform, int whichtm, List<X> args, List<X> fields) {
            assert (this.verifyTHAargs(transform, whichtm, args, fields));
            args.addAll(2, fields);
            return args;
        }

        private boolean verifyTHAargs(MemberName transform, int whichtm, List<?> args, List<?> fields) {
            assert (transform == Specializer.BMH_TRANSFORMS.get(whichtm));
            assert (args.size() == transform.getMethodType().parameterCount());
            assert (fields.size() == this.fieldCount());
            int MH_AND_LF = 2;
            if (whichtm == Specializer.TN_COPY_NO_EXTEND) {
                assert (transform.getMethodType().parameterCount() == 2);
            } else if (whichtm < LambdaForm.BasicType.ARG_TYPE_LIMIT) {
                assert (transform.getMethodType().parameterCount() == 3);
                LambdaForm.BasicType type = LambdaForm.BasicType.basicType((byte)whichtm);
                assert (transform.getParameterTypes()[2] == type.basicTypeClass());
            } else {
                return false;
            }
            return true;
        }

        SpeciesData extendWith(byte typeNum) {
            SpeciesData sd = this.extensions[typeNum];
            if (sd != null) {
                return sd;
            }
            this.extensions[typeNum] = sd = (SpeciesData)SPECIALIZER.findSpecies((String)this.key() + LambdaForm.BasicType.basicType(typeNum).basicTypeChar());
            return sd;
        }
    }

    static final class Specializer
    extends ClassSpecializer<BoundMethodHandle, String, SpeciesData> {
        private static final MemberName SPECIES_DATA_ACCESSOR;
        static final List<MemberName> BMH_TRANSFORMS;
        static final int TN_COPY_NO_EXTEND;

        private Specializer() {
            super(BoundMethodHandle.class, String.class, SpeciesData.class, MethodType.methodType(Void.TYPE, MethodType.class, LambdaForm.class), SPECIES_DATA_ACCESSOR, "BMH_SPECIES", BMH_TRANSFORMS);
        }

        @Override
        protected String topSpeciesKey() {
            return "";
        }

        @Override
        protected SpeciesData newSpeciesData(String key) {
            return new SpeciesData(this, key);
        }

        @Override
        protected Factory makeFactory() {
            return new Factory();
        }

        static {
            try {
                SPECIES_DATA_ACCESSOR = MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BoundMethodHandle.class, "speciesData", MethodType.methodType(SpeciesData.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError("Bootstrap link error", ex);
            }
            TN_COPY_NO_EXTEND = LambdaForm.BasicType.V_TYPE_NUM;
            Class<BoundMethodHandle> BMH = BoundMethodHandle.class;
            try {
                BMH_TRANSFORMS = List.of(MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWithExtendL", MethodType.methodType(BMH, MethodType.class, LambdaForm.class, Object.class)), MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWithExtendI", MethodType.methodType(BMH, MethodType.class, LambdaForm.class, Integer.TYPE)), MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWithExtendJ", MethodType.methodType(BMH, MethodType.class, LambdaForm.class, Long.TYPE)), MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWithExtendF", MethodType.methodType(BMH, MethodType.class, LambdaForm.class, Float.TYPE)), MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWithExtendD", MethodType.methodType(BMH, MethodType.class, LambdaForm.class, Double.TYPE)), MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, BMH, "copyWith", MethodType.methodType(BMH, MethodType.class, LambdaForm.class)));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError("Failed resolving copyWith methods", ex);
            }
            assert (BMH_TRANSFORMS.size() == LambdaForm.BasicType.TYPE_LIMIT);
        }

        class Factory
        extends ClassSpecializer.Factory {
            Factory() {
                super(Specializer.this);
            }

            @Override
            protected String chooseFieldName(Class<?> type, int index) {
                return "arg" + super.chooseFieldName(type, index);
            }
        }
    }

    private static final class Species_L
    extends BoundMethodHandle {
        final Object argL0;
        @Stable
        static SpeciesData BMH_SPECIES;

        private Species_L(MethodType mt, LambdaForm lf, Object argL0) {
            super(mt, lf);
            this.argL0 = argL0;
        }

        @Override
        SpeciesData speciesData() {
            return BMH_SPECIES;
        }

        static BoundMethodHandle make(MethodType mt, LambdaForm lf, Object argL0) {
            return new Species_L(mt, lf, argL0);
        }

        @Override
        final BoundMethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Species_L(mt, lf, this.argL0);
        }

        @Override
        final BoundMethodHandle copyWithExtendL(MethodType mt, LambdaForm lf, Object narg) {
            try {
                return BMH_SPECIES.extendWith(LambdaForm.BasicType.L_TYPE_NUM).factory().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendI(MethodType mt, LambdaForm lf, int narg) {
            try {
                return BMH_SPECIES.extendWith(LambdaForm.BasicType.I_TYPE_NUM).factory().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendJ(MethodType mt, LambdaForm lf, long narg) {
            try {
                return BMH_SPECIES.extendWith(LambdaForm.BasicType.J_TYPE_NUM).factory().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendF(MethodType mt, LambdaForm lf, float narg) {
            try {
                return BMH_SPECIES.extendWith(LambdaForm.BasicType.F_TYPE_NUM).factory().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        @Override
        final BoundMethodHandle copyWithExtendD(MethodType mt, LambdaForm lf, double narg) {
            try {
                return BMH_SPECIES.extendWith(LambdaForm.BasicType.D_TYPE_NUM).factory().invokeBasic(mt, lf, this.argL0, narg);
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }
    }
}

