/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BootstrapMethodInvoker;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import jdk.internal.vm.annotation.Stable;

public abstract class CallSite {
    final MethodHandle target;
    private final MethodHandleNatives.CallSiteContext context = MethodHandleNatives.CallSiteContext.make(this);
    @Stable
    private static MethodHandle GET_TARGET;
    @Stable
    private static MethodHandle THROW_UCS;
    @Stable
    private static long TARGET_OFFSET;

    CallSite(MethodType type) {
        this.target = this.makeUninitializedCallSite(type);
    }

    CallSite(MethodHandle target) {
        target.type();
        this.target = target;
    }

    CallSite(MethodType targetType, MethodHandle createTargetHook) throws Throwable {
        this(targetType);
        ConstantCallSite selfCCS = (ConstantCallSite)this;
        MethodHandle boundTarget = (MethodHandle)createTargetHook.invokeWithArguments(selfCCS);
        this.setTargetNormal(boundTarget);
        MethodHandleStatics.UNSAFE.storeStoreFence();
    }

    public MethodType type() {
        return this.target.type();
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    private void checkTargetChange(MethodHandle newTarget) {
        MethodType oldType = this.target.type();
        MethodType newType = newTarget.type();
        if (newType != oldType) {
            throw CallSite.wrongTargetType(newTarget, oldType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle target, MethodType type) {
        return new WrongMethodTypeException(String.valueOf(target) + " should be of type " + type);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        BoundMethodHandle getTarget = CallSite.getTargetHandle().bindArgumentL(0, this);
        MethodHandle invoker = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(invoker, getTarget);
    }

    private static MethodHandle getTargetHandle() {
        MethodHandle handle = GET_TARGET;
        if (handle != null) {
            return handle;
        }
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
            return GET_TARGET;
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
    }

    private static MethodHandle uninitializedCallSiteHandle() {
        MethodHandle handle = THROW_UCS;
        if (handle != null) {
            return handle;
        }
        try {
            THROW_UCS = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Object.class, Object[].class));
            return THROW_UCS;
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
    }

    private static Object uninitializedCallSite(Object ... ignore) {
        throw new IllegalStateException("uninitialized call site");
    }

    private MethodHandle makeUninitializedCallSite(MethodType targetType) {
        MethodType basicType = targetType.basicType();
        MethodHandle invoker = basicType.form().cachedMethodHandle(2);
        if (invoker == null) {
            invoker = CallSite.uninitializedCallSiteHandle().asType(basicType);
            invoker = basicType.form().setCachedMethodHandle(2, invoker);
        }
        return invoker.viewAsType(targetType, false);
    }

    private static long getTargetOffset() {
        long offset = TARGET_OFFSET;
        if (offset > 0L) {
            return offset;
        }
        offset = TARGET_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(CallSite.class, "target");
        assert (offset > 0L);
        return offset;
    }

    final void setTargetNormal(MethodHandle newTarget) {
        this.checkTargetChange(newTarget);
        MethodHandleNatives.setCallSiteTargetNormal(this, newTarget);
    }

    final MethodHandle getTargetVolatile() {
        return (MethodHandle)MethodHandleStatics.UNSAFE.getReferenceVolatile(this, CallSite.getTargetOffset());
    }

    final void setTargetVolatile(MethodHandle newTarget) {
        this.checkTargetChange(newTarget);
        MethodHandleNatives.setCallSiteTargetVolatile(this, newTarget);
    }

    static CallSite makeSite(MethodHandle bootstrapMethod, String name, MethodType type, Object info, Class<?> callerClass) {
        CallSite site;
        try {
            CallSite binding = BootstrapMethodInvoker.invoke(CallSite.class, bootstrapMethod, name, type, info, callerClass);
            if (!(binding instanceof CallSite)) {
                throw new ClassCastException("CallSite bootstrap method failed to produce an instance of CallSite");
            }
            site = binding;
            if (!site.getTarget().type().equals((Object)type)) {
                throw CallSite.wrongTargetType(site.getTarget(), type);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable ex) {
            throw new BootstrapMethodError("CallSite bootstrap method initialization exception", ex);
        }
        return site;
    }
}

