/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import jdk.internal.access.SharedSecrets;
import jdk.internal.loader.BootLoader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.BytecodeName;

abstract class ClassSpecializer<T, K, S extends SpeciesData> {
    private final Class<T> topClass;
    private final Class<K> keyType;
    private final Class<S> metaType;
    private final MemberName sdAccessor;
    private final String sdFieldName;
    private final List<MemberName> transformMethods;
    private final MethodType baseConstructorType;
    private final S topSpecies;
    private final ConcurrentHashMap<K, Object> cache = new ConcurrentHashMap();
    private final Factory factory;
    @Stable
    private boolean topClassIsSuper;
    private static final Function<Object, Object> CREATE_RESERVATION = new Function<Object, Object>(){

        @Override
        public Object apply(Object key) {
            return new Object();
        }
    };
    private static final String MH = "java/lang/invoke/MethodHandle";
    private static final String MH_SIG = "Ljava/lang/invoke/MethodHandle;";
    private static final String STABLE = "jdk/internal/vm/annotation/Stable";
    private static final String STABLE_SIG = "Ljdk/internal/vm/annotation/Stable;";
    private static final String[] E_THROWABLE = new String[]{"java/lang/Throwable"};

    public final Class<T> topClass() {
        return this.topClass;
    }

    public final Class<K> keyType() {
        return this.keyType;
    }

    public final Class<S> metaType() {
        return this.metaType;
    }

    protected MethodType baseConstructorType() {
        return this.baseConstructorType;
    }

    protected final S topSpecies() {
        return this.topSpecies;
    }

    protected final List<MemberName> transformMethods() {
        return this.transformMethods;
    }

    protected final Factory factory() {
        return this.factory;
    }

    protected ClassSpecializer(Class<T> topClass, Class<K> keyType, Class<S> metaType, MethodType baseConstructorType, MemberName sdAccessor, String sdFieldName, List<MemberName> transformMethods) {
        this.topClass = topClass;
        this.keyType = keyType;
        this.metaType = metaType;
        this.sdAccessor = sdAccessor;
        this.transformMethods = List.copyOf(transformMethods);
        this.sdFieldName = sdFieldName;
        this.baseConstructorType = baseConstructorType.changeReturnType(Void.TYPE);
        this.factory = this.makeFactory();
        K tsk = this.topSpeciesKey();
        Object topSpecies = null;
        if (tsk != null && topSpecies == null) {
            topSpecies = this.findSpecies(tsk);
        }
        this.topSpecies = topSpecies;
    }

    protected static <T> Constructor<T> reflectConstructor(Class<T> defc, Class<?> ... ptypes) {
        try {
            return defc.getDeclaredConstructor(ptypes);
        }
        catch (NoSuchMethodException ex) {
            throw ClassSpecializer.newIAE(defc.getName() + "(" + MethodType.methodType(Void.TYPE, ptypes) + ")", ex);
        }
    }

    protected static Field reflectField(Class<?> defc, String name) {
        try {
            return defc.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            throw ClassSpecializer.newIAE(defc.getName() + "." + name, ex);
        }
    }

    private static RuntimeException newIAE(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final S findSpecies(K key) {
        SpeciesData speciesData;
        Object speciesDataOrReservation = this.cache.computeIfAbsent(key, CREATE_RESERVATION);
        if (speciesDataOrReservation.getClass() == Object.class) {
            Object object2 = speciesDataOrReservation;
            synchronized (object2) {
                Object existingSpeciesData = this.cache.get(key);
                if (existingSpeciesData == speciesDataOrReservation) {
                    speciesData = this.newSpeciesData(key);
                    if (!this.cache.replace(key, existingSpeciesData, speciesData = this.factory.loadSpecies(speciesData))) {
                        throw MethodHandleStatics.newInternalError("Concurrent loadSpecies");
                    }
                } else {
                    speciesData = (SpeciesData)this.metaType.cast(existingSpeciesData);
                }
            }
        } else {
            speciesData = (SpeciesData)this.metaType.cast(speciesDataOrReservation);
        }
        assert (speciesData != null && speciesData.isResolved());
        return (S)speciesData;
    }

    protected abstract S newSpeciesData(K var1);

    protected K topSpeciesKey() {
        return null;
    }

    protected Factory makeFactory() {
        return new Factory();
    }

    static String methodSig(MethodType mt) {
        return mt.toMethodDescriptorString();
    }

    static String classSig(Class<?> cls) {
        if (cls.isPrimitive() || cls.isArray()) {
            return MethodType.methodType(cls).toMethodDescriptorString().substring(2);
        }
        return ClassSpecializer.classSig(ClassSpecializer.classBCName(cls));
    }

    static String classSig(String bcName) {
        assert (bcName.indexOf(46) < 0);
        assert (!bcName.endsWith(";"));
        assert (!bcName.startsWith("["));
        return "L" + bcName + ";";
    }

    static String classBCName(Class<?> cls) {
        return ClassSpecializer.classBCName(ClassSpecializer.className(cls));
    }

    static String classBCName(String str) {
        assert (str.indexOf(47) < 0) : str;
        return str.replace('.', '/');
    }

    static String className(Class<?> cls) {
        assert (!cls.isArray() && !cls.isPrimitive());
        return cls.getName();
    }

    static {
        assert (MH_SIG.equals(ClassSpecializer.classSig(MethodHandle.class)));
        assert (MH.equals(ClassSpecializer.classBCName(MethodHandle.class)));
    }

    public abstract class SpeciesData {
        private final K key;
        private final List<Class<?>> fieldTypes;
        @Stable
        private Class<? extends T> speciesCode;
        @Stable
        private List<MethodHandle> factories;
        @Stable
        private List<MethodHandle> getters;
        @Stable
        private List<LambdaForm.NamedFunction> nominalGetters;
        @Stable
        private final MethodHandle[] transformHelpers;

        protected SpeciesData(K key) {
            this.transformHelpers = new MethodHandle[ClassSpecializer.this.transformMethods.size()];
            this.key = ClassSpecializer.this.keyType.cast(Objects.requireNonNull(key));
            List<Class<?>> types = this.deriveFieldTypes(key);
            this.fieldTypes = List.copyOf(types);
        }

        public final K key() {
            return this.key;
        }

        protected final List<Class<?>> fieldTypes() {
            return this.fieldTypes;
        }

        protected final int fieldCount() {
            return this.fieldTypes.size();
        }

        protected ClassSpecializer<T, K, S> outer() {
            return ClassSpecializer.this;
        }

        protected final boolean isResolved() {
            return this.speciesCode != null && this.factories != null && !this.factories.isEmpty();
        }

        public String toString() {
            return ClassSpecializer.this.metaType.getSimpleName() + "[" + this.key.toString() + " => " + (this.isResolved() ? this.speciesCode.getSimpleName() : "UNRESOLVED") + "]";
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SpeciesData)) {
                return false;
            }
            SpeciesData that = (SpeciesData)obj;
            return this.outer() == that.outer() && this.key.equals(that.key);
        }

        protected final Class<? extends T> speciesCode() {
            return Objects.requireNonNull(this.speciesCode);
        }

        protected MethodHandle getter(int i) {
            return this.getters.get(i);
        }

        protected LambdaForm.NamedFunction getterFunction(int i) {
            LambdaForm.NamedFunction nf = this.nominalGetters.get(i);
            assert (nf.memberDeclaringClassOrNull() == this.speciesCode());
            assert (nf.returnType() == LambdaForm.BasicType.basicType(this.fieldTypes.get(i)));
            return nf;
        }

        protected List<LambdaForm.NamedFunction> getterFunctions() {
            return this.nominalGetters;
        }

        protected List<MethodHandle> getters() {
            return this.getters;
        }

        protected MethodHandle factory() {
            return this.factories.get(0);
        }

        protected MethodHandle transformHelper(int whichtm) {
            MethodHandle mh = this.transformHelpers[whichtm];
            if (mh != null) {
                return mh;
            }
            mh = this.deriveTransformHelper(ClassSpecializer.this.transformMethods().get(whichtm), whichtm);
            MethodType mt = this.transformHelperType(whichtm);
            this.transformHelpers[whichtm] = mh = mh.asType(mt);
            return this.transformHelpers[whichtm];
        }

        private final MethodType transformHelperType(int whichtm) {
            MemberName tm = ClassSpecializer.this.transformMethods().get(whichtm);
            ArrayList args = new ArrayList();
            ArrayList fields = new ArrayList();
            Collections.addAll(args, tm.getParameterTypes());
            fields.addAll(this.fieldTypes());
            List<Class<?>> helperArgs = this.deriveTransformHelperArguments(tm, whichtm, args, fields);
            return MethodType.methodType(tm.getReturnType(), helperArgs);
        }

        protected abstract List<Class<?>> deriveFieldTypes(K var1);

        protected abstract MethodHandle deriveTransformHelper(MemberName var1, int var2);

        protected abstract <X> List<X> deriveTransformHelperArguments(MemberName var1, int var2, List<X> var3, List<X> var4);

        protected String deriveClassName() {
            return this.outer().topClass().getName() + "$Species_" + this.deriveTypeString();
        }

        protected String deriveTypeString() {
            List<Class<?>> types = this.fieldTypes();
            StringBuilder buf = new StringBuilder();
            StringBuilder end = new StringBuilder();
            for (Class<?> type : types) {
                LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(type);
                if (basicType.basicTypeClass() == type) {
                    buf.append(basicType.basicTypeChar());
                    continue;
                }
                buf.append('V');
                end.append(ClassSpecializer.classSig(type));
            }
            String typeString = end.length() > 0 ? BytecodeName.toBytecodeName(buf.append("_").append((CharSequence)end).toString()) : buf.toString();
            return LambdaForm.shortenSignature(typeString);
        }

        protected Class<? extends T> deriveSuperClass() {
            Class topc = ClassSpecializer.this.topClass();
            if (!ClassSpecializer.this.topClassIsSuper) {
                try {
                    Constructor con = ClassSpecializer.reflectConstructor(topc, ClassSpecializer.this.baseConstructorType().parameterArray());
                    if (!topc.isInterface() && !Modifier.isPrivate(con.getModifiers())) {
                        ClassSpecializer.this.topClassIsSuper = true;
                    }
                }
                catch (Exception | InternalError throwable) {
                    // empty catch block
                }
                if (!ClassSpecializer.this.topClassIsSuper) {
                    throw MethodHandleStatics.newInternalError("must override if the top class cannot serve as a super class");
                }
            }
            return topc;
        }
    }

    public class Factory {
        private final String SPECIES_DATA;
        private final String SPECIES_DATA_SIG;
        private final String SPECIES_DATA_NAME;
        private final int SPECIES_DATA_MODS;
        private final List<String> TRANSFORM_NAMES;
        private final List<MethodType> TRANSFORM_TYPES;
        private final List<Integer> TRANSFORM_MODS;
        private static final int ACC_PPP = 7;

        Factory() {
            this.SPECIES_DATA = ClassSpecializer.classBCName(ClassSpecializer.this.metaType);
            this.SPECIES_DATA_SIG = ClassSpecializer.classSig(this.SPECIES_DATA);
            this.SPECIES_DATA_NAME = ClassSpecializer.this.sdAccessor.getName();
            this.SPECIES_DATA_MODS = ClassSpecializer.this.sdAccessor.getModifiers();
            ArrayList<String> tns = new ArrayList<String>();
            ArrayList<MethodType> tts = new ArrayList<MethodType>();
            ArrayList<Integer> tms = new ArrayList<Integer>();
            for (int i = 0; i < ClassSpecializer.this.transformMethods.size(); ++i) {
                MemberName tm = ClassSpecializer.this.transformMethods.get(i);
                tns.add(tm.getName());
                MethodType tt = tm.getMethodType();
                tts.add(tt);
                tms.add(tm.getModifiers());
            }
            this.TRANSFORM_NAMES = List.of(tns.toArray(new String[0]));
            this.TRANSFORM_TYPES = List.of(tts.toArray(new MethodType[0]));
            this.TRANSFORM_MODS = List.of(tms.toArray(new Integer[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        S loadSpecies(S speciesData) {
            Class<Object> speciesCode;
            String className = ((SpeciesData)speciesData).deriveClassName();
            assert (className.indexOf(47) < 0) : className;
            Class<?> salvage = null;
            try {
                salvage = BootLoader.loadClassOrNull(className);
            }
            catch (Error error) {
            }
            finally {
                MethodHandleStatics.traceSpeciesType(className, salvage);
            }
            if (salvage != null) {
                speciesCode = salvage.asSubclass(ClassSpecializer.this.topClass());
                this.linkSpeciesDataToCode((SpeciesData)speciesData, (Class)speciesCode);
                this.linkCodeToSpeciesData((Class)speciesCode, (SpeciesData)speciesData, true);
            } else {
                speciesCode = this.generateConcreteSpeciesCode(className, (SpeciesData)speciesData);
                this.linkSpeciesDataToCode((SpeciesData)speciesData, (Class)speciesCode);
                this.linkCodeToSpeciesData((Class)speciesCode, (SpeciesData)speciesData, false);
            }
            if (!((SpeciesData)speciesData).isResolved()) {
                throw MethodHandleStatics.newInternalError("bad species class linkage for " + className + ": " + speciesData);
            }
            assert (speciesData == this.loadSpeciesDataFromCode(speciesCode));
            return speciesData;
        }

        Class<? extends T> generateConcreteSpeciesCode(String className, SpeciesData speciesData) {
            byte[] classFile = this.generateConcreteSpeciesCodeFile(className, speciesData);
            InvokerBytecodeGenerator.maybeDump(ClassSpecializer.classBCName(className), classFile);
            ClassLoader cl = ClassSpecializer.this.topClass.getClassLoader();
            ProtectionDomain pd = null;
            if (cl != null) {
                pd = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                    @Override
                    public ProtectionDomain run() {
                        return ClassSpecializer.this.topClass().getProtectionDomain();
                    }
                });
            }
            Class<?> speciesCode = SharedSecrets.getJavaLangAccess().defineClass(cl, className, classFile, pd, "_ClassSpecializer_generateConcreteSpeciesCode");
            return speciesCode.asSubclass(ClassSpecializer.this.topClass());
        }

        byte[] generateConcreteSpeciesCodeFile(String className0, SpeciesData speciesData) {
            final String className = ClassSpecializer.classBCName(className0);
            String superClassName = ClassSpecializer.classBCName(speciesData.deriveSuperClass());
            ClassWriter cw = new ClassWriter(3);
            boolean NOT_ACC_PUBLIC = false;
            cw.visit(50, 48, className, null, superClassName, null);
            String sourceFile = className.substring(className.lastIndexOf(46) + 1);
            cw.visitSource(sourceFile, null);
            FieldVisitor fw = cw.visitField(8, ClassSpecializer.this.sdFieldName, this.SPECIES_DATA_SIG, null, null);
            fw.visitAnnotation(ClassSpecializer.STABLE_SIG, true);
            fw.visitEnd();
            /*
             * Exception performing whole class analysis ignored.
             */
            class Var {
                final int index;
                final String name;
                final Class<?> type;
                final String desc;
                final LambdaForm.BasicType basicType;
                final int slotIndex;

                Var(int index, int slotIndex) {
                    this.index = index;
                    this.slotIndex = slotIndex;
                    this.name = null;
                    this.type = null;
                    this.desc = null;
                    this.basicType = LambdaForm.BasicType.V_TYPE;
                }

                Var(String name, Class<?> type, Var prev) {
                    className = var5_5;
                    int slotIndex = prev.nextSlotIndex();
                    int index = prev.nextIndex();
                    if (name == null) {
                        name = "x";
                    }
                    if (name.endsWith("#")) {
                        name = name.substring(0, name.length() - 1) + index;
                    }
                    assert (!type.equals(Void.TYPE));
                    String desc = ClassSpecializer.classSig(type);
                    LambdaForm.BasicType basicType = LambdaForm.BasicType.basicType(type);
                    this.index = index;
                    this.name = name;
                    this.type = type;
                    this.desc = desc;
                    this.basicType = basicType;
                    this.slotIndex = slotIndex;
                }

                Var lastOf(List<Var> vars) {
                    int n = vars.size();
                    return n == 0 ? this : vars.get(n - 1);
                }

                <X> List<Var> fromTypes(List<X> types) {
                    Var prev = this;
                    ArrayList<Var> result = new ArrayList<Var>(types.size());
                    int i = 0;
                    for (X x : types) {
                        Class<?> vt;
                        String vn = this.name;
                        if (x instanceof Class) {
                            vt = (Class<?>)x;
                            assert ((vn = vn + "_" + i++) != null);
                        } else {
                            Var v = (Var)x;
                            vn = v.name;
                            vt = v.type;
                        }
                        prev = new Var(Factory.this, vn, vt, prev, className);
                        result.add(prev);
                    }
                    return result;
                }

                int slotSize() {
                    return this.basicType.basicTypeSlots();
                }

                int nextIndex() {
                    return this.index + (this.slotSize() == 0 ? 0 : 1);
                }

                int nextSlotIndex() {
                    return this.slotIndex >= 0 ? this.slotIndex + this.slotSize() : this.slotIndex;
                }

                boolean isInHeap() {
                    return this.slotIndex < 0;
                }

                void emitVarInstruction(int asmop, MethodVisitor mv) {
                    if (asmop != 25) {
                        throw new AssertionError((Object)("bad op=" + asmop + " for desc=" + this.desc));
                    }
                    asmop = Factory.this.typeLoadOp(this.basicType.basicTypeChar());
                    mv.visitVarInsn(asmop, this.slotIndex);
                }

                public void emitFieldInsn(int asmop, MethodVisitor mv) {
                    mv.visitFieldInsn(asmop, className, this.name, this.desc);
                }
            }
            Var NO_THIS = new Var(0, 0);
            Var AFTER_THIS = new Var(0, 1);
            Var IN_HEAP = new Var(0, -1);
            List<Class<?>> fieldTypes = speciesData.fieldTypes();
            ArrayList<Object> fields = new ArrayList<Object>(fieldTypes.size());
            Object nextF = IN_HEAP;
            for (Class<?> ft : fieldTypes) {
                String fn = this.chooseFieldName(ft, ((Var)nextF).nextIndex());
                nextF = new Var(this, fn, ft, (Var)nextF, className);
                fields.add(nextF);
            }
            for (Var var : fields) {
                cw.visitField(16, var.name, var.desc, null, null).visitEnd();
            }
            MethodVisitor mv = cw.visitMethod((this.SPECIES_DATA_MODS & 7) + 16, this.SPECIES_DATA_NAME, "()" + this.SPECIES_DATA_SIG, null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, className, ClassSpecializer.this.sdFieldName, this.SPECIES_DATA_SIG);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            MethodType methodType = ClassSpecializer.this.baseConstructorType();
            MethodType thisCtorType = methodType.appendParameterTypes(fieldTypes);
            mv = cw.visitMethod(2, "<init>", ClassSpecializer.methodSig(thisCtorType), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            List<Var> ctorArgs = AFTER_THIS.fromTypes(methodType.parameterList());
            for (Var var : ctorArgs) {
                var.emitVarInstruction(25, mv);
            }
            mv.visitMethodInsn(183, superClassName, "<init>", ClassSpecializer.methodSig(methodType), false);
            Object lastFV = AFTER_THIS.lastOf(ctorArgs);
            for (Var var : fields) {
                mv.visitVarInsn(25, 0);
                lastFV = new Var(this, var.name, var.type, (Var)lastFV, className);
                ((Var)lastFV).emitVarInstruction(25, mv);
                var.emitFieldInsn(181, mv);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            MethodType ftryType = thisCtorType.changeReturnType(ClassSpecializer.this.topClass());
            mv = cw.visitMethod(8, "make", ClassSpecializer.methodSig(ftryType), null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            for (Var var : NO_THIS.fromTypes(ftryType.parameterList())) {
                var.emitVarInstruction(25, mv);
            }
            mv.visitMethodInsn(183, className, "<init>", ClassSpecializer.methodSig(thisCtorType), false);
            mv.visitInsn(176);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            for (int whichtm = 0; whichtm < this.TRANSFORM_NAMES.size(); ++whichtm) {
                String TNAME = this.TRANSFORM_NAMES.get(whichtm);
                MethodType methodType2 = this.TRANSFORM_TYPES.get(whichtm);
                int n = this.TRANSFORM_MODS.get(whichtm);
                mv = cw.visitMethod(n & 7 | 0x10, TNAME, methodType2.toMethodDescriptorString(), null, E_THROWABLE);
                mv.visitCode();
                mv.visitFieldInsn(178, className, ClassSpecializer.this.sdFieldName, this.SPECIES_DATA_SIG);
                this.emitIntConstant(whichtm, mv);
                mv.visitMethodInsn(182, this.SPECIES_DATA, "transformHelper", "(I)Ljava/lang/invoke/MethodHandle;", false);
                List<Var> targs = AFTER_THIS.fromTypes(methodType2.parameterList());
                ArrayList tfields = new ArrayList(fields);
                List<Var> helperArgs = speciesData.deriveTransformHelperArguments(ClassSpecializer.this.transformMethods.get(whichtm), whichtm, targs, tfields);
                ArrayList helperTypes = new ArrayList(helperArgs.size());
                for (Var ha : helperArgs) {
                    helperTypes.add(ha.basicType.basicTypeClass());
                    if (ha.isInHeap()) {
                        assert (tfields.contains(ha));
                        mv.visitVarInsn(25, 0);
                        ha.emitFieldInsn(180, mv);
                        continue;
                    }
                    assert (targs.contains(ha));
                    ha.emitVarInstruction(25, mv);
                }
                TypeDescriptor.OfField rtype = methodType2.returnType();
                LambdaForm.BasicType rbt = LambdaForm.BasicType.basicType(rtype);
                MethodType invokeBasicType = MethodType.methodType(rbt.basicTypeClass(), helperTypes);
                mv.visitMethodInsn(182, ClassSpecializer.MH, "invokeBasic", ClassSpecializer.methodSig(invokeBasicType), false);
                if (rbt != LambdaForm.BasicType.L_TYPE) {
                    throw MethodHandleStatics.newInternalError("NYI: transform of type " + rtype);
                }
                mv.visitTypeInsn(192, ClassSpecializer.classBCName(rtype));
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            cw.visitEnd();
            return cw.toByteArray();
        }

        private int typeLoadOp(char t) {
            return switch (t) {
                case 'L' -> 25;
                case 'I' -> 21;
                case 'J' -> 22;
                case 'F' -> 23;
                case 'D' -> 24;
                default -> throw MethodHandleStatics.newInternalError("unrecognized type " + t);
            };
        }

        private void emitIntConstant(int con, MethodVisitor mv) {
            if (-1 <= con && con <= 5) {
                mv.visitInsn(3 + con);
            } else if (con == (byte)con) {
                mv.visitIntInsn(16, con);
            } else if (con == (short)con) {
                mv.visitIntInsn(17, con);
            } else {
                mv.visitLdcInsn(con);
            }
        }

        private MethodHandle findGetter(Class<?> speciesCode, List<Class<?>> types, int index) {
            Class<?> fieldType = types.get(index);
            String fieldName = this.chooseFieldName(fieldType, index);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findGetter(speciesCode, fieldName, fieldType);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }

        private List<MethodHandle> findGetters(Class<?> speciesCode, List<Class<?>> types) {
            MethodHandle[] mhs = new MethodHandle[types.size()];
            for (int i = 0; i < mhs.length; ++i) {
                mhs[i] = this.findGetter(speciesCode, types, i);
                assert (mhs[i].internalMemberName().getDeclaringClass() == speciesCode);
            }
            return List.of(mhs);
        }

        private List<MethodHandle> findFactories(Class<? extends T> speciesCode, List<Class<?>> types) {
            MethodHandle[] mhs = new MethodHandle[]{this.findFactory(speciesCode, types)};
            return List.of(mhs);
        }

        List<LambdaForm.NamedFunction> makeNominalGetters(List<Class<?>> types, List<MethodHandle> getters) {
            LambdaForm.NamedFunction[] nfs = new LambdaForm.NamedFunction[types.size()];
            for (int i = 0; i < nfs.length; ++i) {
                nfs[i] = new LambdaForm.NamedFunction(getters.get(i));
            }
            return List.of(nfs);
        }

        protected void linkSpeciesDataToCode(SpeciesData speciesData, Class<? extends T> speciesCode) {
            speciesData.speciesCode = speciesCode.asSubclass(ClassSpecializer.this.topClass);
            List<Class<?>> types = speciesData.fieldTypes;
            speciesData.factories = this.findFactories(speciesCode, types);
            speciesData.getters = this.findGetters(speciesCode, types);
            speciesData.nominalGetters = this.makeNominalGetters(types, speciesData.getters);
        }

        private Field reflectSDField(Class<? extends T> speciesCode) {
            Field field = ClassSpecializer.reflectField(speciesCode, ClassSpecializer.this.sdFieldName);
            assert (field.getType() == ClassSpecializer.this.metaType);
            assert (Modifier.isStatic(field.getModifiers()));
            return field;
        }

        private S readSpeciesDataFromCode(Class<? extends T> speciesCode) {
            try {
                MemberName sdField = MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)2, speciesCode, ClassSpecializer.this.sdFieldName, ClassSpecializer.this.metaType);
                Object base = MethodHandleNatives.staticFieldBase(sdField);
                long offset = MethodHandleNatives.staticFieldOffset(sdField);
                MethodHandleStatics.UNSAFE.loadFence();
                return (SpeciesData)ClassSpecializer.this.metaType.cast(MethodHandleStatics.UNSAFE.getReference(base, offset));
            }
            catch (Error err) {
                throw err;
            }
            catch (Exception ex) {
                throw MethodHandleStatics.newInternalError("Failed to load speciesData from speciesCode: " + speciesCode.getName(), ex);
            }
            catch (Throwable t) {
                throw MethodHandleStatics.uncaughtException(t);
            }
        }

        protected S loadSpeciesDataFromCode(Class<? extends T> speciesCode) {
            if (speciesCode == ClassSpecializer.this.topClass()) {
                return ClassSpecializer.this.topSpecies;
            }
            Object result = this.readSpeciesDataFromCode(speciesCode);
            if (((SpeciesData)result).outer() != ClassSpecializer.this) {
                throw MethodHandleStatics.newInternalError("wrong class");
            }
            return result;
        }

        protected void linkCodeToSpeciesData(Class<? extends T> speciesCode, SpeciesData speciesData, boolean salvage) {
            try {
                assert (this.readSpeciesDataFromCode(speciesCode) == null || salvage && ((SpeciesData)this.readSpeciesDataFromCode(speciesCode)).equals(speciesData));
                MemberName sdField = MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)4, speciesCode, ClassSpecializer.this.sdFieldName, ClassSpecializer.this.metaType);
                Object base = MethodHandleNatives.staticFieldBase(sdField);
                long offset = MethodHandleNatives.staticFieldOffset(sdField);
                MethodHandleStatics.UNSAFE.storeFence();
                MethodHandleStatics.UNSAFE.putReference(base, offset, speciesData);
                MethodHandleStatics.UNSAFE.storeFence();
            }
            catch (Error err) {
                throw err;
            }
            catch (Exception ex) {
                throw MethodHandleStatics.newInternalError("Failed to link speciesData to speciesCode: " + speciesCode.getName(), ex);
            }
            catch (Throwable t) {
                throw MethodHandleStatics.uncaughtException(t);
            }
        }

        protected String chooseFieldName(Class<?> type, int index) {
            LambdaForm.BasicType bt = LambdaForm.BasicType.basicType(type);
            return "" + bt.basicTypeChar() + index;
        }

        MethodHandle findFactory(Class<? extends T> speciesCode, List<Class<?>> types) {
            MethodType type = ClassSpecializer.this.baseConstructorType().changeReturnType(ClassSpecializer.this.topClass()).appendParameterTypes(types);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(speciesCode, "make", type);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | TypeNotPresentException e) {
                throw MethodHandleStatics.newInternalError(e);
            }
        }
    }
}

