/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import jdk.internal.misc.Unsafe;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyAccess;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;

class DirectMethodHandle
extends MethodHandle {
    final MemberName member;
    final boolean crackable;
    private static final MemberName.Factory IMPL_NAMES = MemberName.getFactory();
    static final byte AF_GETFIELD = 0;
    static final byte AF_PUTFIELD = 1;
    static final byte AF_GETSTATIC = 2;
    static final byte AF_PUTSTATIC = 3;
    static final byte AF_GETSTATIC_INIT = 4;
    static final byte AF_PUTSTATIC_INIT = 5;
    static final byte AF_LIMIT = 6;
    static final int FT_LAST_WRAPPER = 9;
    static final int FT_UNCHECKED_REF = Wrapper.OBJECT.ordinal();
    static final int FT_CHECKED_REF = 10;
    static final int FT_LIMIT = 11;
    @Stable
    private static final LambdaForm[] ACCESSOR_FORMS = new LambdaForm[DirectMethodHandle.afIndex((byte)6, false, 0)];
    private static final Wrapper[] ALL_WRAPPERS = Wrapper.values();
    static final byte NF_internalMemberName = 0;
    static final byte NF_internalMemberNameEnsureInit = 1;
    static final byte NF_ensureInitialized = 2;
    static final byte NF_fieldOffset = 3;
    static final byte NF_checkBase = 4;
    static final byte NF_staticBase = 5;
    static final byte NF_staticOffset = 6;
    static final byte NF_checkCast = 7;
    static final byte NF_allocateInstance = 8;
    static final byte NF_constructorMethod = 9;
    static final byte NF_UNSAFE = 10;
    static final byte NF_checkReceiver = 11;
    static final byte NF_LIMIT = 12;
    @Stable
    private static final LambdaForm.NamedFunction[] NFS = new LambdaForm.NamedFunction[12];
    private static final MethodType OBJ_OBJ_TYPE = MethodType.methodType(Object.class, Object.class);
    private static final MethodType LONG_OBJ_TYPE = MethodType.methodType(Long.TYPE, Object.class);

    private DirectMethodHandle(MethodType mtype, LambdaForm form, MemberName member, boolean crackable) {
        super(mtype, form);
        if (!member.isResolved()) {
            throw new InternalError();
        }
        if (member.getDeclaringClass().isInterface() && member.getReferenceKind() == 9 && member.isMethod() && !member.isAbstract()) {
            MemberName m = new MemberName(Object.class, member.getName(), member.getMethodType(), member.getReferenceKind());
            m = MemberName.getFactory().resolveOrNull(m.getReferenceKind(), m, null, -1);
            if (m != null && m.isPublic()) {
                assert (member.getReferenceKind() == m.getReferenceKind());
                member = m;
            }
        }
        this.member = member;
        this.crackable = crackable;
    }

    static DirectMethodHandle make(byte refKind, Class<?> refc, MemberName member, Class<?> callerClass) {
        MethodType mtype = member.getMethodOrFieldType();
        if (!member.isStatic()) {
            if (!member.getDeclaringClass().isAssignableFrom(refc) || member.isConstructor()) {
                throw new InternalError(member.toString());
            }
            mtype = mtype.insertParameterTypes(0, refc);
        }
        if (!member.isField()) {
            return switch (refKind) {
                case 7 -> {
                    member = member.asSpecial();
                    if (callerClass == null) {
                        throw new InternalError("callerClass must not be null for REF_invokeSpecial");
                    }
                    LambdaForm lform = DirectMethodHandle.preparedLambdaForm(member, callerClass.isInterface());
                    yield new Special(mtype, lform, member, true, callerClass);
                }
                case 9 -> {
                    LambdaForm lform = DirectMethodHandle.preparedLambdaForm(member, true);
                    yield new Interface(mtype, lform, member, true, refc);
                }
                default -> {
                    LambdaForm lform = DirectMethodHandle.preparedLambdaForm(member);
                    yield new DirectMethodHandle(mtype, lform, member, true);
                }
            };
        }
        LambdaForm lform = DirectMethodHandle.preparedFieldLambdaForm(member);
        if (member.isStatic()) {
            long offset = MethodHandleNatives.staticFieldOffset(member);
            Object base = MethodHandleNatives.staticFieldBase(member);
            return new StaticAccessor(mtype, lform, member, true, base, offset);
        }
        long offset = MethodHandleNatives.objectFieldOffset(member);
        assert (offset == (long)((int)offset));
        return new Accessor(mtype, lform, member, true, (int)offset);
    }

    static DirectMethodHandle make(Class<?> refc, MemberName member) {
        byte refKind = member.getReferenceKind();
        if (refKind == 7) {
            refKind = 5;
        }
        return DirectMethodHandle.make(refKind, refc, member, null);
    }

    static DirectMethodHandle make(MemberName member) {
        if (member.isConstructor()) {
            return DirectMethodHandle.makeAllocator(member);
        }
        return DirectMethodHandle.make(member.getDeclaringClass(), member);
    }

    private static DirectMethodHandle makeAllocator(MemberName ctor) {
        assert (ctor.isConstructor() && ctor.getName().equals("<init>"));
        Class<?> instanceClass = ctor.getDeclaringClass();
        ctor = ctor.asConstructor();
        assert (ctor.isConstructor() && ctor.getReferenceKind() == 8) : ctor;
        MethodType mtype = ctor.getMethodType().changeReturnType(instanceClass);
        LambdaForm lform = DirectMethodHandle.preparedLambdaForm(ctor);
        MemberName init = ctor.asSpecial();
        assert (init.getMethodType().returnType() == Void.TYPE);
        return new Constructor(mtype, lform, ctor, true, init, instanceClass);
    }

    @Override
    BoundMethodHandle rebind() {
        return BoundMethodHandle.makeReinvoker(this);
    }

    @Override
    MethodHandle copyWith(MethodType mt, LambdaForm lf) {
        assert (this.getClass() == DirectMethodHandle.class);
        return new DirectMethodHandle(mt, lf, this.member, this.crackable);
    }

    @Override
    MethodHandle viewAsType(MethodType newType, boolean strict) {
        assert (this.viewAsTypeChecks(newType, strict));
        assert (this.getClass() == DirectMethodHandle.class);
        return new DirectMethodHandle(newType, this.form, this.member, false);
    }

    @Override
    boolean isCrackable() {
        return this.crackable;
    }

    @Override
    String internalProperties() {
        return "\n& DMH.MN=" + this.internalMemberName();
    }

    @Override
    @ForceInline
    MemberName internalMemberName() {
        return this.member;
    }

    private static LambdaForm preparedLambdaForm(MemberName m, boolean adaptToSpecialIfc) {
        assert (m.isInvocable()) : m;
        MethodType mtype = m.getInvocationType().basicType();
        assert (!m.isMethodHandleInvoke()) : m;
        int which = switch (m.getReferenceKind()) {
            case 5 -> 0;
            case 6 -> 1;
            case 7 -> 2;
            case 9 -> 4;
            case 8 -> 3;
            default -> throw new InternalError(m.toString());
        };
        if (which == 1 && DirectMethodHandle.shouldBeInitialized(m)) {
            DirectMethodHandle.preparedLambdaForm(mtype, which);
            which = 5;
        }
        if (which == 2 && adaptToSpecialIfc) {
            which = 20;
        }
        LambdaForm lform = DirectMethodHandle.preparedLambdaForm(mtype, which);
        DirectMethodHandle.maybeCompile(lform, m);
        assert (lform.methodType().dropParameterTypes(0, 1).equals((Object)m.getInvocationType().basicType())) : Arrays.asList(m, m.getInvocationType().basicType(), lform, lform.methodType());
        return lform;
    }

    private static LambdaForm preparedLambdaForm(MemberName m) {
        return DirectMethodHandle.preparedLambdaForm(m, false);
    }

    private static LambdaForm preparedLambdaForm(MethodType mtype, int which) {
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        lform = DirectMethodHandle.makePreparedLambdaForm(mtype, which);
        return mtype.form().setCachedLambdaForm(which, lform);
    }

    static LambdaForm makePreparedLambdaForm(MethodType mtype, int which) {
        int ARG_LIMIT;
        String linkerName;
        boolean needsInit = which == 5;
        boolean doesAlloc = which == 3;
        boolean needsReceiverCheck = which == 4 || which == 20;
        LambdaForm.Kind kind = switch (which) {
            case 0 -> {
                linkerName = "linkToVirtual";
                yield LambdaForm.Kind.DIRECT_INVOKE_VIRTUAL;
            }
            case 1 -> {
                linkerName = "linkToStatic";
                yield LambdaForm.Kind.DIRECT_INVOKE_STATIC;
            }
            case 5 -> {
                linkerName = "linkToStatic";
                yield LambdaForm.Kind.DIRECT_INVOKE_STATIC_INIT;
            }
            case 20 -> {
                linkerName = "linkToSpecial";
                yield LambdaForm.Kind.DIRECT_INVOKE_SPECIAL_IFC;
            }
            case 2 -> {
                linkerName = "linkToSpecial";
                yield LambdaForm.Kind.DIRECT_INVOKE_SPECIAL;
            }
            case 4 -> {
                linkerName = "linkToInterface";
                yield LambdaForm.Kind.DIRECT_INVOKE_INTERFACE;
            }
            case 3 -> {
                linkerName = "linkToSpecial";
                yield LambdaForm.Kind.DIRECT_NEW_INVOKE_SPECIAL;
            }
            default -> throw new InternalError("which=" + which);
        };
        MethodType mtypeWithArg = mtype.appendParameterTypes(MemberName.class);
        if (doesAlloc) {
            mtypeWithArg = mtypeWithArg.insertParameterTypes(0, Object.class).changeReturnType(Void.TYPE);
        }
        MemberName linker = new MemberName(MethodHandle.class, linkerName, mtypeWithArg, 6);
        try {
            linker = IMPL_NAMES.resolveOrFail((byte)6, linker, null, -1, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        boolean DMH_THIS = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int NEW_OBJ = doesAlloc ? nameCursor++ : -1;
        int GET_MEMBER = nameCursor++;
        int CHECK_RECEIVER = needsReceiverCheck ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        assert (names.length == nameCursor);
        if (doesAlloc) {
            names[NEW_OBJ] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)8), names[0]);
            names[GET_MEMBER] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)9), names[0]);
        } else {
            names[GET_MEMBER] = needsInit ? new LambdaForm.Name(DirectMethodHandle.getFunction((byte)1), names[0]) : new LambdaForm.Name(DirectMethodHandle.getFunction((byte)0), names[0]);
        }
        assert (DirectMethodHandle.findDirectMethodHandle(names[GET_MEMBER]) == names[0]);
        Object[] outArgs = Arrays.copyOfRange(names, 1, GET_MEMBER + 1, Object[].class);
        if (needsReceiverCheck) {
            names[CHECK_RECEIVER] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)11), names[0], names[1]);
            outArgs[0] = names[CHECK_RECEIVER];
        }
        assert (outArgs[outArgs.length - 1] == names[GET_MEMBER]);
        int result = -2;
        if (doesAlloc) {
            assert (outArgs[outArgs.length - 2] == names[NEW_OBJ]);
            System.arraycopy(outArgs, 0, outArgs, 1, outArgs.length - 2);
            outArgs[0] = names[NEW_OBJ];
            result = NEW_OBJ;
        }
        names[LINKER_CALL] = new LambdaForm.Name(linker, outArgs);
        LambdaForm lform = new LambdaForm(ARG_LIMIT, names, result, kind);
        lform.compileToBytecode();
        return lform;
    }

    static Object findDirectMethodHandle(LambdaForm.Name name) {
        if (name.function.equals(DirectMethodHandle.getFunction((byte)0)) || name.function.equals(DirectMethodHandle.getFunction((byte)1)) || name.function.equals(DirectMethodHandle.getFunction((byte)9))) {
            assert (name.arguments.length == 1);
            return name.arguments[0];
        }
        return null;
    }

    private static void maybeCompile(LambdaForm lform, MemberName m) {
        if (lform.vmentry == null && VerifyAccess.isSamePackage(m.getDeclaringClass(), MethodHandle.class)) {
            lform.compileToBytecode();
        }
    }

    @ForceInline
    static Object internalMemberName(Object mh) {
        return ((DirectMethodHandle)mh).member;
    }

    static Object internalMemberNameEnsureInit(Object mh) {
        DirectMethodHandle dmh = (DirectMethodHandle)mh;
        dmh.ensureInitialized();
        return dmh.member;
    }

    static boolean shouldBeInitialized(MemberName member) {
        switch (member.getReferenceKind()) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            default: {
                return false;
            }
        }
        Class<?> cls = member.getDeclaringClass();
        if (cls == ValueConversions.class || cls == MethodHandleImpl.class || cls == Invokers.class) {
            return false;
        }
        if (VerifyAccess.isSamePackage(MethodHandle.class, cls) || VerifyAccess.isSamePackage(ValueConversions.class, cls)) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(cls)) {
                MethodHandleStatics.UNSAFE.ensureClassInitialized(cls);
            }
            return false;
        }
        return MethodHandleStatics.UNSAFE.shouldBeInitialized(cls);
    }

    private void ensureInitialized() {
        if (DirectMethodHandle.checkInitialized(this.member)) {
            this.updateForm(new Function<LambdaForm, LambdaForm>(){

                @Override
                public LambdaForm apply(LambdaForm oldForm) {
                    return DirectMethodHandle.this.member.isField() ? DirectMethodHandle.preparedFieldLambdaForm(DirectMethodHandle.this.member) : DirectMethodHandle.preparedLambdaForm(DirectMethodHandle.this.member);
                }
            });
        }
    }

    private static boolean checkInitialized(MemberName member) {
        Class<?> defc = member.getDeclaringClass();
        WeakReference ref = (WeakReference)EnsureInitialized.INSTANCE.get(defc);
        if (ref == null) {
            return true;
        }
        if (ref.refersTo(Thread.currentThread())) {
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(defc)) {
                return false;
            }
        } else {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(defc);
        }
        assert (!MethodHandleStatics.UNSAFE.shouldBeInitialized(defc));
        EnsureInitialized.INSTANCE.remove(defc);
        return true;
    }

    static void ensureInitialized(Object mh) {
        ((DirectMethodHandle)mh).ensureInitialized();
    }

    Object checkReceiver(Object recv) {
        throw new InternalError("Should only be invoked on a subclass");
    }

    static Object constructorMethod(Object mh) {
        Constructor dmh = (Constructor)mh;
        return dmh.initMethod;
    }

    static Object allocateInstance(Object mh) throws InstantiationException {
        Constructor dmh = (Constructor)mh;
        return MethodHandleStatics.UNSAFE.allocateInstance(dmh.instanceClass);
    }

    @ForceInline
    static long fieldOffset(Object accessorObj) {
        return ((Accessor)accessorObj).fieldOffset;
    }

    @ForceInline
    static Object checkBase(Object obj) {
        return Objects.requireNonNull(obj);
    }

    @ForceInline
    static Object nullCheck(Object obj) {
        return Objects.requireNonNull(obj);
    }

    @ForceInline
    static Object staticBase(Object accessorObj) {
        return ((StaticAccessor)accessorObj).staticBase;
    }

    @ForceInline
    static long staticOffset(Object accessorObj) {
        return ((StaticAccessor)accessorObj).staticOffset;
    }

    @ForceInline
    static Object checkCast(Object mh, Object obj) {
        return ((DirectMethodHandle)mh).checkCast(obj);
    }

    Object checkCast(Object obj) {
        return this.member.getReturnType().cast(obj);
    }

    private static int afIndex(byte formOp, boolean isVolatile, int ftypeKind) {
        return formOp * 11 * 2 + (isVolatile ? 11 : 0) + ftypeKind;
    }

    static int ftypeKind(Class<?> ftype) {
        if (ftype.isPrimitive()) {
            return Wrapper.forPrimitiveType(ftype).ordinal();
        }
        if (VerifyType.isNullReferenceConversion(Object.class, ftype)) {
            return FT_UNCHECKED_REF;
        }
        return 10;
    }

    private static LambdaForm preparedFieldLambdaForm(MemberName m) {
        Class<?> ftype = m.getFieldType();
        boolean isVolatile = m.isVolatile();
        byte formOp = switch (m.getReferenceKind()) {
            case 1 -> 0;
            case 3 -> 1;
            case 2 -> 2;
            case 4 -> 3;
            default -> throw new InternalError(m.toString());
        };
        if (DirectMethodHandle.shouldBeInitialized(m)) {
            DirectMethodHandle.preparedFieldLambdaForm(formOp, isVolatile, ftype);
            formOp = (byte)(formOp + 2);
        }
        LambdaForm lform = DirectMethodHandle.preparedFieldLambdaForm(formOp, isVolatile, ftype);
        DirectMethodHandle.maybeCompile(lform, m);
        assert (lform.methodType().dropParameterTypes(0, 1).equals((Object)m.getInvocationType().basicType())) : Arrays.asList(m, m.getInvocationType().basicType(), lform, lform.methodType());
        return lform;
    }

    private static LambdaForm preparedFieldLambdaForm(byte formOp, boolean isVolatile, Class<?> ftype) {
        int ftypeKind = DirectMethodHandle.ftypeKind(ftype);
        int afIndex = DirectMethodHandle.afIndex(formOp, isVolatile, ftypeKind);
        LambdaForm lform = ACCESSOR_FORMS[afIndex];
        if (lform != null) {
            return lform;
        }
        DirectMethodHandle.ACCESSOR_FORMS[afIndex] = lform = DirectMethodHandle.makePreparedFieldLambdaForm(formOp, isVolatile, ftypeKind);
        return lform;
    }

    private static LambdaForm.Kind getFieldKind(boolean isGetter, boolean isVolatile, Wrapper wrapper) {
        if (isGetter) {
            if (isVolatile) {
                switch (wrapper) {
                    case BOOLEAN: {
                        return LambdaForm.Kind.GET_BOOLEAN_VOLATILE;
                    }
                    case BYTE: {
                        return LambdaForm.Kind.GET_BYTE_VOLATILE;
                    }
                    case SHORT: {
                        return LambdaForm.Kind.GET_SHORT_VOLATILE;
                    }
                    case CHAR: {
                        return LambdaForm.Kind.GET_CHAR_VOLATILE;
                    }
                    case INT: {
                        return LambdaForm.Kind.GET_INT_VOLATILE;
                    }
                    case LONG: {
                        return LambdaForm.Kind.GET_LONG_VOLATILE;
                    }
                    case FLOAT: {
                        return LambdaForm.Kind.GET_FLOAT_VOLATILE;
                    }
                    case DOUBLE: {
                        return LambdaForm.Kind.GET_DOUBLE_VOLATILE;
                    }
                    case OBJECT: {
                        return LambdaForm.Kind.GET_REFERENCE_VOLATILE;
                    }
                }
            } else {
                switch (wrapper) {
                    case BOOLEAN: {
                        return LambdaForm.Kind.GET_BOOLEAN;
                    }
                    case BYTE: {
                        return LambdaForm.Kind.GET_BYTE;
                    }
                    case SHORT: {
                        return LambdaForm.Kind.GET_SHORT;
                    }
                    case CHAR: {
                        return LambdaForm.Kind.GET_CHAR;
                    }
                    case INT: {
                        return LambdaForm.Kind.GET_INT;
                    }
                    case LONG: {
                        return LambdaForm.Kind.GET_LONG;
                    }
                    case FLOAT: {
                        return LambdaForm.Kind.GET_FLOAT;
                    }
                    case DOUBLE: {
                        return LambdaForm.Kind.GET_DOUBLE;
                    }
                    case OBJECT: {
                        return LambdaForm.Kind.GET_REFERENCE;
                    }
                }
            }
        } else if (isVolatile) {
            switch (wrapper) {
                case BOOLEAN: {
                    return LambdaForm.Kind.PUT_BOOLEAN_VOLATILE;
                }
                case BYTE: {
                    return LambdaForm.Kind.PUT_BYTE_VOLATILE;
                }
                case SHORT: {
                    return LambdaForm.Kind.PUT_SHORT_VOLATILE;
                }
                case CHAR: {
                    return LambdaForm.Kind.PUT_CHAR_VOLATILE;
                }
                case INT: {
                    return LambdaForm.Kind.PUT_INT_VOLATILE;
                }
                case LONG: {
                    return LambdaForm.Kind.PUT_LONG_VOLATILE;
                }
                case FLOAT: {
                    return LambdaForm.Kind.PUT_FLOAT_VOLATILE;
                }
                case DOUBLE: {
                    return LambdaForm.Kind.PUT_DOUBLE_VOLATILE;
                }
                case OBJECT: {
                    return LambdaForm.Kind.PUT_REFERENCE_VOLATILE;
                }
            }
        } else {
            switch (wrapper) {
                case BOOLEAN: {
                    return LambdaForm.Kind.PUT_BOOLEAN;
                }
                case BYTE: {
                    return LambdaForm.Kind.PUT_BYTE;
                }
                case SHORT: {
                    return LambdaForm.Kind.PUT_SHORT;
                }
                case CHAR: {
                    return LambdaForm.Kind.PUT_CHAR;
                }
                case INT: {
                    return LambdaForm.Kind.PUT_INT;
                }
                case LONG: {
                    return LambdaForm.Kind.PUT_LONG;
                }
                case FLOAT: {
                    return LambdaForm.Kind.PUT_FLOAT;
                }
                case DOUBLE: {
                    return LambdaForm.Kind.PUT_DOUBLE;
                }
                case OBJECT: {
                    return LambdaForm.Kind.PUT_REFERENCE;
                }
            }
        }
        throw new AssertionError((Object)"Invalid arguments");
    }

    static LambdaForm makePreparedFieldLambdaForm(byte formOp, boolean isVolatile, int ftypeKind) {
        boolean isGetter = (formOp & 1) == 0;
        boolean isStatic = formOp >= 2;
        boolean needsInit = formOp >= 4;
        boolean needsCast = ftypeKind == 10;
        Wrapper fw = needsCast ? Wrapper.OBJECT : ALL_WRAPPERS[ftypeKind];
        Class<?> ft = fw.primitiveType();
        assert (DirectMethodHandle.ftypeKind(needsCast ? String.class : ft) == ftypeKind);
        LambdaForm.Kind kind = DirectMethodHandle.getFieldKind(isGetter, isVolatile, fw);
        MethodType linkerType = isGetter ? MethodType.methodType(ft, Object.class, Long.TYPE) : MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, ft);
        MemberName linker = new MemberName(Unsafe.class, kind.methodName, linkerType, 5);
        try {
            linker = IMPL_NAMES.resolveOrFail((byte)5, linker, null, -1, NoSuchMethodException.class);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
        MethodType mtype = isGetter ? MethodType.methodType(ft) : MethodType.methodType(Void.TYPE, ft);
        mtype = mtype.basicType();
        if (!isStatic) {
            mtype = mtype.insertParameterTypes(0, Object.class);
        }
        boolean DMH_THIS = false;
        boolean ARG_BASE = true;
        int ARG_LIMIT = 1 + mtype.parameterCount();
        int OBJ_BASE = isStatic ? -1 : 1;
        int SET_VALUE = isGetter ? -1 : ARG_LIMIT - 1;
        int nameCursor = ARG_LIMIT;
        int F_HOLDER = isStatic ? nameCursor++ : -1;
        int F_OFFSET = nameCursor++;
        int OBJ_CHECK = OBJ_BASE >= 0 ? nameCursor++ : -1;
        int U_HOLDER = nameCursor++;
        int INIT_BAR = needsInit ? nameCursor++ : -1;
        int PRE_CAST = needsCast && !isGetter ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        int POST_CAST = needsCast && isGetter ? nameCursor++ : -1;
        int RESULT = nameCursor - 1;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, mtype.invokerType());
        if (needsInit) {
            names[INIT_BAR] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)2), names[0]);
        }
        if (needsCast && !isGetter) {
            names[PRE_CAST] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)7), names[0], names[SET_VALUE]);
        }
        Object[] outArgs = new Object[1 + linkerType.parameterCount()];
        assert (outArgs.length == (isGetter ? 3 : 4));
        names[U_HOLDER] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)10), new Object[0]);
        outArgs[0] = names[U_HOLDER];
        if (isStatic) {
            names[F_HOLDER] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)5), names[0]);
            outArgs[1] = names[F_HOLDER];
            names[F_OFFSET] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)6), names[0]);
            outArgs[2] = names[F_OFFSET];
        } else {
            names[OBJ_CHECK] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)4), names[OBJ_BASE]);
            outArgs[1] = names[OBJ_CHECK];
            names[F_OFFSET] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)3), names[0]);
            outArgs[2] = names[F_OFFSET];
        }
        if (!isGetter) {
            outArgs[3] = needsCast ? names[PRE_CAST] : names[SET_VALUE];
        }
        for (Object a : outArgs) {
            assert (a != null);
        }
        names[LINKER_CALL] = new LambdaForm.Name(linker, outArgs);
        if (needsCast && isGetter) {
            names[POST_CAST] = new LambdaForm.Name(DirectMethodHandle.getFunction((byte)7), names[0], names[LINKER_CALL]);
        }
        for (LambdaForm.Name n : names) {
            assert (n != null);
        }
        LambdaForm form = needsCast || needsInit ? new LambdaForm(ARG_LIMIT, names, RESULT) : new LambdaForm(ARG_LIMIT, names, RESULT, kind);
        if (LambdaForm.debugNames()) {
            StringBuilder nameBuilder = new StringBuilder(kind.methodName);
            if (isStatic) {
                nameBuilder.append("Static");
            } else {
                nameBuilder.append("Field");
            }
            if (needsCast) {
                nameBuilder.append("Cast");
            }
            if (needsInit) {
                nameBuilder.append("Init");
            }
            LambdaForm.associateWithDebugName(form, nameBuilder.toString());
        }
        return form;
    }

    private static LambdaForm.NamedFunction getFunction(byte func) {
        LambdaForm.NamedFunction nf = NFS[func];
        if (nf != null) {
            return nf;
        }
        nf = DirectMethodHandle.NFS[func] = DirectMethodHandle.createFunction(func);
        assert (InvokerBytecodeGenerator.isStaticallyInvocable(nf));
        return nf;
    }

    private static LambdaForm.NamedFunction createFunction(byte func) {
        try {
            switch (func) {
                case 0: {
                    return DirectMethodHandle.getNamedFunction("internalMemberName", OBJ_OBJ_TYPE);
                }
                case 1: {
                    return DirectMethodHandle.getNamedFunction("internalMemberNameEnsureInit", OBJ_OBJ_TYPE);
                }
                case 2: {
                    return DirectMethodHandle.getNamedFunction("ensureInitialized", MethodType.methodType(Void.TYPE, Object.class));
                }
                case 3: {
                    return DirectMethodHandle.getNamedFunction("fieldOffset", LONG_OBJ_TYPE);
                }
                case 4: {
                    return DirectMethodHandle.getNamedFunction("checkBase", OBJ_OBJ_TYPE);
                }
                case 5: {
                    return DirectMethodHandle.getNamedFunction("staticBase", OBJ_OBJ_TYPE);
                }
                case 6: {
                    return DirectMethodHandle.getNamedFunction("staticOffset", LONG_OBJ_TYPE);
                }
                case 7: {
                    return DirectMethodHandle.getNamedFunction("checkCast", MethodType.methodType(Object.class, Object.class, Object.class));
                }
                case 8: {
                    return DirectMethodHandle.getNamedFunction("allocateInstance", OBJ_OBJ_TYPE);
                }
                case 9: {
                    return DirectMethodHandle.getNamedFunction("constructorMethod", OBJ_OBJ_TYPE);
                }
                case 10: {
                    MemberName member = new MemberName(MethodHandleStatics.class, "UNSAFE", Unsafe.class, 1);
                    return new LambdaForm.NamedFunction(MemberName.getFactory().resolveOrFail((byte)1, member, DirectMethodHandle.class, -1, NoSuchMethodException.class));
                }
                case 11: {
                    MemberName member = new MemberName(DirectMethodHandle.class, "checkReceiver", OBJ_OBJ_TYPE, 5);
                    return new LambdaForm.NamedFunction(MemberName.getFactory().resolveOrFail((byte)5, member, DirectMethodHandle.class, -1, NoSuchMethodException.class));
                }
            }
            throw MethodHandleStatics.newInternalError("Unknown function: " + func);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    private static LambdaForm.NamedFunction getNamedFunction(String name, MethodType type) throws ReflectiveOperationException {
        MemberName member = new MemberName(DirectMethodHandle.class, name, type, 6);
        return new LambdaForm.NamedFunction(MemberName.getFactory().resolveOrFail((byte)6, member, DirectMethodHandle.class, -1, NoSuchMethodException.class));
    }

    static {
        MethodHandleStatics.UNSAFE.ensureClassInitialized(Holder.class);
    }

    static class Special
    extends DirectMethodHandle {
        private final Class<?> caller;

        private Special(MethodType mtype, LambdaForm form, MemberName member, boolean crackable, Class<?> caller) {
            super(mtype, form, member, crackable);
            this.caller = caller;
        }

        @Override
        boolean isInvokeSpecial() {
            return true;
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Special(mt, lf, this.member, this.crackable, this.caller);
        }

        @Override
        MethodHandle viewAsType(MethodType newType, boolean strict) {
            assert (this.viewAsTypeChecks(newType, strict));
            return new Special(newType, this.form, this.member, false, this.caller);
        }

        @Override
        Object checkReceiver(Object recv) {
            if (!this.caller.isInstance(recv)) {
                String msg = String.format("Receiver class %s is not a subclass of caller class %s", recv.getClass().getName(), this.caller.getName());
                throw new IncompatibleClassChangeError(msg);
            }
            return recv;
        }
    }

    static class Interface
    extends DirectMethodHandle {
        private final Class<?> refc;

        private Interface(MethodType mtype, LambdaForm form, MemberName member, boolean crackable, Class<?> refc) {
            super(mtype, form, member, crackable);
            assert (refc.isInterface()) : refc;
            this.refc = refc;
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Interface(mt, lf, this.member, this.crackable, this.refc);
        }

        @Override
        MethodHandle viewAsType(MethodType newType, boolean strict) {
            assert (this.viewAsTypeChecks(newType, strict));
            return new Interface(newType, this.form, this.member, false, this.refc);
        }

        @Override
        Object checkReceiver(Object recv) {
            if (!this.refc.isInstance(recv)) {
                String msg = String.format("Receiver class %s does not implement the requested interface %s", recv.getClass().getName(), this.refc.getName());
                throw new IncompatibleClassChangeError(msg);
            }
            return recv;
        }
    }

    static class StaticAccessor
    extends DirectMethodHandle {
        private final Class<?> fieldType;
        private final Object staticBase;
        private final long staticOffset;

        private StaticAccessor(MethodType mtype, LambdaForm form, MemberName member, boolean crackable, Object staticBase, long staticOffset) {
            super(mtype, form, member, crackable);
            this.fieldType = member.getFieldType();
            this.staticBase = staticBase;
            this.staticOffset = staticOffset;
        }

        @Override
        Object checkCast(Object obj) {
            return this.fieldType.cast(obj);
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new StaticAccessor(mt, lf, this.member, this.crackable, this.staticBase, this.staticOffset);
        }

        @Override
        MethodHandle viewAsType(MethodType newType, boolean strict) {
            assert (this.viewAsTypeChecks(newType, strict));
            return new StaticAccessor(newType, this.form, this.member, false, this.staticBase, this.staticOffset);
        }
    }

    static class Accessor
    extends DirectMethodHandle {
        final Class<?> fieldType;
        final int fieldOffset;

        private Accessor(MethodType mtype, LambdaForm form, MemberName member, boolean crackable, int fieldOffset) {
            super(mtype, form, member, crackable);
            this.fieldType = member.getFieldType();
            this.fieldOffset = fieldOffset;
        }

        @Override
        Object checkCast(Object obj) {
            return this.fieldType.cast(obj);
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Accessor(mt, lf, this.member, this.crackable, this.fieldOffset);
        }

        @Override
        MethodHandle viewAsType(MethodType newType, boolean strict) {
            assert (this.viewAsTypeChecks(newType, strict));
            return new Accessor(newType, this.form, this.member, false, this.fieldOffset);
        }
    }

    static class Constructor
    extends DirectMethodHandle {
        final MemberName initMethod;
        final Class<?> instanceClass;

        private Constructor(MethodType mtype, LambdaForm form, MemberName constructor, boolean crackable, MemberName initMethod, Class<?> instanceClass) {
            super(mtype, form, constructor, crackable);
            this.initMethod = initMethod;
            this.instanceClass = instanceClass;
            assert (initMethod.isResolved());
        }

        @Override
        MethodHandle copyWith(MethodType mt, LambdaForm lf) {
            return new Constructor(mt, lf, this.member, this.crackable, this.initMethod, this.instanceClass);
        }

        @Override
        MethodHandle viewAsType(MethodType newType, boolean strict) {
            assert (this.viewAsTypeChecks(newType, strict));
            return new Constructor(newType, this.form, this.member, false, this.initMethod, this.instanceClass);
        }
    }

    private static class EnsureInitialized
    extends ClassValue<WeakReference<Thread>> {
        static final EnsureInitialized INSTANCE = new EnsureInitialized();

        private EnsureInitialized() {
        }

        @Override
        protected WeakReference<Thread> computeValue(Class<?> type) {
            MethodHandleStatics.UNSAFE.ensureClassInitialized(type);
            if (MethodHandleStatics.UNSAFE.shouldBeInitialized(type)) {
                return new WeakReference<Thread>(Thread.currentThread());
            }
            return null;
        }
    }

    final class Holder {
        Holder() {
        }
    }
}

