/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ClassSpecializer;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import jdk.internal.org.objectweb.asm.ClassWriter;
import sun.invoke.util.Wrapper;

class GenerateJLIClassesHelper {
    static final Map<String, Integer> DMH_METHOD_TYPE_MAP = Map.of(LambdaForm.Kind.DIRECT_INVOKE_VIRTUAL.methodName, 0, LambdaForm.Kind.DIRECT_INVOKE_STATIC.methodName, 1, LambdaForm.Kind.DIRECT_INVOKE_SPECIAL.methodName, 2, LambdaForm.Kind.DIRECT_NEW_INVOKE_SPECIAL.methodName, 3, LambdaForm.Kind.DIRECT_INVOKE_INTERFACE.methodName, 4, LambdaForm.Kind.DIRECT_INVOKE_STATIC_INIT.methodName, 5, LambdaForm.Kind.DIRECT_INVOKE_SPECIAL_IFC.methodName, 20);
    static final String DIRECT_HOLDER = "java/lang/invoke/DirectMethodHandle$Holder";
    static final String DELEGATING_HOLDER = "java/lang/invoke/DelegatingMethodHandle$Holder";
    static final String BASIC_FORMS_HOLDER = "java/lang/invoke/LambdaForm$Holder";
    static final String INVOKERS_HOLDER = "java/lang/invoke/Invokers$Holder";
    static final String INVOKERS_HOLDER_CLASS_NAME = "java/lang/invoke/Invokers$Holder".replace('/', '.');
    static final String BMH_SPECIES_PREFIX = "java.lang.invoke.BoundMethodHandle$Species_";

    GenerateJLIClassesHelper() {
    }

    static Map<String, byte[]> generateHolderClasses(Stream<String> traces) {
        Objects.requireNonNull(traces);
        HolderClassBuilder builder = new HolderClassBuilder();
        traces.map(line -> line.split(" ")).forEach(parts -> {
            switch (parts[0]) {
                case "[SPECIES_RESOLVE]": {
                    String species;
                    assert (((String[])parts).length >= 2);
                    if (!parts[1].startsWith(BMH_SPECIES_PREFIX) || "L".equals(species = parts[1].substring(BMH_SPECIES_PREFIX.length()))) break;
                    builder.addSpeciesType(species);
                    break;
                }
                case "[LF_RESOLVE]": {
                    String dmh;
                    assert (((String[])parts).length > 3);
                    String methodType = parts[3];
                    if (parts[1].equals(INVOKERS_HOLDER_CLASS_NAME)) {
                        if ("linkToTargetMethod".equals(parts[2]) || "linkToCallSite".equals(parts[2])) {
                            builder.addCallSiteType(methodType);
                            break;
                        }
                        builder.addInvokerType(methodType);
                        break;
                    }
                    if (!parts[1].contains("DirectMethodHandle") || !DMH_METHOD_TYPE_MAP.containsKey(dmh = parts[2])) break;
                    builder.addDMHMethodType(dmh, methodType);
                    break;
                }
            }
        });
        return builder.build();
    }

    static byte[] generateBasicFormsClassBytes(String className) {
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        HashSet<String> dedupSet = new HashSet<String>();
        for (LambdaForm.BasicType type : LambdaForm.BasicType.values()) {
            LambdaForm zero = LambdaForm.zeroForm(type);
            String name = zero.kind.defaultLambdaName + "_" + zero.returnType().basicTypeChar();
            if (dedupSet.add(name)) {
                names.add(name);
                forms.add(zero);
            }
            LambdaForm identity = LambdaForm.identityForm(type);
            name = identity.kind.defaultLambdaName + "_" + identity.returnType().basicTypeChar();
            if (!dedupSet.add(name)) continue;
            names.add(name);
            forms.add(identity);
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateDirectMethodHandleHolderClassBytes(String className, MethodType[] methodTypes, int[] types) {
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < methodTypes.length; ++i) {
            if (!(types[i] != 0 && types[i] != 4 || methodTypes[i].parameterCount() >= 1 && methodTypes[i].parameterType(0) == Object.class)) {
                throw new InternalError("Invalid method type for " + (types[i] == 0 ? "invokeVirtual" : "invokeInterface") + " DMH, needs at least two leading reference arguments: " + methodTypes[i]);
            }
            LambdaForm form = DirectMethodHandle.makePreparedLambdaForm(methodTypes[i], types[i]);
            forms.add(form);
            names.add(form.kind.defaultLambdaName);
        }
        for (Wrapper wrapper : Wrapper.values()) {
            if (wrapper == Wrapper.VOID) continue;
            for (byte b = 0; b < 6; b = (byte)(b + 1)) {
                int ftype = DirectMethodHandle.ftypeKind(wrapper.primitiveType());
                LambdaForm form = DirectMethodHandle.makePreparedFieldLambdaForm(b, false, ftype);
                if (form.kind != LambdaForm.Kind.GENERIC) {
                    forms.add(form);
                    names.add(form.kind.defaultLambdaName);
                }
                form = DirectMethodHandle.makePreparedFieldLambdaForm(b, true, ftype);
                if (form.kind == LambdaForm.Kind.GENERIC) continue;
                forms.add(form);
                names.add(form.kind.defaultLambdaName);
            }
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateDelegatingMethodHandleHolderClassBytes(String className, MethodType[] methodTypes) {
        HashSet<MethodType> dedupSet = new HashSet<MethodType>();
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < methodTypes.length; ++i) {
            if (!dedupSet.add(methodTypes[i])) continue;
            LambdaForm reinvoker = GenerateJLIClassesHelper.makeReinvokerFor(methodTypes[i]);
            forms.add(reinvoker);
            String speciesSig = (String)BoundMethodHandle.speciesDataFor(reinvoker).key();
            assert (speciesSig.equals("L"));
            names.add(reinvoker.kind.defaultLambdaName + "_" + speciesSig);
            LambdaForm delegate = GenerateJLIClassesHelper.makeDelegateFor(methodTypes[i]);
            forms.add(delegate);
            names.add(delegate.kind.defaultLambdaName);
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    static byte[] generateInvokersHolderClassBytes(String className, MethodType[] invokerMethodTypes, MethodType[] callSiteMethodTypes) {
        int i;
        HashSet<MethodType> dedupSet = new HashSet<MethodType>();
        ArrayList<LambdaForm> forms = new ArrayList<LambdaForm>();
        ArrayList<String> names = new ArrayList<String>();
        int[] types = new int[]{10, 11, 12, 13};
        for (i = 0; i < invokerMethodTypes.length; ++i) {
            if (!dedupSet.add(invokerMethodTypes[i])) continue;
            for (int type : types) {
                LambdaForm invokerForm = Invokers.invokeHandleForm(invokerMethodTypes[i], false, type);
                forms.add(invokerForm);
                names.add(invokerForm.kind.defaultLambdaName);
            }
        }
        dedupSet = new HashSet();
        for (i = 0; i < callSiteMethodTypes.length; ++i) {
            if (!dedupSet.add(callSiteMethodTypes[i])) continue;
            LambdaForm callSiteForm = Invokers.callSiteForm(callSiteMethodTypes[i], true);
            forms.add(callSiteForm);
            names.add(callSiteForm.kind.defaultLambdaName);
            LambdaForm methodHandleForm = Invokers.callSiteForm(callSiteMethodTypes[i], false);
            forms.add(methodHandleForm);
            names.add(methodHandleForm.kind.defaultLambdaName);
        }
        return GenerateJLIClassesHelper.generateCodeBytesForLFs(className, names.toArray(new String[0]), forms.toArray(new LambdaForm[0]));
    }

    private static byte[] generateCodeBytesForLFs(String className, String[] names, LambdaForm[] forms) {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 50, className, null, "java/lang/Object", null);
        cw.visitSource(className.substring(className.lastIndexOf(47) + 1), null);
        for (int i = 0; i < forms.length; ++i) {
            InvokerBytecodeGenerator g = new InvokerBytecodeGenerator(className, names[i], forms[i], forms[i].methodType());
            g.setClassWriter(cw);
            g.addMethod();
        }
        return cw.toByteArray();
    }

    private static LambdaForm makeReinvokerFor(MethodType type) {
        MethodHandle emptyHandle = MethodHandles.empty(type);
        return DelegatingMethodHandle.makeReinvokerForm(emptyHandle, 7, BoundMethodHandle.speciesData_L(), BoundMethodHandle.speciesData_L().getterFunction(0));
    }

    private static LambdaForm makeDelegateFor(MethodType type) {
        MethodHandle handle = MethodHandles.empty(type);
        return DelegatingMethodHandle.makeReinvokerForm(handle, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
    }

    static Map.Entry<String, byte[]> generateConcreteBMHClassBytes(String types) {
        for (char c : types.toCharArray()) {
            if (LambdaForm.BasicType.isArgBasicTypeChar(c)) continue;
            throw new IllegalArgumentException("All characters must correspond to a basic field type: LIJFD");
        }
        BoundMethodHandle.SpeciesData species = (BoundMethodHandle.SpeciesData)BoundMethodHandle.SPECIALIZER.findSpecies(types);
        String className = species.speciesCode().getName();
        ClassSpecializer.Factory factory = BoundMethodHandle.SPECIALIZER.factory();
        byte[] code = factory.generateConcreteSpeciesCodeFile(className, species);
        return Map.entry(className.replace('.', '/'), code);
    }

    static class HolderClassBuilder {
        private final TreeSet<String> speciesTypes = new TreeSet();
        private final TreeSet<String> invokerTypes = new TreeSet();
        private final TreeSet<String> callSiteTypes = new TreeSet();
        private final Map<String, Set<String>> dmhMethods = new TreeMap<String, Set<String>>();

        HolderClassBuilder() {
        }

        HolderClassBuilder addSpeciesType(String type) {
            this.speciesTypes.add(HolderClassBuilder.expandSignature(type));
            return this;
        }

        HolderClassBuilder addInvokerType(String methodType) {
            HolderClassBuilder.validateMethodType(methodType);
            this.invokerTypes.add(methodType);
            return this;
        }

        HolderClassBuilder addCallSiteType(String csType) {
            HolderClassBuilder.validateMethodType(csType);
            this.callSiteTypes.add(csType);
            return this;
        }

        Map<String, byte[]> build() {
            int count = 0;
            for (Set<String> entry : this.dmhMethods.values()) {
                count += entry.size();
            }
            MethodType[] directMethodTypes = new MethodType[count];
            int[] dmhTypes = new int[count];
            int index = 0;
            for (Map.Entry<String, Set<String>> entry : this.dmhMethods.entrySet()) {
                String string = entry.getKey();
                for (String type : entry.getValue()) {
                    MethodType mt = HolderClassBuilder.asMethodType(type);
                    if (mt.parameterCount() < 1 || mt.parameterType(0) != Object.class) {
                        throw new RuntimeException("DMH type parameter must start with L: " + string + " " + type);
                    }
                    directMethodTypes[index] = mt.dropParameterTypes(0, 1);
                    dmhTypes[index] = DMH_METHOD_TYPE_MAP.get(string);
                    if (!(dmhTypes[index] != 4 && dmhTypes[index] != 0 || mt.parameterCount() >= 2 && mt.parameterType(1) == Object.class)) {
                        throw new RuntimeException("DMH type parameter must start with LL: " + string + " " + type);
                    }
                    ++index;
                }
            }
            MethodType[] invokerMethodTypes = new MethodType[this.invokerTypes.size()];
            index = 0;
            for (String string : this.invokerTypes) {
                MethodType mt = HolderClassBuilder.asMethodType(string);
                int lastParam = mt.parameterCount() - 1;
                if (mt.parameterCount() < 2 || mt.parameterType(0) != Object.class || mt.parameterType(lastParam) != Object.class) {
                    throw new RuntimeException("Invoker type parameter must start and end with Object: " + string);
                }
                mt = mt.dropParameterTypes(lastParam, lastParam + 1);
                invokerMethodTypes[index] = mt.dropParameterTypes(0, 1);
                ++index;
            }
            MethodType[] methodTypeArray = new MethodType[this.callSiteTypes.size()];
            index = 0;
            for (String callSiteType : this.callSiteTypes) {
                MethodType mt = HolderClassBuilder.asMethodType(callSiteType);
                int lastParam = mt.parameterCount() - 1;
                if (mt.parameterCount() < 1 || mt.parameterType(lastParam) != Object.class) {
                    throw new RuntimeException("CallSite type parameter must end with Object: " + callSiteType);
                }
                methodTypeArray[index] = mt.dropParameterTypes(lastParam, lastParam + 1);
                ++index;
            }
            TreeMap<String, byte[]> treeMap = new TreeMap<String, byte[]>();
            treeMap.put(GenerateJLIClassesHelper.DIRECT_HOLDER, GenerateJLIClassesHelper.generateDirectMethodHandleHolderClassBytes(GenerateJLIClassesHelper.DIRECT_HOLDER, directMethodTypes, dmhTypes));
            treeMap.put(GenerateJLIClassesHelper.DELEGATING_HOLDER, GenerateJLIClassesHelper.generateDelegatingMethodHandleHolderClassBytes(GenerateJLIClassesHelper.DELEGATING_HOLDER, directMethodTypes));
            treeMap.put(GenerateJLIClassesHelper.INVOKERS_HOLDER, GenerateJLIClassesHelper.generateInvokersHolderClassBytes(GenerateJLIClassesHelper.INVOKERS_HOLDER, invokerMethodTypes, methodTypeArray));
            treeMap.put(GenerateJLIClassesHelper.BASIC_FORMS_HOLDER, GenerateJLIClassesHelper.generateBasicFormsClassBytes(GenerateJLIClassesHelper.BASIC_FORMS_HOLDER));
            this.speciesTypes.forEach(types -> {
                Map.Entry<String, byte[]> entry = GenerateJLIClassesHelper.generateConcreteBMHClassBytes(types);
                result.put(entry.getKey(), entry.getValue());
            });
            this.speciesTypes.clear();
            this.invokerTypes.clear();
            this.callSiteTypes.clear();
            this.dmhMethods.clear();
            return treeMap;
        }

        private static MethodType asMethodType(String basicSignatureString) {
            String[] parts = basicSignatureString.split("_");
            assert (parts.length == 2);
            assert (parts[1].length() == 1);
            String parameters = HolderClassBuilder.expandSignature(parts[0]);
            Class<?> rtype = HolderClassBuilder.simpleType(parts[1].charAt(0));
            if (parameters.isEmpty()) {
                return MethodType.methodType(rtype);
            }
            Class[] ptypes = new Class[parameters.length()];
            for (int i = 0; i < ptypes.length; ++i) {
                ptypes[i] = HolderClassBuilder.simpleType(parameters.charAt(i));
            }
            return MethodType.methodType(rtype, ptypes);
        }

        private void addDMHMethodType(String dmh, String methodType) {
            HolderClassBuilder.validateMethodType(methodType);
            Set<String> methodTypes = this.dmhMethods.get(dmh);
            if (methodTypes == null) {
                methodTypes = new TreeSet<String>();
                this.dmhMethods.put(dmh, methodTypes);
            }
            methodTypes.add(methodType);
        }

        private static void validateMethodType(String type) {
            String[] typeParts = type.split("_");
            if (typeParts.length != 2 || typeParts[1].length() != 1 || !LambdaForm.BasicType.isBasicTypeChar(typeParts[1].charAt(0))) {
                throw new RuntimeException("Method type signature must be of form [LJIFD]*_[LJIFDV]");
            }
            HolderClassBuilder.expandSignature(typeParts[0]);
        }

        private static String expandSignature(String signature) {
            StringBuilder sb = new StringBuilder();
            char last = 'X';
            int count = 0;
            for (int i = 0; i < signature.length(); ++i) {
                char c = signature.charAt(i);
                if (c >= '0' && c <= '9') {
                    count *= 10;
                    count += c - 48;
                    continue;
                }
                HolderClassBuilder.requireBasicType(c);
                for (int j = 1; j < count; ++j) {
                    sb.append(last);
                }
                sb.append(c);
                last = c;
                count = 0;
            }
            if (count > 1) {
                HolderClassBuilder.requireBasicType(last);
                for (int j = 1; j < count; ++j) {
                    sb.append(last);
                }
            }
            return sb.toString();
        }

        private static void requireBasicType(char c) {
            if (!LambdaForm.BasicType.isArgBasicTypeChar(c)) {
                throw new RuntimeException("Character " + c + " must correspond to a basic field type: LIJFD");
            }
        }

        private static Class<?> simpleType(char c) {
            if (LambdaForm.BasicType.isBasicTypeChar(c)) {
                return LambdaForm.BasicType.basicType(c).basicTypeClass();
            }
            switch (c) {
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    throw new IllegalArgumentException("Not a valid primitive: " + c + " (use I instead)");
                }
            }
            throw new IllegalArgumentException("Not a primitive: " + c);
        }
    }
}

