/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarForm;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.function.BiFunction;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Stable;

class IndirectVarHandle
extends VarHandle {
    @Stable
    private final MethodHandle[] handleMap = new MethodHandle[VarHandle.AccessMode.COUNT];
    private final VarHandle directTarget;
    private final VarHandle target;
    private final BiFunction<VarHandle.AccessMode, MethodHandle, MethodHandle> handleFactory;
    private final Class<?> value;
    private final Class<?>[] coordinates;

    IndirectVarHandle(VarHandle target, Class<?> value, Class<?>[] coordinates, BiFunction<VarHandle.AccessMode, MethodHandle, MethodHandle> handleFactory) {
        this(target, value, coordinates, handleFactory, new VarForm(value, coordinates), false);
    }

    private IndirectVarHandle(VarHandle target, Class<?> value, Class<?>[] coordinates, BiFunction<VarHandle.AccessMode, MethodHandle, MethodHandle> handleFactory, VarForm form, boolean exact) {
        super(form, exact);
        this.handleFactory = handleFactory;
        this.target = target;
        this.directTarget = target.asDirect();
        this.value = value;
        this.coordinates = coordinates;
    }

    @Override
    public Class<?> varType() {
        return this.value;
    }

    @Override
    public List<Class<?>> coordinateTypes() {
        return List.of(this.coordinates);
    }

    @Override
    MethodType accessModeTypeUncached(VarHandle.AccessType at) {
        return at.accessModeType(null, this.value, this.coordinates);
    }

    @Override
    boolean isDirect() {
        return false;
    }

    @Override
    VarHandle asDirect() {
        return this.directTarget;
    }

    @Override
    VarHandle target() {
        return this.target;
    }

    @Override
    public VarHandle withInvokeExactBehavior() {
        return this.hasInvokeExactBehavior() ? this : new IndirectVarHandle(this.target, this.value, this.coordinates, this.handleFactory, this.vform, true);
    }

    @Override
    public VarHandle withInvokeBehavior() {
        return !this.hasInvokeExactBehavior() ? this : new IndirectVarHandle(this.target, this.value, this.coordinates, this.handleFactory, this.vform, false);
    }

    @Override
    @ForceInline
    MethodHandle getMethodHandle(int mode) {
        MethodHandle handle = this.handleMap[mode];
        if (handle == null) {
            MethodHandle targetHandle = this.target.getMethodHandle(mode);
            handle = this.handleMap[mode] = this.handleFactory.apply(VarHandle.AccessMode.values()[mode], targetHandle);
        }
        return handle;
    }

    @Override
    public MethodHandle toMethodHandle(VarHandle.AccessMode accessMode) {
        return this.getMethodHandle(accessMode.ordinal()).bindTo(this.directTarget);
    }
}

