/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.FilePermission;
import java.io.Serializable;
import java.lang.invoke.AbstractValidatingLambdaMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.LambdaProxyClassArchive;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.ProxyClassesDumper;
import java.lang.invoke.TypeConvertingMethodAdapter;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.PropertyPermission;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.misc.CDS;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.ConstantDynamic;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.Handle;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.Type;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyAccess;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

final class InnerClassLambdaMetafactory
extends AbstractValidatingLambdaMetafactory {
    private static final int CLASSFILE_VERSION = 59;
    private static final String METHOD_DESCRIPTOR_VOID = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
    private static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private static final String NAME_CTOR = "<init>";
    private static final String LAMBDA_INSTANCE_FIELD = "LAMBDA_INSTANCE$";
    private static final String NAME_SERIALIZED_LAMBDA = "java/lang/invoke/SerializedLambda";
    private static final String NAME_NOT_SERIALIZABLE_EXCEPTION = "java/io/NotSerializableException";
    private static final String DESCR_METHOD_WRITE_REPLACE = "()Ljava/lang/Object;";
    private static final String DESCR_METHOD_WRITE_OBJECT = "(Ljava/io/ObjectOutputStream;)V";
    private static final String DESCR_METHOD_READ_OBJECT = "(Ljava/io/ObjectInputStream;)V";
    private static final String NAME_METHOD_WRITE_REPLACE = "writeReplace";
    private static final String NAME_METHOD_READ_OBJECT = "readObject";
    private static final String NAME_METHOD_WRITE_OBJECT = "writeObject";
    private static final String DESCR_CLASS = "Ljava/lang/Class;";
    private static final String DESCR_STRING = "Ljava/lang/String;";
    private static final String DESCR_OBJECT = "Ljava/lang/Object;";
    private static final String DESCR_CTOR_SERIALIZED_LAMBDA = "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V";
    private static final String DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION = "(Ljava/lang/String;)V";
    private static final String[] SER_HOSTILE_EXCEPTIONS = new String[]{"java/io/NotSerializableException"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final AtomicInteger counter = new AtomicInteger();
    private static final ProxyClassesDumper dumper;
    private static final boolean disableEagerInitialization;
    private static final ConstantDynamic implMethodCondy;
    private final String implMethodClassName;
    private final String implMethodName;
    private final String implMethodDesc;
    private final MethodType constructorType;
    private final ClassWriter cw;
    private final String[] argNames;
    private final String[] argDescs;
    private final String lambdaClassName;
    private final boolean useImplMethodHandle;

    public InnerClassLambdaMetafactory(MethodHandles.Lookup caller, MethodType factoryType, String interfaceMethodName, MethodType interfaceMethodType, MethodHandle implementation, MethodType dynamicMethodType, boolean isSerializable, Class<?>[] altInterfaces, MethodType[] altMethods) throws LambdaConversionException {
        super(caller, factoryType, interfaceMethodName, interfaceMethodType, implementation, dynamicMethodType, isSerializable, altInterfaces, altMethods);
        this.implMethodClassName = this.implClass.getName().replace('.', '/');
        this.implMethodName = this.implInfo.getName();
        this.implMethodDesc = this.implInfo.getMethodType().toMethodDescriptorString();
        this.constructorType = factoryType.changeReturnType(Void.TYPE);
        this.lambdaClassName = InnerClassLambdaMetafactory.lambdaClassName(this.targetClass);
        this.useImplMethodHandle = Modifier.isProtected(this.implInfo.getModifiers()) && !VerifyAccess.isSamePackage(this.targetClass, this.implInfo.getDeclaringClass()) || this.implKind == 7;
        this.cw = new ClassWriter(1);
        int parameterCount = factoryType.parameterCount();
        if (parameterCount > 0) {
            this.argNames = new String[parameterCount];
            this.argDescs = new String[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                this.argNames[i] = "arg$" + (i + 1);
                this.argDescs[i] = BytecodeDescriptor.unparse(factoryType.parameterType(i));
            }
        } else {
            this.argDescs = EMPTY_STRING_ARRAY;
            this.argNames = EMPTY_STRING_ARRAY;
        }
    }

    private static String lambdaClassName(Class<?> targetClass) {
        String name = targetClass.getName();
        if (targetClass.isHidden()) {
            name = name.replace('/', '_');
        }
        return name.replace('.', '/') + "$$Lambda$" + counter.incrementAndGet();
    }

    @Override
    CallSite buildCallSite() throws LambdaConversionException {
        final Class<?> innerClass = this.spinInnerClass();
        if (this.factoryType.parameterCount() == 0) {
            if (disableEagerInitialization) {
                try {
                    return new ConstantCallSite(this.caller.findStaticGetter(innerClass, LAMBDA_INSTANCE_FIELD, (Class<?>)this.factoryType.returnType()));
                }
                catch (ReflectiveOperationException e) {
                    throw new LambdaConversionException("Exception finding LAMBDA_INSTANCE$ static field", e);
                }
            }
            Constructor<?>[] ctrs = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

                @Override
                public Constructor<?>[] run() {
                    Constructor<?>[] ctrs = innerClass.getDeclaredConstructors();
                    if (ctrs.length == 1) {
                        ctrs[0].setAccessible(true);
                    }
                    return ctrs;
                }
            });
            if (ctrs.length != 1) {
                throw new LambdaConversionException("Expected one lambda constructor for " + innerClass.getCanonicalName() + ", got " + ctrs.length);
            }
            try {
                Object inst = ctrs[0].newInstance(new Object[0]);
                return new ConstantCallSite(MethodHandles.constant(this.interfaceClass, inst));
            }
            catch (ReflectiveOperationException e) {
                throw new LambdaConversionException("Exception instantiating lambda object", e);
            }
        }
        try {
            MethodHandle mh = this.caller.findConstructor(innerClass, this.constructorType);
            return new ConstantCallSite(mh.asType(this.factoryType));
        }
        catch (ReflectiveOperationException e) {
            throw new LambdaConversionException("Exception finding constructor", e);
        }
    }

    private Class<?> spinInnerClass() throws LambdaConversionException {
        if (!disableEagerInitialization) {
            if (CDS.isDumpingArchive()) {
                Class<?> innerClass = this.generateInnerClass();
                LambdaProxyClassArchive.register(this.targetClass, this.interfaceMethodName, this.factoryType, this.interfaceMethodType, this.implementation, this.dynamicMethodType, this.isSerializable, this.altInterfaces, this.altMethods, innerClass);
                return innerClass;
            }
            Class<?> innerClass = LambdaProxyClassArchive.find(this.targetClass, this.interfaceMethodName, this.factoryType, this.interfaceMethodType, this.implementation, this.dynamicMethodType, this.isSerializable, this.altInterfaces, this.altMethods);
            if (innerClass != null) {
                return innerClass;
            }
        }
        return this.generateInnerClass();
    }

    private Class<?> generateInnerClass() throws LambdaConversionException {
        String[] interfaceNames;
        boolean accidentallySerializable;
        String interfaceName = this.interfaceClass.getName().replace('.', '/');
        boolean bl = accidentallySerializable = !this.isSerializable && Serializable.class.isAssignableFrom(this.interfaceClass);
        if (this.altInterfaces.length == 0) {
            interfaceNames = new String[]{interfaceName};
        } else {
            LinkedHashSet<String> itfs = new LinkedHashSet<String>(this.altInterfaces.length + 1);
            itfs.add(interfaceName);
            for (Class i : this.altInterfaces) {
                itfs.add(i.getName().replace('.', '/'));
                accidentallySerializable |= !this.isSerializable && Serializable.class.isAssignableFrom(i);
            }
            interfaceNames = itfs.toArray(new String[itfs.size()]);
        }
        this.cw.visit(59, 4144, this.lambdaClassName, null, JAVA_LANG_OBJECT, interfaceNames);
        for (int i = 0; i < this.argDescs.length; ++i) {
            MethodType[] fv = this.cw.visitField(18, this.argNames[i], this.argDescs[i], null, null);
            fv.visitEnd();
        }
        this.generateConstructor();
        if (this.factoryType.parameterCount() == 0 && disableEagerInitialization) {
            this.generateClassInitializer();
        }
        MethodVisitor mv = this.cw.visitMethod(1, this.interfaceMethodName, this.interfaceMethodType.toMethodDescriptorString(), null, null);
        new ForwardingMethodGenerator(mv).generate(this.interfaceMethodType);
        if (this.altMethods != null) {
            for (MethodType mt : this.altMethods) {
                mv = this.cw.visitMethod(1, this.interfaceMethodName, mt.toMethodDescriptorString(), null, null);
                new ForwardingMethodGenerator(mv).generate(mt);
            }
        }
        if (this.isSerializable) {
            this.generateSerializationFriendlyMethods();
        } else if (accidentallySerializable) {
            this.generateSerializationHostileMethods();
        }
        this.cw.visitEnd();
        final byte[] classBytes = this.cw.toByteArray();
        if (dumper != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    dumper.dumpClass(InnerClassLambdaMetafactory.this.lambdaClassName, classBytes);
                    return null;
                }
            }, null, new FilePermission("<<ALL FILES>>", "read, write"), new PropertyPermission("user.dir", "read"));
        }
        try {
            MethodHandles.Lookup lookup = this.useImplMethodHandle ? this.caller.defineHiddenClassWithClassData(classBytes, this.implementation, !disableEagerInitialization, MethodHandles.Lookup.ClassOption.NESTMATE, MethodHandles.Lookup.ClassOption.STRONG) : this.caller.defineHiddenClass(classBytes, !disableEagerInitialization, MethodHandles.Lookup.ClassOption.NESTMATE, MethodHandles.Lookup.ClassOption.STRONG);
            return lookup.lookupClass();
        }
        catch (IllegalAccessException e) {
            throw new LambdaConversionException("Exception defining lambda proxy class", e);
        }
        catch (Throwable t) {
            throw new InternalError(t);
        }
    }

    private void generateClassInitializer() {
        String lambdaTypeDescriptor = ((Class)this.factoryType.returnType()).descriptorString();
        FieldVisitor fv = this.cw.visitField(26, LAMBDA_INSTANCE_FIELD, lambdaTypeDescriptor, null, null);
        fv.visitEnd();
        MethodVisitor clinit = this.cw.visitMethod(8, "<clinit>", "()V", null, null);
        clinit.visitCode();
        clinit.visitTypeInsn(187, this.lambdaClassName);
        clinit.visitInsn(89);
        assert (this.factoryType.parameterCount() == 0);
        clinit.visitMethodInsn(183, this.lambdaClassName, NAME_CTOR, this.constructorType.toMethodDescriptorString(), false);
        clinit.visitFieldInsn(179, this.lambdaClassName, LAMBDA_INSTANCE_FIELD, lambdaTypeDescriptor);
        clinit.visitInsn(177);
        clinit.visitMaxs(-1, -1);
        clinit.visitEnd();
    }

    private void generateConstructor() {
        MethodVisitor ctor = this.cw.visitMethod(2, NAME_CTOR, this.constructorType.toMethodDescriptorString(), null, null);
        ctor.visitCode();
        ctor.visitVarInsn(25, 0);
        ctor.visitMethodInsn(183, JAVA_LANG_OBJECT, NAME_CTOR, METHOD_DESCRIPTOR_VOID, false);
        int parameterCount = this.factoryType.parameterCount();
        int lvIndex = 0;
        for (int i = 0; i < parameterCount; ++i) {
            ctor.visitVarInsn(25, 0);
            TypeDescriptor.OfField argType = this.factoryType.parameterType(i);
            ctor.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
            lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
            ctor.visitFieldInsn(181, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
        }
        ctor.visitInsn(177);
        ctor.visitMaxs(-1, -1);
        ctor.visitEnd();
    }

    private void generateSerializationFriendlyMethods() {
        TypeConvertingMethodAdapter mv = new TypeConvertingMethodAdapter(this.cw.visitMethod(18, NAME_METHOD_WRITE_REPLACE, DESCR_METHOD_WRITE_REPLACE, null, null));
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_SERIALIZED_LAMBDA);
        mv.visitInsn(89);
        mv.visitLdcInsn(Type.getType(this.targetClass));
        mv.visitLdcInsn(((Class)this.factoryType.returnType()).getName().replace('.', '/'));
        mv.visitLdcInsn(this.interfaceMethodName);
        mv.visitLdcInsn(this.interfaceMethodType.toMethodDescriptorString());
        mv.visitLdcInsn(this.implInfo.getReferenceKind());
        mv.visitLdcInsn(this.implInfo.getDeclaringClass().getName().replace('.', '/'));
        mv.visitLdcInsn(this.implInfo.getName());
        mv.visitLdcInsn(this.implInfo.getMethodType().toMethodDescriptorString());
        mv.visitLdcInsn(this.dynamicMethodType.toMethodDescriptorString());
        mv.iconst(this.argDescs.length);
        mv.visitTypeInsn(189, JAVA_LANG_OBJECT);
        for (int i = 0; i < this.argDescs.length; ++i) {
            mv.visitInsn(89);
            mv.iconst(i);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, this.lambdaClassName, this.argNames[i], this.argDescs[i]);
            mv.boxIfTypePrimitive(Type.getType(this.argDescs[i]));
            mv.visitInsn(83);
        }
        mv.visitMethodInsn(183, NAME_SERIALIZED_LAMBDA, NAME_CTOR, DESCR_CTOR_SERIALIZED_LAMBDA, false);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void generateSerializationHostileMethods() {
        MethodVisitor mv = this.cw.visitMethod(18, NAME_METHOD_WRITE_OBJECT, DESCR_METHOD_WRITE_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
        mv = this.cw.visitMethod(18, NAME_METHOD_READ_OBJECT, DESCR_METHOD_READ_OBJECT, null, SER_HOSTILE_EXCEPTIONS);
        mv.visitCode();
        mv.visitTypeInsn(187, NAME_NOT_SERIALIZABLE_EXCEPTION);
        mv.visitInsn(89);
        mv.visitLdcInsn("Non-serializable lambda");
        mv.visitMethodInsn(183, NAME_NOT_SERIALIZABLE_EXCEPTION, NAME_CTOR, DESCR_CTOR_NOT_SERIALIZABLE_EXCEPTION, false);
        mv.visitInsn(191);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    static int getParameterSize(Class<?> c) {
        if (c == Void.TYPE) {
            return 0;
        }
        if (c == Long.TYPE || c == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    static int getLoadOpcode(Class<?> c) {
        if (c == Void.TYPE) {
            throw new InternalError("Unexpected void type of load opcode");
        }
        return 21 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    static int getReturnOpcode(Class<?> c) {
        if (c == Void.TYPE) {
            return 177;
        }
        return 172 + InnerClassLambdaMetafactory.getOpcodeOffset(c);
    }

    private static int getOpcodeOffset(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Long.TYPE) {
                return 1;
            }
            if (c == Float.TYPE) {
                return 2;
            }
            if (c == Double.TYPE) {
                return 3;
            }
            return 0;
        }
        return 4;
    }

    static {
        String dumpProxyClassesKey = "jdk.internal.lambda.dumpProxyClasses";
        String dumpPath = GetPropertyAction.privilegedGetProperty("jdk.internal.lambda.dumpProxyClasses");
        dumper = null == dumpPath ? null : ProxyClassesDumper.getInstance(dumpPath);
        String disableEagerInitializationKey = "jdk.internal.lambda.disableEagerInitialization";
        disableEagerInitialization = GetBooleanAction.privilegedGetProperty("jdk.internal.lambda.disableEagerInitialization");
        MethodType classDataMType = MethodType.methodType(Object.class, MethodHandles.Lookup.class, String.class, Class.class);
        Handle classDataBsm = new Handle(6, Type.getInternalName(MethodHandles.class), "classData", classDataMType.descriptorString(), false);
        implMethodCondy = new ConstantDynamic("_", MethodHandle.class.descriptorString(), classDataBsm, new Object[0]);
    }

    private class ForwardingMethodGenerator
    extends TypeConvertingMethodAdapter {
        ForwardingMethodGenerator(MethodVisitor mv) {
            super(mv);
        }

        void generate(MethodType methodType) {
            this.visitCode();
            if (InnerClassLambdaMetafactory.this.implKind == 8) {
                this.visitTypeInsn(187, InnerClassLambdaMetafactory.this.implMethodClassName);
                this.visitInsn(89);
            }
            if (InnerClassLambdaMetafactory.this.useImplMethodHandle) {
                this.visitLdcInsn(implMethodCondy);
            }
            for (int i = 0; i < InnerClassLambdaMetafactory.this.argNames.length; ++i) {
                this.visitVarInsn(25, 0);
                this.visitFieldInsn(180, InnerClassLambdaMetafactory.this.lambdaClassName, InnerClassLambdaMetafactory.this.argNames[i], InnerClassLambdaMetafactory.this.argDescs[i]);
            }
            this.convertArgumentTypes(methodType);
            if (InnerClassLambdaMetafactory.this.useImplMethodHandle) {
                MethodType mtype = InnerClassLambdaMetafactory.this.implInfo.getMethodType();
                if (InnerClassLambdaMetafactory.this.implKind != 6) {
                    mtype = mtype.insertParameterTypes(0, InnerClassLambdaMetafactory.this.implClass);
                }
                this.visitMethodInsn(182, "java/lang/invoke/MethodHandle", "invokeExact", mtype.descriptorString(), false);
            } else {
                this.visitMethodInsn(this.invocationOpcode(), InnerClassLambdaMetafactory.this.implMethodClassName, InnerClassLambdaMetafactory.this.implMethodName, InnerClassLambdaMetafactory.this.implMethodDesc, InnerClassLambdaMetafactory.this.implClass.isInterface());
            }
            TypeDescriptor.OfField implReturnClass = InnerClassLambdaMetafactory.this.implMethodType.returnType();
            TypeDescriptor.OfField samReturnClass = methodType.returnType();
            this.convertType((Class<?>)implReturnClass, (Class<?>)samReturnClass, (Class<?>)samReturnClass);
            this.visitInsn(InnerClassLambdaMetafactory.getReturnOpcode(samReturnClass));
            this.visitMaxs(-1, -1);
            this.visitEnd();
        }

        private void convertArgumentTypes(MethodType samType) {
            int lvIndex = 0;
            int samParametersLength = samType.parameterCount();
            int captureArity = InnerClassLambdaMetafactory.this.factoryType.parameterCount();
            for (int i = 0; i < samParametersLength; ++i) {
                TypeDescriptor.OfField argType = samType.parameterType(i);
                this.visitVarInsn(InnerClassLambdaMetafactory.getLoadOpcode(argType), lvIndex + 1);
                lvIndex += InnerClassLambdaMetafactory.getParameterSize(argType);
                this.convertType((Class<?>)argType, (Class<?>)InnerClassLambdaMetafactory.this.implMethodType.parameterType(captureArity + i), (Class<?>)InnerClassLambdaMetafactory.this.dynamicMethodType.parameterType(i));
            }
        }

        private int invocationOpcode() throws InternalError {
            return switch (InnerClassLambdaMetafactory.this.implKind) {
                case 6 -> 184;
                case 8 -> 183;
                case 5 -> 182;
                case 9 -> 185;
                case 7 -> 183;
                default -> throw new InternalError("Unexpected invocation kind: " + InnerClassLambdaMetafactory.this.implKind);
            };
        }
    }
}

