/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.invoke.VarHandle;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.util.Arrays;
import jdk.internal.vm.annotation.DontInline;
import jdk.internal.vm.annotation.ForceInline;
import jdk.internal.vm.annotation.Hidden;
import jdk.internal.vm.annotation.Stable;

class Invokers {
    private final MethodType targetType;
    @Stable
    private final MethodHandle[] invokers = new MethodHandle[INV_LIMIT];
    static final int INV_EXACT = 0;
    static final int INV_GENERIC = 1;
    static final int INV_BASIC = 2;
    static final int VH_INV_EXACT = 3;
    static final int VH_INV_GENERIC = 3 + VarHandle.AccessMode.COUNT;
    static final int INV_LIMIT = VH_INV_GENERIC + VarHandle.AccessMode.COUNT;
    private static final int MH_LINKER_ARG_APPENDED = 1;
    private static final byte NF_checkExactType = 0;
    private static final byte NF_checkGenericType = 1;
    private static final byte NF_getCallSiteTarget = 2;
    private static final byte NF_checkCustomized = 3;
    private static final byte NF_checkVarHandleGenericType = 4;
    private static final byte NF_checkVarHandleExactType = 5;
    private static final byte NF_directVarHandleTarget = 6;
    private static final byte NF_LIMIT = 7;
    @Stable
    private static final LambdaForm.NamedFunction[] NFS = new LambdaForm.NamedFunction[7];

    Invokers(MethodType targetType) {
        this.targetType = targetType;
    }

    MethodHandle exactInvoker() {
        MethodHandle invoker = this.cachedInvoker(0);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeExactOrGeneralInvoker(true);
        return this.setCachedInvoker(0, invoker);
    }

    MethodHandle genericInvoker() {
        MethodHandle invoker = this.cachedInvoker(1);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeExactOrGeneralInvoker(false);
        return this.setCachedInvoker(1, invoker);
    }

    MethodHandle basicInvoker() {
        MethodHandle invoker = this.cachedInvoker(2);
        if (invoker != null) {
            return invoker;
        }
        MethodType basicType = this.targetType.basicType();
        if (basicType != this.targetType) {
            return this.setCachedInvoker(2, basicType.invokers().basicInvoker());
        }
        invoker = basicType.form().cachedMethodHandle(0);
        if (invoker == null) {
            MemberName method = Invokers.invokeBasicMethod(basicType);
            invoker = DirectMethodHandle.make(method);
            assert (this.checkInvoker(invoker));
            invoker = basicType.form().setCachedMethodHandle(0, invoker);
        }
        return this.setCachedInvoker(2, invoker);
    }

    MethodHandle varHandleMethodInvoker(VarHandle.AccessMode ak) {
        boolean isExact = false;
        MethodHandle invoker = this.cachedVHInvoker(isExact, ak);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeVarHandleMethodInvoker(ak, isExact);
        return this.setCachedVHInvoker(isExact, ak, invoker);
    }

    MethodHandle varHandleMethodExactInvoker(VarHandle.AccessMode ak) {
        boolean isExact = true;
        MethodHandle invoker = this.cachedVHInvoker(isExact, ak);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.makeVarHandleMethodInvoker(ak, isExact);
        return this.setCachedVHInvoker(isExact, ak, invoker);
    }

    private MethodHandle cachedInvoker(int idx) {
        return this.invokers[idx];
    }

    private synchronized MethodHandle setCachedInvoker(int idx, MethodHandle invoker) {
        MethodHandle prev = this.invokers[idx];
        if (prev != null) {
            return prev;
        }
        this.invokers[idx] = invoker;
        return this.invokers[idx];
    }

    private MethodHandle cachedVHInvoker(boolean isExact, VarHandle.AccessMode ak) {
        int baseIndex = isExact ? 3 : VH_INV_GENERIC;
        return this.cachedInvoker(baseIndex + ak.ordinal());
    }

    private MethodHandle setCachedVHInvoker(boolean isExact, VarHandle.AccessMode ak, MethodHandle invoker) {
        int baseIndex = isExact ? 3 : VH_INV_GENERIC;
        return this.setCachedInvoker(baseIndex + ak.ordinal(), invoker);
    }

    private MethodHandle makeExactOrGeneralInvoker(boolean isExact) {
        MethodType mtype = this.targetType;
        MethodType invokerType = mtype.invokerType();
        int which = isExact ? 11 : 13;
        LambdaForm lform = Invokers.invokeHandleForm(mtype, false, which);
        MethodHandle invoker = BoundMethodHandle.bindSingle(invokerType, lform, mtype);
        String whichName = isExact ? "invokeExact" : "invoke";
        invoker = invoker.withInternalMemberName(MemberName.makeMethodHandleInvoke(whichName, mtype), false);
        assert (this.checkInvoker(invoker));
        this.maybeCompileToBytecode(invoker);
        return invoker;
    }

    private MethodHandle makeVarHandleMethodInvoker(VarHandle.AccessMode ak, boolean isExact) {
        MethodType mtype = this.targetType;
        MethodType invokerType = mtype.insertParameterTypes(0, VarHandle.class);
        LambdaForm lform = Invokers.varHandleMethodInvokerHandleForm(mtype, isExact);
        VarHandle.AccessDescriptor ad = new VarHandle.AccessDescriptor(mtype, ak.at.ordinal(), ak.ordinal());
        MethodHandle invoker = BoundMethodHandle.bindSingle(invokerType, lform, ad);
        invoker = invoker.withInternalMemberName(MemberName.makeVarHandleMethodInvoke(ak.methodName(), mtype), false);
        assert (this.checkVarHandleInvoker(invoker));
        this.maybeCompileToBytecode(invoker);
        return invoker;
    }

    private void maybeCompileToBytecode(MethodHandle invoker) {
        int EAGER_COMPILE_ARITY_LIMIT = 10;
        if (this.targetType == this.targetType.erase() && this.targetType.parameterCount() < 10) {
            invoker.form.compileToBytecode();
        }
    }

    static MemberName invokeBasicMethod(MethodType basicType) {
        assert (basicType == basicType.basicType());
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, MethodHandle.class, "invokeBasic", basicType);
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError("JVM cannot find invoker for " + basicType, ex);
        }
    }

    private boolean checkInvoker(MethodHandle invoker) {
        assert (this.targetType.invokerType().equals((Object)invoker.type())) : Arrays.asList(this.targetType, this.targetType.invokerType(), invoker);
        assert (invoker.internalMemberName() == null || invoker.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!invoker.isVarargsCollector());
        return true;
    }

    private boolean checkVarHandleInvoker(MethodHandle invoker) {
        MethodType invokerType = this.targetType.insertParameterTypes(0, VarHandle.class);
        assert (invokerType.equals((Object)invoker.type())) : Arrays.asList(this.targetType, invokerType, invoker);
        assert (invoker.internalMemberName() == null || invoker.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!invoker.isVarargsCollector());
        return true;
    }

    MethodHandle spreadInvoker(int leadingArgCount) {
        int spreadArgCount = this.targetType.parameterCount() - leadingArgCount;
        MethodType postSpreadType = this.targetType;
        Class<?> argArrayType = Invokers.impliedRestargType(postSpreadType, leadingArgCount);
        if (postSpreadType.parameterSlotCount() <= 253) {
            return this.genericInvoker().asSpreader(argArrayType, spreadArgCount);
        }
        MethodType preSpreadType = postSpreadType.replaceParameterTypes(leadingArgCount, postSpreadType.parameterCount(), argArrayType);
        MethodHandle arrayInvoker = MethodHandles.invoker(preSpreadType);
        MethodHandle makeSpreader = MethodHandles.insertArguments(Lazy.MH_asSpreader, 1, argArrayType, spreadArgCount);
        return MethodHandles.filterArgument(arrayInvoker, 0, makeSpreader);
    }

    private static Class<?> impliedRestargType(MethodType restargType, int fromPos) {
        if (restargType.isGeneric()) {
            return Object[].class;
        }
        int maxPos = restargType.parameterCount();
        if (fromPos >= maxPos) {
            return Object[].class;
        }
        TypeDescriptor.OfField argType = restargType.parameterType(fromPos);
        for (int i = fromPos + 1; i < maxPos; ++i) {
            if (argType == restargType.parameterType(i)) continue;
            throw MethodHandleStatics.newIllegalArgumentException("need homogeneous rest arguments", restargType);
        }
        if (argType == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(argType, 0).getClass();
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }

    static MemberName methodHandleInvokeLinkerMethod(String name, MethodType mtype, Object[] appendixResult) {
        LambdaForm lform;
        int which = switch (name) {
            case "invokeExact" -> 10;
            case "invoke" -> 12;
            default -> throw new InternalError("not invoker: " + name);
        };
        if (mtype.parameterSlotCount() <= 253) {
            lform = Invokers.invokeHandleForm(mtype, false, which);
            appendixResult[0] = mtype;
        } else {
            lform = Invokers.invokeHandleForm(mtype, true, which);
        }
        return lform.vmentry;
    }

    static LambdaForm invokeHandleForm(MethodType mtype, boolean customized, int which) {
        MethodType mtypeArg;
        LambdaForm lform;
        boolean isGeneric;
        boolean isLinker;
        boolean isCached;
        if (!customized) {
            mtype = mtype.basicType();
            isCached = true;
        } else {
            isCached = false;
        }
        LambdaForm.Kind kind = switch (which) {
            case 10 -> {
                isLinker = true;
                isGeneric = false;
                yield LambdaForm.Kind.EXACT_LINKER;
            }
            case 11 -> {
                isLinker = false;
                isGeneric = false;
                yield LambdaForm.Kind.EXACT_INVOKER;
            }
            case 12 -> {
                isLinker = true;
                isGeneric = true;
                yield LambdaForm.Kind.GENERIC_LINKER;
            }
            case 13 -> {
                isLinker = false;
                isGeneric = true;
                yield LambdaForm.Kind.GENERIC_INVOKER;
            }
            default -> throw new InternalError();
        };
        if (isCached && (lform = mtype.form().cachedLambdaForm(which)) != null) {
            return lform;
        }
        boolean THIS_MH = false;
        int CALL_MH = 0 + (isLinker ? 0 : 1);
        int ARG_BASE = CALL_MH + 1;
        int OUTARG_LIMIT = ARG_BASE + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + (isLinker && !customized ? 1 : 0);
        int nameCursor = OUTARG_LIMIT;
        int MTYPE_ARG = customized ? -1 : nameCursor++;
        int CHECK_TYPE = nameCursor++;
        int CHECK_CUSTOM = MethodHandleStatics.CUSTOMIZE_THRESHOLD >= 0 ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.invokerType();
        if (isLinker) {
            if (!customized) {
                invokerFormType = invokerFormType.appendParameterTypes(MemberName.class);
            }
        } else {
            invokerFormType = invokerFormType.invokerType();
        }
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor) : Arrays.asList(mtype, customized, which, nameCursor, names.length);
        if (MTYPE_ARG >= INARG_LIMIT) {
            assert (names[MTYPE_ARG] == null);
            BoundMethodHandle.SpeciesData speciesData = BoundMethodHandle.speciesData_L();
            names[0] = names[0].withConstraint(speciesData);
            LambdaForm.NamedFunction getter = speciesData.getterFunction(0);
            names[MTYPE_ARG] = new LambdaForm.Name(getter, names[0]);
        }
        MethodType outCallType = mtype.basicType();
        Object[] outArgs = Arrays.copyOfRange(names, CALL_MH, OUTARG_LIMIT, Object[].class);
        MethodType methodType = mtypeArg = customized ? mtype : names[MTYPE_ARG];
        if (!isGeneric) {
            names[CHECK_TYPE] = new LambdaForm.Name(Invokers.getFunction((byte)0), names[CALL_MH], mtypeArg);
        } else {
            names[CHECK_TYPE] = new LambdaForm.Name(Invokers.getFunction((byte)1), names[CALL_MH], mtypeArg);
            outArgs[0] = names[CHECK_TYPE];
        }
        if (CHECK_CUSTOM != -1) {
            names[CHECK_CUSTOM] = new LambdaForm.Name(Invokers.getFunction((byte)3), outArgs[0]);
        }
        names[LINKER_CALL] = new LambdaForm.Name(outCallType, outArgs);
        lform = customized ? new LambdaForm(INARG_LIMIT, names) : new LambdaForm(INARG_LIMIT, names, kind);
        if (isLinker) {
            lform.compileToBytecode();
        }
        if (isCached) {
            lform = mtype.form().setCachedLambdaForm(which, lform);
        }
        return lform;
    }

    static MemberName varHandleInvokeLinkerMethod(MethodType mtype) {
        if (mtype.parameterSlotCount() > 253) {
            throw MethodHandleStatics.newInternalError("Unsupported parameter slot count " + mtype.parameterSlotCount());
        }
        LambdaForm lform = Invokers.varHandleMethodGenericLinkerHandleForm(mtype);
        return lform.vmentry;
    }

    private static LambdaForm varHandleMethodGenericLinkerHandleForm(MethodType mtype) {
        int ARG_LIMIT;
        mtype = mtype.basicType();
        int which = 24;
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        boolean THIS_VH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + mtype.parameterCount();
        int VAD_ARG = nameCursor++;
        int UNBOUND_VH = nameCursor++;
        int CHECK_TYPE = nameCursor++;
        int CHECK_CUSTOM = MethodHandleStatics.CUSTOMIZE_THRESHOLD >= 0 ? nameCursor++ : -1;
        int LINKER_CALL = nameCursor++;
        LambdaForm.Name[] names = new LambdaForm.Name[LINKER_CALL + 1];
        names[0] = LambdaForm.argument(0, LambdaForm.BasicType.basicType(Object.class));
        for (int i = 0; i < mtype.parameterCount(); ++i) {
            names[1 + i] = LambdaForm.argument(1 + i, LambdaForm.BasicType.basicType(mtype.parameterType(i)));
        }
        names[VAD_ARG] = new LambdaForm.Name(ARG_LIMIT, LambdaForm.BasicType.basicType(Object.class));
        names[UNBOUND_VH] = new LambdaForm.Name(Invokers.getFunction((byte)6), names[0]);
        names[CHECK_TYPE] = new LambdaForm.Name(Invokers.getFunction((byte)4), names[0], names[VAD_ARG]);
        Object[] outArgs = new Object[ARG_LIMIT + 1];
        outArgs[0] = names[CHECK_TYPE];
        outArgs[1] = names[UNBOUND_VH];
        for (int i = 1; i < ARG_LIMIT; ++i) {
            outArgs[i + 1] = names[i];
        }
        if (CHECK_CUSTOM != -1) {
            names[CHECK_CUSTOM] = new LambdaForm.Name(Invokers.getFunction((byte)3), outArgs[0]);
        }
        MethodType outCallType = mtype.insertParameterTypes(0, VarHandle.class).basicType();
        names[LINKER_CALL] = new LambdaForm.Name(outCallType, outArgs);
        lform = new LambdaForm(ARG_LIMIT + 1, names, LambdaForm.Kind.VARHANDLE_LINKER);
        if (LambdaForm.debugNames()) {
            String name = "VarHandle_invoke_MT_" + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(mtype));
            LambdaForm.associateWithDebugName(lform, name);
        }
        lform.compileToBytecode();
        lform = mtype.form().setCachedLambdaForm(which, lform);
        return lform;
    }

    private static LambdaForm varHandleMethodInvokerHandleForm(MethodType mtype, boolean isExact) {
        int ARG_LIMIT;
        mtype = mtype.basicType();
        int which = isExact ? 22 : 23;
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean CALL_VH = true;
        int ARG_BASE = 2;
        int nameCursor = ARG_LIMIT = 2 + mtype.parameterCount();
        int VAD_ARG = nameCursor++;
        int UNBOUND_VH = nameCursor++;
        int CHECK_TYPE = nameCursor++;
        int LINKER_CALL = nameCursor++;
        LambdaForm.Name[] names = new LambdaForm.Name[LINKER_CALL + 1];
        names[0] = LambdaForm.argument(0, LambdaForm.BasicType.basicType(Object.class));
        names[1] = LambdaForm.argument(1, LambdaForm.BasicType.basicType(Object.class));
        for (int i = 0; i < mtype.parameterCount(); ++i) {
            names[2 + i] = LambdaForm.argument(2 + i, LambdaForm.BasicType.basicType(mtype.parameterType(i)));
        }
        BoundMethodHandle.SpeciesData speciesData = BoundMethodHandle.speciesData_L();
        names[0] = names[0].withConstraint(speciesData);
        LambdaForm.NamedFunction getter = speciesData.getterFunction(0);
        names[VAD_ARG] = new LambdaForm.Name(getter, names[0]);
        names[UNBOUND_VH] = new LambdaForm.Name(Invokers.getFunction((byte)6), names[1]);
        names[CHECK_TYPE] = isExact ? new LambdaForm.Name(Invokers.getFunction((byte)5), names[1], names[VAD_ARG]) : new LambdaForm.Name(Invokers.getFunction((byte)4), names[1], names[VAD_ARG]);
        Object[] outArgs = new Object[ARG_LIMIT];
        outArgs[0] = names[CHECK_TYPE];
        outArgs[1] = names[UNBOUND_VH];
        for (int i = 2; i < ARG_LIMIT; ++i) {
            outArgs[i] = names[i];
        }
        MethodType outCallType = mtype.insertParameterTypes(0, VarHandle.class).basicType();
        names[LINKER_CALL] = new LambdaForm.Name(outCallType, outArgs);
        LambdaForm.Kind kind = isExact ? LambdaForm.Kind.VARHANDLE_EXACT_INVOKER : LambdaForm.Kind.VARHANDLE_INVOKER;
        lform = new LambdaForm(ARG_LIMIT, names, kind);
        if (LambdaForm.debugNames()) {
            String name = (isExact ? "VarHandle_exactInvoker_" : "VarHandle_invoker_") + LambdaForm.shortenSignature(LambdaForm.basicTypeSignature(mtype));
            LambdaForm.associateWithDebugName(lform, name);
        }
        lform.prepare();
        lform = mtype.form().setCachedLambdaForm(which, lform);
        return lform;
    }

    @ForceInline
    @Hidden
    static MethodHandle checkVarHandleGenericType(VarHandle handle, VarHandle.AccessDescriptor ad) {
        if (handle.hasInvokeExactBehavior() && handle.accessModeType(ad.type) != ad.symbolicMethodTypeExact) {
            throw new WrongMethodTypeException("expected " + handle.accessModeType(ad.type) + " but found " + ad.symbolicMethodTypeExact);
        }
        MethodHandle mh = handle.getMethodHandle(ad.mode);
        if (mh.type() != ad.symbolicMethodTypeInvoker) {
            return mh.asType(ad.symbolicMethodTypeInvoker);
        }
        return mh;
    }

    @ForceInline
    static MethodHandle checkVarHandleExactType(VarHandle handle, VarHandle.AccessDescriptor ad) {
        MethodHandle mh = handle.getMethodHandle(ad.mode);
        MethodType mt = mh.type();
        if (mt != ad.symbolicMethodTypeInvoker) {
            throw Invokers.newWrongMethodTypeException(mt, ad.symbolicMethodTypeInvoker);
        }
        return mh;
    }

    static WrongMethodTypeException newWrongMethodTypeException(MethodType actual, MethodType expected) {
        return new WrongMethodTypeException("expected " + expected + " but found " + actual);
    }

    @ForceInline
    static void checkExactType(MethodHandle mh, MethodType expected) {
        MethodType actual = mh.type();
        if (actual != expected) {
            throw Invokers.newWrongMethodTypeException(expected, actual);
        }
    }

    @ForceInline
    static MethodHandle checkGenericType(MethodHandle mh, MethodType expected) {
        return mh.asType(expected);
    }

    @ForceInline
    static VarHandle directVarHandleTarget(VarHandle handle) {
        return handle.asDirect();
    }

    static MemberName linkToCallSiteMethod(MethodType mtype) {
        LambdaForm lform = Invokers.callSiteForm(mtype, false);
        return lform.vmentry;
    }

    static MemberName linkToTargetMethod(MethodType mtype) {
        LambdaForm lform = Invokers.callSiteForm(mtype, true);
        return lform.vmentry;
    }

    static LambdaForm callSiteForm(MethodType mtype, boolean skipCallSite) {
        mtype = mtype.basicType();
        int which = skipCallSite ? 15 : 14;
        LambdaForm lform = mtype.form().cachedLambdaForm(which);
        if (lform != null) {
            return lform;
        }
        boolean ARG_BASE = false;
        int OUTARG_LIMIT = 0 + mtype.parameterCount();
        int INARG_LIMIT = OUTARG_LIMIT + 1;
        int nameCursor = OUTARG_LIMIT;
        int APPENDIX_ARG = nameCursor++;
        int CSITE_ARG = skipCallSite ? -1 : APPENDIX_ARG;
        int CALL_MH = skipCallSite ? APPENDIX_ARG : nameCursor++;
        int LINKER_CALL = nameCursor++;
        MethodType invokerFormType = mtype.appendParameterTypes(skipCallSite ? MethodHandle.class : CallSite.class);
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - INARG_LIMIT, invokerFormType);
        assert (names.length == nameCursor);
        assert (names[APPENDIX_ARG] != null);
        if (!skipCallSite) {
            names[CALL_MH] = new LambdaForm.Name(Invokers.getFunction((byte)2), names[CSITE_ARG]);
        }
        boolean PREPEND_MH = false;
        boolean PREPEND_COUNT = true;
        Object[] outArgs = Arrays.copyOfRange(names, 0, OUTARG_LIMIT + 1, Object[].class);
        System.arraycopy(outArgs, 0, outArgs, 1, outArgs.length - 1);
        outArgs[0] = names[CALL_MH];
        names[LINKER_CALL] = new LambdaForm.Name(mtype, outArgs);
        lform = new LambdaForm(INARG_LIMIT, names, skipCallSite ? LambdaForm.Kind.LINK_TO_TARGET_METHOD : LambdaForm.Kind.LINK_TO_CALL_SITE);
        lform.compileToBytecode();
        lform = mtype.form().setCachedLambdaForm(which, lform);
        return lform;
    }

    @ForceInline
    static MethodHandle getCallSiteTarget(CallSite site) {
        return site.getTarget();
    }

    @ForceInline
    static void checkCustomized(MethodHandle mh) {
        if (MethodHandleImpl.isCompileConstant(mh)) {
            return;
        }
        if (mh.form.customized == null) {
            Invokers.maybeCustomize(mh);
        }
    }

    @DontInline
    static void maybeCustomize(MethodHandle mh) {
        mh.maybeCustomize();
    }

    private static LambdaForm.NamedFunction getFunction(byte func) {
        LambdaForm.NamedFunction nf = NFS[func];
        if (nf != null) {
            return nf;
        }
        Invokers.NFS[func] = nf = Invokers.createFunction(func);
        assert (InvokerBytecodeGenerator.isStaticallyInvocable(nf));
        return nf;
    }

    private static LambdaForm.NamedFunction createFunction(byte func) {
        try {
            return switch (func) {
                case 0 -> Invokers.getNamedFunction("checkExactType", MethodType.methodType(Void.TYPE, MethodHandle.class, MethodType.class));
                case 1 -> Invokers.getNamedFunction("checkGenericType", MethodType.methodType(MethodHandle.class, MethodHandle.class, MethodType.class));
                case 2 -> Invokers.getNamedFunction("getCallSiteTarget", MethodType.methodType(MethodHandle.class, CallSite.class));
                case 3 -> Invokers.getNamedFunction("checkCustomized", MethodType.methodType(Void.TYPE, MethodHandle.class));
                case 4 -> Invokers.getNamedFunction("checkVarHandleGenericType", MethodType.methodType(MethodHandle.class, VarHandle.class, VarHandle.AccessDescriptor.class));
                case 5 -> Invokers.getNamedFunction("checkVarHandleExactType", MethodType.methodType(MethodHandle.class, VarHandle.class, VarHandle.AccessDescriptor.class));
                case 6 -> Invokers.getNamedFunction("directVarHandleTarget", MethodType.methodType(VarHandle.class, VarHandle.class));
                default -> throw MethodHandleStatics.newInternalError("Unknown function: " + func);
            };
        }
        catch (ReflectiveOperationException ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }

    private static LambdaForm.NamedFunction getNamedFunction(String name, MethodType type) throws ReflectiveOperationException {
        MemberName member = new MemberName(Invokers.class, name, type, 6);
        return new LambdaForm.NamedFunction(MemberName.getFactory().resolveOrFail((byte)6, member, Invokers.class, -1, NoSuchMethodException.class));
    }

    static {
        MethodHandleStatics.UNSAFE.ensureClassInitialized(Holder.class);
    }

    private static class Lazy {
        private static final MethodHandle MH_asSpreader;

        private Lazy() {
        }

        static {
            try {
                MH_asSpreader = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, "asSpreader", MethodType.methodType(MethodHandle.class, Class.class, Integer.TYPE));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    final class Holder {
        Holder() {
        }
    }
}

