/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ClassSpecializer;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import jdk.internal.perf.PerfCounter;
import jdk.internal.vm.annotation.DontInline;
import jdk.internal.vm.annotation.Hidden;
import jdk.internal.vm.annotation.Stable;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    final boolean forceInline;
    final MethodHandle customized;
    @Stable
    final Name[] names;
    final Kind kind;
    MemberName vmentry;
    private boolean isCompiled;
    volatile Object transformCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    @Stable
    private static PerfCounter LF_FAILED;
    private static final int COMPILE_THRESHOLD;
    private int invocationCounter = 0;
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS;
    private static final MemberName.Factory IMPL_NAMES;
    @Stable
    private static final LambdaForm[] LF_identity;
    @Stable
    private static final LambdaForm[] LF_zero;
    @Stable
    private static final NamedFunction[] NF_identity;
    @Stable
    private static final NamedFunction[] NF_zero;
    private static final Object createFormsLock;
    private static final HashMap<String, Integer> DEBUG_NAME_COUNTERS;
    private static final HashMap<LambdaForm, String> DEBUG_NAMES;
    private static final boolean TRACE_INTERPRETER;

    LambdaForm(int arity, Name[] names, int result) {
        this(arity, names, result, true, null, Kind.GENERIC);
    }

    LambdaForm(int arity, Name[] names, int result, Kind kind) {
        this(arity, names, result, true, null, kind);
    }

    LambdaForm(int arity, Name[] names, int result, boolean forceInline, MethodHandle customized) {
        this(arity, names, result, forceInline, customized, Kind.GENERIC);
    }

    LambdaForm(int arity, Name[] names, int result, boolean forceInline, MethodHandle customized, Kind kind) {
        assert (LambdaForm.namesOK(arity, names));
        this.arity = arity;
        this.result = LambdaForm.fixResult(result, names);
        this.names = (Name[])names.clone();
        this.forceInline = forceInline;
        this.customized = customized;
        this.kind = kind;
        int maxOutArity = this.normalize();
        if (maxOutArity > 253) {
            assert (maxOutArity <= 255);
            this.compileToBytecode();
        }
    }

    LambdaForm(int arity, Name[] names) {
        this(arity, names, -2, true, null, Kind.GENERIC);
    }

    LambdaForm(int arity, Name[] names, Kind kind) {
        this(arity, names, -2, true, null, kind);
    }

    LambdaForm(int arity, Name[] names, boolean forceInline, Kind kind) {
        this(arity, names, -2, forceInline, null, kind);
    }

    private static Name[] buildNames(Name[] formals, Name[] temps, Name result) {
        int arity = formals.length;
        int length = arity + temps.length + (result == null ? 0 : 1);
        Name[] names = Arrays.copyOf(formals, length);
        System.arraycopy(temps, 0, names, arity, temps.length);
        if (result != null) {
            names[length - 1] = result;
        }
        return names;
    }

    private LambdaForm(MethodType mt) {
        this.arity = mt.parameterCount();
        this.result = mt.returnType() == Void.TYPE || mt.returnType() == Void.class ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, mt, this.result == -1);
        this.forceInline = true;
        this.customized = null;
        this.kind = Kind.ZERO;
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        String sig = null;
        assert (LambdaForm.isValidSignature(sig = this.basicTypeSignature()));
        assert (sig.equals(this.basicTypeSignature())) : sig + " != " + this.basicTypeSignature();
    }

    private static Name[] buildEmptyNames(int arity, MethodType mt, boolean isVoid) {
        Name[] names = LambdaForm.arguments(isVoid ? 0 : 1, mt);
        if (!isVoid) {
            Name zero = new Name(LambdaForm.constantZero(BasicType.basicType(mt.returnType())), new Object[0]);
            names[arity] = zero.newIndex(arity);
        }
        return names;
    }

    private static int fixResult(int result, Name[] names) {
        if (result == -2) {
            result = names.length - 1;
        }
        if (result >= 0 && names[result].type == BasicType.V_TYPE) {
            result = -1;
        }
        return result;
    }

    static boolean debugNames() {
        return DEBUG_NAME_COUNTERS != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void associateWithDebugName(LambdaForm form, String name) {
        assert (LambdaForm.debugNames());
        HashMap<LambdaForm, String> hashMap = DEBUG_NAMES;
        synchronized (hashMap) {
            DEBUG_NAMES.put(form, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String lambdaName() {
        if (DEBUG_NAMES != null) {
            HashMap<LambdaForm, String> hashMap = DEBUG_NAMES;
            synchronized (hashMap) {
                String name = DEBUG_NAMES.get(this);
                if (name == null) {
                    name = this.generateDebugName();
                }
                return name;
            }
        }
        return this.kind.defaultLambdaName;
    }

    private String generateDebugName() {
        assert (LambdaForm.debugNames());
        String debugNameStem = this.kind.defaultLambdaName;
        Integer ctr = DEBUG_NAME_COUNTERS.getOrDefault(debugNameStem, 0);
        DEBUG_NAME_COUNTERS.put(debugNameStem, ctr + 1);
        StringBuilder buf = new StringBuilder(debugNameStem);
        int leadingZero = buf.length();
        buf.append(ctr);
        for (int i = buf.length() - leadingZero; i < 3; ++i) {
            buf.insert(leadingZero, '0');
        }
        buf.append('_');
        buf.append(this.basicTypeSignature());
        String name = buf.toString();
        LambdaForm.associateWithDebugName(this, name);
        return name;
    }

    private static boolean namesOK(int arity, Name[] names) {
        for (int i = 0; i < names.length; ++i) {
            Name n = names[i];
            assert (n != null) : "n is null";
            if (i < arity) {
                assert (n.isParam()) : n + " is not param at " + i;
                continue;
            }
            assert (!n.isParam()) : n + " is param at " + i;
        }
        return true;
    }

    LambdaForm customize(MethodHandle mh) {
        if (this.customized == mh) {
            return this;
        }
        LambdaForm customForm = new LambdaForm(this.arity, this.names, this.result, this.forceInline, mh, this.kind);
        if (COMPILE_THRESHOLD >= 0 && this.isCompiled) {
            customForm.compileToBytecode();
        }
        customForm.transformCache = this;
        return customForm;
    }

    LambdaForm uncustomize() {
        if (this.customized == null) {
            return this;
        }
        assert (this.transformCache != null);
        LambdaForm uncustomizedForm = (LambdaForm)this.transformCache;
        if (COMPILE_THRESHOLD >= 0 && this.isCompiled) {
            uncustomizedForm.compileToBytecode();
        }
        return uncustomizedForm;
    }

    private int normalize() {
        int i;
        Name[] oldNames = null;
        int maxOutArity = 0;
        int changesStart = 0;
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            Name n = this.names[i2];
            if (!n.initIndex(i2)) {
                if (oldNames == null) {
                    oldNames = (Name[])this.names.clone();
                    changesStart = i2;
                }
                this.names[i2] = n.cloneWithIndex(i2);
            }
            if (n.arguments == null || maxOutArity >= n.arguments.length) continue;
            maxOutArity = n.arguments.length;
        }
        if (oldNames != null) {
            int startFixing = this.arity;
            if (startFixing <= changesStart) {
                startFixing = changesStart + 1;
            }
            for (int i3 = startFixing; i3 < this.names.length; ++i3) {
                Name fixed = this.names[i3].replaceNames(oldNames, this.names, changesStart, i3);
                this.names[i3] = fixed.newIndex(i3);
            }
        }
        assert (this.nameRefsAreLegal());
        int maxInterned = Math.min(this.arity, 10);
        boolean needIntern = false;
        for (i = 0; i < maxInterned; ++i) {
            Name n = this.names[i];
            Name n2 = LambdaForm.internArgument(n);
            if (n == n2) continue;
            this.names[i] = n2;
            needIntern = true;
        }
        if (needIntern) {
            for (i = this.arity; i < this.names.length; ++i) {
                this.names[i].internArguments();
            }
        }
        assert (this.nameRefsAreLegal());
        return maxOutArity;
    }

    boolean nameRefsAreLegal() {
        Name n;
        int i;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (i = 0; i < this.arity; ++i) {
            n = this.names[i];
            assert (n.index() == i) : Arrays.asList(n.index(), i);
            assert (n.isParam());
        }
        for (i = this.arity; i < this.names.length; ++i) {
            n = this.names[i];
            assert (n.index() == i);
            for (Object arg : n.arguments) {
                if (!(arg instanceof Name)) continue;
                Name n2 = (Name)arg;
                short i2 = n2.index;
                assert (0 <= i2 && i2 < this.names.length) : n.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + i2 + " < " + this.names.length;
                assert (this.names[i2] == n2) : Arrays.asList("-1-", i, "-2-", n.debugString(), "-3-", i2, "-4-", n2.debugString(), "-5-", this.names[i2].debugString(), "-6-", this);
                assert (i2 < i);
            }
        }
        return true;
    }

    BasicType returnType() {
        if (this.result < 0) {
            return BasicType.V_TYPE;
        }
        Name n = this.names[this.result];
        return n.type;
    }

    BasicType parameterType(int n) {
        return this.parameter((int)n).type;
    }

    Name parameter(int n) {
        Name param = this.names[n];
        assert (n < this.arity && param.isParam());
        return param;
    }

    Object parameterConstraint(int n) {
        return this.parameter((int)n).constraint;
    }

    int arity() {
        return this.arity;
    }

    int expressionCount() {
        return this.names.length - this.arity;
    }

    MethodType methodType() {
        Class[] ptypes = new Class[this.arity];
        for (int i = 0; i < this.arity; ++i) {
            ptypes[i] = this.parameterType((int)i).btClass;
        }
        return MethodType.makeImpl(this.returnType().btClass, ptypes, true);
    }

    final String basicTypeSignature() {
        StringBuilder buf = new StringBuilder(this.arity() + 3);
        int a = this.arity();
        for (int i = 0; i < a; ++i) {
            buf.append(this.parameterType(i).basicTypeChar());
        }
        return buf.append('_').append(this.returnType().basicTypeChar()).toString();
    }

    static int signatureArity(String sig) {
        assert (LambdaForm.isValidSignature(sig));
        return sig.indexOf(95);
    }

    static boolean isValidSignature(String sig) {
        int arity = sig.indexOf(95);
        if (arity < 0) {
            return false;
        }
        int siglen = sig.length();
        if (siglen != arity + 2) {
            return false;
        }
        for (int i = 0; i < siglen; ++i) {
            if (i == arity) continue;
            char c = sig.charAt(i);
            if (c == 'V') {
                return i == siglen - 1 && arity == siglen - 2;
            }
            if (BasicType.isArgBasicTypeChar(c)) continue;
            return false;
        }
        return true;
    }

    boolean isSelectAlternative(int pos) {
        if (pos + 1 >= this.names.length) {
            return false;
        }
        Name name0 = this.names[pos];
        Name name1 = this.names[pos + 1];
        return name0.refersTo(MethodHandleImpl.class, "selectAlternative") && name1.isInvokeBasic() && name1.lastUseIndex(name0) == 0 && this.lastUseIndex(name0) == pos + 1;
    }

    private boolean isMatchingIdiom(int pos, String idiomName, int nArgs) {
        if (pos + 2 >= this.names.length) {
            return false;
        }
        Name name0 = this.names[pos];
        Name name1 = this.names[pos + 1];
        Name name2 = this.names[pos + 2];
        return name1.refersTo(MethodHandleImpl.class, idiomName) && name0.isInvokeBasic() && name2.isInvokeBasic() && name1.lastUseIndex(name0) == nArgs && this.lastUseIndex(name0) == pos + 1 && name2.lastUseIndex(name1) == 1 && this.lastUseIndex(name1) == pos + 2;
    }

    boolean isGuardWithCatch(int pos) {
        return this.isMatchingIdiom(pos, "guardWithCatch", 3);
    }

    boolean isTryFinally(int pos) {
        return this.isMatchingIdiom(pos, "tryFinally", 2);
    }

    boolean isTableSwitch(int pos) {
        if (pos + 2 >= this.names.length) {
            return false;
        }
        int POS_COLLECT_ARGS = pos;
        int POS_TABLE_SWITCH = pos + 1;
        int POS_UNBOX_RESULT = pos + 2;
        Name collectArgs = this.names[POS_COLLECT_ARGS];
        Name tableSwitch = this.names[POS_TABLE_SWITCH];
        Name unboxResult = this.names[POS_UNBOX_RESULT];
        return tableSwitch.refersTo(MethodHandleImpl.class, "tableSwitch") && collectArgs.isInvokeBasic() && unboxResult.isInvokeBasic() && tableSwitch.lastUseIndex(collectArgs) == 3 && this.lastUseIndex(collectArgs) == POS_TABLE_SWITCH && unboxResult.lastUseIndex(tableSwitch) == 1 && this.lastUseIndex(tableSwitch) == POS_UNBOX_RESULT;
    }

    boolean isLoop(int pos) {
        return this.isMatchingIdiom(pos, "loop", 2);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0 && !this.forceInterpretation() && !this.isCompiled) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        MethodType mtype = this.methodType();
        LambdaForm prep = mtype.form().cachedLambdaForm(6);
        if (prep == null) {
            assert (LambdaForm.isValidSignature(this.basicTypeSignature()));
            prep = new LambdaForm(mtype);
            prep.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint(mtype);
            prep = mtype.form().setCachedLambdaForm(6, prep);
        }
        this.vmentry = prep.vmentry;
    }

    private static PerfCounter failedCompilationCounter() {
        if (LF_FAILED == null) {
            LF_FAILED = PerfCounter.newPerfCounter("java.lang.invoke.failedLambdaFormCompilations");
        }
        return LF_FAILED;
    }

    void compileToBytecode() {
        if (this.forceInterpretation()) {
            return;
        }
        if (this.vmentry != null && this.isCompiled) {
            return;
        }
        MethodType invokerType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)invokerType));
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, invokerType);
            if (TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
        }
        catch (InvokerBytecodeGenerator.BytecodeGenerationException bge) {
            this.invocationCounter = -1;
            LambdaForm.failedCompilationCounter().increment();
            if (MethodHandleStatics.LOG_LF_COMPILATION_FAILURE) {
                System.out.println("LambdaForm compilation failed: " + this);
                bge.printStackTrace(System.out);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw MethodHandleStatics.newInternalError(this.toString(), e);
        }
    }

    private static boolean argumentTypesMatch(String sig, Object[] av) {
        int arity = LambdaForm.signatureArity(sig);
        assert (av.length == arity) : "av.length == arity: av.length=" + av.length + ", arity=" + arity;
        assert (av[0] instanceof MethodHandle) : "av[0] not instance of MethodHandle: " + av[0];
        MethodHandle mh = (MethodHandle)av[0];
        MethodType mt = mh.type();
        assert (mt.parameterCount() == arity - 1);
        for (int i = 0; i < av.length; ++i) {
            Class<MethodHandle> pt;
            Class<MethodHandle> clazz = pt = i == 0 ? MethodHandle.class : mt.parameterType(i - 1);
            assert (LambdaForm.valueMatches(BasicType.basicType(sig.charAt(i)), pt, av[i]));
        }
        return true;
    }

    private static boolean valueMatches(BasicType tc, Class<?> type, Object x) {
        if (type == Void.TYPE) {
            tc = BasicType.V_TYPE;
        }
        assert (tc == BasicType.basicType(type)) : (Object)((Object)tc) + " == basicType(" + type + ")=" + (Object)((Object)BasicType.basicType(type));
        switch (tc) {
            case I_TYPE: {
                assert (LambdaForm.checkInt(type, x)) : "checkInt(" + type + "," + x + ")";
                break;
            }
            case J_TYPE: {
                assert (x instanceof Long) : "instanceof Long: " + x;
                break;
            }
            case F_TYPE: {
                assert (x instanceof Float) : "instanceof Float: " + x;
                break;
            }
            case D_TYPE: {
                assert (x instanceof Double) : "instanceof Double: " + x;
                break;
            }
            case L_TYPE: {
                assert (LambdaForm.checkRef(type, x)) : "checkRef(" + type + "," + x + ")";
                break;
            }
            case V_TYPE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean checkInt(Class<?> type, Object x) {
        assert (x instanceof Integer);
        if (type == Integer.TYPE) {
            return true;
        }
        Wrapper w = Wrapper.forBasicType(type);
        assert (w.isSubwordOrInt());
        Object x1 = Wrapper.INT.wrap(w.wrap(x));
        return x.equals(x1);
    }

    private static boolean checkRef(Class<?> type, Object x) {
        assert (!type.isPrimitive());
        if (x == null) {
            return true;
        }
        if (type.isInterface()) {
            return true;
        }
        return type.isInstance(x);
    }

    private boolean forceInterpretation() {
        return this.invocationCounter == -1;
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... argumentValues) throws Throwable {
        Object rv;
        if (TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(argumentValues);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(argumentValues));
        Object[] values = Arrays.copyOf(argumentValues, this.names.length);
        for (int i = argumentValues.length; i < values.length; ++i) {
            values[i] = this.interpretName(this.names[i], values);
        }
        Object object2 = rv = this.result < 0 ? null : values[this.result];
        assert (this.resultCheck(argumentValues, rv));
        return rv;
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] values) throws Throwable {
        if (TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] arguments = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < arguments.length; ++i) {
            Object a = arguments[i];
            if (!(a instanceof Name)) continue;
            int i2 = ((Name)a).index();
            assert (this.names[i2] == a);
            a = values[i2];
            arguments[i] = a;
        }
        return name.function.invokeWithArguments(arguments);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && !this.forceInterpretation() && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... argumentValues) throws Throwable {
        Object rval;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, argumentValues);
        if (!this.forceInterpretation() && this.invocationCounter < COMPILE_THRESHOLD) {
            int ctr = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", ctr);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(argumentValues));
            Object[] values = Arrays.copyOf(argumentValues, this.names.length);
            for (int i = argumentValues.length; i < values.length; ++i) {
                values[i] = this.interpretName(this.names[i], values);
            }
            rval = this.result < 0 ? null : values[this.result];
        }
        catch (Throwable ex) {
            LambdaForm.traceInterpreter("] throw =>", ex);
            throw ex;
        }
        LambdaForm.traceInterpreter("] return =>", rval);
        return rval;
    }

    static void traceInterpreter(String event, Object obj, Object ... args) {
        if (TRACE_INTERPRETER) {
            System.out.println("LFI: " + event + " " + (obj != null ? obj : "") + (args != null && args.length != 0 ? Arrays.asList(args) : ""));
        }
    }

    static void traceInterpreter(String event, Object obj) {
        LambdaForm.traceInterpreter(event, obj, null);
    }

    private boolean arityCheck(Object[] argumentValues) {
        assert (argumentValues.length == this.arity) : this.arity + "!=" + Arrays.asList(argumentValues) + ".length";
        assert (argumentValues[0] instanceof MethodHandle) : "not MH: " + argumentValues[0];
        MethodHandle mh = (MethodHandle)argumentValues[0];
        assert (mh.internalForm() == this);
        LambdaForm.argumentTypesMatch(this.basicTypeSignature(), argumentValues);
        return true;
    }

    private boolean resultCheck(Object[] argumentValues, Object result) {
        MethodHandle mh = (MethodHandle)argumentValues[0];
        MethodType mt = mh.type();
        assert (LambdaForm.valueMatches(this.returnType(), mt.returnType(), result));
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        String lambdaName = this.lambdaName();
        StringBuilder buf = new StringBuilder(lambdaName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                buf.append(")=>{");
            }
            Name n = this.names[i];
            if (i >= this.arity) {
                buf.append("\n    ");
            }
            buf.append(n.paramString());
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                buf.append(",");
                continue;
            }
            buf.append("=").append(n.exprString());
            buf.append(";");
        }
        if (this.arity == this.names.length) {
            buf.append(")=>{");
        }
        buf.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (TRACE_INTERPRETER) {
            buf.append(":").append(this.basicTypeSignature());
            buf.append("/").append(this.vmentry);
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof LambdaForm && this.equals((LambdaForm)obj);
    }

    public boolean equals(LambdaForm that) {
        if (this.result != that.result) {
            return false;
        }
        return Arrays.equals(this.names, that.names);
    }

    public int hashCode() {
        return this.result + 31 * Arrays.hashCode(this.names);
    }

    LambdaFormEditor editor() {
        return LambdaFormEditor.lambdaFormEditor(this);
    }

    boolean contains(Name name) {
        int pos = name.index();
        if (pos >= 0) {
            return pos < this.names.length && name.equals(this.names[pos]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    public static String basicTypeSignature(MethodType type) {
        int params = type.parameterCount();
        char[] sig = new char[params + 2];
        int sigp = 0;
        while (sigp < params) {
            sig[sigp] = BasicType.basicTypeChar(type.parameterType(sigp++));
        }
        sig[sigp++] = 95;
        sig[sigp++] = BasicType.basicTypeChar(type.returnType());
        assert (sigp == sig.length);
        return String.valueOf(sig);
    }

    public static String shortenSignature(String signature) {
        int NO_CHAR = -1;
        int MIN_RUN = 3;
        int c1 = -1;
        int c1reps = 0;
        StringBuilder buf = null;
        int len = signature.length();
        if (len < 3) {
            return signature;
        }
        for (int i = 0; i <= len; ++i) {
            if (c1 != -1 && (65 > c1 || c1 > 90)) {
                if (buf == null) break;
                buf.append(signature, i - c1reps, len);
                break;
            }
            int c0 = c1;
            int n = c1 = i == len ? -1 : (int)signature.charAt(i);
            if (c1 == c0) {
                ++c1reps;
                continue;
            }
            int c0reps = c1reps;
            c1reps = 1;
            if (c0reps < 3) {
                if (buf == null) continue;
                while (--c0reps >= 0) {
                    buf.append((char)c0);
                }
                continue;
            }
            if (buf == null) {
                buf = new StringBuilder().append(signature, 0, i - c0reps);
            }
            buf.append((char)c0).append(c0reps);
        }
        return buf == null ? signature : buf.toString();
    }

    int lastUseIndex(Name n) {
        short ni = n.index;
        int nmax = this.names.length;
        assert (this.names[ni] == n);
        if (this.result == ni) {
            return nmax;
        }
        int i = nmax;
        while (--i > ni) {
            if (this.names[i].lastUseIndex(n) < 0) continue;
            return i;
        }
        return -1;
    }

    int useCount(Name n) {
        int count = this.result == n.index ? 1 : 0;
        int i = Math.max(n.index + 1, this.arity);
        while (i < this.names.length) {
            count += this.names[i++].useCount(n);
        }
        return count;
    }

    static Name argument(int which, BasicType type) {
        if (which >= 10) {
            return new Name(which, type);
        }
        return INTERNED_ARGUMENTS[type.ordinal()][which];
    }

    static Name internArgument(Name n) {
        assert (n.isParam()) : "not param: " + n;
        assert (n.index < 10);
        if (n.constraint != null) {
            return n;
        }
        return LambdaForm.argument(n.index, n.type);
    }

    static Name[] arguments(int extra, MethodType types) {
        int length = types.parameterCount();
        Name[] names = new Name[length + extra];
        for (int i = 0; i < length; ++i) {
            names[i] = LambdaForm.argument(i, BasicType.basicType(types.parameterType(i)));
        }
        return names;
    }

    static LambdaForm identityForm(BasicType type) {
        int ord = type.ordinal();
        LambdaForm form = LF_identity[ord];
        if (form != null) {
            return form;
        }
        LambdaForm.createFormsFor(type);
        return LF_identity[ord];
    }

    static LambdaForm zeroForm(BasicType type) {
        int ord = type.ordinal();
        LambdaForm form = LF_zero[ord];
        if (form != null) {
            return form;
        }
        LambdaForm.createFormsFor(type);
        return LF_zero[ord];
    }

    static NamedFunction identity(BasicType type) {
        int ord = type.ordinal();
        NamedFunction function = NF_identity[ord];
        if (function != null) {
            return function;
        }
        LambdaForm.createFormsFor(type);
        return NF_identity[ord];
    }

    static NamedFunction constantZero(BasicType type) {
        int ord = type.ordinal();
        NamedFunction function = NF_zero[ord];
        if (function != null) {
            return function;
        }
        LambdaForm.createFormsFor(type);
        return NF_zero[ord];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFormsFor(BasicType type) {
        MethodHandleStatics.UNSAFE.ensureClassInitialized(BoundMethodHandle.class);
        Object object2 = createFormsLock;
        synchronized (object2) {
            NamedFunction zeFun;
            LambdaForm zeForm;
            NamedFunction idFun;
            int ord = type.ordinal();
            LambdaForm idForm = LF_identity[ord];
            if (idForm != null) {
                return;
            }
            char btChar = type.basicTypeChar();
            boolean isVoid = type == BasicType.V_TYPE;
            Class<?> btClass = type.btClass;
            MethodType zeType = MethodType.methodType(btClass);
            MethodType idType = isVoid ? zeType : MethodType.methodType(btClass, btClass);
            MemberName idMem = new MemberName(LambdaForm.class, "identity_" + btChar, idType, 6);
            MemberName zeMem = null;
            try {
                idMem = IMPL_NAMES.resolveOrFail((byte)6, idMem, null, -1, NoSuchMethodException.class);
                if (!isVoid) {
                    zeMem = new MemberName(LambdaForm.class, "zero_" + btChar, zeType, 6);
                    zeMem = IMPL_NAMES.resolveOrFail((byte)6, zeMem, null, -1, NoSuchMethodException.class);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
            if (isVoid) {
                Name[] idNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE)};
                idForm = new LambdaForm(1, idNames, -1, Kind.IDENTITY);
                idForm.compileToBytecode();
                idFun = new NamedFunction(idMem, SimpleMethodHandle.make(idMem.getInvocationType(), idForm));
                zeForm = idForm;
                zeFun = idFun;
            } else {
                Name[] idNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), LambdaForm.argument(1, type)};
                idForm = new LambdaForm(2, idNames, 1, Kind.IDENTITY);
                idForm.compileToBytecode();
                idFun = new NamedFunction(idMem, MethodHandleImpl.makeIntrinsic(SimpleMethodHandle.make(idMem.getInvocationType(), idForm), MethodHandleImpl.Intrinsic.IDENTITY));
                Object zeValue = Wrapper.forBasicType(btChar).zero();
                Name[] zeNames = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), new Name(idFun, zeValue)};
                zeForm = new LambdaForm(1, zeNames, 1, Kind.ZERO);
                zeForm.compileToBytecode();
                zeFun = new NamedFunction(zeMem, MethodHandleImpl.makeIntrinsic(SimpleMethodHandle.make(zeMem.getInvocationType(), zeForm), MethodHandleImpl.Intrinsic.ZERO));
            }
            LambdaForm.LF_zero[ord] = zeForm;
            LambdaForm.NF_zero[ord] = zeFun;
            LambdaForm.LF_identity[ord] = idForm;
            LambdaForm.NF_identity[ord] = idFun;
            assert (idFun.isIdentity());
            assert (zeFun.isConstantZero());
            assert (new Name(zeFun, new Object[0]).isConstantZero());
        }
    }

    private static int identity_I(int x) {
        return x;
    }

    private static long identity_J(long x) {
        return x;
    }

    private static float identity_F(float x) {
        return x;
    }

    private static double identity_D(double x) {
        return x;
    }

    private static Object identity_L(Object x) {
        return x;
    }

    private static void identity_V() {
    }

    private static int zero_I() {
        return 0;
    }

    private static long zero_J() {
        return 0L;
    }

    private static float zero_F() {
        return 0.0f;
    }

    private static double zero_D() {
        return 0.0;
    }

    private static Object zero_L() {
        return null;
    }

    static {
        COMPILE_THRESHOLD = Math.max(-1, MethodHandleStatics.COMPILE_THRESHOLD);
        INTERNED_ARGUMENTS = new Name[BasicType.ARG_TYPE_LIMIT][10];
        for (BasicType type : BasicType.ARG_TYPES) {
            int ord = type.ordinal();
            for (int i = 0; i < INTERNED_ARGUMENTS[ord].length; ++i) {
                LambdaForm.INTERNED_ARGUMENTS[ord][i] = new Name(i, type);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        LF_identity = new LambdaForm[BasicType.TYPE_LIMIT];
        LF_zero = new LambdaForm[BasicType.TYPE_LIMIT];
        NF_identity = new NamedFunction[BasicType.TYPE_LIMIT];
        NF_zero = new NamedFunction[BasicType.TYPE_LIMIT];
        createFormsLock = new Object();
        if (MethodHandleStatics.debugEnabled()) {
            DEBUG_NAME_COUNTERS = new HashMap();
            DEBUG_NAMES = new HashMap();
        } else {
            DEBUG_NAME_COUNTERS = null;
            DEBUG_NAMES = null;
        }
        MethodHandleStatics.UNSAFE.ensureClassInitialized(Holder.class);
        TRACE_INTERPRETER = MethodHandleStatics.TRACE_INTERPRETER;
    }

    static enum Kind {
        GENERIC("invoke"),
        ZERO("zero"),
        IDENTITY("identity"),
        BOUND_REINVOKER("BMH.reinvoke", "reinvoke"),
        REINVOKER("MH.reinvoke", "reinvoke"),
        DELEGATE("MH.delegate", "delegate"),
        EXACT_LINKER("MH.invokeExact_MT", "invokeExact_MT"),
        EXACT_INVOKER("MH.exactInvoker", "exactInvoker"),
        GENERIC_LINKER("MH.invoke_MT", "invoke_MT"),
        GENERIC_INVOKER("MH.invoker", "invoker"),
        LINK_TO_TARGET_METHOD("linkToTargetMethod"),
        LINK_TO_CALL_SITE("linkToCallSite"),
        DIRECT_INVOKE_VIRTUAL("DMH.invokeVirtual", "invokeVirtual"),
        DIRECT_INVOKE_SPECIAL("DMH.invokeSpecial", "invokeSpecial"),
        DIRECT_INVOKE_SPECIAL_IFC("DMH.invokeSpecialIFC", "invokeSpecialIFC"),
        DIRECT_INVOKE_STATIC("DMH.invokeStatic", "invokeStatic"),
        DIRECT_NEW_INVOKE_SPECIAL("DMH.newInvokeSpecial", "newInvokeSpecial"),
        DIRECT_INVOKE_INTERFACE("DMH.invokeInterface", "invokeInterface"),
        DIRECT_INVOKE_STATIC_INIT("DMH.invokeStaticInit", "invokeStaticInit"),
        GET_REFERENCE("getReference"),
        PUT_REFERENCE("putReference"),
        GET_REFERENCE_VOLATILE("getReferenceVolatile"),
        PUT_REFERENCE_VOLATILE("putReferenceVolatile"),
        GET_INT("getInt"),
        PUT_INT("putInt"),
        GET_INT_VOLATILE("getIntVolatile"),
        PUT_INT_VOLATILE("putIntVolatile"),
        GET_BOOLEAN("getBoolean"),
        PUT_BOOLEAN("putBoolean"),
        GET_BOOLEAN_VOLATILE("getBooleanVolatile"),
        PUT_BOOLEAN_VOLATILE("putBooleanVolatile"),
        GET_BYTE("getByte"),
        PUT_BYTE("putByte"),
        GET_BYTE_VOLATILE("getByteVolatile"),
        PUT_BYTE_VOLATILE("putByteVolatile"),
        GET_CHAR("getChar"),
        PUT_CHAR("putChar"),
        GET_CHAR_VOLATILE("getCharVolatile"),
        PUT_CHAR_VOLATILE("putCharVolatile"),
        GET_SHORT("getShort"),
        PUT_SHORT("putShort"),
        GET_SHORT_VOLATILE("getShortVolatile"),
        PUT_SHORT_VOLATILE("putShortVolatile"),
        GET_LONG("getLong"),
        PUT_LONG("putLong"),
        GET_LONG_VOLATILE("getLongVolatile"),
        PUT_LONG_VOLATILE("putLongVolatile"),
        GET_FLOAT("getFloat"),
        PUT_FLOAT("putFloat"),
        GET_FLOAT_VOLATILE("getFloatVolatile"),
        PUT_FLOAT_VOLATILE("putFloatVolatile"),
        GET_DOUBLE("getDouble"),
        PUT_DOUBLE("putDouble"),
        GET_DOUBLE_VOLATILE("getDoubleVolatile"),
        PUT_DOUBLE_VOLATILE("putDoubleVolatile"),
        TRY_FINALLY("tryFinally"),
        TABLE_SWITCH("tableSwitch"),
        COLLECT("collect"),
        COLLECTOR("collector"),
        CONVERT("convert"),
        SPREAD("spread"),
        LOOP("loop"),
        FIELD("field"),
        GUARD("guard"),
        GUARD_WITH_CATCH("guardWithCatch"),
        VARHANDLE_EXACT_INVOKER("VH.exactInvoker"),
        VARHANDLE_INVOKER("VH.invoker", "invoker"),
        VARHANDLE_LINKER("VH.invoke_MT", "invoke_MT");

        final String defaultLambdaName;
        final String methodName;

        private Kind(String defaultLambdaName) {
            this(defaultLambdaName, defaultLambdaName);
        }

        private Kind(String defaultLambdaName, String methodName) {
            this.defaultLambdaName = defaultLambdaName;
            this.methodName = methodName;
        }
    }

    static final class Name {
        final BasicType type;
        @Stable
        short index;
        final NamedFunction function;
        final Object constraint;
        @Stable
        final Object[] arguments;

        private Name(int index, BasicType type, NamedFunction function, Object[] arguments) {
            this.index = (short)index;
            this.type = type;
            this.function = function;
            this.arguments = arguments;
            this.constraint = null;
            assert (this.index == index);
        }

        private Name(Name that, Object constraint) {
            this.index = that.index;
            this.type = that.type;
            this.function = that.function;
            this.arguments = that.arguments;
            this.constraint = constraint;
            assert (constraint == null || this.isParam());
            assert (constraint == null || constraint instanceof ClassSpecializer.SpeciesData || constraint instanceof Class);
        }

        Name(MethodHandle function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(MethodType functionType, Object ... arguments) {
            this(new NamedFunction(functionType), arguments);
            assert (arguments[0] instanceof Name && ((Name)arguments[0]).type == BasicType.L_TYPE);
        }

        Name(MemberName function, Object ... arguments) {
            this(new NamedFunction(function), arguments);
        }

        Name(NamedFunction function, Object ... arguments) {
            arguments = Arrays.copyOf(arguments, arguments.length, Object[].class);
            this(-1, function.returnType(), function, arguments);
            assert (this.typesMatch(function, arguments));
        }

        Name(int index, BasicType type) {
            this(index, type, null, null);
        }

        Name(BasicType type) {
            this(-1, type);
        }

        BasicType type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int i) {
            if (this.index != i) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)i;
            }
            return true;
        }

        char typeChar() {
            return this.type.btChar;
        }

        Name newIndex(int i) {
            if (this.initIndex(i)) {
                return this;
            }
            return this.cloneWithIndex(i);
        }

        Name cloneWithIndex(int i) {
            Object[] newArguments = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(i, this.type, this.function, newArguments).withConstraint(this.constraint);
        }

        Name withConstraint(Object constraint) {
            if (constraint == this.constraint) {
                return this;
            }
            return new Name(this, constraint);
        }

        Name replaceName(Name oldName, Name newName) {
            if (oldName == newName) {
                return this;
            }
            Object[] arguments = this.arguments;
            if (arguments == null) {
                return this;
            }
            boolean replaced = false;
            for (int j = 0; j < arguments.length; ++j) {
                if (arguments[j] != oldName) continue;
                if (!replaced) {
                    replaced = true;
                    arguments = (Object[])arguments.clone();
                }
                arguments[j] = newName;
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        Name replaceNames(Name[] oldNames, Name[] newNames, int start, int end) {
            if (start >= end) {
                return this;
            }
            Object[] arguments = this.arguments;
            boolean replaced = false;
            block0: for (int j = 0; j < arguments.length; ++j) {
                Object object2 = arguments[j];
                if (!(object2 instanceof Name)) continue;
                Name n = (Name)object2;
                short check = n.index;
                if (check >= 0 && check < newNames.length && n == newNames[check]) continue;
                for (int i = start; i < end; ++i) {
                    if (n != oldNames[i]) continue;
                    if (n == newNames[i]) continue block0;
                    if (!replaced) {
                        replaced = true;
                        arguments = (Object[])arguments.clone();
                    }
                    arguments[j] = newNames[i];
                    continue block0;
                }
            }
            if (!replaced) {
                return this;
            }
            return new Name(this.function, arguments);
        }

        void internArguments() {
            Object[] arguments = this.arguments;
            for (int j = 0; j < arguments.length; ++j) {
                Name n;
                Object object2 = arguments[j];
                if (!(object2 instanceof Name) || !(n = (Name)object2).isParam() || n.index >= 10) continue;
                arguments[j] = LambdaForm.internArgument(n);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.isConstantZero();
        }

        boolean refersTo(Class<?> declaringClass, String methodName) {
            return this.function != null && this.function.member() != null && this.function.member().refersTo(declaringClass, methodName);
        }

        boolean isInvokeBasic() {
            if (this.function == null) {
                return false;
            }
            if (this.arguments.length < 1) {
                return false;
            }
            MemberName member = this.function.member();
            return member != null && member.refersTo(MethodHandle.class, "invokeBasic") && !member.isPublic() && !member.isStatic();
        }

        boolean isLinkerMethodInvoke() {
            if (this.function == null) {
                return false;
            }
            if (this.arguments.length < 1) {
                return false;
            }
            MemberName member = this.function.member();
            return member != null && member.getDeclaringClass() == MethodHandle.class && !member.isPublic() && member.isStatic() && member.getName().startsWith("linkTo");
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.typeChar();
        }

        public String debugString() {
            String s = this.paramString();
            return this.function == null ? s : s + "=" + this.exprString();
        }

        public String paramString() {
            String s = this.toString();
            Object c = this.constraint;
            if (c == null) {
                return s;
            }
            if (c instanceof Class) {
                c = ((Class)c).getSimpleName();
            }
            return s + "/" + c;
        }

        public String exprString() {
            if (this.function == null) {
                return this.toString();
            }
            StringBuilder buf = new StringBuilder(this.function.toString());
            buf.append("(");
            String cma = "";
            for (Object a : this.arguments) {
                buf.append(cma);
                cma = ",";
                if (a instanceof Name || a instanceof Integer) {
                    buf.append(a);
                    continue;
                }
                buf.append("(").append(a).append(")");
            }
            buf.append(")");
            return buf.toString();
        }

        private boolean typesMatch(NamedFunction function, Object ... arguments) {
            assert (arguments.length == function.arity()) : "arity mismatch: arguments.length=" + arguments.length + " == function.arity()=" + function.arity() + " in " + this.debugString();
            for (int i = 0; i < arguments.length; ++i) {
                assert (Name.typesMatch(function.parameterType(i), arguments[i])) : "types don't match: function.parameterType(" + i + ")=" + (Object)((Object)function.parameterType(i)) + ", arguments[" + i + "]=" + arguments[i] + " in " + this.debugString();
            }
            return true;
        }

        private static boolean typesMatch(BasicType parameterType, Object object2) {
            if (object2 instanceof Name) {
                return ((Name)object2).type == parameterType;
            }
            switch (parameterType) {
                case I_TYPE: {
                    return object2 instanceof Integer;
                }
                case J_TYPE: {
                    return object2 instanceof Long;
                }
                case F_TYPE: {
                    return object2 instanceof Float;
                }
                case D_TYPE: {
                    return object2 instanceof Double;
                }
            }
            assert (parameterType == BasicType.L_TYPE);
            return true;
        }

        int lastUseIndex(Name n) {
            if (this.arguments == null) {
                return -1;
            }
            int i = this.arguments.length;
            while (--i >= 0) {
                if (this.arguments[i] != n) continue;
                return i;
            }
            return -1;
        }

        int useCount(Name n) {
            int count = 0;
            if (this.arguments != null) {
                for (Object argument : this.arguments) {
                    if (argument != n) continue;
                    ++count;
                }
            }
            return count;
        }

        public boolean equals(Name that) {
            if (this == that) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == that.type && this.function.equals(that.function) && Arrays.equals(this.arguments, that.arguments);
        }

        public boolean equals(Object x) {
            return x instanceof Name && this.equals((Name)x);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type.ordinal() << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static final class BasicType
    extends Enum<BasicType> {
        public static final /* enum */ BasicType L_TYPE = new BasicType('L', Object.class, Wrapper.OBJECT);
        public static final /* enum */ BasicType I_TYPE = new BasicType('I', Integer.TYPE, Wrapper.INT);
        public static final /* enum */ BasicType J_TYPE = new BasicType('J', Long.TYPE, Wrapper.LONG);
        public static final /* enum */ BasicType F_TYPE = new BasicType('F', Float.TYPE, Wrapper.FLOAT);
        public static final /* enum */ BasicType D_TYPE = new BasicType('D', Double.TYPE, Wrapper.DOUBLE);
        public static final /* enum */ BasicType V_TYPE = new BasicType('V', Void.TYPE, Wrapper.VOID);
        @Stable
        static final BasicType[] ALL_TYPES;
        @Stable
        static final BasicType[] ARG_TYPES;
        static final int ARG_TYPE_LIMIT;
        static final int TYPE_LIMIT;
        static final byte L_TYPE_NUM;
        static final byte I_TYPE_NUM;
        static final byte J_TYPE_NUM;
        static final byte F_TYPE_NUM;
        static final byte D_TYPE_NUM;
        static final byte V_TYPE_NUM;
        final char btChar;
        final Class<?> btClass;
        final Wrapper btWrapper;
        private static final /* synthetic */ BasicType[] $VALUES;

        public static BasicType[] values() {
            return (BasicType[])$VALUES.clone();
        }

        public static BasicType valueOf(String name) {
            return Enum.valueOf(BasicType.class, name);
        }

        private BasicType(char btChar, Class<?> btClass, Wrapper wrapper) {
            this.btChar = btChar;
            this.btClass = btClass;
            this.btWrapper = wrapper;
        }

        char basicTypeChar() {
            return this.btChar;
        }

        Class<?> basicTypeClass() {
            return this.btClass;
        }

        Wrapper basicTypeWrapper() {
            return this.btWrapper;
        }

        int basicTypeSlots() {
            return this.btWrapper.stackSlots();
        }

        static BasicType basicType(byte type) {
            return ALL_TYPES[type];
        }

        static BasicType basicType(char type) {
            return switch (type) {
                case 'L' -> L_TYPE;
                case 'I' -> I_TYPE;
                case 'J' -> J_TYPE;
                case 'F' -> F_TYPE;
                case 'D' -> D_TYPE;
                case 'V' -> V_TYPE;
                case 'B', 'C', 'S', 'Z' -> I_TYPE;
                default -> throw MethodHandleStatics.newInternalError("Unknown type char: '" + type + "'");
            };
        }

        static BasicType basicType(Wrapper type) {
            char c = type.basicTypeChar();
            return BasicType.basicType(c);
        }

        static BasicType basicType(Class<?> type) {
            if (!type.isPrimitive()) {
                return L_TYPE;
            }
            return BasicType.basicType(Wrapper.forPrimitiveType(type));
        }

        static int[] basicTypeOrds(BasicType[] types) {
            if (types == null) {
                return null;
            }
            int[] a = new int[types.length];
            for (int i = 0; i < types.length; ++i) {
                a[i] = types[i].ordinal();
            }
            return a;
        }

        static char basicTypeChar(Class<?> type) {
            return BasicType.basicType(type).btChar;
        }

        static byte[] basicTypesOrd(Class<?>[] types) {
            byte[] ords = new byte[types.length];
            for (int i = 0; i < ords.length; ++i) {
                ords[i] = (byte)BasicType.basicType(types[i]).ordinal();
            }
            return ords;
        }

        static boolean isBasicTypeChar(char c) {
            return "LIJFDV".indexOf(c) >= 0;
        }

        static boolean isArgBasicTypeChar(char c) {
            return "LIJFD".indexOf(c) >= 0;
        }

        private static boolean checkBasicType() {
            int i;
            for (i = 0; i < ARG_TYPE_LIMIT; ++i) {
                assert (ARG_TYPES[i].ordinal() == i);
                assert (ARG_TYPES[i] == ALL_TYPES[i]);
            }
            for (i = 0; i < TYPE_LIMIT; ++i) {
                assert (ALL_TYPES[i].ordinal() == i);
            }
            assert (ALL_TYPES[TYPE_LIMIT - 1] == V_TYPE);
            assert (!Arrays.asList(ARG_TYPES).contains((Object)V_TYPE));
            return true;
        }

        private static /* synthetic */ BasicType[] $values() {
            return new BasicType[]{L_TYPE, I_TYPE, J_TYPE, F_TYPE, D_TYPE, V_TYPE};
        }

        static {
            $VALUES = BasicType.$values();
            ALL_TYPES = BasicType.values();
            ARG_TYPES = Arrays.copyOf(ALL_TYPES, ALL_TYPES.length - 1);
            ARG_TYPE_LIMIT = ARG_TYPES.length;
            TYPE_LIMIT = ALL_TYPES.length;
            L_TYPE_NUM = (byte)L_TYPE.ordinal();
            I_TYPE_NUM = (byte)I_TYPE.ordinal();
            J_TYPE_NUM = (byte)J_TYPE.ordinal();
            F_TYPE_NUM = (byte)F_TYPE.ordinal();
            D_TYPE_NUM = (byte)D_TYPE.ordinal();
            V_TYPE_NUM = (byte)V_TYPE.ordinal();
            assert (BasicType.checkBasicType());
        }
    }

    static class NamedFunction {
        final MemberName member;
        @Stable
        private MethodHandle resolvedHandle;
        @Stable
        MethodHandle invoker;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle resolvedHandle) {
            this(resolvedHandle.internalMemberName(), resolvedHandle);
        }

        NamedFunction(MemberName member, MethodHandle resolvedHandle) {
            this.member = member;
            this.resolvedHandle = resolvedHandle;
        }

        NamedFunction(MethodType basicInvokerType) {
            assert (basicInvokerType == basicInvokerType.basicType()) : basicInvokerType;
            if (basicInvokerType.parameterSlotCount() < 253) {
                this.resolvedHandle = basicInvokerType.invokers().basicInvoker();
                this.member = this.resolvedHandle.internalMemberName();
            } else {
                this.member = Invokers.invokeBasicMethod(basicInvokerType);
            }
            assert (NamedFunction.isInvokeBasic(this.member));
        }

        private static boolean isInvokeBasic(MemberName member) {
            return member != null && member.getDeclaringClass() == MethodHandle.class && "invokeBasic".equals(member.getName());
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(MemberName member) {
            this(member, null);
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        synchronized void resolve() {
            if (this.resolvedHandle == null) {
                this.resolvedHandle = DirectMethodHandle.make(this.member);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NamedFunction)) return false;
            NamedFunction that = (NamedFunction)other;
            if (this.member == null) return false;
            if (!this.member.equals(that.member)) return false;
            return true;
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        private static MethodHandle computeInvoker(MethodTypeForm typeForm) {
            MethodHandle mh = (typeForm = typeForm.basicType().form()).cachedMethodHandle(1);
            if (mh != null) {
                return mh;
            }
            MemberName invoker = InvokerBytecodeGenerator.generateNamedFunctionInvoker(typeForm);
            mh = DirectMethodHandle.make(invoker);
            MethodHandle mh2 = typeForm.cachedMethodHandle(1);
            if (mh2 != null) {
                return mh2;
            }
            if (!mh.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw MethodHandleStatics.newInternalError(mh.debugString());
            }
            return typeForm.setCachedMethodHandle(1, mh);
        }

        @Hidden
        Object invokeWithArguments(Object ... arguments) throws Throwable {
            if (TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(arguments);
            }
            return this.invoker().invokeBasic(this.resolvedHandle(), arguments);
        }

        @Hidden
        Object invokeWithArgumentsTracing(Object[] arguments) throws Throwable {
            Object rval;
            try {
                LambdaForm.traceInterpreter("[ call", this, arguments);
                if (this.invoker == null) {
                    LambdaForm.traceInterpreter("| getInvoker", this);
                    this.invoker();
                }
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                rval = this.invoker().invokeBasic(this.resolvedHandle(), arguments);
            }
            catch (Throwable ex) {
                LambdaForm.traceInterpreter("] throw =>", ex);
                throw ex;
            }
            LambdaForm.traceInterpreter("] return =>", rval);
            return rval;
        }

        private MethodHandle invoker() {
            if (this.invoker != null) {
                return this.invoker;
            }
            this.invoker = NamedFunction.computeInvoker(this.methodType().form());
            return this.invoker;
        }

        MethodType methodType() {
            if (this.resolvedHandle != null) {
                return this.resolvedHandle.type();
            }
            return this.member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName m = this.resolvedHandle.internalMemberName();
                assert (m.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        BasicType returnType() {
            return BasicType.basicType(this.methodType().returnType());
        }

        BasicType parameterType(int n) {
            return BasicType.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return String.valueOf(this.resolvedHandle);
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }

        public boolean isIdentity() {
            return this.equals(LambdaForm.identity(this.returnType()));
        }

        public boolean isConstantZero() {
            return this.equals(LambdaForm.constantZero(this.returnType()));
        }

        public MethodHandleImpl.Intrinsic intrinsicName() {
            return this.resolvedHandle != null ? this.resolvedHandle.intrinsicName() : MethodHandleImpl.Intrinsic.NONE;
        }

        public Object intrinsicData() {
            return this.resolvedHandle != null ? this.resolvedHandle.intrinsicData() : null;
        }
    }

    final class Holder {
        Holder() {
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }
}

