/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.LambdaForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class LambdaFormBuffer {
    private int arity;
    private int length;
    private LambdaForm.Name[] names;
    private LambdaForm.Name[] originalNames;
    private byte flags;
    private int firstChange;
    private LambdaForm.Name resultName;
    private ArrayList<LambdaForm.Name> dups;
    private static final int F_TRANS = 16;
    private static final int F_OWNED = 3;

    LambdaFormBuffer(LambdaForm lf) {
        this.arity = lf.arity;
        this.setNames(lf.names);
        int result = lf.result;
        if (result == -2) {
            result = this.length - 1;
        }
        if (result >= 0 && lf.names[result].type != LambdaForm.BasicType.V_TYPE) {
            this.resultName = lf.names[result];
        }
        assert (lf.nameRefsAreLegal());
    }

    private LambdaForm lambdaForm() {
        assert (!this.inTrans());
        return new LambdaForm(this.arity, this.nameArray(), this.resultIndex());
    }

    LambdaForm.Name name(int i) {
        assert (i < this.length);
        return this.names[i];
    }

    LambdaForm.Name[] nameArray() {
        return Arrays.copyOf(this.names, this.length);
    }

    int resultIndex() {
        if (this.resultName == null) {
            return -1;
        }
        int index = LambdaFormBuffer.indexOf(this.resultName, this.names);
        assert (index >= 0);
        return index;
    }

    void setNames(LambdaForm.Name[] names2) {
        this.originalNames = names2;
        this.names = names2;
        this.length = names2.length;
        this.flags = 0;
    }

    private boolean verifyArity() {
        int i;
        for (i = 0; i < this.arity && i < this.firstChange; ++i) {
            assert (this.names[i].isParam()) : "#" + i + "=" + this.names[i];
        }
        for (i = this.arity; i < this.length; ++i) {
            assert (!this.names[i].isParam()) : "#" + i + "=" + this.names[i];
        }
        for (i = this.length; i < this.names.length; ++i) {
            assert (this.names[i] == null) : "#" + i + "=" + this.names[i];
        }
        if (this.resultName != null) {
            int resultIndex = LambdaFormBuffer.indexOf(this.resultName, this.names);
            assert (resultIndex >= 0) : "not found: " + this.resultName.exprString() + Arrays.asList(this.names);
            assert (this.names[resultIndex] == this.resultName);
        }
        return true;
    }

    private boolean verifyFirstChange() {
        assert (this.inTrans());
        for (int i = 0; i < this.length; ++i) {
            if (this.names[i] == this.originalNames[i]) continue;
            assert (this.firstChange == i) : Arrays.asList(this.firstChange, i, this.originalNames[i].exprString(), Arrays.asList(this.names));
            return true;
        }
        assert (this.firstChange == this.length) : Arrays.asList(this.firstChange, Arrays.asList(this.names));
        return true;
    }

    private static int indexOf(LambdaForm.NamedFunction fn, List<LambdaForm.NamedFunction> fns) {
        for (int i = 0; i < fns.size(); ++i) {
            if (fns.get(i) != fn) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(LambdaForm.Name n, LambdaForm.Name[] ns) {
        for (int i = 0; i < ns.length; ++i) {
            if (ns[i] != n) continue;
            return i;
        }
        return -1;
    }

    boolean inTrans() {
        return (this.flags & 0x10) != 0;
    }

    int ownedCount() {
        return this.flags & 3;
    }

    void growNames(int insertPos, int growLength) {
        int oldLength = this.length;
        int newLength = oldLength + growLength;
        int oc = this.ownedCount();
        if (oc == 0 || newLength > this.names.length) {
            this.names = Arrays.copyOf(this.names, (this.names.length + growLength) * 5 / 4);
            if (oc == 0) {
                this.flags = (byte)(this.flags + 1);
                assert (this.ownedCount() == ++oc);
            }
        }
        if (this.originalNames != null && this.originalNames.length < this.names.length) {
            this.originalNames = Arrays.copyOf(this.originalNames, this.names.length);
            if (oc == 1) {
                this.flags = (byte)(this.flags + 1);
                assert (this.ownedCount() == ++oc);
            }
        }
        if (growLength == 0) {
            return;
        }
        int insertEnd = insertPos + growLength;
        int tailLength = oldLength - insertPos;
        System.arraycopy(this.names, insertPos, this.names, insertEnd, tailLength);
        Arrays.fill(this.names, insertPos, insertEnd, null);
        if (this.originalNames != null) {
            System.arraycopy(this.originalNames, insertPos, this.originalNames, insertEnd, tailLength);
            Arrays.fill(this.originalNames, insertPos, insertEnd, null);
        }
        this.length = newLength;
        if (this.firstChange >= insertPos) {
            this.firstChange += growLength;
        }
    }

    int lastIndexOf(LambdaForm.Name n) {
        int result = -1;
        for (int i = 0; i < this.length; ++i) {
            if (this.names[i] != n) continue;
            result = i;
        }
        return result;
    }

    private void noteDuplicate(int pos1, int pos2) {
        LambdaForm.Name n = this.names[pos1];
        assert (n == this.names[pos2]);
        assert (this.originalNames[pos1] != null);
        assert (this.originalNames[pos2] == null || this.originalNames[pos2] == n);
        if (this.dups == null) {
            this.dups = new ArrayList();
        }
        this.dups.add(n);
    }

    private void clearDuplicatesAndNulls() {
        if (this.dups != null) {
            assert (this.ownedCount() >= 1);
            block0: for (LambdaForm.Name dup : this.dups) {
                for (int i = this.firstChange; i < this.length; ++i) {
                    if (this.names[i] != dup || this.originalNames[i] == dup) continue;
                    this.names[i] = null;
                    assert (Arrays.asList(this.names).contains(dup));
                    continue block0;
                }
            }
            this.dups.clear();
        }
        int oldLength = this.length;
        for (int i = this.firstChange; i < this.length; ++i) {
            if (this.names[i] != null) continue;
            System.arraycopy(this.names, i + 1, this.names, i, --this.length - i);
            --i;
        }
        if (this.length < oldLength) {
            Arrays.fill(this.names, this.length, oldLength, null);
        }
        assert (!Arrays.asList(this.names).subList(0, this.length).contains(null));
    }

    void startEdit() {
        LambdaForm.Name[] ownBuffer;
        assert (this.verifyArity());
        int oc = this.ownedCount();
        assert (!this.inTrans());
        this.flags = (byte)(this.flags | 0x10);
        LambdaForm.Name[] oldNames = this.names;
        LambdaForm.Name[] nameArray = ownBuffer = oc == 2 ? this.originalNames : null;
        assert (ownBuffer != oldNames);
        if (ownBuffer != null && ownBuffer.length >= this.length) {
            this.names = this.copyNamesInto(ownBuffer);
        } else {
            int SLOP = 2;
            this.names = Arrays.copyOf(oldNames, Math.max(this.length + 2, oldNames.length));
            if (oc < 2) {
                this.flags = (byte)(this.flags + 1);
            }
            assert (this.ownedCount() == oc + 1);
        }
        this.originalNames = oldNames;
        assert (this.originalNames != this.names);
        this.firstChange = this.length;
        assert (this.inTrans());
    }

    void changeName(int i, LambdaForm.Name name) {
        assert (this.inTrans());
        assert (i < this.length);
        LambdaForm.Name oldName = this.names[i];
        assert (oldName == this.originalNames[i]);
        assert (this.verifyFirstChange());
        if (this.ownedCount() == 0) {
            this.growNames(0, 0);
        }
        this.names[i] = name;
        if (this.firstChange > i) {
            this.firstChange = i;
        }
        if (this.resultName != null && this.resultName == oldName) {
            this.resultName = name;
        }
    }

    void setResult(LambdaForm.Name name) {
        assert (name == null || this.lastIndexOf(name) >= 0);
        this.resultName = name;
    }

    LambdaForm endEdit() {
        assert (this.verifyFirstChange());
        for (int i = Math.max(this.firstChange, this.arity); i < this.length; ++i) {
            LambdaForm.Name newName;
            LambdaForm.Name name = this.names[i];
            if (name == null || (newName = name.replaceNames(this.originalNames, this.names, this.firstChange, i)) == name) continue;
            this.names[i] = newName;
            if (this.resultName != name) continue;
            this.resultName = newName;
        }
        assert (this.inTrans());
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        this.clearDuplicatesAndNulls();
        this.originalNames = null;
        if (this.firstChange < this.arity) {
            LambdaForm.Name[] exprs = new LambdaForm.Name[this.arity - this.firstChange];
            int argp = this.firstChange;
            int exprp = 0;
            for (int i = this.firstChange; i < this.arity; ++i) {
                LambdaForm.Name name = this.names[i];
                if (name != null && name.isParam()) {
                    this.names[argp++] = name;
                    continue;
                }
                exprs[exprp++] = name;
            }
            assert (exprp == this.arity - argp);
            System.arraycopy(exprs, 0, this.names, argp, exprp);
            this.arity -= exprp;
        }
        assert (this.verifyArity());
        return this.lambdaForm();
    }

    private LambdaForm.Name[] copyNamesInto(LambdaForm.Name[] buffer) {
        System.arraycopy(this.names, 0, buffer, 0, this.length);
        Arrays.fill(buffer, this.length, buffer.length, null);
        return buffer;
    }

    LambdaFormBuffer replaceFunctions(List<LambdaForm.NamedFunction> oldFns, List<LambdaForm.NamedFunction> newFns, Object ... forArguments) {
        assert (this.inTrans());
        if (oldFns.isEmpty()) {
            return this;
        }
        for (int i = this.arity; i < this.length; ++i) {
            LambdaForm.Name n = this.names[i];
            int nfi = LambdaFormBuffer.indexOf(n.function, oldFns);
            if (nfi < 0 || !Arrays.equals(n.arguments, forArguments)) continue;
            this.changeName(i, new LambdaForm.Name(newFns.get(nfi), n.arguments));
        }
        return this;
    }

    private void replaceName(int pos, LambdaForm.Name binding) {
        assert (this.inTrans());
        assert (this.verifyArity());
        assert (pos < this.arity);
        LambdaForm.Name param = this.names[pos];
        assert (param.isParam());
        assert (param.type == binding.type);
        this.changeName(pos, binding);
    }

    LambdaFormBuffer renameParameter(int pos, LambdaForm.Name newParam) {
        assert (newParam.isParam());
        this.replaceName(pos, newParam);
        return this;
    }

    LambdaFormBuffer replaceParameterByNewExpression(int pos, LambdaForm.Name binding) {
        assert (!binding.isParam());
        assert (this.lastIndexOf(binding) < 0);
        this.replaceName(pos, binding);
        return this;
    }

    LambdaFormBuffer replaceParameterByCopy(int pos, int valuePos) {
        assert (pos != valuePos);
        this.replaceName(pos, this.names[valuePos]);
        this.noteDuplicate(pos, valuePos);
        return this;
    }

    private void insertName(int pos, LambdaForm.Name expr, boolean isParameter) {
        assert (this.inTrans());
        assert (this.verifyArity());
        assert (!isParameter ? pos >= this.arity : pos <= this.arity);
        this.growNames(pos, 1);
        if (isParameter) {
            ++this.arity;
        }
        this.changeName(pos, expr);
    }

    LambdaFormBuffer insertExpression(int pos, LambdaForm.Name expr) {
        assert (!expr.isParam());
        this.insertName(pos, expr, false);
        return this;
    }

    LambdaFormBuffer insertParameter(int pos, LambdaForm.Name param) {
        assert (param.isParam());
        this.insertName(pos, param, true);
        return this;
    }
}

