/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.Serializable;
import java.lang.invoke.AbstractValidatingLambdaMetafactory;
import java.lang.invoke.CallSite;
import java.lang.invoke.InnerClassLambdaMetafactory;
import java.lang.invoke.LambdaConversionException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public final class LambdaMetafactory {
    public static final int FLAG_SERIALIZABLE = 1;
    public static final int FLAG_MARKERS = 2;
    public static final int FLAG_BRIDGES = 4;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final MethodType[] EMPTY_MT_ARRAY = new MethodType[0];

    private LambdaMetafactory() {
    }

    public static CallSite metafactory(MethodHandles.Lookup caller, String interfaceMethodName, MethodType factoryType, MethodType interfaceMethodType, MethodHandle implementation, MethodType dynamicMethodType) throws LambdaConversionException {
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(Objects.requireNonNull(caller), Objects.requireNonNull(factoryType), Objects.requireNonNull(interfaceMethodName), Objects.requireNonNull(interfaceMethodType), Objects.requireNonNull(implementation), Objects.requireNonNull(dynamicMethodType), false, EMPTY_CLASS_ARRAY, EMPTY_MT_ARRAY);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }

    public static CallSite altMetafactory(MethodHandles.Lookup caller, String interfaceMethodName, MethodType factoryType, Object ... args) throws LambdaConversionException {
        boolean isSerializable;
        Objects.requireNonNull(caller);
        Objects.requireNonNull(interfaceMethodName);
        Objects.requireNonNull(factoryType);
        Objects.requireNonNull(args);
        int argIndex = 0;
        MethodType interfaceMethodType = LambdaMetafactory.extractArg(args, argIndex++, MethodType.class);
        MethodHandle implementation = LambdaMetafactory.extractArg(args, argIndex++, MethodHandle.class);
        MethodType dynamicMethodType = LambdaMetafactory.extractArg(args, argIndex++, MethodType.class);
        int flags = LambdaMetafactory.extractArg(args, argIndex++, Integer.class);
        Class<?>[] altInterfaces = EMPTY_CLASS_ARRAY;
        MethodType[] altMethods = EMPTY_MT_ARRAY;
        if ((flags & 2) != 0) {
            int altInterfaceCount;
            if ((altInterfaceCount = LambdaMetafactory.extractArg(args, argIndex++, Integer.class).intValue()) < 0) {
                throw new IllegalArgumentException("negative argument count");
            }
            if (altInterfaceCount > 0) {
                altInterfaces = LambdaMetafactory.extractArgs(args, argIndex, Class.class, altInterfaceCount);
                argIndex += altInterfaceCount;
            }
        }
        if ((flags & 4) != 0) {
            int altMethodCount;
            if ((altMethodCount = LambdaMetafactory.extractArg(args, argIndex++, Integer.class).intValue()) < 0) {
                throw new IllegalArgumentException("negative argument count");
            }
            if (altMethodCount > 0) {
                altMethods = LambdaMetafactory.extractArgs(args, argIndex, MethodType.class, altMethodCount);
                argIndex += altMethodCount;
            }
        }
        if (argIndex < args.length) {
            throw new IllegalArgumentException("too many arguments");
        }
        boolean bl = isSerializable = (flags & 1) != 0;
        if (isSerializable) {
            boolean foundSerializableSupertype = Serializable.class.isAssignableFrom((Class<?>)factoryType.returnType());
            for (Class<?> c : altInterfaces) {
                foundSerializableSupertype |= Serializable.class.isAssignableFrom(c);
            }
            if (!foundSerializableSupertype) {
                altInterfaces = Arrays.copyOf(altInterfaces, altInterfaces.length + 1);
                altInterfaces[altInterfaces.length - 1] = Serializable.class;
            }
        }
        InnerClassLambdaMetafactory mf = new InnerClassLambdaMetafactory(caller, factoryType, interfaceMethodName, interfaceMethodType, implementation, dynamicMethodType, isSerializable, altInterfaces, altMethods);
        mf.validateMetafactoryArgs();
        return ((AbstractValidatingLambdaMetafactory)mf).buildCallSite();
    }

    private static <T> T extractArg(Object[] args, int index, Class<T> type) {
        if (index >= args.length) {
            throw new IllegalArgumentException("missing argument");
        }
        Object result = Objects.requireNonNull(args[index]);
        if (!type.isInstance(result)) {
            throw new IllegalArgumentException("argument has wrong type");
        }
        return type.cast(result);
    }

    private static <T> T[] extractArgs(Object[] args, int index, Class<T> type, int count) {
        Object[] result = (Object[])Array.newInstance(type, count);
        for (int i = 0; i < count; ++i) {
            result[i] = LambdaMetafactory.extractArg(args, index + i, type);
        }
        return result;
    }
}

